/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.project.Project;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.SoftFactoryMap;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.highlighting.ResolvingElementQuickFix;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomResolveConverter<T extends DomElement>
extends ResolvingConverter<T> {
    private static final Map<Class<? extends DomElement>, DomResolveConverter> ourCache = ConcurrentFactoryMap.createMap(key -> new DomResolveConverter(key));
    private final boolean myAttribute;
    private final SoftFactoryMap<DomElement, CachedValue<Map<String, DomElement>>> myResolveCache = new SoftFactoryMap<DomElement, CachedValue<Map<String, DomElement>>>(){

        @NotNull
        protected CachedValue<Map<String, DomElement>> create(final DomElement scope) {
            DomManager domManager = scope.getManager();
            if (domManager == null) {
                throw new AssertionError((Object)("Null DomManager for " + scope.getClass()));
            }
            Project project = domManager.getProject();
            CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, DomElement>>(){

                public CachedValueProvider.Result<Map<String, DomElement>> compute() {
                    HashMap<String, DomElement> map = new HashMap<String, DomElement>();
                    this.visitDomElement(scope, map);
                    return new CachedValueProvider.Result(map, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }

                private void visitDomElement(DomElement element, Map<String, DomElement> map) {
                    if (DomResolveConverter.this.myClass.isInstance(element)) {
                        String name = ElementPresentationManager.getElementName(element);
                        if (name != null && !map.containsKey(name)) {
                            map.put(name, element);
                        }
                    } else {
                        for (DomElement child : DomUtil.getDefinedChildren(element, true, DomResolveConverter.this.myAttribute)) {
                            this.visitDomElement(child, map);
                        }
                    }
                }
            }, false);
            if (cachedValue == null) {
                1.$$$reportNull$$$0(0);
            }
            return cachedValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/DomResolveConverter$1", "create"));
        }
    };
    private final Class<T> myClass;

    public DomResolveConverter(Class<T> aClass) {
        this.myClass = aClass;
        this.myAttribute = GenericAttributeValue.class.isAssignableFrom(this.myClass);
    }

    public static <T extends DomElement> DomResolveConverter<T> createConverter(Class<T> aClass) {
        return ourCache.get(aClass);
    }

    @Override
    public T fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        return (T)((DomElement)((Map)((CachedValue)this.myResolveCache.get((Object)DomResolveConverter.getResolvingScope(context))).getValue()).get(s));
    }

    @Override
    public PsiElement getPsiElement(@Nullable T resolvedValue) {
        if (resolvedValue == null) {
            return null;
        }
        DomTarget target = DomTarget.getTarget(resolvedValue);
        return target == null ? super.getPsiElement(resolvedValue) : PomService.convertToPsi((PsiTarget)target);
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element, String stringValue, @Nullable T resolveResult, ConvertContext context) {
        if (element == null) {
            DomResolveConverter.$$$reportNull$$$0(0);
        }
        return resolveResult != null && element.getManager().areElementsEquivalent(element, (PsiElement)resolveResult.getXmlElement());
    }

    private static DomElement getResolvingScope(ConvertContext context) {
        DomElement invocationElement = context.getInvocationElement();
        return invocationElement.getManager().getResolvingScope((GenericDomValue)invocationElement);
    }

    @Override
    public String getErrorMessage(String s, ConvertContext context) {
        return CodeInsightBundle.message((String)"error.cannot.resolve.0.1", (Object[])new Object[]{TypePresentationService.getService().getTypePresentableName(this.myClass), s});
    }

    @Override
    public String toString(T t, ConvertContext context) {
        if (t == null) {
            return null;
        }
        return ElementPresentationManager.getElementName(t);
    }

    @Override
    @NotNull
    public Collection<? extends T> getVariants(ConvertContext context) {
        DomElement reference = context.getInvocationElement();
        DomElement scope = reference.getManager().getResolvingScope((GenericDomValue)reference);
        Collection collection = ((Map)((CachedValue)this.myResolveCache.get((Object)scope)).getValue()).values();
        if (collection == null) {
            DomResolveConverter.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Override
    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        GenericDomValue value = (GenericDomValue)element.createStableCopy();
        String newName = value.getStringValue();
        if (newName == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        DomElement scope = value.getManager().getResolvingScope(value);
        return ResolvingElementQuickFix.createFixes(newName, this.myClass, scope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/DomResolveConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/DomResolveConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

