/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.DocumentsEditor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.UndoHelper;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PerspectiveFileEditor
extends UserDataHolderBase
implements DocumentsEditor,
Committable {
    private final Wrapper myWrapper = new Wrapper();
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    private final Project myProject;
    private final VirtualFile myFile;
    private final UndoHelper myUndoHelper;
    private boolean myInitialised;
    private boolean myInitializing;
    private boolean myInvalidated;

    protected PerspectiveFileEditor(Project project, VirtualFile file) {
        Document document;
        this.myProject = project;
        this.myUndoHelper = new UndoHelper(project, this);
        this.myFile = file;
        project.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!PerspectiveFileEditor.this.isValid()) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (PerspectiveFileEditor.this.myUndoHelper.isShowing() && !PerspectiveFileEditor.this.getComponent().isShowing()) {
                        PerspectiveFileEditor.this.deselectNotify();
                    } else if (!PerspectiveFileEditor.this.myUndoHelper.isShowing() && PerspectiveFileEditor.this.getComponent().isShowing()) {
                        PerspectiveFileEditor.this.selectNotify();
                    }
                });
                FileEditor oldEditor = event.getOldEditor();
                FileEditor newEditor = event.getNewEditor();
                if (oldEditor == null || newEditor == null) {
                    return;
                }
                if (oldEditor.getComponent().isShowing() && newEditor.getComponent().isShowing()) {
                    return;
                }
                if (PerspectiveFileEditor.this.equals(oldEditor)) {
                    if (newEditor instanceof TextEditor) {
                        PerspectiveFileEditor.this.ensureInitialized();
                        DomElement selectedDomElement = PerspectiveFileEditor.this.getSelectedDomElement();
                        if (selectedDomElement != null) {
                            PerspectiveFileEditor.this.setSelectionInTextEditor((TextEditor)newEditor, selectedDomElement);
                        }
                    }
                } else if (PerspectiveFileEditor.this.equals(newEditor)) {
                    if (oldEditor instanceof TextEditor) {
                        DomElement element = PerspectiveFileEditor.this.getSelectedDomElementFromTextEditor((TextEditor)oldEditor);
                        if (element != null) {
                            PerspectiveFileEditor.this.ensureInitialized();
                            PerspectiveFileEditor.this.setSelectedDomElement(element);
                        }
                    } else if (oldEditor instanceof PerspectiveFileEditor) {
                        PerspectiveFileEditor.this.ensureInitialized();
                        DomElement selectedDomElement = ((PerspectiveFileEditor)oldEditor).getSelectedDomElement();
                        if (selectedDomElement != null) {
                            PerspectiveFileEditor.this.setSelectedDomElement(selectedDomElement);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/xml/ui/PerspectiveFileEditor$1", "selectionChanged"));
            }
        });
        this.myUndoHelper.startListeningDocuments();
        PsiFile psiFile = this.getPsiFile();
        if (psiFile != null && (document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile)) != null) {
            this.addWatchedDocument(document);
        }
    }

    @Nullable
    protected abstract DomElement getSelectedDomElement();

    protected abstract void setSelectedDomElement(DomElement var1);

    public final void addWatchedElement(@NotNull DomElement domElement) {
        if (domElement == null) {
            PerspectiveFileEditor.$$$reportNull$$$0(0);
        }
        this.addWatchedDocument(this.getDocumentManager().getDocument((PsiFile)DomUtil.getFile(domElement)));
    }

    final void removeWatchedElement(@NotNull DomElement domElement) {
        if (domElement == null) {
            PerspectiveFileEditor.$$$reportNull$$$0(1);
        }
        this.removeWatchedDocument(this.getDocumentManager().getDocument((PsiFile)DomUtil.getFile(domElement)));
    }

    private void addWatchedDocument(Document document) {
        this.myUndoHelper.addWatchedDocument(document);
    }

    private void removeWatchedDocument(Document document) {
        this.myUndoHelper.removeWatchedDocument(document);
    }

    @Nullable
    private DomElement getSelectedDomElementFromTextEditor(TextEditor textEditor) {
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null) {
            return null;
        }
        PsiElement psiElement = psiFile.findElementAt(textEditor.getEditor().getCaretModel().getOffset());
        if (psiElement == null) {
            return null;
        }
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class);
        return DomManager.getDomManager(this.myProject).getDomElement(xmlTag);
    }

    private void setSelectionInTextEditor(TextEditor textEditor, DomElement element) {
        if (element != null && element.isValid()) {
            XmlTag tag = element.getXmlTag();
            if (tag == null) {
                return;
            }
            PsiFile file = tag.getContainingFile();
            if (file == null) {
                return;
            }
            Document document = this.getDocumentManager().getDocument(file);
            if (document == null || !document.equals(textEditor.getEditor().getDocument())) {
                return;
            }
            textEditor.getEditor().getCaretModel().moveToOffset(tag.getTextOffset());
            textEditor.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    protected final PsiDocumentManager getDocumentManager() {
        return PsiDocumentManager.getInstance((Project)this.myProject);
    }

    @Nullable
    public final PsiFile getPsiFile() {
        return PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
    }

    @NotNull
    public final @NotNull Document @NotNull [] getDocuments() {
        Document[] documentArray = this.myUndoHelper.getDocuments();
        if (documentArray == null) {
            PerspectiveFileEditor.$$$reportNull$$$0(2);
        }
        return documentArray;
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final VirtualFile getVirtualFile() {
        return this.myFile;
    }

    public void dispose() {
        if (this.myInvalidated) {
            return;
        }
        this.myInvalidated = true;
        this.myUndoHelper.stopListeningDocuments();
    }

    public final boolean isModified() {
        return FileDocumentManager.getInstance().isFileModified(this.getVirtualFile());
    }

    public boolean isValid() {
        return this.getVirtualFile().isValid();
    }

    public void selectNotify() {
        if (!this.checkIsValid() || this.myInvalidated) {
            return;
        }
        this.ensureInitialized();
        this.setShowing(true);
        if (this.myInitialised) {
            this.reset();
        }
    }

    protected final void setShowing(boolean b) {
        this.myUndoHelper.setShowing(b);
    }

    protected final synchronized void ensureInitialized() {
        if (!this.isInitialised() && !this.myInitializing) {
            this.myInitializing = true;
            JComponent component = this.createCustomComponent();
            this.myWrapper.setContent(component);
            this.myInitialised = true;
        }
    }

    public void deselectNotify() {
        if (!this.checkIsValid() || this.myInvalidated) {
            return;
        }
        this.setShowing(false);
        this.commit();
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return new FileEditorLocation(){

            @NotNull
            public FileEditor getEditor() {
                PerspectiveFileEditor perspectiveFileEditor = PerspectiveFileEditor.this;
                if (perspectiveFileEditor == null) {
                    2.$$$reportNull$$$0(0);
                }
                return perspectiveFileEditor;
            }

            public int compareTo(@NotNull FileEditorLocation fileEditorLocation) {
                if (fileEditorLocation == null) {
                    2.$$$reportNull$$$0(1);
                }
                return 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/xml/ui/PerspectiveFileEditor$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileEditorLocation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEditor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/xml/ui/PerspectiveFileEditor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "compareTo";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            PerspectiveFileEditor.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            PerspectiveFileEditor.$$$reportNull$$$0(4);
        }
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            PerspectiveFileEditor.$$$reportNull$$$0(5);
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            PerspectiveFileEditor.$$$reportNull$$$0(6);
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected boolean checkIsValid() {
        if (!this.myInvalidated && !this.isValid()) {
            this.myInvalidated = true;
            this.myPropertyChangeSupport.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        }
        return !this.myInvalidated;
    }

    @NotNull
    public JComponent getComponent() {
        Wrapper wrapper = this.getWrapper();
        if (wrapper == null) {
            PerspectiveFileEditor.$$$reportNull$$$0(7);
        }
        return wrapper;
    }

    @NotNull
    protected abstract JComponent createCustomComponent();

    public Wrapper getWrapper() {
        return this.myWrapper;
    }

    protected final synchronized boolean isInitialised() {
        return this.myInitialised;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/ui/PerspectiveFileEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/ui/PerspectiveFileEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocuments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addWatchedElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeWatchedElement";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

