/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintEditorResult;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeIssueRegistry;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFixProvider;
import com.android.tools.idea.lint.common.LintIdeRequest;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.idea.lint.common.SuppressLintIntentionAction;
import com.android.tools.lint.checks.DeprecationDetector;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.WrongIdDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.collect.Sets;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.CustomEditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.plugins.gradle.config.GradleFileType;

public class LintExternalAnnotator
extends ExternalAnnotator<LintEditorResult, LintEditorResult> {
    static final String LINK_PREFIX = "#lint/";
    static final boolean INCLUDE_IDEA_SUPPRESS_ACTIONS = false;

    @Nullable
    public LintEditorResult collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        if (file == null) {
            LintExternalAnnotator.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            LintExternalAnnotator.$$$reportNull$$$0(1);
        }
        return this.collectInformation(file);
    }

    public LintEditorResult collectInformation(@NotNull PsiFile file) {
        Module module;
        if (file == null) {
            LintExternalAnnotator.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            return null;
        }
        return this.collectInformation(file, module);
    }

    protected boolean isRelevant(@NotNull PsiFile file, @NotNull Module module) {
        if (file == null) {
            LintExternalAnnotator.$$$reportNull$$$0(3);
        }
        if (module == null) {
            LintExternalAnnotator.$$$reportNull$$$0(4);
        }
        return LintIdeSupport.get().canAnnotate(file, module);
    }

    @Nullable
    protected LintEditorResult collectInformation(@NotNull PsiFile file, @NotNull Module module) {
        VirtualFile vFile;
        if (file == null) {
            LintExternalAnnotator.$$$reportNull$$$0(5);
        }
        if (module == null) {
            LintExternalAnnotator.$$$reportNull$$$0(6);
        }
        if ((vFile = file.getVirtualFile()) == null) {
            return null;
        }
        if (!this.isRelevant(file, module)) {
            return null;
        }
        Set<Issue> issues = LintExternalAnnotator.getIssuesFromInspections(file.getProject(), (PsiElement)file);
        return new LintEditorResult(module, vFile, file.getText(), issues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LintEditorResult doAnnotate(LintEditorResult lintResult) {
        long startTime = System.currentTimeMillis();
        LintIdeClient client = LintIdeSupport.get().createEditorClient(lintResult);
        try {
            EnumSet scope;
            VirtualFile mainFile = lintResult.getMainFile();
            FileType fileType = mainFile.getFileType();
            String name = mainFile.getName();
            if (fileType == XmlFileType.INSTANCE) {
                if (name.equals("AndroidManifest.xml")) {
                    scope = Scope.MANIFEST_SCOPE;
                } else {
                    if (!name.endsWith(".xml")) {
                        LintEditorResult lintEditorResult = lintResult;
                        return lintEditorResult;
                    }
                    scope = Scope.RESOURCE_FILE_SCOPE;
                }
            } else if (fileType == JavaFileType.INSTANCE || fileType == KotlinFileType.INSTANCE) {
                scope = Scope.JAVA_FILE_SCOPE;
                if (name.endsWith(".kts")) {
                    scope = EnumSet.of(Scope.GRADLE_FILE, Scope.JAVA_FILE);
                }
            } else if (name.equals("proguard.cfg") || name.equals("proguard-project.txt")) {
                scope = EnumSet.of(Scope.PROGUARD_FILE);
            } else if (GradleFileType.isGradleFile((VirtualFile)mainFile)) {
                scope = Scope.GRADLE_SCOPE;
            } else if (fileType == PropertiesFileType.INSTANCE) {
                scope = Scope.PROPERTY_SCOPE;
            } else {
                assert (false) : fileType;
                LintEditorResult lintEditorResult = lintResult;
                return lintEditorResult;
            }
            Project project = lintResult.getModule().getProject();
            if (project.isDisposed()) {
                LintEditorResult lintEditorResult = lintResult;
                return lintEditorResult;
            }
            if (DumbService.isDumb((Project)project)) {
                LintEditorResult lintEditorResult = lintResult;
                return lintEditorResult;
            }
            List<VirtualFile> files = Collections.singletonList(mainFile);
            LintIdeRequest request = new LintIdeRequest(client, project, files, Collections.singletonList(lintResult.getModule()), true);
            request.setScope(scope);
            LintDriver lint = client.createDriver(request);
            lint.analyze();
            lint.setAnalysisStartTime(startTime);
            LintIdeSupport.get().logSession(lint, lintResult);
            return lintResult;
        }
        finally {
            Disposer.dispose((Disposable)client);
        }
    }

    @NotNull
    static Set<Issue> getIssuesFromInspections(@NotNull Project project, @Nullable PsiElement context) {
        if (project == null) {
            LintExternalAnnotator.$$$reportNull$$$0(7);
        }
        IssueRegistry fullRegistry = LintIdeIssueRegistry.get();
        List issueList = fullRegistry.getIssues();
        HashSet result = Sets.newHashSetWithExpectedSize((int)(issueList.size() + 10));
        for (Issue issue : issueList) {
            HighlightDisplayKey key;
            String inspectionShortName = AndroidLintInspectionBase.getInspectionShortNameByIssue(project, issue);
            if (inspectionShortName == null || (key = HighlightDisplayKey.find((String)inspectionShortName)) == null) continue;
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
            boolean enabled = context != null ? profile.isToolEnabled(key, context) : profile.isToolEnabled(key);
            if (!enabled) continue;
            if (!issue.isEnabledByDefault()) {
                issue.setEnabledByDefault(true);
            }
            result.add(issue);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            LintExternalAnnotator.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    public void apply(@NotNull PsiFile file, LintEditorResult lintResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            LintExternalAnnotator.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            LintExternalAnnotator.$$$reportNull$$$0(10);
        }
        if (lintResult.isDirty()) {
            return;
        }
        Project project = file.getProject();
        if (DumbService.isDumb((Project)project)) {
            return;
        }
        LintIdeQuickFixProvider[] fixProviders = (LintIdeQuickFixProvider[])LintIdeQuickFixProvider.EP_NAME.getExtensions();
        LintIdeSupport ideSupport = LintIdeSupport.get();
        for (LintProblemData problemData : lintResult.getProblems()) {
            LintIdeQuickFix[] fixes;
            HighlightDisplayLevel configuredLevel;
            HighlightDisplayKey key;
            Pair<AndroidLintInspectionBase, HighlightDisplayLevel> pair;
            Issue issue = problemData.getIssue();
            String message = problemData.getMessage();
            TextRange range = problemData.getTextRange();
            LintFix quickfixData = problemData.getQuickfixData();
            if (range.getStartOffset() == range.getEndOffset() || (pair = LintExternalAnnotator.getHighlightLevelAndInspection(project, issue, (PsiElement)file)) == null) continue;
            AndroidLintInspectionBase inspection = (AndroidLintInspectionBase)((Object)pair.getFirst());
            HighlightDisplayLevel displayLevel = (HighlightDisplayLevel)pair.getSecond();
            if (inspection == null || (key = HighlightDisplayKey.find((String)inspection.getShortName())) == null) continue;
            PsiElement startElement = file.findElementAt(range.getStartOffset());
            PsiElement endElement = file.findElementAt(range.getEndOffset() - 1);
            if (startElement == null || endElement == null || inspection.isSuppressedFor(startElement)) continue;
            if (problemData.getConfiguredSeverity() != null && (configuredLevel = AndroidLintInspectionBase.toHighlightDisplayLevel(problemData.getConfiguredSeverity())) != null) {
                displayLevel = configuredLevel;
            }
            HighlightSeverity severity = displayLevel.getSeverity();
            ProblemHighlightType type = issue == DeprecationDetector.ISSUE || issue == GradleDetector.DEPRECATED || issue == GradleDetector.DEPRECATED_CONFIGURATION ? ProblemHighlightType.LIKE_DEPRECATED : (issue == WrongIdDetector.UNKNOWN_ID || issue == WrongIdDetector.UNKNOWN_ID_LAYOUT ? ProblemHighlightType.ERROR : (severity == HighlightSeverity.ERROR ? ProblemHighlightType.GENERIC_ERROR : HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)severity)));
            String descriptionLink = "<a href=\"#lint/" + issue.getId() + "\"></a>";
            String tooltip = XmlStringUtil.wrapInHtml((CharSequence)(descriptionLink + TextFormat.RAW.convertTo(message, TextFormat.HTML)));
            AnnotationBuilder builder = holder.newAnnotation(severity, message).highlightType(type).range(range).tooltip(tooltip);
            for (LintIdeQuickFix lintIdeQuickFix : fixes = inspection.getAllFixes(startElement, endElement, message, quickfixData, fixProviders, issue)) {
                if (!lintIdeQuickFix.isApplicable(startElement, endElement, AndroidQuickfixContexts.EditorContext.TYPE)) continue;
                builder = builder.withFix((IntentionAction)new MyFixingIntention(lintIdeQuickFix, startElement, endElement));
            }
            for (LintIdeQuickFix lintIdeQuickFix : inspection.getIntentions(startElement, endElement)) {
                builder = builder.withFix((IntentionAction)lintIdeQuickFix);
            }
            if (ideSupport.canRequestFeedback()) {
                builder = builder.withFix(ideSupport.requestFeedbackIntentionAction(issue));
            }
            String id = key.getID();
            builder = builder.withFix((IntentionAction)new SuppressLintIntentionAction(id, startElement));
            builder.create();
        }
    }

    @Nullable
    public static Pair<AndroidLintInspectionBase, HighlightDisplayLevel> getHighlightLevelAndInspection(@NotNull Project project, @NotNull Issue issue, @NotNull PsiElement context) {
        String inspectionShortName;
        if (project == null) {
            LintExternalAnnotator.$$$reportNull$$$0(11);
        }
        if (issue == null) {
            LintExternalAnnotator.$$$reportNull$$$0(12);
        }
        if (context == null) {
            LintExternalAnnotator.$$$reportNull$$$0(13);
        }
        if ((inspectionShortName = AndroidLintInspectionBase.getInspectionShortNameByIssue(project, issue)) == null) {
            return null;
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)inspectionShortName);
        if (key == null) {
            return null;
        }
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)context.getProject()).getCurrentProfile();
        if (!profile.isToolEnabled(key, context) && issue.isEnabledByDefault()) {
            return null;
        }
        AndroidLintInspectionBase inspection = (AndroidLintInspectionBase)profile.getUnwrappedTool(inspectionShortName, context);
        if (inspection == null) {
            return null;
        }
        HighlightDisplayLevel errorLevel = profile.getErrorLevel(key, context);
        return Pair.create((Object)((Object)inspection), (Object)errorLevel);
    }

    static {
        LintClient.setClientName((String)"studio");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/common/LintExternalAnnotator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/common/LintExternalAnnotator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssuesFromInspections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRelevant";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIssuesFromInspections";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightLevelAndInspection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyEditInspectionToolsSettingsAction
    extends CustomEditInspectionToolsSettingsAction {
        private MyEditInspectionToolsSettingsAction(@NotNull HighlightDisplayKey key, @NotNull AndroidLintInspectionBase inspection) {
            if (key == null) {
                MyEditInspectionToolsSettingsAction.$$$reportNull$$$0(0);
            }
            if (inspection == null) {
                MyEditInspectionToolsSettingsAction.$$$reportNull$$$0(1);
            }
            super(key, () -> "Edit '" + inspection.getDisplayName() + "' inspection settings");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inspection";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/lint/common/LintExternalAnnotator$MyEditInspectionToolsSettingsAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyFixingIntention
    implements IntentionAction,
    HighPriorityAction {
        private final LintIdeQuickFix myQuickFix;
        private final PsiElement myStartElement;
        private final PsiElement myEndElement;

        public MyFixingIntention(@NotNull LintIdeQuickFix quickFix, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (quickFix == null) {
                MyFixingIntention.$$$reportNull$$$0(0);
            }
            if (startElement == null) {
                MyFixingIntention.$$$reportNull$$$0(1);
            }
            if (endElement == null) {
                MyFixingIntention.$$$reportNull$$$0(2);
            }
            this.myQuickFix = quickFix;
            this.myStartElement = startElement;
            this.myEndElement = endElement;
        }

        @NotNull
        public String getText() {
            String string = this.myQuickFix.getName();
            if (string == null) {
                MyFixingIntention.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = LintBundle.message("android.lint.quickfixes.family", new Object[0]);
            if (string == null) {
                MyFixingIntention.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                MyFixingIntention.$$$reportNull$$$0(5);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                MyFixingIntention.$$$reportNull$$$0(6);
            }
            this.myQuickFix.apply(this.myStartElement, this.myEndElement, AndroidQuickfixContexts.EditorContext.getInstance(editor));
        }

        public boolean startInWriteAction() {
            return this.myQuickFix.startInWriteAction();
        }

        public String toString() {
            return this.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "quickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/lint/common/LintExternalAnnotator$MyFixingIntention";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/lint/common/LintExternalAnnotator$MyFixingIntention";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyDisableInspectionFix
    implements IntentionAction,
    Iconable {
        private final DisableInspectionToolAction myDisableInspectionToolAction;

        private MyDisableInspectionFix(@NotNull HighlightDisplayKey key) {
            if (key == null) {
                MyDisableInspectionFix.$$$reportNull$$$0(0);
            }
            this.myDisableInspectionToolAction = new DisableInspectionToolAction(key);
        }

        @NotNull
        public String getText() {
            return "Disable inspection";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                MyDisableInspectionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                MyDisableInspectionFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                MyDisableInspectionFix.$$$reportNull$$$0(3);
            }
            this.myDisableInspectionToolAction.invoke(project, editor, file);
        }

        public boolean startInWriteAction() {
            return this.myDisableInspectionToolAction.startInWriteAction();
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
            if (file == null) {
                MyDisableInspectionFix.$$$reportNull$$$0(4);
            }
            return this.myDisableInspectionToolAction.getElementToMakeWritable(file);
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return this.myDisableInspectionToolAction.getIcon(flags);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/lint/common/LintExternalAnnotator$MyDisableInspectionFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/lint/common/LintExternalAnnotator$MyDisableInspectionFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

