/*
 * MIT License
 *
 * Copyright (c) 2019-2022 JetBrains s.r.o.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.jetbrains.projector.server.core.convert.toAwt

import org.jetbrains.projector.common.protocol.data.VK
import java.awt.event.KeyEvent

internal val codesMap = mapOf(
  VK.UNDEFINED to KeyEvent.VK_UNDEFINED,
  VK.ESCAPE to KeyEvent.VK_ESCAPE,
  VK.D1 to KeyEvent.VK_1,
  VK.D2 to KeyEvent.VK_2,
  VK.D3 to KeyEvent.VK_3,
  VK.D4 to KeyEvent.VK_4,
  VK.D5 to KeyEvent.VK_5,
  VK.D6 to KeyEvent.VK_6,
  VK.D7 to KeyEvent.VK_7,
  VK.D8 to KeyEvent.VK_8,
  VK.D9 to KeyEvent.VK_9,
  VK.D0 to KeyEvent.VK_0,
  VK.MINUS to KeyEvent.VK_MINUS,
  VK.EQUALS to KeyEvent.VK_EQUALS,
  VK.Q to KeyEvent.VK_Q,
  VK.W to KeyEvent.VK_W,
  VK.E to KeyEvent.VK_E,
  VK.R to KeyEvent.VK_R,
  VK.T to KeyEvent.VK_T,
  VK.Y to KeyEvent.VK_Y,
  VK.U to KeyEvent.VK_U,
  VK.I to KeyEvent.VK_I,
  VK.O to KeyEvent.VK_O,
  VK.P to KeyEvent.VK_P,
  VK.OPEN_BRACKET to KeyEvent.VK_OPEN_BRACKET,
  VK.CLOSE_BRACKET to KeyEvent.VK_CLOSE_BRACKET,
  VK.CONTROL to KeyEvent.VK_CONTROL,
  VK.CONTROL to KeyEvent.VK_CONTROL,
  VK.META to KeyEvent.VK_META,
  VK.META to KeyEvent.VK_META,
  VK.META to KeyEvent.VK_META,
  VK.A to KeyEvent.VK_A,
  VK.S to KeyEvent.VK_S,
  VK.D to KeyEvent.VK_D,
  VK.F to KeyEvent.VK_F,
  VK.G to KeyEvent.VK_G,
  VK.H to KeyEvent.VK_H,
  VK.J to KeyEvent.VK_J,
  VK.K to KeyEvent.VK_K,
  VK.L to KeyEvent.VK_L,
  VK.SEMICOLON to KeyEvent.VK_SEMICOLON,
  VK.QUOTE to KeyEvent.VK_QUOTE,
  VK.BACK_QUOTE to KeyEvent.VK_BACK_QUOTE,
  VK.SHIFT to KeyEvent.VK_SHIFT,
  VK.SHIFT to KeyEvent.VK_SHIFT,
  VK.BACK_SLASH to KeyEvent.VK_BACK_SLASH,
  VK.Z to KeyEvent.VK_Z,
  VK.X to KeyEvent.VK_X,
  VK.C to KeyEvent.VK_C,
  VK.V to KeyEvent.VK_V,
  VK.B to KeyEvent.VK_B,
  VK.N to KeyEvent.VK_N,
  VK.M to KeyEvent.VK_M,
  VK.COMMA to KeyEvent.VK_COMMA,
  VK.PERIOD to KeyEvent.VK_PERIOD,
  VK.SLASH to KeyEvent.VK_SLASH,
  VK.SHIFT to KeyEvent.VK_SHIFT,
  VK.MULTIPLY to KeyEvent.VK_MULTIPLY,
  VK.ALT to KeyEvent.VK_ALT,
  VK.ALT to KeyEvent.VK_ALT,
  VK.SPACE to KeyEvent.VK_SPACE,
  VK.CAPS_LOCK to KeyEvent.VK_CAPS_LOCK,
  VK.F1 to KeyEvent.VK_F1,
  VK.F2 to KeyEvent.VK_F2,
  VK.F3 to KeyEvent.VK_F3,
  VK.F4 to KeyEvent.VK_F4,
  VK.F5 to KeyEvent.VK_F5,
  VK.F6 to KeyEvent.VK_F6,
  VK.F7 to KeyEvent.VK_F7,
  VK.F8 to KeyEvent.VK_F8,
  VK.F9 to KeyEvent.VK_F9,
  VK.F10 to KeyEvent.VK_F10,
  VK.NUM_LOCK to KeyEvent.VK_NUM_LOCK,
  VK.SCROLL_LOCK to KeyEvent.VK_SCROLL_LOCK,
  VK.NUMPAD7 to KeyEvent.VK_NUMPAD7,
  VK.NUMPAD8 to KeyEvent.VK_NUMPAD8,
  VK.NUMPAD9 to KeyEvent.VK_NUMPAD9,
  VK.SUBTRACT to KeyEvent.VK_SUBTRACT,
  VK.NUMPAD4 to KeyEvent.VK_NUMPAD4,
  VK.NUMPAD5 to KeyEvent.VK_NUMPAD5,
  VK.NUMPAD6 to KeyEvent.VK_NUMPAD6,
  VK.ADD to KeyEvent.VK_ADD,
  VK.NUMPAD1 to KeyEvent.VK_NUMPAD1,
  VK.NUMPAD2 to KeyEvent.VK_NUMPAD2,
  VK.NUMPAD3 to KeyEvent.VK_NUMPAD3,
  VK.NUMPAD0 to KeyEvent.VK_NUMPAD0,
  VK.DECIMAL to KeyEvent.VK_DECIMAL,
  VK.BACK_SLASH to KeyEvent.VK_BACK_SLASH,
  VK.F11 to KeyEvent.VK_F11,
  VK.F12 to KeyEvent.VK_F12,
  VK.CONVERT to KeyEvent.VK_CONVERT,
  VK.KANA to KeyEvent.VK_KANA,
  VK.NONCONVERT to KeyEvent.VK_NONCONVERT,
  VK.ENTER to KeyEvent.VK_ENTER,
  VK.CONTROL to KeyEvent.VK_CONTROL,
  VK.DIVIDE to KeyEvent.VK_DIVIDE,
  VK.PRINTSCREEN to KeyEvent.VK_PRINTSCREEN,
  VK.ALT_GRAPH to KeyEvent.VK_ALT_GRAPH,
  VK.HOME to KeyEvent.VK_HOME,
  VK.UP to KeyEvent.VK_UP,
  VK.PAGE_UP to KeyEvent.VK_PAGE_UP,
  VK.LEFT to KeyEvent.VK_LEFT,
  VK.RIGHT to KeyEvent.VK_RIGHT,
  VK.END to KeyEvent.VK_END,
  VK.DOWN to KeyEvent.VK_DOWN,
  VK.PAGE_DOWN to KeyEvent.VK_PAGE_DOWN,
  VK.INSERT to KeyEvent.VK_INSERT,
  VK.DELETE to KeyEvent.VK_DELETE,
  VK.EQUALS to KeyEvent.VK_EQUALS,
  VK.PAUSE to KeyEvent.VK_PAUSE,
  VK.COMMA to KeyEvent.VK_COMMA,
  VK.CONTEXT_MENU to KeyEvent.VK_CONTEXT_MENU,
  VK.CANCEL to KeyEvent.VK_CANCEL,
  VK.AGAIN to KeyEvent.VK_AGAIN,
  VK.PROPS to KeyEvent.VK_PROPS,
  VK.UNDO to KeyEvent.VK_UNDO,
  VK.COPY to KeyEvent.VK_COPY,
  VK.PASTE to KeyEvent.VK_PASTE,
  VK.FIND to KeyEvent.VK_FIND,
  VK.CUT to KeyEvent.VK_CUT,
  VK.HELP to KeyEvent.VK_HELP,
  VK.LEFT_PARENTHESIS to KeyEvent.VK_LEFT_PARENTHESIS,
  VK.RIGHT_PARENTHESIS to KeyEvent.VK_RIGHT_PARENTHESIS,
  VK.F13 to KeyEvent.VK_F13,
  VK.F14 to KeyEvent.VK_F14,
  VK.F15 to KeyEvent.VK_F15,
  VK.F16 to KeyEvent.VK_F16,
  VK.F17 to KeyEvent.VK_F17,
  VK.F18 to KeyEvent.VK_F18,
  VK.F19 to KeyEvent.VK_F19,
  VK.F20 to KeyEvent.VK_F20,
  VK.F21 to KeyEvent.VK_F21,
  VK.F22 to KeyEvent.VK_F22,
  VK.F23 to KeyEvent.VK_F23,
  VK.F24 to KeyEvent.VK_F24,
  VK.BACK_SPACE to KeyEvent.VK_BACK_SPACE,
  VK.TAB to KeyEvent.VK_TAB,
  VK.CLEAR to KeyEvent.VK_CLEAR,
  VK.SEPARATOR to KeyEvent.VK_SEPARATOR,
  VK.KP_UP to KeyEvent.VK_KP_UP,
  VK.KP_DOWN to KeyEvent.VK_KP_DOWN,
  VK.KP_LEFT to KeyEvent.VK_KP_LEFT,
  VK.KP_RIGHT to KeyEvent.VK_KP_RIGHT,
  VK.DEAD_GRAVE to KeyEvent.VK_DEAD_GRAVE,
  VK.DEAD_ACUTE to KeyEvent.VK_DEAD_ACUTE,
  VK.DEAD_CIRCUMFLEX to KeyEvent.VK_DEAD_CIRCUMFLEX,
  VK.DEAD_TILDE to KeyEvent.VK_DEAD_TILDE,
  VK.DEAD_MACRON to KeyEvent.VK_DEAD_MACRON,
  VK.DEAD_BREVE to KeyEvent.VK_DEAD_BREVE,
  VK.DEAD_ABOVEDOT to KeyEvent.VK_DEAD_ABOVEDOT,
  VK.DEAD_DIAERESIS to KeyEvent.VK_DEAD_DIAERESIS,
  VK.DEAD_ABOVERING to KeyEvent.VK_DEAD_ABOVERING,
  VK.DEAD_DOUBLEACUTE to KeyEvent.VK_DEAD_DOUBLEACUTE,
  VK.DEAD_CARON to KeyEvent.VK_DEAD_CARON,
  VK.DEAD_CEDILLA to KeyEvent.VK_DEAD_CEDILLA,
  VK.DEAD_OGONEK to KeyEvent.VK_DEAD_OGONEK,
  VK.DEAD_IOTA to KeyEvent.VK_DEAD_IOTA,
  VK.DEAD_VOICED_SOUND to KeyEvent.VK_DEAD_VOICED_SOUND,
  VK.DEAD_SEMIVOICED_SOUND to KeyEvent.VK_DEAD_SEMIVOICED_SOUND,
  VK.AMPERSAND to KeyEvent.VK_AMPERSAND,
  VK.ASTERISK to KeyEvent.VK_ASTERISK,
  VK.QUOTEDBL to KeyEvent.VK_QUOTEDBL,
  VK.LESS to KeyEvent.VK_LESS,
  VK.GREATER to KeyEvent.VK_GREATER,
  VK.BRACELEFT to KeyEvent.VK_BRACELEFT,
  VK.BRACERIGHT to KeyEvent.VK_BRACERIGHT,
  VK.AT to KeyEvent.VK_AT,
  VK.COLON to KeyEvent.VK_COLON,
  VK.CIRCUMFLEX to KeyEvent.VK_CIRCUMFLEX,
  VK.DOLLAR to KeyEvent.VK_DOLLAR,
  VK.EURO_SIGN to KeyEvent.VK_EURO_SIGN,
  VK.EXCLAMATION_MARK to KeyEvent.VK_EXCLAMATION_MARK,
  VK.INVERTED_EXCLAMATION_MARK to KeyEvent.VK_INVERTED_EXCLAMATION_MARK,
  VK.NUMBER_SIGN to KeyEvent.VK_NUMBER_SIGN,
  VK.PLUS to KeyEvent.VK_PLUS,
  VK.UNDERSCORE to KeyEvent.VK_UNDERSCORE,
  VK.WINDOWS to KeyEvent.VK_WINDOWS,
  VK.FINAL to KeyEvent.VK_FINAL,
  VK.ACCEPT to KeyEvent.VK_ACCEPT,
  VK.MODECHANGE to KeyEvent.VK_MODECHANGE,
  VK.KANJI to KeyEvent.VK_KANJI,
  VK.ALPHANUMERIC to KeyEvent.VK_ALPHANUMERIC,
  VK.KATAKANA to KeyEvent.VK_KATAKANA,
  VK.HIRAGANA to KeyEvent.VK_HIRAGANA,
  VK.FULL_WIDTH to KeyEvent.VK_FULL_WIDTH,
  VK.HALF_WIDTH to KeyEvent.VK_HALF_WIDTH,
  VK.ROMAN_CHARACTERS to KeyEvent.VK_ROMAN_CHARACTERS,
  VK.ALL_CANDIDATES to KeyEvent.VK_ALL_CANDIDATES,
  VK.PREVIOUS_CANDIDATE to KeyEvent.VK_PREVIOUS_CANDIDATE,
  VK.CODE_INPUT to KeyEvent.VK_CODE_INPUT,
  VK.JAPANESE_KATAKANA to KeyEvent.VK_JAPANESE_KATAKANA,
  VK.JAPANESE_HIRAGANA to KeyEvent.VK_JAPANESE_HIRAGANA,
  VK.JAPANESE_ROMAN to KeyEvent.VK_JAPANESE_ROMAN,
  VK.KANA_LOCK to KeyEvent.VK_KANA_LOCK,
  VK.INPUT_METHOD_ON_OFF to KeyEvent.VK_INPUT_METHOD_ON_OFF,
  VK.STOP to KeyEvent.VK_STOP,
  VK.COMPOSE to KeyEvent.VK_COMPOSE,
  VK.BEGIN to KeyEvent.VK_BEGIN,
)

// Maps symbol to control character when Ctrl is pressed
// The right part is the subset of ASCII control characters:
// https://en.wikipedia.org/wiki/Control_character
// This map was generated by logging key events in headfull mode.
internal val controlCharMap = mapOf(
  KeyEvent.VK_A to '\u0001',
  KeyEvent.VK_B to '\u0002',
  KeyEvent.VK_C to '\u0003',
  KeyEvent.VK_D to '\u0004',
  KeyEvent.VK_E to '\u0005',
  KeyEvent.VK_F to '\u0006',
  KeyEvent.VK_G to '\u0007',
  KeyEvent.VK_H to '\u0008',
  KeyEvent.VK_I to '\u0009',
  KeyEvent.VK_J to '\u000a',
  KeyEvent.VK_K to '\u000b',
  KeyEvent.VK_L to '\u000c',
  KeyEvent.VK_M to '\u000d',
  KeyEvent.VK_N to '\u000e',
  KeyEvent.VK_O to '\u000f',
  KeyEvent.VK_P to '\u0010',
  KeyEvent.VK_Q to '\u0011',
  KeyEvent.VK_R to '\u0012',
  KeyEvent.VK_S to '\u0013',
  KeyEvent.VK_T to '\u0014',
  KeyEvent.VK_U to '\u0015',
  KeyEvent.VK_V to '\u0016',
  KeyEvent.VK_W to '\u0017',
  KeyEvent.VK_X to '\u0018',
  KeyEvent.VK_Y to '\u0019',
  KeyEvent.VK_Z to '\u001a',
  KeyEvent.VK_OPEN_BRACKET to '\u001b',
  KeyEvent.VK_BACK_SLASH to '\u001c',
  KeyEvent.VK_CLOSE_BRACKET to '\u001d',
)
