/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.tree;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenModelUtil;
import org.jetbrains.idea.maven.importing.MavenModuleNameMapper;
import org.jetbrains.idea.maven.importing.ModuleModelProxy;
import org.jetbrains.idea.maven.importing.tree.MavenJavaVersionHolder;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportContext;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportData;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportDataWithDependencies;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportDependencyProvider;
import org.jetbrains.idea.maven.importing.tree.MavenModuleType;
import org.jetbrains.idea.maven.importing.tree.ModuleData;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectImportContextProvider {
    @NotNull
    private final Project myProject;
    @NotNull
    private final MavenProjectsTree myProjectsTree;
    @NotNull
    private final Map<MavenId, MavenProjectChanges> myProjectsToImportWithChanges;
    @NotNull
    private final ModuleModelProxy myModuleModel;
    @NotNull
    private final MavenImportingSettings myImportingSettings;

    public MavenProjectImportContextProvider(@NotNull Project project2, @NotNull MavenProjectsTree projectsTree, @NotNull Map<MavenProject, MavenProjectChanges> changes, @NotNull ModuleModelProxy moduleModel, @NotNull MavenImportingSettings importingSettings) {
        if (project2 == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(0);
        }
        if (projectsTree == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(1);
        }
        if (changes == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(2);
        }
        if (moduleModel == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(3);
        }
        if (importingSettings == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(4);
        }
        this.myProject = project2;
        this.myProjectsTree = projectsTree;
        this.myProjectsToImportWithChanges = changes.entrySet().stream().collect(Collectors.toMap(e -> ((MavenProject)e.getKey()).getMavenId(), e -> (MavenProjectChanges)e.getValue(), (v1, v2) -> v1));
        this.myModuleModel = moduleModel;
        this.myImportingSettings = importingSettings;
    }

    public MavenModuleImportContext getContext() {
        ModuleImportDataContext importDataContext = this.getModuleImportDataContext();
        ModuleImportDataDependecyContext importDataDependencyContext = this.getFlattenModuleDataDependencyContext(importDataContext);
        return new MavenModuleImportContext(importDataDependencyContext.changedModuleDataWithDependencies, importDataDependencyContext.allModuleDataWithDependencies, importDataDependencyContext.createdModules, importDataContext.obsoleteModules, importDataContext.moduleNameByProject, importDataContext.hasChanges);
    }

    @NotNull
    private ModuleImportDataContext getModuleImportDataContext() {
        boolean hasChanges = false;
        ArrayList<MavenProjectImportData> allModules = new ArrayList<MavenProjectImportData>();
        TreeMap<MavenId, MavenProjectImportData> moduleImportDataByMavenId = new TreeMap<MavenId, MavenProjectImportData>(Comparator.comparing(MavenId::getKey));
        HashMap<MavenProject, String> moduleNameByProject = new HashMap<MavenProject, String>();
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        Map<String, Module> moduleByName = Arrays.stream(this.myModuleModel.getModules()).filter(m -> projectsManager.isMavenizedModule((Module)m)).collect(Collectors.toMap(m -> m.getName(), Function.identity()));
        for (MavenProject project2 : this.myProjectsTree.getProjects()) {
            if (this.myProjectsTree.isIgnored(project2)) continue;
            String moduleName = MavenProjectImportContextProvider.getModuleName(project2, this.myProjectsTree, moduleNameByProject);
            if (StringUtil.isEmpty((String)moduleName)) {
                MavenLog.LOG.warn("[import context] empty module name for project " + project2);
                continue;
            }
            MavenProjectChanges changes = this.myProjectsToImportWithChanges.get(project2.getMavenId());
            MavenProjectImportData mavenProjectImportData = this.getModuleImportData(project2, moduleName, moduleByName, changes);
            if (changes != null && changes.hasChanges()) {
                hasChanges = true;
            }
            moduleImportDataByMavenId.put(project2.getMavenId(), mavenProjectImportData);
            allModules.add(mavenProjectImportData);
        }
        return new ModuleImportDataContext(allModules, moduleNameByProject, moduleImportDataByMavenId, new ArrayList<Module>(moduleByName.values()), hasChanges);
    }

    @NotNull
    private ModuleImportDataDependecyContext getFlattenModuleDataDependencyContext(ModuleImportDataContext context) {
        ArrayList<Module> createdModules = new ArrayList<Module>();
        ArrayList<MavenModuleImportData> allModuleDataWithDependencies = new ArrayList<MavenModuleImportData>();
        ArrayList<MavenModuleImportData> changedModuleDataWithDependencies = new ArrayList<MavenModuleImportData>();
        MavenModuleImportDependencyProvider dependencyProvider = new MavenModuleImportDependencyProvider(this.myProject, context.moduleImportDataByMavenId, this.myImportingSettings);
        for (MavenProjectImportData importData : context.importData) {
            MavenModuleImportDataWithDependencies importDataWithDependencies = dependencyProvider.getDependencies(importData);
            List<MavenModuleImportData> mavenModuleImportDataList = MavenProjectImportContextProvider.splitToModules(importDataWithDependencies);
            for (MavenModuleImportData moduleImportData : mavenModuleImportDataList) {
                if (moduleImportData.hasChanges()) {
                    changedModuleDataWithDependencies.add(moduleImportData);
                }
                if (moduleImportData.isNewModule()) {
                    createdModules.add(moduleImportData.getModuleData().getModule());
                }
                allModuleDataWithDependencies.add(moduleImportData);
            }
        }
        return new ModuleImportDataDependecyContext(allModuleDataWithDependencies, changedModuleDataWithDependencies, createdModules);
    }

    @NotNull
    private static List<MavenModuleImportData> splitToModules(MavenModuleImportDataWithDependencies dataWithDependencies) {
        SplittedMainAndTestModules mainAndTestModules = dataWithDependencies.getModuleImportData().splittedMainAndTestModules;
        MavenProject project2 = dataWithDependencies.getModuleImportData().mavenProject;
        ModuleData moduleData = dataWithDependencies.getModuleImportData().moduleData;
        MavenProjectChanges changes = dataWithDependencies.getModuleImportData().changes;
        if (mainAndTestModules != null) {
            ArrayList<MavenModuleImportData> result = new ArrayList<MavenModuleImportData>(3);
            result.add(new MavenModuleImportData(project2, moduleData, Collections.emptyList(), dataWithDependencies.getModuleImportData().changes));
            result.add(new MavenModuleImportData(project2, mainAndTestModules.mainData, dataWithDependencies.getMainDependencies(), changes));
            List dependencies = ContainerUtil.concat(dataWithDependencies.getTestDependencies(), dataWithDependencies.getMainDependencies());
            result.add(new MavenModuleImportData(project2, mainAndTestModules.testData, dependencies, changes));
            ArrayList<MavenModuleImportData> arrayList = result;
            if (arrayList == null) {
                MavenProjectImportContextProvider.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        List<MavenModuleImportData> list = List.of(new MavenModuleImportData(project2, moduleData, ContainerUtil.concat(dataWithDependencies.getMainDependencies(), dataWithDependencies.getTestDependencies()), changes));
        if (list == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    private void deleteExistingFiles(String moduleName, String modulePath) {
        this.deleteExistingImlFile(modulePath);
        this.deleteExistingModuleByName(moduleName);
    }

    @NotNull
    public static String getModuleName(@NotNull MavenProject mavenProject2, @NotNull Project project2) {
        MavenProjectsTree projectsTree;
        if (mavenProject2 == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(7);
        }
        if (project2 == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(8);
        }
        return (projectsTree = MavenProjectsManager.getInstance(project2).getProjectsTree()) != null ? MavenProjectImportContextProvider.getModuleName(mavenProject2, projectsTree, new HashMap<MavenProject, String>()) : "";
    }

    @NotNull
    private static String getModuleName(@NotNull MavenProject project2, @NotNull MavenProjectsTree projectsTree, @NotNull Map<MavenProject, String> moduleNameMap) {
        String parentName;
        MavenProject parentProject;
        Object moduleName;
        if (project2 == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(9);
        }
        if (projectsTree == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(10);
        }
        if (moduleNameMap == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(11);
        }
        if ((moduleName = moduleNameMap.get(project2)) != null) {
            String string = moduleName;
            if (string == null) {
                MavenProjectImportContextProvider.$$$reportNull$$$0(12);
            }
            return string;
        }
        moduleName = project2.getMavenId().getArtifactId();
        if (moduleName == null) {
            return "";
        }
        if (project2.getParentId() != null && (parentProject = projectsTree.findProject(project2.getParentId())) != null && StringUtil.isNotEmpty((String)(parentName = MavenProjectImportContextProvider.getModuleName(parentProject, projectsTree, moduleNameMap)))) {
            moduleName = parentName + "." + (String)moduleName;
        }
        moduleNameMap.put(project2, (String)moduleName);
        String string = moduleName;
        if (string == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(13);
        }
        return string;
    }

    private MavenProjectImportData getModuleImportData(MavenProject project2, String moduleName, Map<String, Module> moduleByName, MavenProjectChanges changes) {
        MavenJavaVersionHolder javaVersions = MavenModelUtil.getMavenJavaVersions(project2);
        MavenModuleType type2 = MavenProjectImportContextProvider.getModuleType(project2, javaVersions);
        ModuleData moduleData = this.getModuleData(project2, moduleName, type2, javaVersions, moduleByName);
        if (type2 != MavenModuleType.AGGREGATOR_MAIN_TEST) {
            return new MavenProjectImportData(project2, moduleData, changes, null);
        }
        String moduleMainName = moduleName + ".main";
        ModuleData mainData = this.getModuleData(project2, moduleMainName, MavenModuleType.MAIN, javaVersions, moduleByName);
        String moduleTestName = moduleName + ".test";
        ModuleData testData = this.getModuleData(project2, moduleTestName, MavenModuleType.TEST, javaVersions, moduleByName);
        SplittedMainAndTestModules mainAndTestModules = new SplittedMainAndTestModules(mainData, testData);
        return new MavenProjectImportData(project2, moduleData, changes, mainAndTestModules);
    }

    private static MavenModuleType getModuleType(MavenProject project2, MavenJavaVersionHolder mavenJavaVersions) {
        if (MavenProjectImportContextProvider.needSplitMainAndTest(project2, mavenJavaVersions)) {
            return MavenModuleType.AGGREGATOR_MAIN_TEST;
        }
        if (project2.isAggregator()) {
            return MavenModuleType.AGGREGATOR;
        }
        return MavenModuleType.MAIN_TEST;
    }

    private static boolean needSplitMainAndTest(MavenProject project2, MavenJavaVersionHolder mavenJavaVersions) {
        return !project2.isAggregator() && mavenJavaVersions.needSeparateTestModule() && MavenModelUtil.isCompilerTestSupport(project2);
    }

    private ModuleData getModuleData(MavenProject project2, String moduleName, MavenModuleType type2, MavenJavaVersionHolder javaVersionHolder, Map<String, Module> moduleByName) {
        boolean newModule2;
        Module module = moduleByName.remove(moduleName);
        if (module != null && !ModuleType.get((Module)module).equals(project2.getModuleType())) {
            this.myModuleModel.disposeModule(module);
            module = null;
        }
        boolean bl = newModule2 = module == null;
        if (newModule2) {
            String modulePath = MavenModuleNameMapper.generateModulePath(MavenProjectImportContextProvider.getModuleDirPath(project2, type2), moduleName, this.myImportingSettings.getDedicatedModuleDir());
            this.deleteExistingFiles(moduleName, modulePath);
            module = this.myModuleModel.newModule(modulePath, project2.getModuleType().getId());
        }
        return new ModuleData(module, type2, javaVersionHolder, newModule2);
    }

    private static String getModuleDirPath(MavenProject project2, MavenModuleType type2) {
        if (type2 == MavenModuleType.TEST) {
            return Path.of(project2.getDirectory(), "src", "test").toString();
        }
        if (type2 == MavenModuleType.MAIN) {
            return Path.of(project2.getDirectory(), "src", "main").toString();
        }
        return project2.getDirectory();
    }

    private void deleteExistingModuleByName(String name) {
        Module module = this.myModuleModel.findModuleByName(name);
        if (module != null) {
            this.myModuleModel.disposeModule(module);
        }
    }

    private void deleteExistingImlFile(final String path) {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, new Runnable(){

            @Override
            public void run() {
                try {
                    VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                    if (file != null) {
                        file.delete((Object)this);
                    }
                }
                catch (IOException e) {
                    MavenLog.LOG.warn("Cannot delete existing iml file: " + path, (Throwable)e);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsTree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importingSettings";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNameMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "splitToModules";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class SplittedMainAndTestModules {
        @NotNull
        final ModuleData mainData;
        @NotNull
        final ModuleData testData;

        SplittedMainAndTestModules(@NotNull ModuleData mainData, @NotNull ModuleData testData) {
            if (mainData == null) {
                SplittedMainAndTestModules.$$$reportNull$$$0(0);
            }
            if (testData == null) {
                SplittedMainAndTestModules.$$$reportNull$$$0(1);
            }
            this.mainData = mainData;
            this.testData = testData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mainData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "testData";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider$SplittedMainAndTestModules";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class MavenProjectImportData {
        @NotNull
        final MavenProject mavenProject;
        @NotNull
        final ModuleData moduleData;
        @Nullable
        final MavenProjectChanges changes;
        @Nullable
        final SplittedMainAndTestModules splittedMainAndTestModules;

        MavenProjectImportData(@NotNull MavenProject mavenProject2, @NotNull ModuleData moduleData, @Nullable MavenProjectChanges changes, @Nullable SplittedMainAndTestModules splittedMainAndTestModules) {
            if (mavenProject2 == null) {
                MavenProjectImportData.$$$reportNull$$$0(0);
            }
            if (moduleData == null) {
                MavenProjectImportData.$$$reportNull$$$0(1);
            }
            this.mavenProject = mavenProject2;
            this.changes = changes;
            this.moduleData = moduleData;
            this.splittedMainAndTestModules = splittedMainAndTestModules;
        }

        public boolean hasChanges() {
            return this.changes != null && this.changes.hasChanges();
        }

        public String toString() {
            return this.mavenProject.getMavenId().toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mavenProject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleData";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider$MavenProjectImportData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ModuleImportDataDependecyContext {
        @NotNull
        final List<MavenModuleImportData> allModuleDataWithDependencies;
        @NotNull
        final List<MavenModuleImportData> changedModuleDataWithDependencies;
        @NotNull
        final List<Module> createdModules;

        private ModuleImportDataDependecyContext(@NotNull List<MavenModuleImportData> allModuleDataWithDependencies, @NotNull List<MavenModuleImportData> changedModuleDataWithDependencies, @NotNull List<Module> createdModules) {
            if (allModuleDataWithDependencies == null) {
                ModuleImportDataDependecyContext.$$$reportNull$$$0(0);
            }
            if (changedModuleDataWithDependencies == null) {
                ModuleImportDataDependecyContext.$$$reportNull$$$0(1);
            }
            if (createdModules == null) {
                ModuleImportDataDependecyContext.$$$reportNull$$$0(2);
            }
            this.allModuleDataWithDependencies = allModuleDataWithDependencies;
            this.changedModuleDataWithDependencies = changedModuleDataWithDependencies;
            this.createdModules = createdModules;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "allModuleDataWithDependencies";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changedModuleDataWithDependencies";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "createdModules";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider$ModuleImportDataDependecyContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ModuleImportDataContext {
        @NotNull
        final List<MavenProjectImportData> importData;
        @NotNull
        final Map<MavenProject, String> moduleNameByProject;
        @NotNull
        final Map<MavenId, MavenProjectImportData> moduleImportDataByMavenId;
        @NotNull
        final List<Module> obsoleteModules;
        final boolean hasChanges;

        private ModuleImportDataContext(@NotNull List<MavenProjectImportData> importData, @NotNull Map<MavenProject, String> moduleNameByProject, @NotNull Map<MavenId, MavenProjectImportData> moduleImportDataByMavenId, @NotNull List<Module> obsoleteModules, boolean hasChanges) {
            if (importData == null) {
                ModuleImportDataContext.$$$reportNull$$$0(0);
            }
            if (moduleNameByProject == null) {
                ModuleImportDataContext.$$$reportNull$$$0(1);
            }
            if (moduleImportDataByMavenId == null) {
                ModuleImportDataContext.$$$reportNull$$$0(2);
            }
            if (obsoleteModules == null) {
                ModuleImportDataContext.$$$reportNull$$$0(3);
            }
            this.importData = importData;
            this.moduleNameByProject = moduleNameByProject;
            this.moduleImportDataByMavenId = moduleImportDataByMavenId;
            this.obsoleteModules = obsoleteModules;
            this.hasChanges = hasChanges;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "importData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleNameByProject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleImportDataByMavenId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "obsoleteModules";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider$ModuleImportDataContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

