/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.workspaceModel;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleManagerBridgeImpl;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenModuleNameMapper;
import org.jetbrains.idea.maven.importing.MavenProjectImporterBase;
import org.jetbrains.idea.maven.importing.workspaceModel.MavenProjectImporterToWorkspaceModel;
import org.jetbrains.idea.maven.importing.workspaceModel.WorkspaceModuleImporter;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0010H\u0016R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0015j\b\u0012\u0004\u0012\u00020\u0011`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/MavenProjectImporterToWorkspaceModel;", "Lorg/jetbrains/idea/maven/importing/MavenProjectImporterBase;", "mavenProjectsTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "projectsToImportWithChanges", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "mavenImportingSettings", "Lorg/jetbrains/idea/maven/project/MavenImportingSettings;", "virtualFileUrlManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Ljava/util/Map;Lorg/jetbrains/idea/maven/project/MavenImportingSettings;Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;Lcom/intellij/openapi/project/Project;)V", "createdModules", "", "Lcom/intellij/openapi/module/Module;", "getCreatedModules", "()Ljava/util/List;", "createdModulesList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "importModules", "", "builder", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "importProject", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "Companion", "intellij.maven"})
public final class MavenProjectImporterToWorkspaceModel
extends MavenProjectImporterBase {
    private final ArrayList<Module> createdModulesList;
    private final MavenProjectsTree mavenProjectsTree;
    private final Map<MavenProject, MavenProjectChanges> projectsToImportWithChanges;
    private final MavenImportingSettings mavenImportingSettings;
    private final VirtualFileUrlManager virtualFileUrlManager;
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public List<MavenProjectsProcessorTask> importProject() {
        long startTime = System.currentTimeMillis();
        ArrayList postTasks = new ArrayList();
        if (this.projectsToImportHaveChanges()) {
            WorkspaceEntityStorageBuilder builder = WorkspaceEntityStorageBuilder.Companion.create();
            this.importModules(builder);
            this.scheduleRefreshResolvedArtifacts(postTasks);
        }
        LOG.info("[maven import] applying models to workspace model took " + (System.currentTimeMillis() - startTime) + "ms");
        return postTasks;
    }

    private final void importModules(WorkspaceEntityStorageBuilder builder) {
        MavenProjectsTree mavenProjectsTree = this.myProjectsTree;
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsTree, (String)"myProjectsTree");
        List<MavenProject> list = mavenProjectsTree.getProjects();
        Intrinsics.checkNotNullExpressionValue(list, (String)"myProjectsTree.projects");
        Set allProjects = CollectionsKt.toMutableSet((Iterable)list);
        allProjects.addAll((Collection)this.projectsToImportWithChanges.keySet());
        ArrayList<Pair> createdModules = new ArrayList<Pair>();
        HashMap<MavenProject, String> mavenProjectToModuleName = new HashMap<MavenProject, String>();
        MavenModuleNameMapper.map(allProjects, MapsKt.emptyMap(), (Map<MavenProject, String>)mavenProjectToModuleName, new HashMap(), this.mavenImportingSettings.getDedicatedModuleDir());
        Iterator iterator = allProjects.iterator();
        while (iterator.hasNext()) {
            MavenProject mavenProject2;
            MavenProject mavenProject3 = mavenProject2 = (MavenProject)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)mavenProject3, (String)"mavenProject");
            ModuleEntity moduleEntity2 = new WorkspaceModuleImporter(mavenProject3, this.virtualFileUrlManager, this.mavenProjectsTree, builder, this.mavenImportingSettings, mavenProjectToModuleName, this.project).importModule();
            createdModules.add(TuplesKt.to((Object)mavenProject2, (Object)moduleEntity2));
        }
        HashMap mavenProjectToModule = new HashMap();
        MavenUtil.invokeAndWaitWriteAction(this.project, new Runnable(this, builder, createdModules, mavenProjectToModule){
            final /* synthetic */ MavenProjectImporterToWorkspaceModel this$0;
            final /* synthetic */ WorkspaceEntityStorageBuilder $builder;
            final /* synthetic */ ArrayList $createdModules;
            final /* synthetic */ HashMap $mavenProjectToModule;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                WorkspaceModel.Companion.getInstance(MavenProjectImporterToWorkspaceModel.access$getProject$p(this.this$0)).updateProjectModel((Function1)new Function1<WorkspaceEntityStorageBuilder, Unit>(this){
                    final /* synthetic */ importModules.1 this$0;

                    public final void invoke(@NotNull WorkspaceEntityStorageBuilder current) {
                        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                        current.replaceBySource((Function1)importModules.1.INSTANCE, (WorkspaceEntityStorage)this.this$0.$builder);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                WorkspaceEntityStorage storage = WorkspaceModel.Companion.getInstance(MavenProjectImporterToWorkspaceModel.access$getProject$p(this.this$0)).getEntityStorage().getCurrent();
                for (Pair pair : this.$createdModules) {
                    void mavenProject2;
                    MavenProject mavenProject3 = (MavenProject)pair.component1();
                    ModuleEntity moduleEntity2 = (ModuleEntity)pair.component2();
                    ModuleBridge module = ModuleManagerBridgeImpl.Companion.findModuleByEntity(storage, moduleEntity2);
                    if (module == null) continue;
                    MavenProjectImporterToWorkspaceModel.access$getCreatedModulesList$p(this.this$0).add(module);
                    ((Map)this.$mavenProjectToModule).put(mavenProject2, module);
                }
            }
            {
                this.this$0 = mavenProjectImporterToWorkspaceModel;
                this.$builder = workspaceEntityStorageBuilder;
                this.$createdModules = arrayList;
                this.$mavenProjectToModule = hashMap;
            }
        });
        MavenProjectImporterToWorkspaceModel.access$configureMavenProjectsInBackground$s653221713(allProjects, mavenProjectToModule, this.project);
    }

    @Override
    @NotNull
    public List<Module> getCreatedModules() {
        return this.createdModulesList;
    }

    public MavenProjectImporterToWorkspaceModel(@NotNull MavenProjectsTree mavenProjectsTree, @NotNull Map<MavenProject, ? extends MavenProjectChanges> projectsToImportWithChanges, @NotNull MavenImportingSettings mavenImportingSettings, @NotNull VirtualFileUrlManager virtualFileUrlManager, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)mavenProjectsTree, (String)"mavenProjectsTree");
        Intrinsics.checkNotNullParameter(projectsToImportWithChanges, (String)"projectsToImportWithChanges");
        Intrinsics.checkNotNullParameter((Object)mavenImportingSettings, (String)"mavenImportingSettings");
        Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(mavenProjectsTree, mavenImportingSettings, projectsToImportWithChanges);
        this.mavenProjectsTree = mavenProjectsTree;
        this.projectsToImportWithChanges = projectsToImportWithChanges;
        this.mavenImportingSettings = mavenImportingSettings;
        this.virtualFileUrlManager = virtualFileUrlManager;
        this.project = project2;
        this.createdModulesList = new ArrayList();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MavenProjectImporterToWorkspaceModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Project access$getProject$p(MavenProjectImporterToWorkspaceModel $this) {
        return $this.project;
    }

    public static final /* synthetic */ ArrayList access$getCreatedModulesList$p(MavenProjectImporterToWorkspaceModel $this) {
        return $this.createdModulesList;
    }

    public static final /* synthetic */ void access$configureMavenProjectsInBackground$s653221713(Collection projects, Map mavenProjectToModule, Project project2) {
        MavenProjectImporterBase.configureMavenProjectsInBackground(projects, mavenProjectToModule, project2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/MavenProjectImporterToWorkspaceModel$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

