/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.indices.MavenArchetypeManager;
import org.jetbrains.idea.maven.indices.MavenArchetypesProvider;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexHolder;
import org.jetbrains.idea.maven.indices.MavenIndexUpdateManager;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.indices.MavenRepositoryProvider;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.reposearch.DependencySearchService;

public final class MavenIndicesManager
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final MavenIndices myMavenIndices;
    private final MavenIndexServerDownloadListener myDownloadListener;
    private final MavenIndexerWrapper myIndexerWrapper;
    private final IndexFixer myIndexFixer;
    private final MavenIndexUpdateManager myIndexUpdateManager;
    private volatile Path myTestIndicesDir;

    public static MavenIndicesManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            MavenIndicesManager.$$$reportNull$$$0(0);
        }
        return (MavenIndicesManager)project2.getService(MavenIndicesManager.class);
    }

    public MavenIndicesManager(@NotNull Project project2) {
        if (project2 == null) {
            MavenIndicesManager.$$$reportNull$$$0(1);
        }
        this.myDownloadListener = new MavenIndexServerDownloadListener(this);
        this.myIndexFixer = new IndexFixer();
        this.myProject = project2;
        this.myIndexerWrapper = MavenServerManager.getInstance().createIndexer(this.myProject);
        this.myIndexUpdateManager = new MavenIndexUpdateManager();
        this.myMavenIndices = new MavenIndices(this.myIndexerWrapper, this.getIndicesDir().toFile(), new MavenSearchIndexListener(this));
        this.initListeners();
        Disposer.register((Disposable)this, (Disposable)this.myMavenIndices);
        Disposer.register((Disposable)this, (Disposable)this.myIndexUpdateManager);
    }

    public void dispose() {
        MavenServerManager mavenServerManager;
        if (MavenUtil.isMavenUnitTestModeEnabled()) {
            PathKt.delete((Path)this.getIndicesDir());
        }
        if ((mavenServerManager = MavenServerManager.getInstanceIfCreated()) != null) {
            mavenServerManager.removeDownloadListener(this.myDownloadListener);
        }
    }

    @NotNull
    public MavenIndexHolder getIndex() {
        if (this.myMavenIndices.isNotInit() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.myIndexUpdateManager.scheduleUpdateIndicesList(this.myProject, null);
        }
        MavenIndexHolder mavenIndexHolder = this.myMavenIndices.getIndexHolder();
        if (mavenIndexHolder == null) {
            MavenIndicesManager.$$$reportNull$$$0(2);
        }
        return mavenIndexHolder;
    }

    void updateIndicesListSync() {
        this.myMavenIndices.updateIndicesList(this.myProject);
    }

    public boolean isInit() {
        return this.myMavenIndices.isIndicesInit();
    }

    private void initListeners() {
        MavenServerManager.getInstance().addDownloadListener(this.myDownloadListener);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            MavenProjectsManager.getInstance(this.myProject).addProjectsTreeListener(new MavenProjectsTree.Listener(){

                @Override
                public void projectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
                    if (updated == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (deleted == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    DependencySearchService.getInstance((Project)MavenIndicesManager.this.myProject).clearCache();
                }

                @Override
                public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
                    if (projectWithChanges == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    DependencySearchService.getInstance((Project)MavenIndicesManager.this.myProject).clearCache();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "updated";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "deleted";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "projectWithChanges";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndicesManager$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "projectsUpdated";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "projectResolved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, this);
            return;
        }
        MavenRepositoryProvider.EP_NAME.addChangeListener(() -> this.scheduleUpdateIndicesList(null), (Disposable)this);
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        projectsManager.addProjectsTreeListener(new MavenProjectsTree.Listener(){

            @Override
            public void resolutionCompleted() {
                MavenIndicesManager.this.scheduleUpdateIndicesList(null);
            }
        }, this);
    }

    @TestOnly
    public void setTestIndexDir(Path indicesDir) {
        this.myTestIndicesDir = indicesDir;
    }

    @NotNull
    Path getIndicesDir() {
        Path path = this.myTestIndicesDir == null ? MavenUtil.getPluginSystemDir("Indices") : this.myTestIndicesDir;
        if (path == null) {
            MavenIndicesManager.$$$reportNull$$$0(3);
        }
        return path;
    }

    public void addArchetype(@NotNull MavenArchetype archetype) {
        if (archetype == null) {
            MavenIndicesManager.$$$reportNull$$$0(4);
        }
        MavenArchetypeManager.addArchetype(archetype, this.getUserArchetypesFile());
    }

    public boolean hasLocalGroupId(@NotNull String groupId) {
        MavenIndex localIndex;
        if (groupId == null) {
            MavenIndicesManager.$$$reportNull$$$0(5);
        }
        return (localIndex = this.getIndex().getLocalIndex()) != null && localIndex.hasGroupId(groupId);
    }

    public boolean hasLocalArtifactId(@Nullable String groupId, @Nullable String artifactId) {
        MavenIndex localIndex = this.getIndex().getLocalIndex();
        return localIndex != null && localIndex.hasArtifactId(groupId, artifactId);
    }

    public boolean hasLocalVersion(@Nullable String groupId, @Nullable String artifactId, @Nullable String version2) {
        MavenIndex localIndex = this.getIndex().getLocalIndex();
        return localIndex != null && localIndex.hasVersion(groupId, artifactId, version2);
    }

    public void addArtifactIndexAsync(@Nullable MavenId mavenId, @NotNull File artifactFile) {
        if (artifactFile == null) {
            MavenIndicesManager.$$$reportNull$$$0(6);
        }
        if (this.myMavenIndices.isNotInit()) {
            return;
        }
        MavenIndex localIndex = this.myMavenIndices.getIndexHolder().getLocalIndex();
        if (localIndex == null) {
            return;
        }
        AppExecutorUtil.getAppExecutorService().execute(() -> this.myIndexFixer.fixIndex(mavenId, artifactFile, localIndex));
    }

    public void scheduleUpdateContentAll() {
        this.myIndexUpdateManager.scheduleUpdateContent(this.myProject, ContainerUtil.map(this.myMavenIndices.getIndices(), MavenIndex::getRepositoryPathOrUrl));
    }

    public CompletableFuture<?> scheduleUpdateContent(@NotNull List<MavenIndex> indices) {
        if (indices == null) {
            MavenIndicesManager.$$$reportNull$$$0(7);
        }
        return this.myIndexUpdateManager.scheduleUpdateContent(this.myProject, ContainerUtil.map(indices, MavenIndex::getRepositoryPathOrUrl));
    }

    public void scheduleUpdateIndicesList(@Nullable Consumer<? super List<MavenIndex>> consumer) {
        this.myIndexUpdateManager.scheduleUpdateIndicesList(this.myProject, consumer);
    }

    public MavenIndexUpdateManager.IndexUpdatingState getUpdatingState(@NotNull MavenSearchIndex index) {
        if (index == null) {
            MavenIndicesManager.$$$reportNull$$$0(8);
        }
        return this.myIndexUpdateManager.getUpdatingState(index);
    }

    @Deprecated
    public Set<MavenArchetype> getArchetypes() {
        HashSet<MavenArchetype> result = new HashSet<MavenArchetype>(this.myIndexerWrapper.getArchetypes());
        result.addAll(MavenArchetypeManager.loadUserArchetypes(this.getIndicesDir().resolve("UserArchetypes.xml")));
        if (this.myMavenIndices.isNotInit()) {
            this.myMavenIndices.updateIndicesList(this.myProject);
        }
        MavenIndexHolder indexHolder = this.myMavenIndices.getIndexHolder();
        for (MavenIndex index : indexHolder.getIndices()) {
            result.addAll(index.getArchetypes());
        }
        for (MavenArchetypesProvider each : MavenArchetypesProvider.EP_NAME.getExtensionList()) {
            result.addAll(each.getArchetypes());
        }
        return result;
    }

    @NotNull
    private Path getUserArchetypesFile() {
        Path path = this.getIndicesDir().resolve("UserArchetypes.xml");
        if (path == null) {
            MavenIndicesManager.$$$reportNull$$$0(9);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/indices/MavenIndicesManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archetype";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndicesManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicesDir";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserArchetypesFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addArchetype";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasLocalGroupId";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addArtifactIndexAsync";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUpdateContent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatingState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MavenSearchIndexListener
    implements MavenSearchIndex.IndexListener {
        private final MavenIndicesManager myManager;

        private MavenSearchIndexListener(MavenIndicesManager manager) {
            this.myManager = manager;
        }

        @Override
        public void indexIsBroken(@NotNull MavenSearchIndex index) {
            if (index == null) {
                MavenSearchIndexListener.$$$reportNull$$$0(0);
            }
            if (index instanceof MavenIndex) {
                this.myManager.myIndexUpdateManager.scheduleUpdateContent(this.myManager.myProject, List.of(index.getRepositoryPathOrUrl()), false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "org/jetbrains/idea/maven/indices/MavenIndicesManager$MavenSearchIndexListener", "indexIsBroken"));
        }
    }

    private static class MavenIndexServerDownloadListener
    implements MavenServerDownloadListener {
        private final MavenIndicesManager myManager;

        private MavenIndexServerDownloadListener(MavenIndicesManager manager) {
            this.myManager = manager;
        }

        public void artifactDownloaded(File file, String relativePath) {
            this.myManager.addArtifactIndexAsync(null, file);
        }
    }

    private final class IndexFixer {
        private final ConcurrentLinkedQueue<File> queueToAdd = new ConcurrentLinkedQueue();
        private final MergingUpdateQueue myMergingUpdateQueue;
        private final AddToIndexRunnable taskConsumer = new AddToIndexRunnable();

        private IndexFixer() {
            this.myMergingUpdateQueue = new MergingUpdateQueue(this.getClass().getName(), 1000, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)MavenIndicesManager.this, null, false).usePassThroughInUnitTestMode();
        }

        public void fixIndex(@Nullable MavenId mavenId, @NotNull File file, @NotNull MavenIndex localIndex) {
            if (file == null) {
                IndexFixer.$$$reportNull$$$0(0);
            }
            if (localIndex == null) {
                IndexFixer.$$$reportNull$$$0(1);
            }
            if (mavenId != null) {
                if (mavenId.getGroupId() == null || mavenId.getArtifactId() == null || mavenId.getVersion() == null) {
                    return;
                }
                if (localIndex.hasVersion(mavenId.getGroupId(), mavenId.getArtifactId(), mavenId.getVersion())) {
                    return;
                }
            }
            this.queueToAdd.add(file);
            this.myMergingUpdateQueue.queue(Update.create((Object)this, (Runnable)this.taskConsumer));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "localIndex";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/indices/MavenIndicesManager$IndexFixer";
            objectArray[2] = "fixIndex";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class AddToIndexRunnable
        implements Runnable {
            private AddToIndexRunnable() {
            }

            @Override
            public void run() {
                File elementToAdd;
                MavenIndex localIndex = MavenIndicesManager.this.myMavenIndices.getIndexHolder().getLocalIndex();
                if (localIndex == null) {
                    return;
                }
                TreeSet<File> retryElements = new TreeSet<File>();
                TreeSet<File> addedFiles = new TreeSet<File>();
                while ((elementToAdd = IndexFixer.this.queueToAdd.poll()) != null) {
                    if (addedFiles.contains(elementToAdd)) continue;
                    boolean added = localIndex.tryAddArtifact(elementToAdd);
                    if (added) {
                        addedFiles.add(elementToAdd);
                        continue;
                    }
                    retryElements.add(elementToAdd);
                }
                if (!retryElements.isEmpty() && retryElements.size() < 10000) {
                    IndexFixer.this.queueToAdd.addAll(retryElements);
                }
            }
        }
    }
}

