/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.externalSystemIntegration.output.importproject.quickfixes.RepositoryBlockedSyncIssue;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectReaderResult;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;

@ApiStatus.Internal
public class MavenResolveResultProcessor {
    private static final String BLOCKED_MIRROR_FOR_REPOSITORIES = "Blocked mirror for repositories:";

    public static void notifySyncForProblem(@NotNull Project project2, @NotNull ArtifactTransferProblems problem) {
        if (project2 == null) {
            MavenResolveResultProcessor.$$$reportNull$$$0(0);
        }
        if (problem == null) {
            MavenResolveResultProcessor.$$$reportNull$$$0(1);
        }
        MavenSyncConsole syncConsole = MavenProjectsManager.getInstance(project2).getSyncConsole();
        for (MavenProjectProblem projectProblem : problem.repositoryBlockedProblems) {
            if (projectProblem.getDescription() == null) continue;
            BuildIssue buildIssue = RepositoryBlockedSyncIssue.getIssue(project2, projectProblem.getDescription());
            syncConsole.getListener(MavenServerProgressIndicator.ResolveType.DEPENDENCY).showBuildIssue(buildIssue.getTitle(), buildIssue);
        }
        for (MavenProjectProblem projectProblem : problem.unresolvedArtifactPronlems) {
            if (projectProblem.getMavenArtifact() == null || projectProblem.getDescription() == null) continue;
            syncConsole.getListener(MavenServerProgressIndicator.ResolveType.DEPENDENCY).showArtifactBuildIssue(projectProblem.getMavenArtifact().getMavenId().getKey(), projectProblem.getDescription());
        }
    }

    public static void notifySyncForProblem(@NotNull Project project2, @NotNull MavenProjectProblem problem) {
        if (project2 == null) {
            MavenResolveResultProcessor.$$$reportNull$$$0(2);
        }
        if (problem == null) {
            MavenResolveResultProcessor.$$$reportNull$$$0(3);
        }
        MavenSyncConsole syncConsole = MavenProjectsManager.getInstance(project2).getSyncConsole();
        String message = problem.getDescription();
        if (message == null) {
            return;
        }
        if (message.contains(BLOCKED_MIRROR_FOR_REPOSITORIES)) {
            BuildIssue buildIssue = RepositoryBlockedSyncIssue.getIssue(project2, problem.getDescription());
            syncConsole.getListener(MavenServerProgressIndicator.ResolveType.DEPENDENCY).showBuildIssue(buildIssue.getTitle(), buildIssue);
        } else if (problem.getMavenArtifact() == null) {
            MavenProjectsManager.getInstance(project2).getSyncConsole().addWarning(SyncBundle.message("maven.sync.annotation.processor.problem", new Object[0]), message);
        }
        if (problem.getMavenArtifact() != null) {
            syncConsole.getListener(MavenServerProgressIndicator.ResolveType.DEPENDENCY).showArtifactBuildIssue(problem.getMavenArtifact().getMavenId().getKey(), message);
        }
    }

    public static void notifyMavenProblems(@NotNull Project project2) {
        if (project2 == null) {
            MavenResolveResultProcessor.$$$reportNull$$$0(4);
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
        MavenSyncConsole syncConsole = projectsManager.getSyncConsole();
        for (MavenProject mavenProject2 : projectsManager.getProjects()) {
            for (MavenProjectProblem problem : mavenProject2.getProblems()) {
                syncConsole.showProblem(problem);
            }
        }
    }

    @NotNull
    public static ArtifactTransferProblems getArtifactTransferProblems(@NotNull Collection<MavenProjectReaderResult> results) {
        if (results == null) {
            MavenResolveResultProcessor.$$$reportNull$$$0(5);
        }
        HashSet<MavenProjectProblem> repositoryBlockedProblems = new HashSet<MavenProjectProblem>();
        HashSet<MavenProjectProblem> unresolvedArtifactProblems = new HashSet<MavenProjectProblem>();
        HashSet<MavenArtifact> unresolvedArtifacts = new HashSet<MavenArtifact>();
        boolean hasProblem = false;
        for (MavenProjectReaderResult result : results) {
            for (MavenProjectProblem problem : result.readingProblems) {
                String message;
                if (!hasProblem) {
                    hasProblem = true;
                }
                if (problem.getMavenArtifact() != null) {
                    unresolvedArtifactProblems.add(problem);
                    unresolvedArtifacts.add(problem.getMavenArtifact());
                }
                if ((message = problem.getDescription()) == null || !message.contains(BLOCKED_MIRROR_FOR_REPOSITORIES)) continue;
                repositoryBlockedProblems.add(problem);
            }
        }
        return new ArtifactTransferProblems(repositoryBlockedProblems, unresolvedArtifactProblems, unresolvedArtifacts);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/MavenResolveResultProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "notifySyncForProblem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyMavenProblems";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getArtifactTransferProblems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ArtifactTransferProblems {
        @NotNull
        public final Set<MavenProjectProblem> repositoryBlockedProblems;
        @NotNull
        public final Set<MavenProjectProblem> unresolvedArtifactPronlems;
        @NotNull
        public final Set<MavenArtifact> unresolvedArtifacts;

        public ArtifactTransferProblems(@NotNull Set<MavenProjectProblem> repositoryBlockedProblems, @NotNull Set<MavenProjectProblem> unresolvedArtifactPronlems, @NotNull Set<MavenArtifact> unresolvedArtifacts) {
            if (repositoryBlockedProblems == null) {
                ArtifactTransferProblems.$$$reportNull$$$0(0);
            }
            if (unresolvedArtifactPronlems == null) {
                ArtifactTransferProblems.$$$reportNull$$$0(1);
            }
            if (unresolvedArtifacts == null) {
                ArtifactTransferProblems.$$$reportNull$$$0(2);
            }
            this.repositoryBlockedProblems = repositoryBlockedProblems;
            this.unresolvedArtifactPronlems = unresolvedArtifactPronlems;
            this.unresolvedArtifacts = unresolvedArtifacts;
        }

        public boolean isEmpty() {
            return this.repositoryBlockedProblems.isEmpty() && this.unresolvedArtifactPronlems.isEmpty() && this.unresolvedArtifacts.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositoryBlockedProblems";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "unresolvedArtifactPronlems";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "unresolvedArtifacts";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/project/MavenResolveResultProcessor$ArtifactTransferProblems";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

