/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.importing;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.SyncViewManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.importing.FilesList;
import org.jetbrains.idea.maven.project.importing.ImportPaths;
import org.jetbrains.idea.maven.project.importing.MavenImportContext;
import org.jetbrains.idea.maven.project.importing.MavenImportFinishedContext;
import org.jetbrains.idea.maven.project.importing.MavenImportFlow;
import org.jetbrains.idea.maven.project.importing.MavenImportedContext;
import org.jetbrains.idea.maven.project.importing.MavenImportingManager;
import org.jetbrains.idea.maven.project.importing.MavenInitialImportContext;
import org.jetbrains.idea.maven.project.importing.MavenPluginResolvedContext;
import org.jetbrains.idea.maven.project.importing.MavenReadContext;
import org.jetbrains.idea.maven.project.importing.MavenResolvedContext;
import org.jetbrains.idea.maven.project.importing.MavenSourcesGeneratedContext;
import org.jetbrains.idea.maven.project.importing.MavenStartedImport;
import org.jetbrains.idea.maven.project.importing.RootPath;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 ;2\u00020\u0001:\u0001;B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0002J0\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J2\u0010%\u001a\u0002H&\"\b\b\u0000\u0010&*\u00020\r2\u000b\u0010'\u001a\u00070(\u00a2\u0006\u0002\b)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H&0+H\u0002\u00a2\u0006\u0002\u0010,J\u0006\u0010-\u001a\u00020\u0019J\u001c\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150/2\u0006\u00100\u001a\u00020\u0016H\u0002J\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001602J\u0006\u00103\u001a\u000204J\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020\u0016022\u0006\u00106\u001a\u000207J,\u00108\u001a\b\u0012\u0004\u0012\u00020\u0016022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020$J\u001e\u00109\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00160+H\u0002J\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020\u0016022\u0006\u0010#\u001a\u00020$R#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R*\u0010\u0013\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/idea/maven/project/importing/MavenImportingManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "console", "Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;", "kotlin.jvm.PlatformType", "getConsole", "()Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;", "console$delegate", "Lkotlin/Lazy;", "<set-?>", "Lorg/jetbrains/idea/maven/project/importing/MavenImportContext;", "currentContext", "getCurrentContext", "()Lorg/jetbrains/idea/maven/project/importing/MavenImportContext;", "getProject", "()Lcom/intellij/openapi/project/Project;", "waitingPromises", "Ljava/util/ArrayList;", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lorg/jetbrains/idea/maven/project/importing/MavenImportFinishedContext;", "Lkotlin/collections/ArrayList;", "assertNoCurrentImport", "", "doImport", "indicator", "Lorg/jetbrains/idea/maven/utils/MavenProgressIndicator;", "importPaths", "Lorg/jetbrains/idea/maven/project/importing/ImportPaths;", "generalSettings", "Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "importingSettings", "Lorg/jetbrains/idea/maven/project/MavenImportingSettings;", "spec", "Lorg/jetbrains/idea/maven/buildtool/MavenImportSpec;", "doTask", "Result", "message", "", "Lcom/intellij/build/events/BuildEventsNls$Message;", "init", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Lorg/jetbrains/idea/maven/project/importing/MavenImportContext;", "forceStopImport", "getAndClearWaitingPromises", "", "finishedContext", "getImportFinishPromise", "Lorg/jetbrains/concurrency/Promise;", "isImportingInProgress", "", "linkAndImportFile", "pom", "Lcom/intellij/openapi/vfs/VirtualFile;", "openProjectAndImport", "runSync", "scheduleImportAll", "Companion", "intellij.maven"})
@ApiStatus.Experimental
public final class MavenImportingManager {
    @Nullable
    private MavenImportContext currentContext;
    private final Lazy console$delegate;
    private final ArrayList<AsyncPromise<MavenImportFinishedContext>> waitingPromises;
    @NotNull
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final MavenImportContext getCurrentContext() {
        return this.currentContext;
    }

    private final MavenSyncConsole getConsole() {
        Lazy lazy = this.console$delegate;
        MavenImportingManager mavenImportingManager = this;
        Object var3_3 = null;
        return (MavenSyncConsole)lazy.getValue();
    }

    @NotNull
    public final Promise<MavenImportFinishedContext> linkAndImportFile(@NotNull VirtualFile pom2) {
        Intrinsics.checkNotNullParameter((Object)pom2, (String)"pom");
        ApplicationManager.getApplication().assertIsDispatchThread();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.project);
        ImportPaths importPath = pom2.isDirectory() ? (ImportPaths)new RootPath(pom2) : (ImportPaths)new FilesList(pom2);
        MavenProjectsManager mavenProjectsManager = manager;
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"manager");
        MavenImportingSettings mavenImportingSettings = mavenProjectsManager.getImportingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"manager.importingSettings");
        MavenGeneralSettings mavenGeneralSettings = manager.getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"manager.generalSettings");
        MavenImportSpec mavenImportSpec = MavenImportSpec.EXPLICIT_IMPORT;
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportSpec, (String)"MavenImportSpec.EXPLICIT_IMPORT");
        return this.openProjectAndImport(importPath, mavenImportingSettings, mavenGeneralSettings, mavenImportSpec);
    }

    @NotNull
    public final Promise<MavenImportFinishedContext> openProjectAndImport(@NotNull ImportPaths importPaths, @NotNull MavenImportingSettings importingSettings, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenImportSpec spec) {
        Intrinsics.checkNotNullParameter((Object)importPaths, (String)"importPaths");
        Intrinsics.checkNotNullParameter((Object)importingSettings, (String)"importingSettings");
        Intrinsics.checkNotNullParameter((Object)generalSettings, (String)"generalSettings");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.assertNoCurrentImport();
        MavenUtil.setupProjectSdk(this.project);
        this.currentContext = new MavenStartedImport(this.project);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, importPaths, generalSettings, importingSettings, spec){
            final /* synthetic */ MavenImportingManager this$0;
            final /* synthetic */ ImportPaths $importPaths;
            final /* synthetic */ MavenGeneralSettings $generalSettings;
            final /* synthetic */ MavenImportingSettings $importingSettings;
            final /* synthetic */ MavenImportSpec $spec;

            public final void run() {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, this.this$0.getProject(), MavenProjectBundle.message("maven.project.importing", new Object[0])){
                    final /* synthetic */ openProjectAndImport.1 this$0;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        try {
                            MavenImportFinishedContext finishedContext = MavenImportingManager.access$doImport(this.this$0.this$0, new MavenProgressIndicator(this.getProject(), indicator, null), this.this$0.$importPaths, this.this$0.$generalSettings, this.this$0.$importingSettings, this.this$0.$spec);
                            List promises = MavenImportingManager.access$getAndClearWaitingPromises(this.this$0.this$0, finishedContext);
                            Iterable $this$forEach$iv = promises;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                AsyncPromise it = (AsyncPromise)element$iv;
                                boolean bl = false;
                                it.setResult((Object)finishedContext);
                            }
                        }
                        catch (Throwable e) {
                            MavenImportingManager mavenImportingManager = this.this$0.this$0;
                            Project project2 = this.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                            List promises = MavenImportingManager.access$getAndClearWaitingPromises(mavenImportingManager, new MavenImportFinishedContext(e, project2));
                            if (indicator.isCanceled()) {
                                Iterable $this$forEach$iv = promises;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    AsyncPromise it = (AsyncPromise)element$iv;
                                    boolean bl = false;
                                    it.setError("Cancelled");
                                }
                            } else {
                                MavenLog.LOG.error(e);
                                Iterable $this$forEach$iv = promises;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    AsyncPromise it = (AsyncPromise)element$iv;
                                    boolean bl = false;
                                    it.setError(e);
                                }
                            }
                        }
                    }
                    {
                        this.this$0 = this$0;
                        super($super_call_param$1, $super_call_param$2);
                    }
                });
            }
            {
                this.this$0 = mavenImportingManager;
                this.$importPaths = importPaths;
                this.$generalSettings = mavenGeneralSettings;
                this.$importingSettings = mavenImportingSettings;
                this.$spec = mavenImportSpec;
            }
        });
        return this.getImportFinishPromise();
    }

    private final void assertNoCurrentImport() {
        if (this.currentContext != null && !(this.currentContext instanceof MavenImportFinishedContext)) {
            throw (Throwable)new IllegalStateException("Importing is in progress already");
        }
    }

    private final MavenImportFinishedContext doImport(MavenProgressIndicator indicator, ImportPaths importPaths, MavenGeneralSettings generalSettings, MavenImportingSettings importingSettings, MavenImportSpec spec) {
        MavenImportFinishedContext mavenImportFinishedContext;
        block0: {
            MavenImportFlow flow = new MavenImportFlow();
            MavenImportFinishedContext it = mavenImportFinishedContext = this.runSync(spec, (Function0<MavenImportFinishedContext>)((Function0)new Function0<MavenImportFinishedContext>(this, flow, indicator, importPaths, generalSettings, importingSettings){
                final /* synthetic */ MavenImportingManager this$0;
                final /* synthetic */ MavenImportFlow $flow;
                final /* synthetic */ MavenProgressIndicator $indicator;
                final /* synthetic */ ImportPaths $importPaths;
                final /* synthetic */ MavenGeneralSettings $generalSettings;
                final /* synthetic */ MavenImportingSettings $importingSettings;

                @NotNull
                public final MavenImportFinishedContext invoke() {
                    MavenImportingManager.access$getConsole$p(this.this$0).addWarning("New Maven importing flow is enabled", "New Maven importing flow is enabled, it is experimental feature. \n\nTo revert to old importing flow, set \"maven.new.import\" registry flag to false");
                    MavenInitialImportContext initialImport = this.$flow.prepareNewImport(this.this$0.getProject(), this.$indicator, this.$importPaths, this.$generalSettings, this.$importingSettings, CollectionsKt.emptyList(), CollectionsKt.emptyList());
                    MavenImportingManager.access$setCurrentContext$p(this.this$0, initialImport);
                    String string = MavenProjectBundle.message("maven.reading", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MavenProjectBundle.message(\"maven.reading\")");
                    MavenReadContext readMavenFiles2 = (MavenReadContext)MavenImportingManager.access$doTask(this.this$0, string, (Function0)new Function0<MavenReadContext>(this, initialImport){
                        final /* synthetic */ doImport.1 this$0;
                        final /* synthetic */ MavenInitialImportContext $initialImport;

                        @NotNull
                        public final MavenReadContext invoke() {
                            block0: {
                                Object object = this.this$0.this$0.getCurrentContext();
                                if (object == null || (object = ((MavenImportContext)object).getIndicator()) == null) break block0;
                                ((MavenProgressIndicator)object).checkCanceled();
                            }
                            return MavenImportFlow.readMavenFiles$default(this.this$0.$flow, this.$initialImport, null, null, 6, null);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$initialImport = mavenInitialImportContext;
                            super(0);
                        }
                    });
                    String string2 = MavenProjectBundle.message("maven.resolving", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MavenProjectBundle.message(\"maven.resolving\")");
                    MavenResolvedContext dependenciesContext2 = (MavenResolvedContext)MavenImportingManager.access$doTask(this.this$0, string2, (Function0)new Function0<MavenResolvedContext>(this, readMavenFiles2){
                        final /* synthetic */ doImport.1 this$0;
                        final /* synthetic */ MavenReadContext $readMavenFiles;

                        @NotNull
                        public final MavenResolvedContext invoke() {
                            block0: {
                                Object object = this.this$0.this$0.getCurrentContext();
                                if (object == null || (object = ((MavenImportContext)object).getIndicator()) == null) break block0;
                                ((MavenProgressIndicator)object).checkCanceled();
                            }
                            return this.this$0.$flow.resolveDependencies(this.$readMavenFiles);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$readMavenFiles = mavenReadContext;
                            super(0);
                        }
                    });
                    String string3 = MavenProjectBundle.message("maven.downloading.plugins", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MavenProjectBundle.messa\u2026ven.downloading.plugins\")");
                    MavenPluginResolvedContext resolvePlugins2 = (MavenPluginResolvedContext)MavenImportingManager.access$doTask(this.this$0, string3, (Function0)new Function0<MavenPluginResolvedContext>(this, dependenciesContext2){
                        final /* synthetic */ doImport.1 this$0;
                        final /* synthetic */ MavenResolvedContext $dependenciesContext;

                        @NotNull
                        public final MavenPluginResolvedContext invoke() {
                            block0: {
                                Object object = this.this$0.this$0.getCurrentContext();
                                if (object == null || (object = ((MavenImportContext)object).getIndicator()) == null) break block0;
                                ((MavenProgressIndicator)object).checkCanceled();
                            }
                            return this.this$0.$flow.resolvePlugins(this.$dependenciesContext);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$dependenciesContext = mavenResolvedContext;
                            super(0);
                        }
                    });
                    String string4 = MavenProjectBundle.message("maven.updating.folders", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"MavenProjectBundle.messa\u2026\"maven.updating.folders\")");
                    MavenSourcesGeneratedContext foldersResolved2 = (MavenSourcesGeneratedContext)MavenImportingManager.access$doTask(this.this$0, string4, (Function0)new Function0<MavenSourcesGeneratedContext>(this, dependenciesContext2){
                        final /* synthetic */ doImport.1 this$0;
                        final /* synthetic */ MavenResolvedContext $dependenciesContext;

                        @NotNull
                        public final MavenSourcesGeneratedContext invoke() {
                            block0: {
                                Object object = this.this$0.this$0.getCurrentContext();
                                if (object == null || (object = ((MavenImportContext)object).getIndicator()) == null) break block0;
                                ((MavenProgressIndicator)object).checkCanceled();
                            }
                            return this.this$0.$flow.resolveFolders(this.$dependenciesContext);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$dependenciesContext = mavenResolvedContext;
                            super(0);
                        }
                    });
                    String string5 = MavenProjectBundle.message("maven.project.importing", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"MavenProjectBundle.messa\u2026maven.project.importing\")");
                    MavenImportedContext importContext2 = (MavenImportedContext)MavenImportingManager.access$doTask(this.this$0, string5, (Function0)new Function0<MavenImportedContext>(this, dependenciesContext2){
                        final /* synthetic */ doImport.1 this$0;
                        final /* synthetic */ MavenResolvedContext $dependenciesContext;

                        @NotNull
                        public final MavenImportedContext invoke() {
                            block0: {
                                Object object = this.this$0.this$0.getCurrentContext();
                                if (object == null || (object = ((MavenImportContext)object).getIndicator()) == null) break block0;
                                ((MavenProgressIndicator)object).checkCanceled();
                            }
                            return this.this$0.$flow.commitToWorkspaceModel(this.$dependenciesContext);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$dependenciesContext = mavenResolvedContext;
                            super(0);
                        }
                    });
                    String string6 = MavenProjectBundle.message("maven.post.processing", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"MavenProjectBundle.messa\u2026(\"maven.post.processing\")");
                    return (MavenImportFinishedContext)MavenImportingManager.access$doTask(this.this$0, string6, (Function0)new Function0<MavenImportFinishedContext>(this, importContext2, readMavenFiles2){
                        final /* synthetic */ doImport.1 this$0;
                        final /* synthetic */ MavenImportedContext $importContext;
                        final /* synthetic */ MavenReadContext $readMavenFiles;

                        @NotNull
                        public final MavenImportFinishedContext invoke() {
                            Object object = this.this$0.this$0.getCurrentContext();
                            if (object != null && (object = ((MavenImportContext)object).getIndicator()) != null) {
                                ((MavenProgressIndicator)object).checkCanceled();
                            }
                            this.this$0.$flow.runPostImportTasks(this.$importContext);
                            this.this$0.$flow.updateProjectManager(this.$readMavenFiles);
                            this.this$0.$flow.configureMavenProject(this.$importContext);
                            return new MavenImportFinishedContext(this.$importContext);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$importContext = mavenImportedContext;
                            this.$readMavenFiles = mavenReadContext;
                            super(0);
                        }
                    });
                }
                {
                    this.this$0 = mavenImportingManager;
                    this.$flow = mavenImportFlow;
                    this.$indicator = mavenProgressIndicator;
                    this.$importPaths = importPaths;
                    this.$generalSettings = mavenGeneralSettings;
                    this.$importingSettings = mavenImportingSettings;
                    super(0);
                }
            }));
            boolean bl = false;
            MavenImportedContext mavenImportedContext = it.getContext();
            if (mavenImportedContext == null) break block0;
            MavenImportedContext mavenImportedContext2 = mavenImportedContext;
            MavenImportFlow mavenImportFlow = flow;
            MavenImportedContext p1 = mavenImportedContext2;
            boolean bl2 = false;
            mavenImportFlow.runImportExtensions(p1);
        }
        return mavenImportFinishedContext;
    }

    private final List<AsyncPromise<MavenImportFinishedContext>> getAndClearWaitingPromises(MavenImportFinishedContext finishedContext) {
        Ref ref = new Ref();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(this, ref, finishedContext){
            final /* synthetic */ MavenImportingManager this$0;
            final /* synthetic */ Ref $ref;
            final /* synthetic */ MavenImportFinishedContext $finishedContext;

            public final void run() {
                ArrayList<E> result = new ArrayList<E>(MavenImportingManager.access$getWaitingPromises$p(this.this$0));
                this.$ref.set(result);
                MavenImportingManager.access$getWaitingPromises$p(this.this$0).clear();
                MavenImportingManager.access$setCurrentContext$p(this.this$0, this.$finishedContext);
            }
            {
                this.this$0 = mavenImportingManager;
                this.$ref = ref;
                this.$finishedContext = mavenImportFinishedContext;
            }
        });
        Object object = ref.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ref.get()");
        return (List)object;
    }

    public final boolean isImportingInProgress() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.currentContext != null && !(this.currentContext instanceof MavenImportFinishedContext);
    }

    @NotNull
    public final Promise<MavenImportFinishedContext> getImportFinishPromise() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        MavenImportContext context = this.currentContext;
        if (context instanceof MavenImportFinishedContext) {
            return Promises.resolvedPromise((Object)context);
        }
        AsyncPromise result = new AsyncPromise();
        this.waitingPromises.add((AsyncPromise<MavenImportFinishedContext>)result);
        return (Promise)result;
    }

    @NotNull
    public final Promise<MavenImportFinishedContext> scheduleImportAll(@NotNull MavenImportSpec spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        ApplicationManager.getApplication().assertIsDispatchThread();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.project);
        MavenWorkspaceSettingsComponent settings = MavenWorkspaceSettingsComponent.getInstance(this.project);
        List<VirtualFile> list = manager.collectAllAvailablePomFiles();
        Intrinsics.checkNotNullExpressionValue(list, (String)"manager.collectAllAvailablePomFiles()");
        ImportPaths importPaths = new FilesList(list);
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent = settings;
        Intrinsics.checkNotNullExpressionValue((Object)mavenWorkspaceSettingsComponent, (String)"settings");
        MavenImportingSettings mavenImportingSettings = mavenWorkspaceSettingsComponent.getSettings().getImportingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"settings.settings.getImportingSettings()");
        MavenGeneralSettings mavenGeneralSettings = settings.getSettings().getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"settings.settings.getGeneralSettings()");
        return this.openProjectAndImport(importPaths, mavenImportingSettings, mavenGeneralSettings, spec);
    }

    private final <Result extends MavenImportContext> Result doTask(String message, Function0<? extends Result> init) {
        Result Result2 = this.getConsole().runTask(message, init);
        MavenImportContext it = (MavenImportContext)Result2;
        boolean bl = false;
        this.currentContext = it;
        return (Result)((MavenImportContext)Result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MavenImportFinishedContext runSync(MavenImportSpec spec, Function0<MavenImportFinishedContext> init) {
        MavenSyncConsole mavenSyncConsole = this.getConsole();
        Object object = this.project.getService(SyncViewManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(SyncViewManager::class.java)");
        mavenSyncConsole.startImport((BuildProgressListener)object, spec);
        try {
            MavenImportFinishedContext mavenImportFinishedContext = (MavenImportFinishedContext)init.invoke();
            return mavenImportFinishedContext;
        }
        catch (Exception e) {
            MavenSyncConsole mavenSyncConsole2 = this.getConsole();
            Throwable throwable = e;
            Object object2 = this.project.getService(SyncViewManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.getService(SyncViewManager::class.java)");
            mavenSyncConsole2.addException(throwable, (BuildProgressListener)object2);
            MavenImportFinishedContext mavenImportFinishedContext = new MavenImportFinishedContext(e, this.project);
            return mavenImportFinishedContext;
        }
        finally {
            this.getConsole().finishImport();
        }
    }

    public final void forceStopImport() {
        block0: {
            MavenImportContext mavenImportContext;
            MavenImportContext mavenImportContext2 = this.currentContext;
            if (mavenImportContext2 == null) break block0;
            MavenImportContext it = mavenImportContext = mavenImportContext2;
            boolean bl = false;
            it.getIndicator().cancel();
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public MavenImportingManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.console$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MavenSyncConsole>(this){
            final /* synthetic */ MavenImportingManager this$0;

            public final MavenSyncConsole invoke() {
                Object object = this.this$0.getProject().getService(MavenProjectsManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Maven\u2026jectsManager::class.java)");
                return ((MavenProjectsManager)object).getSyncConsole();
            }
            {
                this.this$0 = mavenImportingManager;
                super(0);
            }
        }));
        this.waitingPromises = new ArrayList();
    }

    public static final /* synthetic */ MavenImportFinishedContext access$doImport(MavenImportingManager $this, MavenProgressIndicator indicator, ImportPaths importPaths, MavenGeneralSettings generalSettings, MavenImportingSettings importingSettings, MavenImportSpec spec) {
        return $this.doImport(indicator, importPaths, generalSettings, importingSettings, spec);
    }

    public static final /* synthetic */ List access$getAndClearWaitingPromises(MavenImportingManager $this, MavenImportFinishedContext finishedContext) {
        return $this.getAndClearWaitingPromises(finishedContext);
    }

    public static final /* synthetic */ MavenSyncConsole access$getConsole$p(MavenImportingManager $this) {
        return $this.getConsole();
    }

    public static final /* synthetic */ MavenImportContext access$getCurrentContext$p(MavenImportingManager $this) {
        return $this.currentContext;
    }

    public static final /* synthetic */ void access$setCurrentContext$p(MavenImportingManager $this, MavenImportContext mavenImportContext) {
        $this.currentContext = mavenImportContext;
    }

    public static final /* synthetic */ MavenImportContext access$doTask(MavenImportingManager $this, String message, Function0 init) {
        return $this.doTask(message, init);
    }

    public static final /* synthetic */ ArrayList access$getWaitingPromises$p(MavenImportingManager $this) {
        return $this.waitingPromises;
    }

    @JvmStatic
    @NotNull
    public static final MavenImportingManager getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/maven/project/importing/MavenImportingManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/idea/maven/project/importing/MavenImportingManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.maven"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final MavenImportingManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(MavenImportingManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Maven\u2026rtingManager::class.java)");
            return (MavenImportingManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

