/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.server.MavenArtifactDownloadServerProgressEvent;
import org.jetbrains.idea.maven.server.MavenArtifactResolveResult;
import org.jetbrains.idea.maven.server.MavenBuildPathsChange;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenServerConsole;
import org.jetbrains.idea.maven.server.MavenServerConsoleEvent;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.server.MavenServerPullProgressIndicator;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public abstract class MavenEmbedderWrapper
extends MavenRemoteObjectWrapper<MavenServerEmbedder> {
    private Customization myCustomization;
    private final Project myProject;
    private ScheduledFuture<?> myProgressPullingFuture;
    private AtomicInteger myFails;

    public MavenEmbedderWrapper(@NotNull Project project2, @Nullable RemoteObjectWrapper<?> parent) {
        if (project2 == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(0);
        }
        super(parent);
        this.myFails = new AtomicInteger(0);
        this.myProject = project2;
    }

    @Override
    protected synchronized void onWrappeeCreated() throws RemoteException {
        super.onWrappeeCreated();
        if (this.myCustomization != null) {
            this.doCustomize();
        }
    }

    public void customizeForResolve(MavenConsole console2, MavenProgressIndicator indicator) {
        boolean alwaysUpdateSnapshots = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings().getGeneralSettings().isAlwaysUpdateSnapshots();
        this.setCustomization(console2, indicator, null, false, alwaysUpdateSnapshots, null);
        this.perform(() -> {
            this.doCustomize();
            return null;
        });
    }

    public void customizeForResolve(MavenConsole console2, MavenProgressIndicator indicator, boolean forceUpdateSnapshots) {
        boolean alwaysUpdateSnapshots = forceUpdateSnapshots ? forceUpdateSnapshots : MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings().getGeneralSettings().isAlwaysUpdateSnapshots();
        this.setCustomization(console2, indicator, null, false, alwaysUpdateSnapshots, null);
        this.perform(() -> {
            this.doCustomize();
            return null;
        });
    }

    public void customizeForResolve(MavenWorkspaceMap workspaceMap, MavenConsole console2, MavenProgressIndicator indicator, boolean alwaysUpdateSnapshot) {
        this.customizeForResolve(workspaceMap, console2, indicator, alwaysUpdateSnapshot, null);
    }

    public void customizeForResolve(MavenWorkspaceMap workspaceMap, MavenConsole console2, MavenProgressIndicator indicator, boolean alwaysUpdateSnapshot, @Nullable Properties userProperties) {
        MavenWorkspaceMap serverWorkspaceMap = this.convertWorkspaceMap(workspaceMap);
        this.setCustomization(console2, indicator, serverWorkspaceMap, false, alwaysUpdateSnapshot, userProperties);
        this.perform(() -> {
            this.doCustomize();
            return null;
        });
    }

    private MavenWorkspaceMap convertWorkspaceMap(MavenWorkspaceMap map) {
        RemotePathTransformerFactory.Transformer transformer = RemotePathTransformerFactory.createForProject(this.myProject);
        if (transformer == RemotePathTransformerFactory.Transformer.ID) {
            return map;
        }
        return MavenWorkspaceMap.copy((MavenWorkspaceMap)map, transformer::toRemotePath);
    }

    public void customizeForStrictResolve(MavenWorkspaceMap workspaceMap, MavenConsole console2, MavenProgressIndicator indicator) {
        MavenWorkspaceMap serverWorkspaceMap = this.convertWorkspaceMap(workspaceMap);
        boolean alwaysUpdateSnapshots = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings().getGeneralSettings().isAlwaysUpdateSnapshots();
        this.setCustomization(console2, indicator, serverWorkspaceMap, true, alwaysUpdateSnapshots, null);
        this.perform(() -> {
            this.doCustomize();
            return null;
        });
    }

    public void customizeForGetVersions() {
        this.perform(() -> {
            this.doCustomizeComponents();
            return null;
        });
    }

    private synchronized void doCustomizeComponents() throws RemoteException {
        ((MavenServerEmbedder)this.getOrCreateWrappee()).customizeComponents(ourToken);
    }

    private synchronized void doCustomize() throws RemoteException {
        MavenServerPullProgressIndicator pullProgressIndicator = ((MavenServerEmbedder)this.getOrCreateWrappee()).customizeAndGetProgressIndicator(this.myCustomization.workspaceMap, this.myCustomization.failOnUnresolvedDependency, this.myCustomization.alwaysUpdateSnapshot, this.myCustomization.userProperties, ourToken);
        if (pullProgressIndicator == null) {
            return;
        }
        this.startPullingProgress(pullProgressIndicator, this.myCustomization.console, this.myCustomization.indicator);
    }

    private void startPullingProgress(MavenServerPullProgressIndicator serverPullProgressIndicator, MavenConsole console2, MavenProgressIndicator indicator) {
        ScheduledFuture<?> future = this.myProgressPullingFuture;
        if (future != null && !future.isCancelled()) {
            future.cancel(true);
        }
        this.myProgressPullingFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
            block12: {
                try {
                    List consoleEvents;
                    List artifactEvents;
                    if (indicator.isCanceled()) {
                        serverPullProgressIndicator.cancel();
                    }
                    if ((artifactEvents = serverPullProgressIndicator.pullDownloadEvents()) != null) {
                        for (MavenArtifactDownloadServerProgressEvent e : artifactEvents) {
                            switch (e.getArtifactEventType()) {
                                case DOWNLOAD_STARTED: {
                                    indicator.startedDownload(e.getResolveType(), e.getDependencyId());
                                    break;
                                }
                                case DOWNLOAD_COMPLETED: {
                                    indicator.completedDownload(e.getResolveType(), e.getDependencyId());
                                    break;
                                }
                                case DOWNLOAD_FAILED: {
                                    indicator.failedDownload(e.getResolveType(), e.getDependencyId(), e.getErrorMessage(), e.getStackTrace());
                                }
                            }
                        }
                    }
                    if ((consoleEvents = serverPullProgressIndicator.pullConsoleEvents()) != null) {
                        for (MavenServerConsoleEvent e : consoleEvents) {
                            console2.printMessage(e.getLevel(), e.getMessage(), e.getThrowable());
                        }
                    }
                    this.myFails.set(0);
                }
                catch (RemoteException e) {
                    if (Thread.currentThread().isInterrupted()) break block12;
                    this.myFails.incrementAndGet();
                }
            }
        }, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected synchronized void cleanup() {
        int count;
        if (this.myProgressPullingFuture != null) {
            this.myProgressPullingFuture.cancel(true);
        }
        if ((count = this.myFails.get()) != 0) {
            MavenLog.LOG.warn("Maven embedder download listener was failed: " + count + " times");
        }
        super.cleanup();
    }

    public MavenServerExecutionResult resolveProject(@NotNull VirtualFile file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles) throws MavenProcessCanceledException {
        if (file == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(1);
        }
        if (activeProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(2);
        }
        if (inactiveProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(3);
        }
        return this.resolveProject(Collections.singleton(file), activeProfiles, inactiveProfiles).iterator().next();
    }

    @NotNull
    public Collection<MavenServerExecutionResult> resolveProject(@NotNull Collection<VirtualFile> files, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles) throws MavenProcessCanceledException {
        if (files == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(4);
        }
        if (activeProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(5);
        }
        if (inactiveProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(6);
        }
        Collection collection = this.performCancelable(() -> {
            RemotePathTransformerFactory.Transformer transformer = files.isEmpty() ? RemotePathTransformerFactory.Transformer.ID : RemotePathTransformerFactory.createForProject(this.myProject);
            List ioFiles = ContainerUtil.map((Collection)files, file -> new File(transformer.toRemotePath(file.getPath())));
            Collection results = ((MavenServerEmbedder)this.getOrCreateWrappee()).resolveProject((Collection)ioFiles, activeProfiles, inactiveProfiles, ourToken);
            if (transformer != RemotePathTransformerFactory.Transformer.ID) {
                for (MavenServerExecutionResult result : results) {
                    MavenServerExecutionResult.ProjectData data = result.projectData;
                    if (data == null) continue;
                    new MavenBuildPathsChange((Function1<? super String, String>)((Function1)s -> transformer.toIdePath((String)s)), (Function1<? super String, Boolean>)((Function1)s -> transformer.canBeRemotePath((String)s))).perform(data.mavenModel);
                }
            }
            return results;
        });
        if (collection == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Nullable
    public String evaluateEffectivePom(@NotNull VirtualFile file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles) throws MavenProcessCanceledException {
        if (file == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(8);
        }
        if (activeProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(9);
        }
        if (inactiveProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(10);
        }
        return this.evaluateEffectivePom(new File(file.getPath()), activeProfiles, inactiveProfiles);
    }

    @Nullable
    public String evaluateEffectivePom(@NotNull File file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles) throws MavenProcessCanceledException {
        if (file == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(11);
        }
        if (activeProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(12);
        }
        if (inactiveProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(13);
        }
        return this.performCancelable(() -> ((MavenServerEmbedder)this.getOrCreateWrappee()).evaluateEffectivePom(file, new ArrayList(activeProfiles), new ArrayList(inactiveProfiles), ourToken));
    }

    @NotNull
    public MavenArtifact resolve(@NotNull MavenArtifactInfo info, @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        if (info == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(14);
        }
        if (remoteRepositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(15);
        }
        MavenArtifact mavenArtifact = this.performCancelable(() -> ((MavenServerEmbedder)this.getOrCreateWrappee()).resolve(info, remoteRepositories, ourToken));
        if (mavenArtifact == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(16);
        }
        return mavenArtifact;
    }

    @Deprecated
    @NotNull
    public List<MavenArtifact> resolveTransitively(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        if (artifacts == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(17);
        }
        if (remoteRepositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(18);
        }
        List list = this.performCancelable(() -> ((MavenServerEmbedder)this.getOrCreateWrappee()).resolveTransitively(artifacts, remoteRepositories, ourToken));
        if (list == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public MavenArtifactResolveResult resolveArtifactTransitively(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        if (artifacts == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(20);
        }
        if (remoteRepositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(21);
        }
        MavenArtifactResolveResult mavenArtifactResolveResult = this.performCancelable(() -> ((MavenServerEmbedder)this.getOrCreateWrappee()).resolveArtifactTransitively(artifacts, remoteRepositories, ourToken));
        if (mavenArtifactResolveResult == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(22);
        }
        return mavenArtifactResolveResult;
    }

    @NotNull
    public List<String> retrieveVersions(@NotNull String groupId, @NotNull String artifactId, @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        if (groupId == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(23);
        }
        if (artifactId == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(24);
        }
        if (remoteRepositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(25);
        }
        List list = this.performCancelable(() -> ((MavenServerEmbedder)this.getOrCreateWrappee()).retrieveAvailableVersions(groupId, artifactId, remoteRepositories, ourToken));
        if (list == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(26);
        }
        return list;
    }

    public Collection<MavenArtifact> resolvePlugin(@NotNull MavenPlugin plugin, @NotNull List<MavenRemoteRepository> repositories, @NotNull NativeMavenProjectHolder nativeMavenProject, boolean transitive) throws MavenProcessCanceledException {
        int id;
        if (plugin == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(27);
        }
        if (repositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(28);
        }
        if (nativeMavenProject == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(29);
        }
        try {
            id = nativeMavenProject.getId();
        }
        catch (RemoteException e) {
            return Collections.emptyList();
        }
        try {
            return ((MavenServerEmbedder)this.getOrCreateWrappee()).resolvePlugin(plugin, repositories, id, transitive, ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
            return Collections.emptyList();
        }
        catch (MavenServerProcessCanceledException e) {
            throw new MavenProcessCanceledException();
        }
    }

    public MavenModel readModel(File file) throws MavenProcessCanceledException {
        return this.performCancelable(() -> ((MavenServerEmbedder)this.getOrCreateWrappee()).readModel(file, ourToken));
    }

    @NotNull
    public MavenServerExecutionResult execute(@NotNull VirtualFile file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles, @NotNull List<String> goals2) throws MavenProcessCanceledException {
        if (file == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(30);
        }
        if (activeProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(31);
        }
        if (inactiveProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(32);
        }
        if (goals2 == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(33);
        }
        MavenServerExecutionResult mavenServerExecutionResult = this.performCancelable(() -> ((MavenServerEmbedder)this.getOrCreateWrappee()).execute(new File(file.getPath()), activeProfiles, inactiveProfiles, goals2, Collections.emptyList(), false, false, ourToken));
        if (mavenServerExecutionResult == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(34);
        }
        return mavenServerExecutionResult;
    }

    @NotNull
    public MavenServerExecutionResult execute(@NotNull VirtualFile file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles, @NotNull List<String> goals2, @NotNull List<String> selectedProjects, boolean alsoMake, boolean alsoMakeDependents) throws MavenProcessCanceledException {
        if (file == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(35);
        }
        if (activeProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(36);
        }
        if (inactiveProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(37);
        }
        if (goals2 == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(38);
        }
        if (selectedProjects == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(39);
        }
        MavenServerExecutionResult mavenServerExecutionResult = this.performCancelable(() -> ((MavenServerEmbedder)this.getOrCreateWrappee()).execute(new File(file.getPath()), activeProfiles, inactiveProfiles, goals2, selectedProjects, alsoMake, alsoMakeDependents, ourToken));
        if (mavenServerExecutionResult == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(40);
        }
        return mavenServerExecutionResult;
    }

    @NotNull
    public Set<MavenRemoteRepository> resolveRepositories(@NotNull Collection<MavenRemoteRepository> repositories) throws MavenProcessCanceledException {
        if (repositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(41);
        }
        Set set = this.perform(() -> ((MavenServerEmbedder)this.getOrCreateWrappee()).resolveRepositories(repositories, ourToken));
        if (set == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(42);
        }
        return set;
    }

    public Collection<MavenArchetype> getArchetypes() {
        return this.perform(() -> ((MavenServerEmbedder)this.getOrCreateWrappee()).getArchetypes(ourToken));
    }

    public Collection<MavenArchetype> getInnerArchetypes(@NotNull Path catalogPath) {
        if (catalogPath == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(43);
        }
        return this.perform(() -> ((MavenServerEmbedder)this.getOrCreateWrappee()).getLocalArchetypes(ourToken, catalogPath.toString()));
    }

    public Collection<MavenArchetype> getRemoteArchetypes(@NotNull String url) {
        if (url == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(44);
        }
        return this.perform(() -> ((MavenServerEmbedder)this.getOrCreateWrappee()).getRemoteArchetypes(ourToken, url));
    }

    @Nullable
    public Map<String, String> resolveAndGetArchetypeDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version2, @NotNull List<MavenRemoteRepository> repositories, @Nullable String url) {
        if (groupId == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(45);
        }
        if (artifactId == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(46);
        }
        if (version2 == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(47);
        }
        if (repositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(48);
        }
        return this.perform(() -> ((MavenServerEmbedder)this.getOrCreateWrappee()).resolveAndGetArchetypeDescriptor(groupId, artifactId, version2, repositories, url, ourToken));
    }

    public void reset() {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            this.stopPulling();
            w.reset(ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    public void release() {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            this.stopPulling();
            w.release(ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    public void clearCaches() {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.clearCaches(ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    public void clearCachesFor(MavenId projectId) {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.clearCachesFor(projectId, ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    private synchronized void setCustomization(MavenConsole console2, MavenProgressIndicator indicator, MavenWorkspaceMap workspaceMap, boolean failOnUnresolvedDependency, boolean alwaysUpdateSnapshot, @Nullable Properties userProperties) {
        this.stopPulling();
        this.myCustomization = new Customization(console2, indicator, workspaceMap, failOnUnresolvedDependency, alwaysUpdateSnapshot, userProperties);
    }

    private synchronized void stopPulling() {
        if (this.myProgressPullingFuture != null) {
            this.myProgressPullingFuture.cancel(true);
        }
        this.myCustomization = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 16: 
            case 19: 
            case 22: 
            case 26: 
            case 34: 
            case 40: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 16: 
            case 19: 
            case 22: 
            case 26: 
            case 34: 
            case 40: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 12: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: 
            case 16: 
            case 19: 
            case 22: 
            case 26: 
            case 34: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenEmbedderWrapper";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositories";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 23: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 24: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 28: 
            case 41: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeMavenProject";
                break;
            }
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goals";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedProjects";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalogPath";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenEmbedderWrapper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTransitively";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifactTransitively";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveVersions";
                break;
            }
            case 34: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveProject";
                break;
            }
            case 7: 
            case 16: 
            case 19: 
            case 22: 
            case 26: 
            case 34: 
            case 40: 
            case 42: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "evaluateEffectivePom";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveTransitively";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifactTransitively";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "retrieveVersions";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "resolvePlugin";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "resolveRepositories";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getInnerArchetypes";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteArchetypes";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndGetArchetypeDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 16: 
            case 19: 
            case 22: 
            case 26: 
            case 34: 
            case 40: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoteMavenServerConsole
    extends MavenRemoteObject
    implements MavenServerConsole {
        private final MavenConsole myConsole;

        RemoteMavenServerConsole(MavenConsole console2) {
            this.myConsole = console2;
        }

        public void printMessage(int level, String message, Throwable throwable) {
            this.myConsole.printMessage(level, message, throwable);
        }
    }

    private static final class Customization {
        private final MavenConsole console;
        private final MavenProgressIndicator indicator;
        private final MavenWorkspaceMap workspaceMap;
        private final boolean failOnUnresolvedDependency;
        private final boolean alwaysUpdateSnapshot;
        private final Properties userProperties;

        private Customization(MavenConsole console2, MavenProgressIndicator indicator, MavenWorkspaceMap workspaceMap, boolean failOnUnresolvedDependency, boolean alwaysUpdateSnapshot, @Nullable Properties userProperties) {
            this.console = console2;
            this.indicator = indicator;
            this.workspaceMap = workspaceMap;
            this.failOnUnresolvedDependency = failOnUnresolvedDependency;
            this.alwaysUpdateSnapshot = alwaysUpdateSnapshot;
            this.userProperties = userProperties;
        }
    }
}

