/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.DeprecatedProjectBuilderForImport;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.containers.ContainerUtil;
import icons.OpenapiIcons;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.importing.MavenModuleNameMapper;
import org.jetbrains.idea.maven.importing.MavenProjectImporter;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigator;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.actions.LookForNestedToggleAction;
import org.jetbrains.idea.maven.project.importing.MavenImportingManager;
import org.jetbrains.idea.maven.project.importing.RootPath;
import org.jetbrains.idea.maven.server.MavenWrapperSupport;
import org.jetbrains.idea.maven.utils.FileFinder;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenTask;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenEnvironmentSettingsDialog;
import org.jetbrains.idea.maven.wizards.MavenProjectOpenProcessor;

public final class MavenProjectBuilder
extends ProjectImportBuilder<MavenProject>
implements DeprecatedProjectBuilderForImport {
    private static final Logger LOG = Logger.getInstance(MavenProjectBuilder.class);
    private Parameters myParameters;

    @NotNull
    public String getName() {
        String string = MavenProjectBundle.message("maven.name", new Object[0]);
        if (string == null) {
            MavenProjectBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        return OpenapiIcons.RepositoryLibraryLogo;
    }

    public void cleanup() {
        this.myParameters = null;
        super.cleanup();
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == JavaSdk.getInstance();
    }

    private Parameters getParameters() {
        if (this.myParameters == null) {
            this.myParameters = new Parameters();
        }
        return this.myParameters;
    }

    private boolean setupProjectImport(@NotNull Project project2) {
        Path rootDirectory;
        if (project2 == null) {
            MavenProjectBuilder.$$$reportNull$$$0(1);
        }
        return (rootDirectory = this.getRootPath()) != null && this.setRootDirectory(project2, rootDirectory) && this.selectProjectsToUpdate();
    }

    private boolean selectProjectsToUpdate() {
        Parameters parameters = this.getParameters();
        MavenProjectsTree projectsTree = parameters.myMavenProjectTree;
        List<MavenProject> projects = projectsTree.getRootProjects();
        if (projects.isEmpty()) {
            return false;
        }
        parameters.mySelectedProjects = projects;
        return true;
    }

    public List<Module> commit(Project project2, ModifiableModuleModel model2, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        boolean isFromUI;
        String distributionUrl;
        MavenProjectsNavigator projectsNavigator;
        boolean isVeryNewProject;
        boolean bl = isVeryNewProject = project2.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == Boolean.TRUE;
        if (isVeryNewProject) {
            ExternalStorageConfigurationManager.getInstance((Project)project2).setEnabled(true);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            FileDocumentManager.getInstance().saveAllDocuments();
        }
        MavenUtil.setupProjectSdk(project2);
        if (MavenUtil.isLinearImportEnabled()) {
            Module dummyModule = this.createDummyModule(project2);
            VirtualFile rootPath = LocalFileSystem.getInstance().findFileByNioFile(this.getRootPath());
            MavenImportingManager.getInstance(project2).openProjectAndImport(new RootPath(rootPath), this.getImportingSettings(), this.getGeneralSettings(), MavenImportSpec.EXPLICIT_IMPORT);
            return Collections.singletonList(dummyModule);
        }
        if (!this.setupProjectImport(project2)) {
            LOG.debug(String.format("Cannot import project for %s", project2.toString()));
            return Collections.emptyList();
        }
        MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(project2).getSettings();
        settings.setGeneralSettings(this.getGeneralSettings());
        settings.setImportingSettings(this.getImportingSettings());
        String settingsFile = System.getProperty("idea.maven.import.settings.file");
        if (!StringUtil.isEmptyOrSpaces((String)settingsFile)) {
            settings.getGeneralSettings().setUserSettingsFile(settingsFile.trim());
        }
        if ((projectsNavigator = MavenProjectsNavigator.getInstance(project2)) != null) {
            projectsNavigator.setGroupModules(true);
        }
        if ((distributionUrl = MavenWrapperSupport.getWrapperDistributionUrl(ProjectUtil.guessProjectDir((Project)project2))) != null) {
            settings.getGeneralSettings().setMavenHome("Use Maven wrapper");
        }
        MavenExplicitProfiles selectedProfiles = MavenExplicitProfiles.NONE.clone();
        String enabledProfilesList = System.getProperty("idea.maven.import.enabled.profiles");
        String disabledProfilesList = System.getProperty("idea.maven.import.disabled.profiles");
        if (enabledProfilesList != null || disabledProfilesList != null) {
            MavenProjectBuilder.appendProfilesFromString(selectedProfiles.getEnabledProfiles(), enabledProfilesList);
            MavenProjectBuilder.appendProfilesFromString(selectedProfiles.getDisabledProfiles(), disabledProfilesList);
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project2);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !manager.hasProjects() && settings.generalSettings.isShowDialogWithAdvancedSettings()) {
            MavenProjectBuilder.showGeneralSettingsConfigurationDialog(project2, settings.generalSettings);
        }
        manager.setIgnoredState(this.getParameters().mySelectedProjects, false);
        if (isVeryNewProject && Registry.is((String)"maven.create.dummy.module.on.first.import")) {
            Module dummyModule = this.createDummyModule(project2);
            manager.addManagedFilesWithProfiles(MavenUtil.collectFiles(this.getParameters().mySelectedProjects), selectedProfiles, dummyModule);
            return Collections.singletonList(dummyModule);
        }
        manager.addManagedFilesWithProfiles(MavenUtil.collectFiles(this.getParameters().mySelectedProjects), selectedProfiles, null);
        manager.waitForReadingCompletion();
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode() && (!MavenUtil.isMavenUnitTestModeEnabled() || Registry.is((String)"ide.force.maven.import", (boolean)false))) {
            Promise<List<Module>> promise = manager.scheduleImportAndResolve();
            manager.waitForResolvingCompletion();
            try {
                return (List)promise.blockingGet(0);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }
        boolean bl2 = isFromUI = model2 != null;
        if (isFromUI) {
            return manager.importProjects((IdeModifiableModelsProvider)new IdeUIModifiableModelsProvider(project2, model2, (ModulesConfigurator)modulesProvider, artifactModel));
        }
        return manager.importProjects();
    }

    @Nullable
    private Module createDummyModule(Project project2) {
        if (ModuleManager.getInstance((Project)project2).getModules().length == 0) {
            MavenProject root = (MavenProject)ContainerUtil.getFirstItem(this.getParameters().mySelectedProjects);
            if (root == null) {
                return null;
            }
            VirtualFile contentRoot = root.getDirectoryFile();
            return (Module)WriteAction.compute(() -> {
                Module module = ModuleManager.getInstance((Project)project2).newModule(contentRoot.toNioPath(), ModuleTypeManager.getInstance().getDefaultModuleType().getId());
                ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                modifiableModel.addContentEntry(contentRoot);
                modifiableModel.commit();
                MavenProjectBuilder.renameModuleToProjectName(project2, module, root);
                if (MavenProjectImporter.isImportToWorkspaceModelEnabled() || MavenProjectImporter.isImportToTreeStructureEnabled(project2)) {
                    ExternalSystemModulePropertyManager.getInstance((Module)module).setMavenized(true);
                }
                return module;
            });
        }
        return null;
    }

    private static void renameModuleToProjectName(Project project2, Module module, MavenProject root) {
        try {
            ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)project2).getModifiableModel();
            moduleModel.renameModule(module, MavenModuleNameMapper.resolveModuleName(root));
            moduleModel.commit();
        }
        catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
            // empty catch block
        }
    }

    private static void showGeneralSettingsConfigurationDialog(@NotNull Project project2, @NotNull MavenGeneralSettings generalSettings) {
        if (project2 == null) {
            MavenProjectBuilder.$$$reportNull$$$0(2);
        }
        if (generalSettings == null) {
            MavenProjectBuilder.$$$reportNull$$$0(3);
        }
        MavenEnvironmentSettingsDialog dialog = new MavenEnvironmentSettingsDialog(project2, generalSettings);
        ApplicationManager.getApplication().invokeAndWait(() -> ((MavenEnvironmentSettingsDialog)dialog).show());
    }

    private static void appendProfilesFromString(Collection<String> selectedProfiles, String profilesList) {
        if (profilesList == null) {
            return;
        }
        for (String profile : StringUtil.split((String)profilesList, (String)",")) {
            String trimmedProfileName = profile.trim();
            if (trimmedProfileName.isEmpty()) continue;
            selectedProfiles.add(trimmedProfileName);
        }
    }

    @Deprecated(forRemoval=true)
    public boolean setRootDirectory(@Nullable Project projectToUpdate, @NotNull String root) {
        if (root == null) {
            MavenProjectBuilder.$$$reportNull$$$0(4);
        }
        return this.setRootDirectory(projectToUpdate, Paths.get(root, new String[0]));
    }

    public boolean setRootDirectory(@Nullable Project projectToUpdate, final @NotNull Path root) {
        if (root == null) {
            MavenProjectBuilder.$$$reportNull$$$0(5);
        }
        this.getParameters().myFiles = null;
        this.getParameters().myMavenProjectTree = null;
        this.getParameters().myProjectToUpdate = projectToUpdate != null ? projectToUpdate : ProjectManager.getInstance().getDefaultProject();
        return MavenProjectBuilder.runConfigurationProcess(MavenProjectBundle.message("maven.scanning.projects", new Object[0]), new MavenTask(){

            @Override
            public void run(MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                indicator.setText(MavenProjectBundle.message("maven.locating.files", new Object[0]));
                MavenProjectBuilder.this.getParameters().myImportRootDirectory = root;
                if (MavenProjectBuilder.this.getParameters().myImportRootDirectory == null) {
                    throw new MavenProcessCanceledException();
                }
                MavenProjectBuilder.this.getParameters().myFiles = MavenProjectBuilder.this.getProjectFiles(indicator);
                MavenProjectBuilder.this.readMavenProjectTree(indicator);
                indicator.setText("");
                indicator.setText2("");
            }
        });
    }

    @Deprecated(forRemoval=true)
    public boolean setSelectedProfiles(MavenExplicitProfiles profiles2) {
        return MavenProjectBuilder.runConfigurationProcess(MavenProjectBundle.message("maven.scanning.projects", new Object[0]), new MavenTask(){

            @Override
            public void run(MavenProgressIndicator indicator) {
                MavenProjectBuilder.this.readMavenProjectTree(indicator);
                indicator.setText2("");
            }
        });
    }

    private static boolean runConfigurationProcess(@NlsContexts.DialogTitle String message, MavenTask p) {
        try {
            MavenUtil.run(null, message, p);
        }
        catch (MavenProcessCanceledException e) {
            return false;
        }
        return true;
    }

    private void readMavenProjectTree(MavenProgressIndicator process2) {
        MavenProjectsTree tree = new MavenProjectsTree(this.getProjectOrDefault());
        tree.addManagedFilesWithProfiles(this.getParameters().myFiles, MavenExplicitProfiles.NONE);
        tree.updateAll(false, this.getGeneralSettings(), process2);
        this.getParameters().myMavenProjectTree = tree;
        this.getParameters().mySelectedProjects = tree.getRootProjects();
    }

    public List<MavenProject> getList() {
        return this.getParameters().myMavenProjectTree.getRootProjects();
    }

    public void setList(List<MavenProject> projects) {
        this.getParameters().mySelectedProjects = projects;
    }

    public boolean isMarked(MavenProject element) {
        return this.getParameters().mySelectedProjects.contains(element);
    }

    public boolean isOpenProjectSettingsAfter() {
        return this.getParameters().myOpenModulesConfigurator;
    }

    public void setOpenProjectSettingsAfter(boolean on) {
        this.getParameters().myOpenModulesConfigurator = on;
    }

    private MavenGeneralSettings getGeneralSettings() {
        if (this.getParameters().myGeneralSettingsCache == null) {
            ApplicationManager.getApplication().runReadAction(() -> {
                this.getParameters().myGeneralSettingsCache = this.getDirectProjectsSettings().getGeneralSettings().clone();
                this.getParameters().myGeneralSettingsCache.setUseMavenConfig(true);
                List<VirtualFile> rootFiles = this.getParameters().myFiles;
                if (rootFiles == null) {
                    rootFiles = Collections.singletonList(LocalFileSystem.getInstance().findFileByNioFile(this.getRootPath()));
                }
                this.getParameters().myGeneralSettingsCache.updateFromMavenConfig(rootFiles);
            });
        }
        return this.getParameters().myGeneralSettingsCache;
    }

    public MavenImportingSettings getImportingSettings() {
        if (this.getParameters().myImportingSettingsCache == null) {
            ApplicationManager.getApplication().runReadAction(() -> {
                this.getParameters().myImportingSettingsCache = this.getDirectProjectsSettings().getImportingSettings().clone();
            });
        }
        return this.getParameters().myImportingSettingsCache;
    }

    private MavenWorkspaceSettings getDirectProjectsSettings() {
        Project project2;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project3 = project2 = this.isUpdate() ? this.getProjectToUpdate() : null;
        if (project2 == null || project2.isDisposed()) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        return MavenWorkspaceSettingsComponent.getInstance(project2).getSettings();
    }

    public void setFiles(List<VirtualFile> files) {
        this.getParameters().myFiles = files;
    }

    @Nullable
    public Project getProjectToUpdate() {
        if (this.getParameters().myProjectToUpdate == null) {
            this.getParameters().myProjectToUpdate = MavenProjectBuilder.getCurrentProject();
        }
        return this.getParameters().myProjectToUpdate;
    }

    @NotNull
    public Project getProjectOrDefault() {
        Project project2 = this.getProjectToUpdate();
        if (project2 == null || project2.isDisposed()) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        Project project3 = project2;
        if (project3 == null) {
            MavenProjectBuilder.$$$reportNull$$$0(6);
        }
        return project3;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public VirtualFile getRootDirectory() {
        Path rootPath = this.getRootPath();
        return rootPath == null ? null : VfsUtil.findFile((Path)rootPath, (boolean)false);
    }

    @Nullable
    public Path getRootPath() {
        if (this.getParameters().myImportRootDirectory == null && this.isUpdate()) {
            Project project2 = this.getProjectToUpdate();
            this.getParameters().myImportRootDirectory = project2 == null ? null : Paths.get(Objects.requireNonNull(project2.getBasePath()), new String[0]);
        }
        return this.getParameters().myImportRootDirectory;
    }

    @Nullable
    public String getSuggestedProjectName() {
        List<MavenProject> list = this.getParameters().myMavenProjectTree.getRootProjects();
        return list.size() == 1 ? list.get(0).getMavenId().getArtifactId() : null;
    }

    public void setFileToImport(@NotNull String path) {
        if (path == null) {
            MavenProjectBuilder.$$$reportNull$$$0(7);
        }
        this.setFileToImport(Paths.get(path, new String[0]));
    }

    public void setFileToImport(@NotNull Path path) {
        if (path == null) {
            MavenProjectBuilder.$$$reportNull$$$0(8);
        }
        this.getParameters().myImportRootDirectory = Files.isDirectory(path, new LinkOption[0]) ? path : path.getParent();
    }

    public void setFileToImport(@NotNull VirtualFile file) {
        if (file == null) {
            MavenProjectBuilder.$$$reportNull$$$0(9);
        }
        if (!file.isDirectory()) {
            this.getParameters().myImportProjectFile = file;
        }
        this.getParameters().myImportRootDirectory = file.isDirectory() ? file.toNioPath() : file.getParent().toNioPath();
    }

    @Nullable
    public Project createProject(String name, String path) {
        return ExternalProjectsManagerImpl.setupCreatedProject((Project)super.createProject(name, path));
    }

    @NotNull
    public ProjectOpenProcessor getProjectOpenProcessor() {
        ProjectOpenProcessor projectOpenProcessor = (ProjectOpenProcessor)ProjectOpenProcessor.EXTENSION_POINT_NAME.findExtensionOrFail(MavenProjectOpenProcessor.class);
        if (projectOpenProcessor == null) {
            MavenProjectBuilder.$$$reportNull$$$0(10);
        }
        return projectOpenProcessor;
    }

    private List<VirtualFile> getProjectFiles(@NotNull MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        VirtualFile virtualFile;
        if (indicator == null) {
            MavenProjectBuilder.$$$reportNull$$$0(11);
        }
        if (this.getParameters().myImportProjectFile != null) {
            return Collections.singletonList(this.getParameters().myImportProjectFile);
        }
        Path file = this.getRootPath();
        VirtualFile virtualFile2 = virtualFile = file == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)file.toString()));
        if (virtualFile == null) {
            throw new MavenProcessCanceledException();
        }
        return FileFinder.findPomFiles(virtualFile.getChildren(), LookForNestedToggleAction.isSelected(), indicator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/wizards/MavenProjectBuilder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generalSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/wizards/MavenProjectBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectOrDefault";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectOpenProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupProjectImport";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showGeneralSettingsConfigurationDialog";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setRootDirectory";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFileToImport";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProjectFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Parameters {
        private Project myProjectToUpdate;
        private MavenGeneralSettings myGeneralSettingsCache;
        private MavenImportingSettings myImportingSettingsCache;
        private Path myImportRootDirectory;
        private VirtualFile myImportProjectFile;
        private List<VirtualFile> myFiles;
        private MavenProjectsTree myMavenProjectTree;
        private List<MavenProject> mySelectedProjects;
        private boolean myOpenModulesConfigurator;

        private Parameters() {
        }
    }
}

