/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server;

import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.server.HeadlessInitializerKt;
import org.jetbrains.projector.server.ProjectorLauncher;
import org.jetbrains.projector.server.ProjectorServer;
import org.jetbrains.projector.server.service.ProjectorFontProvider;
import org.jetbrains.projector.util.loading.ProjectorClassLoader;
import org.jetbrains.projector.util.loading.ProjectorClassLoaderSetup;
import org.jetbrains.projector.util.loading.ReflectKt;
import org.jetbrains.projector.util.loading.UseProjectorLoader;
import org.jetbrains.projector.util.logging.Logger;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u001b\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/projector/server/ProjectorLauncher;", "", "()V", "MAIN_CLASS_PROPERTY_NAME", "", "getMAIN_CLASS_PROPERTY_NAME$annotations", "getStarterClass", "Ljava/lang/Class;", "main", "", "args", "", "([Ljava/lang/String;)V", "runProjectorServer", "", "Starter", "projector-server"})
public final class ProjectorLauncher {
    @NotNull
    public static final ProjectorLauncher INSTANCE = new ProjectorLauncher();
    @NotNull
    public static final String MAIN_CLASS_PROPERTY_NAME = "org.jetbrains.projector.server.classToLaunch";

    private ProjectorLauncher() {
    }

    public static /* synthetic */ void getMAIN_CLASS_PROPERTY_NAME$annotations() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = new Class[]{String[].class};
        objectArray = INSTANCE.getStarterClass().getDeclaredMethod("start", (Class<?>[])objectArray);
        Object[] p0 = objectArray;
        boolean bl = false;
        ReflectKt.unprotect((Method)p0);
        Object[] objectArray2 = objectArray;
        objectArray = new Object[]{args};
        objectArray2.invoke(null, objectArray);
    }

    @JvmStatic
    public static final boolean runProjectorServer() {
        Method method;
        Method p0 = method = INSTANCE.getStarterClass().getDeclaredMethod("runProjectorServer", new Class[0]);
        boolean bl = false;
        ReflectKt.unprotect(p0);
        Object object = method.invoke(null, new Object[0]);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        return (Boolean)object;
    }

    private final Class<?> getStarterClass() {
        Object object = this.getClass().getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"javaClass.classLoader");
        ProjectorClassLoader prjClassLoader = ProjectorClassLoaderSetup.INSTANCE.initClassLoader((ClassLoader)object);
        object = prjClassLoader.loadClass(this.getClass().getName() + "$Starter");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"prjClassLoader.loadClass\u2026avaClass.name}\\$Starter\")");
        return object;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @UseProjectorLoader
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J-\u0010\t\u001a\u00020\n2#\b\u0002\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\fH\u0007J\b\u0010\u0011\u001a\u00020\bH\u0002J\u001b\u0010\u0012\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0007\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/projector/server/ProjectorLauncher$Starter;", "", "()V", "getMainMethodOf", "Ljava/lang/reflect/Method;", "canonicalClassName", "", "initializeHeadless", "", "runProjectorServer", "", "loggerFactory", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "tag", "Lorg/jetbrains/projector/util/logging/Logger;", "setupSingletons", "start", "args", "", "([Ljava/lang/String;)V", "projector-server"})
    private static final class Starter {
        @NotNull
        public static final Starter INSTANCE = new Starter();

        private Starter() {
        }

        @JvmStatic
        public static final void start(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            String string = System.getProperty(ProjectorLauncher.MAIN_CLASS_PROPERTY_NAME);
            if (string == null) {
                boolean bl = false;
                String string2 = "System property `org.jetbrains.projector.server.classToLaunch` isn't assigned, so can't understand which class to launch";
                throw new IllegalArgumentException(string2.toString());
            }
            String canonicalMainClassName = string;
            Method mainMethod = INSTANCE.getMainMethodOf(canonicalMainClassName);
            if (!Starter.runProjectorServer$default(null, 1, null)) {
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            Object[] objectArray = new Object[]{args};
            mainMethod.invoke(null, objectArray);
        }

        private final Method getMainMethodOf(String canonicalClassName) {
            Class<?> mainClass = Class.forName(canonicalClassName);
            Class[] classArray = new Class[]{String[].class};
            Method method = mainClass.getMethod("main", classArray);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"mainClass.getMethod(\"mai\u2026rray<String>::class.java)");
            return method;
        }

        private final void setupSingletons() {
            HeadlessInitializerKt.setupGraphicsEnvironment();
            HeadlessInitializerKt.setupToolkit();
            HeadlessInitializerKt.setupFontManager();
            HeadlessInitializerKt.setupRepaintManager();
        }

        private final void initializeHeadless() {
            HeadlessInitializerKt.setupSystemProperties();
            this.setupSingletons();
            ProjectorFontProvider.INSTANCE.setAgent(false);
        }

        @JvmStatic
        @JvmOverloads
        public static final boolean runProjectorServer(@NotNull Function1<? super String, ? extends Logger> loggerFactory2) {
            Intrinsics.checkNotNullParameter(loggerFactory2, (String)"loggerFactory");
            System.setProperty("org.jetbrains.projector.server.enable", "true");
            boolean bl = ProjectorServer.Companion.isEnabled();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Can't start the " + Reflection.getOrCreateKotlinClass(ProjectorServer.class).getSimpleName() + " because it's disabled...";
                throw new AssertionError((Object)string);
            }
            ProjectorServer server = ProjectorServer.Companion.startServer(false, loggerFactory2, Starter::runProjectorServer$lambda-2);
            Runtime.getRuntime().addShutdownHook(new Thread(server){
                final /* synthetic */ ProjectorServer $server;
                {
                    this.$server = $server;
                }

                public void run() {
                    ProjectorServer.stop$default(this.$server, 0, 1, null);
                }
            });
            return server.getWasStarted();
        }

        public static /* synthetic */ boolean runProjectorServer$default(Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = runProjectorServer.1.INSTANCE;
            }
            return Starter.runProjectorServer((Function1<? super String, ? extends Logger>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public static final boolean runProjectorServer() {
            return Starter.runProjectorServer$default(null, 1, null);
        }

        private static final void runProjectorServer$lambda-2() {
            INSTANCE.initializeHeadless();
        }
    }
}

