/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JWindow;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.awt.PWindow;
import org.jetbrains.projector.awt.data.AwtImageInfo;
import org.jetbrains.projector.awt.data.AwtPaintType;
import org.jetbrains.projector.awt.data.Direction;
import org.jetbrains.projector.common.protocol.data.ImageEventInfo;
import org.jetbrains.projector.common.protocol.data.PaintType;
import org.jetbrains.projector.common.protocol.toClient.WindowClass;
import org.jetbrains.projector.common.protocol.toClient.WindowType;
import org.jetbrains.projector.common.protocol.toServer.ResizeDirection;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0011\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"windowClass", "Lorg/jetbrains/projector/common/protocol/toClient/WindowClass;", "Lorg/jetbrains/projector/awt/PWindow;", "getWindowClass", "(Lorg/jetbrains/projector/awt/PWindow;)Lorg/jetbrains/projector/common/protocol/toClient/WindowClass;", "windowType", "Lorg/jetbrains/projector/common/protocol/toClient/WindowType;", "getWindowType", "(Lorg/jetbrains/projector/awt/PWindow;)Lorg/jetbrains/projector/common/protocol/toClient/WindowType;", "toDirection", "Lorg/jetbrains/projector/awt/data/Direction;", "Lorg/jetbrains/projector/common/protocol/toServer/ResizeDirection;", "toImageEventInfo", "Lorg/jetbrains/projector/common/protocol/data/ImageEventInfo;", "Lorg/jetbrains/projector/awt/data/AwtImageInfo;", "toPaintType", "Lorg/jetbrains/projector/common/protocol/data/PaintType;", "Lorg/jetbrains/projector/awt/data/AwtPaintType;", "projector-server"})
public final class ConvertKt {
    @NotNull
    public static final PaintType toPaintType(@NotNull AwtPaintType $this$toPaintType) {
        PaintType paintType;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toPaintType), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toPaintType.ordinal()]) {
            case 1: {
                paintType = PaintType.DRAW;
                break;
            }
            case 2: {
                paintType = PaintType.FILL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return paintType;
    }

    @NotNull
    public static final ImageEventInfo toImageEventInfo(@NotNull AwtImageInfo $this$toImageEventInfo) {
        ImageEventInfo imageEventInfo;
        Intrinsics.checkNotNullParameter((Object)$this$toImageEventInfo, (String)"<this>");
        AwtImageInfo awtImageInfo = $this$toImageEventInfo;
        if (awtImageInfo instanceof AwtImageInfo.Point) {
            imageEventInfo = new ImageEventInfo.Xy(((AwtImageInfo.Point)$this$toImageEventInfo).getX(), ((AwtImageInfo.Point)$this$toImageEventInfo).getY(), null, 4, null);
        } else if (awtImageInfo instanceof AwtImageInfo.Rectangle) {
            imageEventInfo = new ImageEventInfo.XyWh(((AwtImageInfo.Rectangle)$this$toImageEventInfo).getX(), ((AwtImageInfo.Rectangle)$this$toImageEventInfo).getY(), ((AwtImageInfo.Rectangle)$this$toImageEventInfo).getWidth(), ((AwtImageInfo.Rectangle)$this$toImageEventInfo).getHeight(), ((AwtImageInfo.Rectangle)$this$toImageEventInfo).getArgbBackgroundColor());
        } else if (awtImageInfo instanceof AwtImageInfo.Area) {
            imageEventInfo = new ImageEventInfo.Ds(((AwtImageInfo.Area)$this$toImageEventInfo).getDx1(), ((AwtImageInfo.Area)$this$toImageEventInfo).getDy1(), ((AwtImageInfo.Area)$this$toImageEventInfo).getDx2(), ((AwtImageInfo.Area)$this$toImageEventInfo).getDy2(), ((AwtImageInfo.Area)$this$toImageEventInfo).getSx1(), ((AwtImageInfo.Area)$this$toImageEventInfo).getSy1(), ((AwtImageInfo.Area)$this$toImageEventInfo).getSx2(), ((AwtImageInfo.Area)$this$toImageEventInfo).getSy2(), ((AwtImageInfo.Area)$this$toImageEventInfo).getArgbBackgroundColor());
        } else if (awtImageInfo instanceof AwtImageInfo.Transformation) {
            imageEventInfo = new ImageEventInfo.Transformed(((AwtImageInfo.Transformation)$this$toImageEventInfo).getTx());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return imageEventInfo;
    }

    @NotNull
    public static final WindowType getWindowType(@NotNull PWindow $this$windowType) {
        WindowType windowType;
        Intrinsics.checkNotNullParameter((Object)$this$windowType, (String)"<this>");
        String string = $this$windowType.getTarget().getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"target::class.java.simpleName");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"IdeFrameImpl", (boolean)false, (int)2, null)) {
            windowType = WindowType.IDEA_WINDOW;
        } else {
            Component it = $this$windowType.getTarget();
            boolean bl = false;
            windowType = it instanceof Window && ((Window)it).getType() == Window.Type.POPUP ? WindowType.POPUP : WindowType.WINDOW;
        }
        return windowType;
    }

    @NotNull
    public static final WindowClass getWindowClass(@NotNull PWindow $this$windowClass) {
        Intrinsics.checkNotNullParameter((Object)$this$windowClass, (String)"<this>");
        Component component = $this$windowClass.getTarget();
        return component instanceof Frame ? WindowClass.FRAME : (component instanceof Dialog ? WindowClass.DIALOG : (component instanceof JWindow ? WindowClass.JWINDOW : WindowClass.OTHER));
    }

    @NotNull
    public static final Direction toDirection(@NotNull ResizeDirection $this$toDirection) {
        Direction direction;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toDirection), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toDirection.ordinal()]) {
            case 1: {
                direction = Direction.NW;
                break;
            }
            case 2: {
                direction = Direction.SW;
                break;
            }
            case 3: {
                direction = Direction.NE;
                break;
            }
            case 4: {
                direction = Direction.SE;
                break;
            }
            case 5: {
                direction = Direction.N;
                break;
            }
            case 6: {
                direction = Direction.W;
                break;
            }
            case 7: {
                direction = Direction.S;
                break;
            }
            case 8: {
                direction = Direction.E;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return direction;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AwtPaintType.values().length];
            nArray[AwtPaintType.DRAW.ordinal()] = 1;
            nArray[AwtPaintType.FILL.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ResizeDirection.values().length];
            nArray[ResizeDirection.NW.ordinal()] = 1;
            nArray[ResizeDirection.SW.ordinal()] = 2;
            nArray[ResizeDirection.NE.ordinal()] = 3;
            nArray[ResizeDirection.SE.ordinal()] = 4;
            nArray[ResizeDirection.N.ordinal()] = 5;
            nArray[ResizeDirection.W.ordinal()] = 6;
            nArray[ResizeDirection.S.ordinal()] = 7;
            nArray[ResizeDirection.E.ordinal()] = 8;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

