/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.model.serialization.JpsProjectLoader;

public final class Utils {
    public static final Key<Map<BuildTarget<?>, Collection<String>>> REMOVED_SOURCES_KEY = Key.create((String)"_removed_sources_");
    public static final Key<Boolean> PROCEED_ON_ERROR_KEY = Key.create((String)"_proceed_on_error_");
    public static final Key<Boolean> ERRORS_DETECTED_KEY = Key.create((String)"_errors_detected_");
    private static volatile File ourSystemRoot = new File(System.getProperty("user.home"), ".idea-build");
    public static final boolean IS_TEST_MODE = Boolean.parseBoolean(System.getProperty("test.mode", "false"));
    public static final boolean IS_PROFILING_MODE = Boolean.parseBoolean(System.getProperty("profiling.mode", "false"));
    private static final int FORKED_JAVAC_HEAP_SIZE_MB;

    private Utils() {
    }

    public static File getSystemRoot() {
        return ourSystemRoot;
    }

    public static void setSystemRoot(File systemRoot) {
        ourSystemRoot = systemRoot;
    }

    @Nullable
    public static File getDataStorageRoot(String projectPath) {
        return Utils.getDataStorageRoot(ourSystemRoot, projectPath);
    }

    public static File getDataStorageRoot(File systemRoot, String projectPath) {
        return Utils.getDataStorageRoot(systemRoot, projectPath, s -> s.hashCode());
    }

    public static File getDataStorageRoot(File systemRoot, String projectPath, Function<String, Integer> hashFunction) {
        int locationHash;
        String name;
        if ((projectPath = FileUtil.toCanonicalPath((String)projectPath)) == null) {
            return null;
        }
        Path rootFile = Paths.get(projectPath, new String[0]);
        if (!Files.isDirectory(rootFile, new LinkOption[0]) && projectPath.endsWith(".ipr")) {
            name = StringUtil.trimEnd((String)rootFile.getFileName().toString(), (String)".ipr");
            locationHash = hashFunction.apply(projectPath);
        } else {
            Path directoryBased = null;
            if (rootFile.endsWith(".idea")) {
                directoryBased = rootFile;
            } else {
                Path child = rootFile.resolve(".idea");
                if (Files.exists(child, new LinkOption[0])) {
                    directoryBased = child;
                }
            }
            if (directoryBased == null) {
                return null;
            }
            name = PathUtilRt.suggestFileName((String)JpsProjectLoader.getDirectoryBaseProjectName((Path)directoryBased));
            locationHash = hashFunction.apply(directoryBased.toString());
        }
        return new File(systemRoot, StringUtil.toLowerCase((String)name) + "_" + Integer.toHexString(locationHash));
    }

    public static boolean errorsDetected(CompileContext context) {
        return (Boolean)ERRORS_DETECTED_KEY.get((UserDataHolder)context, (Object)Boolean.FALSE);
    }

    public static String formatDuration(long duration) {
        return StringUtil.formatDuration((long)duration);
    }

    public static int suggestForkedCompilerHeapSize() {
        if (FORKED_JAVAC_HEAP_SIZE_MB > 0) {
            return FORKED_JAVAC_HEAP_SIZE_MB;
        }
        int maxMbytes = (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
        if (maxMbytes < 0 || maxMbytes > 1500) {
            return -1;
        }
        return Math.max(maxMbytes, 256);
    }

    public static Runnable asCountedRunnable(final int count, final Runnable operation) {
        return new Runnable(){
            private final AtomicInteger myCounter;
            {
                this.myCounter = new AtomicInteger(count);
            }

            @Override
            public void run() {
                int currentVal = this.myCounter.decrementAndGet();
                if (currentVal % count == 0) {
                    try {
                        operation.run();
                    }
                    finally {
                        while (currentVal <= 0 && !this.myCounter.compareAndSet(currentVal, count + currentVal % count)) {
                            currentVal = this.myCounter.get();
                        }
                    }
                }
            }
        };
    }

    static {
        int size = -1;
        try {
            size = Integer.parseInt(System.getProperty("forked.javac.heap.size.mb"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        FORKED_JAVAC_HEAP_SIZE_MB = size;
    }
}

