/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertiesUtil;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.GeneralCodeStylePropertyMapper;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigFilesCollector;
import org.editorconfig.configmanagement.EditorConfigNavigationActionsFactory;
import org.editorconfig.configmanagement.extended.EditorConfigCodeStyleStatusBarUIContributor;
import org.editorconfig.configmanagement.extended.EditorConfigIntellijNameUtil;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.editorconfig.configmanagement.extended.IntellijPropertyKindMap;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.core.EditorConfigException;
import org.editorconfig.core.ParsingException;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class EditorConfigCodeStyleSettingsModifier
implements CodeStyleSettingsModifier {
    private static final Logger LOG = Logger.getInstance(EditorConfigCodeStyleSettingsModifier.class);
    private static final Duration TIMEOUT = Duration.ofSeconds(10L);
    private static boolean ourEnabledInTests;
    private final Set<String> myReportedErrorIds = new HashSet<String>();

    public boolean modifySettings(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile psiFile) {
        Project project;
        if (settings == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(1);
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (Utils.isFullIntellijSettingsSupport() && file != null && (!ApplicationManager.getApplication().isUnitTestMode() || EditorConfigCodeStyleSettingsModifier.isEnabledInTests()) && !(project = psiFile.getProject()).isDisposed() && Utils.isEnabled((CodeStyleSettings)settings)) {
            try {
                MyContext context = new MyContext((CodeStyleSettings)settings, psiFile);
                return EditorConfigCodeStyleSettingsModifier.runWithTimeout(() -> {
                    EditorConfigCodeStyleSettingsModifier.processEditorConfig(project, psiFile, context);
                    if (EditorConfigCodeStyleSettingsModifier.applyCodeStyleSettings(context)) {
                        settings.addDependencies(context.getEditorConfigFiles());
                        EditorConfigNavigationActionsFactory navigationFactory = EditorConfigNavigationActionsFactory.getInstance(psiFile);
                        if (navigationFactory != null) {
                            navigationFactory.updateEditorConfigFilePaths(context.getFilePaths());
                        }
                        return true;
                    }
                    return false;
                });
            }
            catch (TimeoutException toe) {
                if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    this.error(project, "timeout", EditorConfigBundle.message("error.timeout"), new DisableEditorConfigAction(project), true);
                }
            }
            catch (EditorConfigException toe) {
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
        return false;
    }

    private static boolean runWithTimeout(@NotNull Callable<Boolean> callable) throws TimeoutException, EditorConfigException {
        if (callable == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(2);
        }
        Future future = ApplicationManager.getApplication().executeOnPooledThread(callable);
        try {
            return (Boolean)future.get(TIMEOUT.toSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EditorConfigException) {
                throw (EditorConfigException)e.getCause();
            }
            LOG.error((Throwable)e);
        }
        return false;
    }

    public synchronized void error(Project project, final String id, @Nls String message2, final @Nullable AnAction fixAction, boolean oneTime) {
        if (oneTime) {
            if (this.myReportedErrorIds.contains(id)) {
                return;
            }
            this.myReportedErrorIds.add(id);
        }
        final Notification notification = new Notification("editorconfig", EditorConfigBundle.message("editorconfig"), message2, NotificationType.ERROR);
        if (fixAction != null) {
            notification.addAction(new AnAction(fixAction.getTemplateText()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    fixAction.actionPerformed(e);
                    EditorConfigCodeStyleSettingsModifier.this.myReportedErrorIds.remove(id);
                    notification.expire();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier$1", "actionPerformed"));
                }
            });
        }
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    @NotNull
    public CodeStyleStatusBarUIContributor getStatusBarUiContributor(@NotNull TransientCodeStyleSettings transientSettings) {
        if (transientSettings == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(3);
        }
        return new EditorConfigCodeStyleStatusBarUIContributor();
    }

    private static boolean applyCodeStyleSettings(@NotNull MyContext context) {
        if (context == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(4);
        }
        HashSet<String> processed = new HashSet<String>();
        boolean isModified = false;
        for (AbstractCodeStylePropertyMapper mapper : EditorConfigCodeStyleSettingsModifier.getMappers(context)) {
            processed.clear();
            isModified |= EditorConfigCodeStyleSettingsModifier.processOptions(context, mapper, false, processed);
            isModified |= EditorConfigCodeStyleSettingsModifier.processOptions(context, mapper, true, processed);
        }
        return isModified;
    }

    public boolean mayOverrideSettingsOf(@NotNull Project project) {
        if (project == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(5);
        }
        return Utils.isEnabled(CodeStyle.getSettings((Project)project)) && Utils.editorConfigExists(project);
    }

    public String getName() {
        return EditorConfigBundle.message("editorconfig");
    }

    private static boolean processOptions(@NotNull MyContext context, @NotNull AbstractCodeStylePropertyMapper mapper, boolean languageSpecific, Set<String> processed) {
        if (context == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(6);
        }
        if (mapper == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(7);
        }
        String langPrefix = languageSpecific ? mapper.getLanguageDomainId() + "_" : null;
        boolean isModified = false;
        for (EditorConfig.OutPair option : context.getOptions()) {
            String optionKey = option.getKey();
            String intellijName = EditorConfigIntellijNameUtil.toIntellijName(optionKey);
            CodeStylePropertyAccessor<?> accessor = EditorConfigCodeStyleSettingsModifier.findAccessor(mapper, intellijName, langPrefix);
            if (accessor == null) continue;
            String val = EditorConfigCodeStyleSettingsModifier.preprocessValue(accessor, context, optionKey, option.getVal());
            for (String dependency : EditorConfigCodeStyleSettingsModifier.getDependentProperties(optionKey, langPrefix)) {
                CodeStylePropertyAccessor<?> dependencyAccessor;
                if (processed.contains(dependency) || (dependencyAccessor = EditorConfigCodeStyleSettingsModifier.findAccessor(mapper, dependency, null)) == null) continue;
                isModified |= dependencyAccessor.setFromString(val);
            }
            isModified |= accessor.setFromString(val);
            processed.add(intellijName);
        }
        return isModified;
    }

    @NotNull
    private static List<String> getDependentProperties(@NotNull String property, @Nullable String langPrefix) {
        if (property == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(8);
        }
        property = StringUtil.trimStart((String)property, (String)"ij_");
        if (langPrefix != null && property.startsWith(langPrefix)) {
            property = StringUtil.trimStart((String)property, (String)langPrefix);
        }
        if ("indent_size".equals(property)) {
            List<String> list = Collections.singletonList("continuation_indent_size");
            if (list == null) {
                EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static String preprocessValue(@NotNull CodeStylePropertyAccessor<?> accessor, @NotNull MyContext context, @NotNull String optionKey, @NotNull String optionValue) {
        if (accessor == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(11);
        }
        if (context == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(12);
        }
        if (optionKey == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(13);
        }
        if (optionValue == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(14);
        }
        if ("indent_size".equals(optionKey) && "tab".equals(optionValue)) {
            return context.getTabSize();
        }
        if ("none".equals(optionValue) && CodeStylePropertiesUtil.isAccessorAllowingEmptyList(accessor)) {
            return "";
        }
        return optionValue;
    }

    @Nullable
    private static CodeStylePropertyAccessor<?> findAccessor(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String propertyName, @Nullable String langPrefix) {
        if (mapper == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(15);
        }
        if (propertyName == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(16);
        }
        if (langPrefix != null) {
            String prefixlessName;
            EditorConfigPropertyKind propertyKind;
            if (propertyName.startsWith(langPrefix) && ((propertyKind = IntellijPropertyKindMap.getPropertyKind(prefixlessName = StringUtil.trimStart((String)propertyName, (String)langPrefix))) == EditorConfigPropertyKind.LANGUAGE || propertyKind == EditorConfigPropertyKind.COMMON || EditorConfigIntellijNameUtil.isIndentProperty(prefixlessName))) {
                return mapper.getAccessor(prefixlessName);
            }
        } else {
            return mapper.getAccessor(propertyName);
        }
        return null;
    }

    private static void processEditorConfig(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull MyContext context) throws EditorConfigException {
        if (project == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(17);
        }
        if (psiFile == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(18);
        }
        if (context == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(19);
        }
        try {
            VirtualFile file = psiFile.getVirtualFile();
            String filePath = Utils.getFilePath(project, file);
            if (filePath != null) {
                Set<String> rootDirs = SettingsProviderComponent.getInstance().getRootDirs(project);
                context.setOptions(new EditorConfig().getProperties(filePath, rootDirs, context));
            } else if (VfsUtilCore.isBrokenLink((VirtualFile)file)) {
                LOG.warn(file.getPresentableUrl() + " is a broken link");
            }
        }
        catch (ParsingException pe) {
            LOG.debug((Throwable)pe);
        }
    }

    @NotNull
    public Consumer<CodeStyleSettings> getDisablingFunction() {
        Consumer<CodeStyleSettings> consumer = settings -> {
            EditorConfigSettings editorConfigSettings = (EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class);
            editorConfigSettings.ENABLED = false;
        };
        if (consumer == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(20);
        }
        return consumer;
    }

    private static boolean isEnabledInTests() {
        return ourEnabledInTests;
    }

    @TestOnly
    public static void setEnabledInTests(boolean isEnabledInTests) {
        ourEnabledInTests = isEnabledInTests;
    }

    private static Collection<AbstractCodeStylePropertyMapper> getMappers(@NotNull MyContext context) {
        if (context == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(21);
        }
        HashSet<AbstractCodeStylePropertyMapper> mappers = new HashSet<AbstractCodeStylePropertyMapper>();
        for (LanguageCodeStyleSettingsProvider provider : EditorConfigCodeStyleSettingsModifier.getLanguageCodeStyleProviders(context)) {
            mappers.add(provider.getPropertyMapper(context.getSettings()));
        }
        mappers.add((AbstractCodeStylePropertyMapper)new GeneralCodeStylePropertyMapper(context.getSettings()));
        return mappers;
    }

    private static Collection<LanguageCodeStyleSettingsProvider> getLanguageCodeStyleProviders(@NotNull MyContext context) {
        if (context == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(22);
        }
        HashSet<LanguageCodeStyleSettingsProvider> providers = new HashSet<LanguageCodeStyleSettingsProvider>();
        LanguageCodeStyleSettingsProvider mainProvider = LanguageCodeStyleSettingsProvider.findUsingBaseLanguage((Language)context.getLanguage());
        if (mainProvider != null) {
            providers.add(mainProvider);
        }
        for (String langId : EditorConfigCodeStyleSettingsModifier.getLanguageIds(context)) {
            if (!langId.equals("any")) {
                LanguageCodeStyleSettingsProvider additionalProvider = LanguageCodeStyleSettingsProvider.findByExternalLanguageId((String)langId);
                if (additionalProvider == null) continue;
                providers.add(additionalProvider);
                continue;
            }
            providers.clear();
            providers.addAll(LanguageCodeStyleSettingsProvider.EP_NAME.getExtensionList());
            break;
        }
        return providers;
    }

    @NotNull
    private static Collection<String> getLanguageIds(@NotNull MyContext context) {
        if (context == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(23);
        }
        HashSet<String> langIds = new HashSet<String>();
        for (EditorConfig.OutPair option : context.getOptions()) {
            String langId;
            String key = option.getKey();
            if (EditorConfigIntellijNameUtil.isIndentProperty(key)) {
                langIds.add("any");
            }
            if ((langId = EditorConfigIntellijNameUtil.extractLanguageDomainId(key)) == null) continue;
            langIds.add(langId);
        }
        HashSet<String> hashSet = langIds;
        if (hashSet == null) {
            EditorConfigCodeStyleSettingsModifier.$$$reportNull$$$0(24);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 20: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 20: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transientSettings";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 9: 
            case 10: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionKey";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionValue";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentProperties";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisablingFunction";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modifySettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runWithTimeout";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStatusBarUiContributor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyCodeStyleSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mayOverrideSettingsOf";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processOptions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDependentProperties";
                break;
            }
            case 9: 
            case 10: 
            case 20: 
            case 24: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "preprocessValue";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findAccessor";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processEditorConfig";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMappers";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageCodeStyleProviders";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 20: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyContext
    extends EditorConfigFilesCollector {
        @NotNull
        private final CodeStyleSettings mySettings;
        @Nullable
        private List<EditorConfig.OutPair> myOptions;
        @NotNull
        private final PsiFile myFile;

        private MyContext(@NotNull CodeStyleSettings settings, @NotNull PsiFile file) {
            if (settings == null) {
                MyContext.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyContext.$$$reportNull$$$0(1);
            }
            this.mySettings = settings;
            this.myFile = file;
        }

        public void setOptions(@NotNull List<EditorConfig.OutPair> options) {
            if (options == null) {
                MyContext.$$$reportNull$$$0(2);
            }
            this.myOptions = options;
        }

        @NotNull
        private CodeStyleSettings getSettings() {
            CodeStyleSettings codeStyleSettings = this.mySettings;
            if (codeStyleSettings == null) {
                MyContext.$$$reportNull$$$0(3);
            }
            return codeStyleSettings;
        }

        @NotNull
        private List<EditorConfig.OutPair> getOptions() {
            List<Object> list = this.myOptions == null ? Collections.emptyList() : this.myOptions;
            if (list == null) {
                MyContext.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        private Language getLanguage() {
            Language language = this.myFile.getLanguage();
            if (language == null) {
                MyContext.$$$reportNull$$$0(5);
            }
            return language;
        }

        private String getTabSize() {
            for (EditorConfig.OutPair pair : this.getOptions()) {
                if (!"tab_width".equals(pair.getKey())) continue;
                return pair.getVal();
            }
            CommonCodeStyleSettings.IndentOptions indentOptions = this.mySettings.getIndentOptions(this.myFile.getFileType());
            return String.valueOf(indentOptions.TAB_SIZE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier$MyContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier$MyContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setOptions";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DisableEditorConfigAction
    extends AnAction {
        private final Project myProject;

        private DisableEditorConfigAction(Project project) {
            super(EditorConfigBundle.message("action.disable"));
            this.myProject = project;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DisableEditorConfigAction.$$$reportNull$$$0(0);
            }
            EditorConfigSettings editorConfigSettings = (EditorConfigSettings)CodeStyle.getSettings((Project)this.myProject).getCustomSettings(EditorConfigSettings.class);
            editorConfigSettings.ENABLED = false;
            CodeStyleSettingsManager.getInstance((Project)this.myProject).notifyCodeStyleSettingsChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/editorconfig/configmanagement/extended/EditorConfigCodeStyleSettingsModifier$DisableEditorConfigAction", "actionPerformed"));
        }
    }
}

