/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.lw;

import java.awt.Font;
import java.util.Locale;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;

public class FontDescriptor {
    private String myFontName;
    private int myFontSize;
    private int myFontStyle;
    private String mySwingFont;

    private FontDescriptor() {
    }

    public FontDescriptor(String fontName, int fontStyle, int fontSize) {
        this.myFontName = fontName;
        this.myFontSize = fontSize;
        this.myFontStyle = fontStyle;
    }

    public boolean isFixedFont() {
        return this.mySwingFont == null;
    }

    public boolean isFullyDefinedFont() {
        return this.myFontName != null && this.myFontSize >= 0 && this.myFontStyle >= 0;
    }

    public static FontDescriptor fromSwingFont(String swingFont) {
        FontDescriptor result = new FontDescriptor();
        result.mySwingFont = swingFont;
        return result;
    }

    public String getFontName() {
        return this.myFontName;
    }

    public int getFontSize() {
        return this.myFontSize;
    }

    public int getFontStyle() {
        return this.myFontStyle;
    }

    public Font getFont(Font defaultFont) {
        if (this.myFontName == null && defaultFont == null) {
            return null;
        }
        String name = this.myFontName;
        if (name == null || name.length() == 0) {
            if (defaultFont == null) {
                return null;
            }
            name = defaultFont.getName();
        } else if (!this.isValidFontName()) {
            if (defaultFont == null) {
                return null;
            }
            name = defaultFont.getName();
        }
        return FontDescriptor.getFontWithFallback(new Font(name, this.myFontStyle >= 0 ? this.myFontStyle : defaultFont.getStyle(), this.myFontSize >= 0 ? this.myFontSize : defaultFont.getSize()));
    }

    private static Font getFontWithFallback(Font font) {
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    public String getSwingFont() {
        return this.mySwingFont;
    }

    public Font getResolvedFont(Font defaultFont) {
        if (this.mySwingFont != null) {
            Font result = UIManager.getFont(this.mySwingFont);
            return result == null ? defaultFont : result;
        }
        return this.getFont(defaultFont);
    }

    private boolean isValidFontName() {
        Font font = new Font(this.myFontName, 0, 10);
        return font.canDisplay('a') && font.canDisplay('1');
    }

    public boolean isValid() {
        if (this.mySwingFont == null) {
            return this.myFontName == null || this.isValidFontName();
        }
        return UIManager.getFont(this.mySwingFont) != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FontDescriptor)) {
            return false;
        }
        FontDescriptor rhs = (FontDescriptor)obj;
        if (this.mySwingFont != null) {
            return this.mySwingFont.equals(rhs.mySwingFont);
        }
        if (this.myFontName == null && rhs.myFontName != null) {
            return false;
        }
        if (this.myFontName != null && rhs.myFontName == null) {
            return false;
        }
        if (this.myFontName != null && !this.myFontName.equals(rhs.myFontName)) {
            return false;
        }
        return this.myFontSize == rhs.myFontSize && this.myFontStyle == rhs.myFontStyle;
    }
}

