/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.AddToExtendsList;
import org.jetbrains.plugins.groovy.annotator.intentions.AddToImplementsList;
import org.jetbrains.plugins.groovy.annotator.intentions.AddToReferenceListFix;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.SealedHelper;
import org.jetbrains.plugins.groovy.lang.psi.util.SealedUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0014\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/bugs/GrPermitsClauseInspection;", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspection;", "()V", "buildErrorString", "", "infos", "", "", "([Ljava/lang/Object;)Ljava/lang/String;", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "intellij.groovy"})
public final class GrPermitsClauseInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            /*
             * WARNING - void declaration
             */
            public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)typeDefinition, (String)"typeDefinition");
                Iterable $this$filter$iv = SealedUtil.getAllPermittedClassElements(typeDefinition);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    PsiElement it = (PsiElement)element$iv$iv;
                    boolean bl = false;
                    if (!(!(it instanceof PsiClass))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List permittedClassElements = (List)destination$iv$iv;
                Collection collection = permittedClassElements;
                if (!collection.isEmpty()) {
                    this.checkPermittedClasses(typeDefinition, permittedClassElements);
                }
            }

            public final void checkPermittedClasses(@NotNull GrTypeDefinition baseClass, @NotNull List<? extends PsiElement> permittedElements) {
                Intrinsics.checkNotNullParameter((Object)baseClass, (String)"baseClass");
                Intrinsics.checkNotNullParameter(permittedElements, (String)"permittedElements");
                PsiClassType ownerType = InferenceKt.type(baseClass);
                for (PsiElement psiElement : permittedElements) {
                    AddToReferenceListFix addToReferenceListFix;
                    GrReferenceList targetReferenceList;
                    GrTypeDefinition subClass;
                    PsiClass psiClass = SealedHelper.INSTANCE.inferReferencedClass(psiElement);
                    if (!(psiClass instanceof GrTypeDefinition)) {
                        psiClass = null;
                    }
                    if ((GrTypeDefinition)psiClass == null) {
                        continue;
                    }
                    if ((baseClass.isInterface() && subClass.isInterface() ? (GrReferenceList)subClass.getExtendsClause() : (baseClass.isInterface() ? (GrReferenceList)subClass.getImplementsClause() : (GrReferenceList)subClass.getExtendsClause())) == null) {
                        continue;
                    }
                    targetReferenceList = targetReferenceList;
                    Object[] objectArray = targetReferenceList.getReferencedTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"targetReferenceList.referencedTypes");
                    if (ArraysKt.contains((Object[])objectArray, (Object)ownerType)) continue;
                    String string = GroovyBundle.message("inspection.message.invalid.permits.clause.must.directly.extend", subClass.getName(), baseClass.getName());
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                    if (targetReferenceList instanceof GrExtendsClause) {
                        addToReferenceListFix = new AddToExtendsList(baseClass, (GrExtendsClause)targetReferenceList);
                    } else {
                        GrReferenceList grReferenceList = targetReferenceList;
                        if (grReferenceList == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause");
                        }
                        addToReferenceListFix = new AddToImplementsList(baseClass, (GrImplementsClause)grReferenceList);
                    }
                    localQuickFixArray[0] = (LocalQuickFix)addToReferenceListFix;
                    this.registerError(psiElement, string, localQuickFixArray, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }
        };
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Intrinsics.checkNotNullParameter((Object)infos, (String)"infos");
        return "";
    }
}

