/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionReferenceKt;
import org.jetbrains.plugins.groovy.lang.resolve.GrReferenceResolveRunner;
import org.jetbrains.plugins.groovy.lang.resolve.GrResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCachingReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ArgumentsKt;
import org.jetbrains.plugins.groovy.lang.resolve.impl.IncompleteKt;
import org.jetbrains.plugins.groovy.lang.resolve.impl.OverloadsKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodProcessor;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\"\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007j\u0004\u0018\u0001`\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrExplicitMethodCallReference;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCachingReference;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyMethodCallReference;", "call", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;)V", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "getArguments", "()Ljava/util/List;", "methodName", "", "getMethodName", "()Ljava/lang/String;", "receiverArgument", "getReceiverArgument", "()Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "doResolve", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "incomplete", "", "intellij.groovy.psi"})
public final class GrExplicitMethodCallReference
extends GroovyCachingReference<GrMethodCall>
implements GroovyMethodCallReference {
    @Override
    @Nullable
    public Argument getReceiverArgument() {
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public String getMethodName() {
        GrMethodCall grMethodCall = (GrMethodCall)this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)grMethodCall, (String)"element");
        GrExpression grExpression = grMethodCall.getInvokedExpression();
        if (grExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression");
        }
        String string = ((GrReferenceExpression)grExpression).getReferenceName();
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        return string;
    }

    @Override
    @Nullable
    public List<Argument> getArguments() {
        GrMethodCall grMethodCall = (GrMethodCall)this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)grMethodCall, (String)"element");
        return ArgumentsKt.getArguments(grMethodCall);
    }

    @Override
    @NotNull
    public Collection<GroovyResolveResult> doResolve(boolean incomplete) {
        GrMethodCall grMethodCall = (GrMethodCall)this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)grMethodCall, (String)"element");
        GrExpression grExpression = grMethodCall.getInvokedExpression();
        if (grExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression");
        }
        GrReferenceExpression ref = (GrReferenceExpression)grExpression;
        if (incomplete) {
            return IncompleteKt.resolveIncomplete(ref);
        }
        String methodName = this.getMethodName();
        List<Argument> arguments2 = this.getArguments();
        PsiElement psiElement = ref;
        PsiType[] psiTypeArray = ref.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"ref.typeArguments");
        MethodProcessor methodProcessor = new MethodProcessor(methodName, psiElement, arguments2, psiTypeArray);
        new GrReferenceResolveRunner(ref, (PsiScopeProcessor)methodProcessor).resolveReferenceExpression();
        List<GroovyMethodResult> list = methodProcessor.getApplicableCandidates();
        if (list != null) {
            List<GroovyMethodResult> list2;
            List<GroovyMethodResult> it = list2 = list;
            boolean bl = false;
            return it;
        }
        GrResolverProcessor<?> propertyProcessor = GrReferenceExpressionReferenceKt.rValueProcessor(methodName, ref, GrReferenceExpressionReferenceKt.resolveKinds(ref));
        new GrReferenceResolveRunner(ref, propertyProcessor).resolveReferenceExpression();
        List<?> properties = propertyProcessor.getResults();
        if (properties.size() == 1) {
            return properties;
        }
        List<GroovyMethodResult> methods = OverloadsKt.filterBySignature(OverloadsKt.filterByArgumentsCount(methodProcessor.getAllCandidates(), arguments2));
        return CollectionsKt.plus((Collection)methods, (Iterable)properties);
    }

    public GrExplicitMethodCallReference(@NotNull GrMethodCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super((PsiElement)call);
    }
}

