/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.field;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightRecordField;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.problem.ProblemEmptyBuilder;
import de.plushnikov.intellij.plugin.problem.ProblemNewBuilder;
import de.plushnikov.intellij.plugin.processor.AbstractProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.processor.field.FieldProcessor;
import de.plushnikov.intellij.plugin.thirdparty.LombokCopyableAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFieldProcessor
extends AbstractProcessor
implements FieldProcessor {
    AbstractFieldProcessor(@NotNull Class<? extends PsiElement> supportedClass, @NotNull String supportedAnnotationClass) {
        if (supportedClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(0);
        }
        if (supportedAnnotationClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(1);
        }
        super(supportedClass, supportedAnnotationClass);
    }

    AbstractFieldProcessor(@NotNull Class<? extends PsiElement> supportedClass, @NotNull String supportedAnnotationClass, @NotNull String equivalentAnnotationClass) {
        if (supportedClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(2);
        }
        if (supportedAnnotationClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(3);
        }
        if (equivalentAnnotationClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(4);
        }
        super(supportedClass, supportedAnnotationClass, equivalentAnnotationClass);
    }

    @Override
    @NotNull
    public List<? super PsiElement> process(@NotNull PsiClass psiClass, @Nullable String nameHint) {
        if (psiClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(5);
        }
        ArrayList result = new ArrayList();
        Collection<PsiField> fields = psiClass.isRecord() ? AbstractFieldProcessor.collectRecordFields(psiClass) : PsiClassUtil.collectClassFieldsIntern(psiClass);
        for (PsiField psiField : fields) {
            PsiAnnotation psiAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, this.getSupportedAnnotationClasses());
            if (null == psiAnnotation || !this.possibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation, psiField) || !this.validate(psiAnnotation, psiField, ProblemEmptyBuilder.getInstance())) continue;
            this.generatePsiElements(psiField, psiAnnotation, result);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    protected boolean possibleToGenerateElementNamed(@Nullable String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField) {
        if (psiClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(7);
        }
        if (psiAnnotation == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(8);
        }
        if (psiField == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(9);
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(10);
        }
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        for (PsiField psiField : PsiClassUtil.collectClassFieldsIntern(psiClass)) {
            PsiAnnotation psiAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, this.getSupportedAnnotationClasses());
            if (null == psiAnnotation) continue;
            result.add(psiAnnotation);
        }
        ArrayList<PsiAnnotation> arrayList = result;
        if (arrayList == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<LombokProblem> verifyAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(12);
        }
        Collection<LombokProblem> result = Collections.emptyList();
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiField.class);
        if (null != psiField) {
            ProblemNewBuilder problemNewBuilder = new ProblemNewBuilder();
            this.validate(psiAnnotation, psiField, problemNewBuilder);
            result = problemNewBuilder.getProblems();
        }
        List<LombokProblem> list = result;
        if (list == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(13);
        }
        return list;
    }

    protected abstract boolean validate(@NotNull PsiAnnotation var1, @NotNull PsiField var2, @NotNull ProblemBuilder var3);

    protected void validateOnXAnnotations(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField, @NotNull ProblemBuilder builder, @NotNull String parameterName) {
        Iterable<String> onMethodAnnotations;
        List<PsiAnnotation> copyableAnnotations;
        if (psiAnnotation == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(14);
        }
        if (psiField == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(15);
        }
        if (builder == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(16);
        }
        if (parameterName == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(17);
        }
        if (!(copyableAnnotations = AbstractFieldProcessor.copyableAnnotations(psiField, LombokCopyableAnnotations.BASE_COPYABLE)).isEmpty()) {
            Iterable<String> onXAnnotations = LombokProcessorUtil.getOnX(psiAnnotation, parameterName);
            List copyableAnnotationsFQNs = ContainerUtil.map(copyableAnnotations, PsiAnnotation::getQualifiedName);
            for (String copyableAnnotationFQN : copyableAnnotationsFQNs) {
                for (String onXAnnotation : onXAnnotations) {
                    if (!onXAnnotation.startsWith(copyableAnnotationFQN)) continue;
                    builder.addError(LombokBundle.message("inspection.message.annotation.copy.duplicate", copyableAnnotationFQN));
                }
            }
        }
        if (psiField.isDeprecated() && StreamSupport.stream((onMethodAnnotations = LombokProcessorUtil.getOnX(psiAnnotation, "onMethod")).spliterator(), false).anyMatch("java.lang.Deprecated"::equals)) {
            builder.addError(LombokBundle.message("inspection.message.annotation.copy.duplicate", "java.lang.Deprecated"));
        }
    }

    protected abstract void generatePsiElements(@NotNull PsiField var1, @NotNull PsiAnnotation var2, @NotNull List<? super PsiElement> var3);

    protected boolean validateExistingMethods(@NotNull PsiField psiField, @NotNull ProblemBuilder builder, boolean isGetter) {
        PsiClass psiClass;
        if (psiField == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(18);
        }
        if (builder == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(19);
        }
        if (null != (psiClass = psiField.getContainingClass())) {
            List ownSignatures = (List)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
                List signatures = ContainerUtil.map(PsiClassUtil.collectClassMethodsIntern(psiClass), m -> MethodSignatureBackedByPsiMethod.create((PsiMethod)m, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                return new CachedValueProvider.Result((Object)signatures, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            });
            ArrayList<MethodSignatureBackedByPsiMethod> classMethods = new ArrayList<MethodSignatureBackedByPsiMethod>(ownSignatures);
            boolean isBoolean = PsiType.BOOLEAN.equals((Object)psiField.getType());
            AccessorsInfo accessorsInfo = AccessorsInfo.build(psiField);
            String fieldName = psiField.getName();
            String accessorName = isGetter ? LombokUtils.toGetterName(accessorsInfo, fieldName, isBoolean) : LombokUtils.toSetterName(accessorsInfo, fieldName, isBoolean);
            int paramCount = isGetter ? 0 : 1;
            classMethods.removeIf(m -> m.getParameterTypes().length != paramCount || !accessorName.equals(m.getName()));
            classMethods.removeIf(definedMethod -> PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)definedMethod.getMethod(), "lombok.experimental.Tolerate"));
            if (!classMethods.isEmpty()) {
                builder.addWarning(LombokBundle.message("inspection.message.not.generated.s.method.with.similar.name.s.already.exists", new Object[0]), accessorName, accessorName);
                return false;
            }
        }
        return true;
    }

    private static Collection<PsiField> collectRecordFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(20);
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory();
        Set<PsiField> fields = Arrays.stream(psiClass.getRecordComponents()).filter(c -> c.getName() != null && c.getTypeElement() != null).map(c -> {
            Object type = c.getTypeElement().getText();
            if (((String)type).endsWith("...")) {
                type = ((String)type).substring(0, ((String)type).length() - 3) + "[]";
            }
            PsiField field = factory.createFieldFromText(String.format("private final %s %s;", type, c.getName()), (PsiElement)psiClass);
            return new LightRecordField(psiClass.getManager(), field, psiClass, c);
        }).collect(Collectors.toSet());
        fields.addAll(((PsiExtensibleClass)psiClass).getOwnFields());
        return fields;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedAnnotationClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equivalentAnnotationClass";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/field/AbstractFieldProcessor";
                break;
            }
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 9: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/field/AbstractFieldProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "verifyAnnotation";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "validateOnXAnnotations";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "validateExistingMethods";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectRecordFields";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

