/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.light.LightTypeParameterBuilder;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.handler.BuilderHandler;
import de.plushnikov.intellij.plugin.processor.handler.BuilderInfo;
import de.plushnikov.intellij.plugin.psi.LombokLightClassBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class SuperBuilderHandler
extends BuilderHandler {
    private static final String SELF_METHOD = "self";
    private static final String TO_BUILDER_METHOD_NAME = "toBuilder";
    private static final String FILL_VALUES_METHOD_NAME = "$fillValuesFrom";
    private static final String STATIC_FILL_VALUES_METHOD_NAME = "$fillValuesFromInstanceIntoBuilder";
    private static final String INSTANCE_VARIABLE_NAME = "instance";
    private static final String BUILDER_VARIABLE_NAME = "b";

    @Override
    protected boolean validateBuilderConstructor(@NotNull PsiClass psiClass, Collection<BuilderInfo> builderInfos, @NotNull ProblemBuilder problemBuilder) {
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(0);
        }
        if (problemBuilder == null) {
            SuperBuilderHandler.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Override
    public boolean validateExistingBuilderClass(@NotNull String builderClassName, @NotNull PsiClass psiClass, @NotNull ProblemBuilder problemBuilder) {
        Optional<PsiClass> existingInnerBuilderClass;
        if (builderClassName == null) {
            SuperBuilderHandler.$$$reportNull$$$0(2);
        }
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(3);
        }
        if (problemBuilder == null) {
            SuperBuilderHandler.$$$reportNull$$$0(4);
        }
        if ((existingInnerBuilderClass = PsiClassUtil.getInnerClassInternByName(psiClass, builderClassName)).isPresent()) {
            if (!this.validateInvalidAnnotationsOnBuilderClass(existingInnerBuilderClass.get(), problemBuilder)) {
                return false;
            }
            Optional<PsiClass> isStaticAndAbstract = existingInnerBuilderClass.filter(psiInnerClass -> psiInnerClass.hasModifierProperty("static")).filter(psiInnerClass -> psiInnerClass.hasModifierProperty("abstract"));
            if (isStaticAndAbstract.isEmpty()) {
                problemBuilder.addError(LombokBundle.message("inspection.message.existing.builder.must.be.abstract.static.inner.class", new Object[0]));
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String getBuilderClassName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(5);
        }
        String string = SuperBuilderHandler.getBuilderClassName(psiClass, psiClass.getName());
        if (string == null) {
            SuperBuilderHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getBuilderImplClassName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(7);
        }
        String string = this.getBuilderClassName(psiClass) + "Impl";
        if (string == null) {
            SuperBuilderHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    public Optional<PsiMethod> createBuilderBasedConstructor(@NotNull PsiClass psiClass, @NotNull PsiClass builderClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClassType psiTypeBaseWithGenerics) {
        String className;
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(9);
        }
        if (builderClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(10);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(11);
        }
        if (psiTypeBaseWithGenerics == null) {
            SuperBuilderHandler.$$$reportNull$$$0(12);
        }
        if (null == (className = psiClass.getName())) {
            return Optional.empty();
        }
        Collection<PsiMethod> existedConstructors = PsiClassUtil.collectClassConstructorIntern(psiClass);
        if (existedConstructors.stream().anyMatch(psiMethod -> psiMethod.getParameterList().getParametersCount() == 1)) {
            return Optional.empty();
        }
        LombokLightMethodBuilder constructorBuilderBased = new LombokLightMethodBuilder(psiClass.getManager(), className).withConstructor(true).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withModifier("protected").withParameter(BUILDER_VARIABLE_NAME, (PsiType)psiTypeBaseWithGenerics);
        List<BuilderInfo> builderInfos = this.createBuilderInfos(psiClass, psiAnnotation, builderClass);
        String buildMethodPrepare = builderInfos.stream().map(BuilderInfo::renderSuperBuilderConstruction).collect(Collectors.joining());
        PsiClass superClass = psiClass.getSuperClass();
        Object codeBlock = null != superClass && !"Object".equals(superClass.getName()) ? "super(b);\n" + buildMethodPrepare : buildMethodPrepare;
        constructorBuilderBased.withBodyText((String)codeBlock);
        return Optional.of(constructorBuilderBased);
    }

    public Optional<PsiMethod> createBuilderMethodIfNecessary(@NotNull PsiClass containingClass, @NotNull PsiClass builderBaseClass, @NotNull PsiClass builderImplClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClassType psiTypeBaseWithGenerics) {
        String builderMethodName;
        if (containingClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(13);
        }
        if (builderBaseClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(14);
        }
        if (builderImplClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(15);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(16);
        }
        if (psiTypeBaseWithGenerics == null) {
            SuperBuilderHandler.$$$reportNull$$$0(17);
        }
        if ((builderMethodName = this.getBuilderMethodName(psiAnnotation)).isEmpty() || this.hasMethod(containingClass, builderMethodName)) {
            return Optional.empty();
        }
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(containingClass.getManager(), builderMethodName).withMethodReturnType((PsiType)psiTypeBaseWithGenerics).withContainingClass(containingClass).withNavigationElement((PsiElement)psiAnnotation).withModifier("public").withModifier("static");
        this.addTypeParameters(containingClass, null, methodBuilder);
        String blockText = String.format("return new %s();", PsiClassUtil.getTypeWithGenerics(builderImplClass).getPresentableText());
        methodBuilder.withBodyText(blockText);
        return Optional.of(methodBuilder);
    }

    public Optional<PsiMethod> createToBuilderMethodIfNecessary(@NotNull PsiClass containingClass, @NotNull PsiClass builderBaseClass, @NotNull PsiClass builderImplClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClassType psiTypeBaseWithGenerics) {
        if (containingClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(18);
        }
        if (builderBaseClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(19);
        }
        if (builderImplClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(20);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(21);
        }
        if (psiTypeBaseWithGenerics == null) {
            SuperBuilderHandler.$$$reportNull$$$0(22);
        }
        if (!this.shouldGenerateToBuilderMethods(psiAnnotation)) {
            return Optional.empty();
        }
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(containingClass.getManager(), TO_BUILDER_METHOD_NAME).withMethodReturnType((PsiType)psiTypeBaseWithGenerics).withContainingClass(containingClass).withNavigationElement((PsiElement)psiAnnotation).withModifier("public");
        String blockText = String.format("return new %s().%s(this);", PsiClassUtil.getTypeWithGenerics(builderImplClass).getPresentableText(), FILL_VALUES_METHOD_NAME);
        methodBuilder.withBodyText(blockText);
        return Optional.of(methodBuilder);
    }

    private boolean shouldGenerateToBuilderMethods(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(23);
        }
        return PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, TO_BUILDER_METHOD_NAME, false);
    }

    private String selectNonClashingNameFor(String classGenericName, Collection<String> typeParamStrings) {
        Object result = classGenericName;
        if (typeParamStrings.contains(classGenericName)) {
            int counter = 2;
            while (typeParamStrings.contains(result = classGenericName + counter++)) {
            }
        }
        return result;
    }

    @NotNull
    public PsiClass createBuilderBaseClass(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        PsiClass parentBuilderClass;
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(24);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(25);
        }
        String builderClassName = this.getBuilderClassName(psiClass);
        String builderClassQualifiedName = psiClass.getQualifiedName() + "." + builderClassName;
        LombokLightClassBuilder baseClassBuilder = new LombokLightClassBuilder((PsiElement)psiClass, builderClassName, builderClassQualifiedName).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withParameterTypes(psiClass.getTypeParameterList()).withModifier("public").withModifier("static").withModifier("abstract");
        List<String> typeParamNames = Stream.of(psiClass.getTypeParameters()).map(PsiQualifiedNamedElement::getName).collect(Collectors.toList());
        LightTypeParameterBuilder c = new LightTypeParameterBuilder(this.selectNonClashingNameFor("C", typeParamNames), (PsiTypeParameterListOwner)baseClassBuilder, 0);
        c.getExtendsList().addReference(PsiClassUtil.getTypeWithGenerics(psiClass));
        baseClassBuilder.withParameterType((PsiTypeParameter)c);
        LightTypeParameterBuilder b = new LightTypeParameterBuilder(this.selectNonClashingNameFor("B", typeParamNames), (PsiTypeParameterListOwner)baseClassBuilder, 1);
        baseClassBuilder.withParameterType((PsiTypeParameter)b);
        b.getExtendsList().addReference(PsiClassUtil.getTypeWithGenerics((PsiClass)baseClassBuilder));
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
        PsiClassType bType = factory.createType((PsiClass)b);
        PsiClassType cType = factory.createType((PsiClass)c);
        PsiClass superClass = psiClass.getSuperClass();
        if (null != superClass && !"Object".equals(superClass.getName()) && null != (parentBuilderClass = superClass.findInnerClassByName(this.getBuilderClassName(superClass), false))) {
            PsiType[] explicitTypes = (PsiType[])Stream.concat(Stream.of(psiClass.getExtendsListTypes()).map(PsiClassType::getParameters).flatMap(Stream::of), Stream.of(cType, bType)).toArray(PsiType[]::new);
            PsiClassType extendsType = this.getTypeWithSpecificTypeParameters(parentBuilderClass, explicitTypes);
            baseClassBuilder.withExtends(extendsType);
        }
        baseClassBuilder.withFieldSupplier(thisPsiClass -> {
            List<BuilderInfo> builderInfos = this.createBuilderInfos(psiClass, psiAnnotation, (PsiClass)thisPsiClass);
            this.initBuilderInfosBuilderClassType(builderInfos, bType);
            return builderInfos.stream().map(BuilderInfo::renderBuilderFields).flatMap(Collection::stream).collect(Collectors.toList());
        });
        baseClassBuilder.withMethodSupplier(thisPsiClass -> {
            List<BuilderInfo> builderInfos = this.createBuilderInfos(psiClass, psiAnnotation, (PsiClass)thisPsiClass);
            this.initBuilderInfosBuilderClassType(builderInfos, bType);
            return this.addAllMethodsForBaseBuilderClass(psiClass, psiAnnotation, (PsiClass)thisPsiClass, builderInfos, bType, cType);
        });
        LombokLightClassBuilder lombokLightClassBuilder = baseClassBuilder;
        if (lombokLightClassBuilder == null) {
            SuperBuilderHandler.$$$reportNull$$$0(26);
        }
        return lombokLightClassBuilder;
    }

    @NotNull
    private List<BuilderInfo> createBuilderInfos(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass baseClassBuilder) {
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(27);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(28);
        }
        if (baseClassBuilder == null) {
            SuperBuilderHandler.$$$reportNull$$$0(29);
        }
        List<BuilderInfo> builderInfos = this.createBuilderInfos(psiAnnotation, psiClass, null, baseClassBuilder);
        for (BuilderInfo builderInfo : builderInfos) {
            builderInfo.withBuilderChainResult("self()").withInstanceVariableName(INSTANCE_VARIABLE_NAME);
        }
        List<BuilderInfo> list = builderInfos;
        if (list == null) {
            SuperBuilderHandler.$$$reportNull$$$0(30);
        }
        return list;
    }

    private void initBuilderInfosBuilderClassType(@NotNull List<BuilderInfo> builderInfos, @NotNull PsiClassType bType) {
        if (builderInfos == null) {
            SuperBuilderHandler.$$$reportNull$$$0(31);
        }
        if (bType == null) {
            SuperBuilderHandler.$$$reportNull$$$0(32);
        }
        for (BuilderInfo builderInfo : builderInfos) {
            builderInfo.withBuilderClassType(bType);
        }
    }

    public Collection<PsiMethod> createAllMethodsOfBaseBuilder(@NotNull PsiClass psiParentClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiBuilderClass) {
        PsiTypeParameter cTypeClass;
        PsiTypeParameter bTypeClass;
        PsiTypeParameter[] typeParameters;
        if (psiParentClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(33);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(34);
        }
        if (psiBuilderClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(35);
        }
        if ((typeParameters = psiBuilderClass.getTypeParameters()).length >= 2) {
            bTypeClass = typeParameters[typeParameters.length - 1];
            cTypeClass = typeParameters[typeParameters.length - 2];
        } else {
            bTypeClass = new LightTypeParameterBuilder("B", (PsiTypeParameterListOwner)psiBuilderClass, 1);
            cTypeClass = new LightTypeParameterBuilder("C", (PsiTypeParameterListOwner)psiBuilderClass, 0);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiParentClass.getProject());
        PsiClassType bType = factory.createType((PsiClass)bTypeClass);
        PsiClassType cType = factory.createType((PsiClass)cTypeClass);
        List<BuilderInfo> builderInfos = this.createBuilderInfos(psiParentClass, psiAnnotation, psiBuilderClass);
        this.initBuilderInfosBuilderClassType(builderInfos, bType);
        return this.addAllMethodsForBaseBuilderClass(psiParentClass, psiAnnotation, psiBuilderClass, builderInfos, bType, cType);
    }

    private Collection<PsiMethod> addAllMethodsForBaseBuilderClass(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass baseClassBuilder, List<BuilderInfo> builderInfos, @NotNull PsiClassType bType, @NotNull PsiClassType cType) {
        String buildMethodName;
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(36);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(37);
        }
        if (baseClassBuilder == null) {
            SuperBuilderHandler.$$$reportNull$$$0(38);
        }
        if (bType == null) {
            SuperBuilderHandler.$$$reportNull$$$0(39);
        }
        if (cType == null) {
            SuperBuilderHandler.$$$reportNull$$$0(40);
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        Collection existedMethodNames = PsiClassUtil.collectClassMethodsIntern(baseClassBuilder).stream().filter(psiMethod -> PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiMethod, "lombok.experimental.Tolerate")).map(PsiMethod::getName).collect(Collectors.toSet());
        builderInfos.stream().filter(info -> info.notAlreadyExistingMethod(existedMethodNames)).map(BuilderInfo::renderBuilderMethods).forEach(result::addAll);
        PsiManager psiManager = psiClass.getManager();
        boolean forceCallSuper = PsiClassUtil.hasSuperClass(psiClass);
        if (this.shouldGenerateToBuilderMethods(psiAnnotation)) {
            LombokLightMethodBuilder methodBuilder;
            builderInfos.forEach(BuilderInfo::withObtainVia);
            if (!existedMethodNames.contains(STATIC_FILL_VALUES_METHOD_NAME)) {
                methodBuilder = new LombokLightMethodBuilder(psiManager, STATIC_FILL_VALUES_METHOD_NAME).withMethodReturnType((PsiType)PsiType.VOID).withParameter(INSTANCE_VARIABLE_NAME, (PsiType)PsiClassUtil.getTypeWithGenerics(psiClass)).withParameter(BUILDER_VARIABLE_NAME, (PsiType)this.getTypeWithWildcardsForSuperBuilderTypeParameters(baseClassBuilder)).withContainingClass(baseClassBuilder).withNavigationElement((PsiElement)psiClass).withModifier("private").withModifier("static");
                this.addTypeParameters(psiClass, null, methodBuilder);
                String toBuilderMethodCalls = builderInfos.stream().map(BuilderInfo::renderToBuilderCall).collect(Collectors.joining(";b.", "b.", ";\n"));
                methodBuilder.withBodyText(toBuilderMethodCalls);
                result.add((PsiMethod)methodBuilder);
            }
            if (!existedMethodNames.contains(FILL_VALUES_METHOD_NAME)) {
                methodBuilder = new LombokLightMethodBuilder(psiManager, FILL_VALUES_METHOD_NAME).withMethodReturnType((PsiType)bType).withParameter(INSTANCE_VARIABLE_NAME, (PsiType)cType).withContainingClass(baseClassBuilder).withNavigationElement((PsiElement)psiClass).withModifier("protected");
                String callSuperCode = "super.$fillValuesFrom(instance);\n";
                String codeBlockText = String.format("%s%s.%s(%s, this);\nreturn self();", forceCallSuper ? "super.$fillValuesFrom(instance);\n" : "", baseClassBuilder.getName(), STATIC_FILL_VALUES_METHOD_NAME, INSTANCE_VARIABLE_NAME);
                methodBuilder.withBodyText(codeBlockText);
                result.add((PsiMethod)methodBuilder);
            }
        }
        if (!existedMethodNames.contains(SELF_METHOD)) {
            LombokLightMethodBuilder selfMethod = new LombokLightMethodBuilder(psiManager, SELF_METHOD).withMethodReturnType((PsiType)bType).withContainingClass(baseClassBuilder).withNavigationElement((PsiElement)psiClass).withModifier("abstract").withModifier("protected");
            result.add((PsiMethod)selfMethod);
        }
        if (!existedMethodNames.contains(buildMethodName = this.getBuildMethodName(psiAnnotation))) {
            LombokLightMethodBuilder buildMethod = new LombokLightMethodBuilder(psiManager, buildMethodName).withMethodReturnType((PsiType)cType).withContainingClass(baseClassBuilder).withNavigationElement((PsiElement)psiClass).withModifier("abstract").withModifier("public");
            result.add((PsiMethod)buildMethod);
        }
        if (!existedMethodNames.contains("toString")) {
            result.add(this.createToStringMethod(psiAnnotation, baseClassBuilder, forceCallSuper));
        }
        return result;
    }

    @NotNull
    public PsiClass createBuilderImplClass(@NotNull PsiClass psiClass, @NotNull PsiClass psiBaseBuilderClass, PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(41);
        }
        if (psiBaseBuilderClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(42);
        }
        String builderClassName = this.getBuilderImplClassName(psiClass);
        String builderClassQualifiedName = psiClass.getQualifiedName() + "." + builderClassName;
        LombokLightClassBuilder implClassBuilder = new LombokLightClassBuilder((PsiElement)psiClass, builderClassName, builderClassQualifiedName).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withParameterTypes(psiClass.getTypeParameterList()).withModifier("private").withModifier("static").withModifier("final");
        PsiClassType extendsType = this.getTypeWithSpecificTypeParameters(psiBaseBuilderClass, new PsiType[]{PsiClassUtil.getTypeWithGenerics(psiClass), PsiClassUtil.getTypeWithGenerics((PsiClass)implClassBuilder)});
        implClassBuilder.withExtends(extendsType);
        implClassBuilder.withMethodSupplier(thisPsiClass -> this.createAllMethodsOfImplBuilder(psiClass, psiAnnotation, (PsiClass)thisPsiClass));
        LombokLightClassBuilder lombokLightClassBuilder = implClassBuilder;
        if (lombokLightClassBuilder == null) {
            SuperBuilderHandler.$$$reportNull$$$0(43);
        }
        return lombokLightClassBuilder;
    }

    public Collection<PsiMethod> createAllMethodsOfImplBuilder(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass implBuilderClass) {
        String buildMethodName;
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(44);
        }
        if (psiAnnotation == null) {
            SuperBuilderHandler.$$$reportNull$$$0(45);
        }
        if (implBuilderClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(46);
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        Collection existedMethodNames = PsiClassUtil.collectClassMethodsIntern(implBuilderClass).stream().map(PsiMethod::getName).collect(Collectors.toSet());
        String builderImplClassName = StringUtil.notNullize((String)implBuilderClass.getName());
        PsiManager psiManager = psiClass.getManager();
        if (!existedMethodNames.contains(builderImplClassName)) {
            LombokLightMethodBuilder privateConstructor = new LombokLightMethodBuilder(psiManager, builderImplClassName).withConstructor(true).withContainingClass(implBuilderClass).withNavigationElement((PsiElement)psiClass).withModifier("private").withBodyText("");
            result.add((PsiMethod)privateConstructor);
        }
        if (!existedMethodNames.contains(SELF_METHOD)) {
            LombokLightMethodBuilder selfMethod = new LombokLightMethodBuilder(psiManager, SELF_METHOD).withMethodReturnType((PsiType)PsiClassUtil.getTypeWithGenerics(implBuilderClass)).withContainingClass(implBuilderClass).withNavigationElement((PsiElement)psiClass).withModifier("protected").withBodyText("return this;");
            result.add((PsiMethod)selfMethod);
        }
        if (!existedMethodNames.contains(buildMethodName = this.getBuildMethodName(psiAnnotation))) {
            PsiType builderType = this.getReturnTypeOfBuildMethod(psiClass, null);
            PsiSubstitutor builderSubstitutor = this.getBuilderSubstitutor((PsiTypeParameterListOwner)psiClass, implBuilderClass);
            PsiType returnType = builderSubstitutor.substitute(builderType);
            LombokLightMethodBuilder buildMethod = new LombokLightMethodBuilder(psiManager, buildMethodName).withMethodReturnType(returnType).withContainingClass(implBuilderClass).withNavigationElement((PsiElement)psiClass).withModifier("public");
            String buildCodeBlockText = String.format("return new %s(this);", PsiClassUtil.getTypeWithGenerics(psiClass).getPresentableText());
            buildMethod.withBodyText(buildCodeBlockText);
            result.add((PsiMethod)buildMethod);
        }
        return result;
    }

    @NotNull
    public PsiClassType getTypeWithWildcardsForSuperBuilderTypeParameters(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(47);
        }
        PsiWildcardType wildcardType = PsiWildcardType.createUnbounded((PsiManager)psiClass.getManager());
        return this.getTypeWithSpecificTypeParameters(psiClass, new PsiType[]{wildcardType, wildcardType});
    }

    @NotNull
    private PsiClassType getTypeWithSpecificTypeParameters(@NotNull PsiClass psiClass, PsiType ... psiTypes) {
        int substituteTypesCount;
        if (psiClass == null) {
            SuperBuilderHandler.$$$reportNull$$$0(48);
        }
        if (psiTypes == null) {
            SuperBuilderHandler.$$$reportNull$$$0(49);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
        PsiTypeParameter[] classTypeParameters = psiClass.getTypeParameters();
        if (classTypeParameters.length >= (substituteTypesCount = psiTypes.length)) {
            int i;
            PsiSubstitutor newSubstitutor = PsiSubstitutor.EMPTY;
            int fromIndex = classTypeParameters.length - substituteTypesCount;
            for (i = 0; i < fromIndex; ++i) {
                newSubstitutor = newSubstitutor.put(classTypeParameters[i], (PsiType)elementFactory.createType((PsiClass)classTypeParameters[i]));
            }
            for (i = fromIndex; i < classTypeParameters.length; ++i) {
                newSubstitutor = newSubstitutor.put(classTypeParameters[i], psiTypes[i - fromIndex]);
            }
            PsiClassType psiClassType = elementFactory.createType(psiClass, newSubstitutor);
            if (psiClassType == null) {
                SuperBuilderHandler.$$$reportNull$$$0(50);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = elementFactory.createType(psiClass);
        if (psiClassType == null) {
            SuperBuilderHandler.$$$reportNull$$$0(51);
        }
        return psiClassType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 26: 
            case 30: 
            case 43: 
            case 50: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 26: 
            case 30: 
            case 43: 
            case 50: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderClassName";
                break;
            }
            case 6: 
            case 8: 
            case 26: 
            case 30: 
            case 43: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/handler/SuperBuilderHandler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderClass";
                break;
            }
            case 11: 
            case 16: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 34: 
            case 37: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 12: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiTypeBaseWithGenerics";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderBaseClass";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderImplClass";
                break;
            }
            case 29: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassBuilder";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderInfos";
                break;
            }
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bType";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParentClass";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiBuilderClass";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cType";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiBaseBuilderClass";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implBuilderClass";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/SuperBuilderHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderClassName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderImplClassName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilderBaseClass";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilderInfos";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilderImplClass";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithSpecificTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validateBuilderConstructor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateExistingBuilderClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderClassName";
                break;
            }
            case 6: 
            case 8: 
            case 26: 
            case 30: 
            case 43: 
            case 50: 
            case 51: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderImplClassName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderBasedConstructor";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderMethodIfNecessary";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createToBuilderMethodIfNecessary";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "shouldGenerateToBuilderMethods";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderBaseClass";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderInfos";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "initBuilderInfosBuilderClassType";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createAllMethodsOfBaseBuilder";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addAllMethodsForBaseBuilderClass";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderImplClass";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createAllMethodsOfImplBuilder";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithWildcardsForSuperBuilderTypeParameters";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithSpecificTypeParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 26: 
            case 30: 
            case 43: 
            case 50: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

