/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class AccordionLayout
implements LayoutManager2,
Updatable {
    private static final float DEFAULT_LERP_FRACTION = 0.9999f;
    private static final float DEFAULT_LERP_THRESHOLD_PIXEL = 1.0f;
    @NotNull
    private final HashMap<Component, ComponentInfo> mComponentInfoMap;
    @NotNull
    private final TreeSet<ComponentInfo> mComponentInfoSet;
    @NotNull
    private final Orientation mOrientation;
    @NotNull
    private final Container mParent;
    private float mMaxTotal;
    private float mPreferredTotal;
    private float mPreoccupiedSpace;
    private float mLerpFraction;
    private float mLerpThreshold;

    public AccordionLayout(@NotNull Container parent, @NotNull Orientation orientation) {
        if (parent == null) {
            AccordionLayout.$$$reportNull$$$0(0);
        }
        if (orientation == null) {
            AccordionLayout.$$$reportNull$$$0(1);
        }
        this.mParent = parent;
        this.mOrientation = orientation;
        this.mComponentInfoMap = new HashMap();
        this.mComponentInfoSet = new TreeSet();
        this.mLerpFraction = 0.9999f;
        this.mLerpThreshold = 1.0f;
    }

    @Override
    public void setLerpFraction(float fraction) {
        this.mLerpFraction = fraction;
    }

    @Override
    public void setLerpThreshold(float threshold) {
        this.mLerpThreshold = threshold;
    }

    public AccordionState getState(@NotNull Component comp) {
        if (comp == null) {
            AccordionLayout.$$$reportNull$$$0(2);
        }
        assert (this.mComponentInfoMap.containsKey(comp));
        return this.mComponentInfoMap.get((Object)comp).state;
    }

    public void setState(@NotNull Component comp, @NotNull AccordionState state) {
        if (comp == null) {
            AccordionLayout.$$$reportNull$$$0(3);
        }
        if (state == null) {
            AccordionLayout.$$$reportNull$$$0(4);
        }
        assert (this.mComponentInfoMap.containsKey(comp));
        ComponentInfo info2 = this.mComponentInfoMap.get(comp);
        if (info2.state != state) {
            this.setStateInternal(comp, info2, state);
        }
    }

    private void setStateInternal(@NotNull Component comp, @NotNull ComponentInfo info2, @NotNull AccordionState state) {
        if (comp == null) {
            AccordionLayout.$$$reportNull$$$0(5);
        }
        if (info2 == null) {
            AccordionLayout.$$$reportNull$$$0(6);
        }
        if (state == null) {
            AccordionLayout.$$$reportNull$$$0(7);
        }
        this.mComponentInfoSet.remove(info2);
        info2.state = state;
        if (state == AccordionState.MINIMIZE) {
            info2.currentSize = this.mOrientation == Orientation.VERTICAL ? (float)comp.getHeight() : (float)comp.getWidth();
        }
        this.mComponentInfoSet.add(info2);
    }

    public void toggleMaximize(@NotNull Component comp) {
        if (comp == null) {
            AccordionLayout.$$$reportNull$$$0(8);
        }
        assert (this.mComponentInfoMap.containsKey(comp));
        ComponentInfo info2 = this.mComponentInfoMap.get(comp);
        this.setStateInternal(comp, info2, info2.state == AccordionState.MAXIMIZE ? AccordionState.PREFERRED : AccordionState.MAXIMIZE);
    }

    public void toggleMinimize(@NotNull Component comp) {
        if (comp == null) {
            AccordionLayout.$$$reportNull$$$0(9);
        }
        assert (this.mComponentInfoMap.containsKey(comp));
        ComponentInfo info2 = this.mComponentInfoMap.get(comp);
        this.setStateInternal(comp, info2, info2.state == AccordionState.MINIMIZE ? AccordionState.PREFERRED : AccordionState.MINIMIZE);
    }

    public void resetComponents() {
        for (Component comp : this.mComponentInfoMap.keySet()) {
            this.setState(comp, AccordionState.PREFERRED);
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        ComponentInfo info2 = new ComponentInfo(comp, 0.0f, AccordionState.PREFERRED);
        this.mComponentInfoMap.put(comp, info2);
        this.mComponentInfoSet.add(info2);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        ComponentInfo info2 = new ComponentInfo(comp, 0.0f, AccordionState.PREFERRED);
        this.mComponentInfoMap.put(comp, info2);
        this.mComponentInfoSet.add(info2);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        assert (this.mComponentInfoMap.containsKey(comp));
        ComponentInfo info2 = this.mComponentInfoMap.get(comp);
        this.mComponentInfoMap.remove(comp);
        this.mComponentInfoSet.remove(info2);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.calculateSizes(parent, AccordionState.MINIMIZE);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.calculateSizes(parent, AccordionState.PREFERRED);
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return this.calculateSizes(parent, AccordionState.MAXIMIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int maxWidth = parent.getWidth() - (insets.left + insets.right);
        int maxHeight = parent.getHeight() - (insets.top + insets.bottom);
        int remainingSpace = this.mOrientation == Orientation.VERTICAL ? maxHeight : maxWidth;
        HashMap<Component, Float> clampedComponents = new HashMap<Component, Float>();
        HashMap<Component, Point> layoutInfos = new HashMap<Component, Point>();
        float totalUsedSpace = 0.0f;
        float otherStatesPreoccupiedSpace = 0.0f;
        float currentStateUsedSpace = 0.0f;
        float currentStateFixedSpace = 0.0f;
        float currentStateFluidSpace = 0.0f;
        int currentStateStartIndex = -1;
        AccordionState currentState = null;
        Component componentToFill = null;
        ArrayList<ComponentInfo> infos = new ArrayList<ComponentInfo>(this.mComponentInfoSet);
        block19: for (int i = 0; i < infos.size(); ++i) {
            Float size;
            ComponentInfo info2 = (ComponentInfo)infos.get(i);
            if (currentState != info2.state) {
                currentState = info2.state;
                currentStateStartIndex = i;
                totalUsedSpace += currentStateUsedSpace;
                currentStateUsedSpace = 0.0f;
                currentStateFixedSpace = 0.0f;
                switch (currentState) {
                    case MAXIMIZE: {
                        otherStatesPreoccupiedSpace = this.mPreoccupiedSpace;
                        currentStateFluidSpace = this.mMaxTotal;
                        break;
                    }
                    case PREFERRED: {
                        otherStatesPreoccupiedSpace = 0.0f;
                        currentStateFluidSpace = this.mPreferredTotal;
                        break;
                    }
                }
            }
            if ((size = (Float)clampedComponents.get(info2.component)) == null) {
                if (info2.state == AccordionState.MINIMIZE) {
                    size = Float.valueOf(info2.currentSize);
                } else {
                    float fluidSpace = this.mOrientation == Orientation.VERTICAL ? (float)maxHeight - (totalUsedSpace + otherStatesPreoccupiedSpace + currentStateFixedSpace) : (float)maxWidth - (totalUsedSpace + otherStatesPreoccupiedSpace + currentStateFixedSpace);
                    size = Float.valueOf(fluidSpace * info2.currentSize / currentStateFluidSpace);
                    float clampedSize = this.clampSize(info2.component, size.floatValue());
                    if (clampedSize != size.floatValue()) {
                        clampedComponents.put(info2.component, Float.valueOf(clampedSize));
                        currentStateFluidSpace -= info2.currentSize;
                        currentStateFixedSpace += clampedSize;
                        currentStateUsedSpace = 0.0f;
                        i = currentStateStartIndex - 1;
                        continue;
                    }
                    if (componentToFill == null) {
                        componentToFill = info2.component;
                    }
                }
            } else if (info2.component == componentToFill) {
                componentToFill = null;
            }
            currentStateUsedSpace += size.floatValue();
            switch (this.mOrientation) {
                case HORIZONTAL: {
                    if (layoutInfos.containsKey(info2.component)) {
                        remainingSpace += ((Point)layoutInfos.get((Object)info2.component)).x;
                    }
                    int width = Math.round(size.floatValue());
                    layoutInfos.put(info2.component, new Point(width, maxHeight));
                    remainingSpace -= width;
                    continue block19;
                }
                case VERTICAL: {
                    if (layoutInfos.containsKey(info2.component)) {
                        remainingSpace += ((Point)layoutInfos.get((Object)info2.component)).y;
                    }
                    int height = Math.round(size.floatValue());
                    layoutInfos.put(info2.component, new Point(maxWidth, height));
                    remainingSpace -= height;
                }
            }
        }
        int currX = insets.left;
        int currY = insets.top;
        Object object = parent.getTreeLock();
        synchronized (object) {
            block20: for (Component comp : parent.getComponents()) {
                Point size = (Point)layoutInfos.get(comp);
                if (componentToFill == comp) {
                    switch (this.mOrientation) {
                        case HORIZONTAL: {
                            size.x += remainingSpace;
                            break;
                        }
                        case VERTICAL: {
                            size.y += remainingSpace;
                        }
                    }
                }
                comp.setBounds(currX, currY, size.x, size.y);
                switch (this.mOrientation) {
                    case HORIZONTAL: {
                        currX += size.x;
                        continue block20;
                    }
                    case VERTICAL: {
                        currY += size.y;
                    }
                }
            }
        }
    }

    @Override
    public void update(long elapsedNs) {
        boolean hasMaximizedComponents = false;
        this.mPreferredTotal = 0.0f;
        this.mMaxTotal = 0.0f;
        this.mPreoccupiedSpace = 0.0f;
        for (ComponentInfo info2 : this.mComponentInfoSet) {
            float minSize = 0.0f;
            float maxSize = 0.0f;
            float preferredSize = 0.0f;
            float targetSize = 0.0f;
            float currentSize = 0.0f;
            switch (this.mOrientation) {
                case HORIZONTAL: {
                    minSize = info2.component.getMinimumSize().width;
                    maxSize = info2.component.getMaximumSize().width;
                    preferredSize = info2.component.getPreferredSize().width;
                    currentSize = info2.component.getSize().width;
                    break;
                }
                case VERTICAL: {
                    minSize = info2.component.getMinimumSize().height;
                    maxSize = info2.component.getMaximumSize().height;
                    preferredSize = info2.component.getPreferredSize().height;
                    currentSize = info2.component.getSize().height;
                }
            }
            switch (info2.state) {
                case MINIMIZE: {
                    targetSize = minSize;
                    break;
                }
                case MAXIMIZE: {
                    targetSize = maxSize;
                    hasMaximizedComponents = true;
                    break;
                }
                case PREFERRED: {
                    targetSize = preferredSize;
                }
            }
            if (info2.currentSize != targetSize) {
                info2.currentSize = Updater.lerp(info2.currentSize, targetSize, this.mLerpFraction, elapsedNs, this.mLerpThreshold);
            }
            if (currentSize != minSize) {
                currentSize = Updater.lerp(currentSize, minSize, this.mLerpFraction, elapsedNs, this.mLerpThreshold);
            }
            switch (info2.state) {
                case MINIMIZE: {
                    this.mPreoccupiedSpace += currentSize;
                    break;
                }
                case MAXIMIZE: {
                    this.mMaxTotal += info2.currentSize;
                    break;
                }
                case PREFERRED: {
                    this.mPreferredTotal += info2.currentSize;
                    if (!hasMaximizedComponents) break;
                    this.mPreoccupiedSpace += currentSize;
                }
            }
        }
        this.mParent.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension calculateSizes(Container parent, AccordionState state) {
        Dimension dim = new Dimension();
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension childSize = new Dimension();
            block12: for (Component child : parent.getComponents()) {
                switch (state) {
                    case MINIMIZE: {
                        childSize = child.getMinimumSize();
                        break;
                    }
                    case MAXIMIZE: {
                        childSize = child.getMaximumSize();
                        break;
                    }
                    case PREFERRED: {
                        childSize = child.getPreferredSize();
                    }
                }
                switch (this.mOrientation) {
                    case HORIZONTAL: {
                        dim.width += childSize.width;
                        dim.height = Math.max(dim.height, childSize.height);
                        continue block12;
                    }
                    case VERTICAL: {
                        dim.width = Math.max(dim.width, childSize.width);
                        dim.height += childSize.height;
                    }
                }
            }
        }
        Insets insets = parent.getInsets();
        int insetWidth = insets.left + insets.right;
        int insetHeight = insets.top + insets.bottom;
        dim.width += insetWidth;
        dim.height += insetHeight;
        return dim;
    }

    private float clampSize(Component c, float preferred) {
        return this.mOrientation == Orientation.VERTICAL ? Math.min((float)c.getMaximumSize().height, Math.max((float)c.getMinimumSize().height, preferred)) : Math.min((float)c.getMaximumSize().width, Math.max((float)c.getMinimumSize().width, preferred));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orientation";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/AccordionLayout";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setState";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setStateInternal";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "toggleMaximize";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "toggleMinimize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ComponentInfo
    implements Comparable<ComponentInfo> {
        Component component;
        float currentSize;
        AccordionState state;

        ComponentInfo(Component component, float size, AccordionState state) {
            this.component = component;
            this.currentSize = size;
            this.state = state;
        }

        @Override
        public int compareTo(ComponentInfo other) {
            int ret = this.state.compareTo(other.state);
            if (ret == 0) {
                ret = this.component.hashCode() - other.component.hashCode();
            }
            return ret;
        }
    }

    public static enum AccordionState {
        MAXIMIZE,
        MINIMIZE,
        PREFERRED;

    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

