/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.android.tools.adtui.common.AdtUiCursorType;
import com.android.tools.adtui.common.AdtUiCursorsProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.UIUtil;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/adtui/common/AdtUiCursorProviderImpl;", "Lcom/android/tools/adtui/common/AdtUiCursorsProvider;", "()V", "cursorMap", "", "Lcom/android/tools/adtui/common/AdtUiCursorType;", "Ljava/awt/Cursor;", "getCursor", "type", "makeCursor", "intellij.android.adt.ui"})
final class AdtUiCursorProviderImpl
implements AdtUiCursorsProvider {
    private final Map<AdtUiCursorType, Cursor> cursorMap = new LinkedHashMap();

    @Override
    @NotNull
    public Cursor getCursor(@NotNull AdtUiCursorType type) {
        Cursor cursor;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Map<AdtUiCursorType, Cursor> $this$getOrPut$iv = this.cursorMap;
        boolean $i$f$getOrPut = false;
        Cursor value$iv = $this$getOrPut$iv.get((Object)type);
        if (value$iv == null) {
            boolean bl = false;
            Cursor answer$iv = this.makeCursor(type);
            $this$getOrPut$iv.put(type, answer$iv);
            cursor = answer$iv;
        } else {
            cursor = value$iv;
        }
        return cursor;
    }

    private final Cursor makeCursor(AdtUiCursorType type) {
        if (GraphicsEnvironment.isHeadless()) {
            Logger.getInstance(AdtUiCursorProviderImpl.class).warn("Cannot create a custom cursor in headless environment, use default cursor instead");
            Cursor cursor = Cursor.getDefaultCursor();
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"Cursor.getDefaultCursor()");
            return cursor;
        }
        String name = ((Object)((Object)type)).getClass().getName() + "." + type.name();
        Icon icon = type.getIcon();
        Function1<BufferedImage, Point> hotSpotMapFunc = type.getHotSpotMapFun$intellij_android_adt_ui();
        float scaleFactor = UIUtil.isRetina() ? 0.5f : 1.0f;
        Icon icon2 = icon;
        if (icon2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.util.IconLoader.CachedImageIcon");
        }
        Icon icon3 = ((IconLoader.CachedImageIcon)icon2).scale(scaleFactor);
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"(icon as IconLoader.Cach\u2026eIcon).scale(scaleFactor)");
        Icon scaledIcon = icon3;
        BufferedImage bufferedImage = UIUtil.createImage((int)scaledIcon.getIconWidth(), (int)scaledIcon.getIconHeight(), (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"UIUtil.createImage(scale\u2026feredImage.TYPE_INT_ARGB)");
        BufferedImage image = bufferedImage;
        scaledIcon.paintIcon(new JPanel(), image.getGraphics(), 0, 0);
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, (Point)hotSpotMapFunc.invoke((Object)image), name);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"Toolkit.getDefaultToolki\u2026SpotMapFunc(image), name)");
        return cursor;
    }
}

