/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.wasm.CompilerKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmCompilerResult;
import org.jetbrains.kotlin.backend.wasm.WasmLoweringPhasesKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleFragmentGenerator;
import org.jetbrains.kotlin.backend.wasm.lower.MarkAdditionalExportedDeclarationsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.IrModuleInfo;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrLinker;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolTableKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.wasm.ir.WasmModule;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToBinary;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToText;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000f\u00a8\u0006\u0010"}, d2={"compileWasm", "Lorg/jetbrains/kotlin/backend/wasm/WasmCompilerResult;", "depsDescriptors", "Lorg/jetbrains/kotlin/ir/backend/js/ModulesStructure;", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/name/FqName;", "emitNameSection", "", "generateJs", "", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;", "backend.wasm"})
public final class CompilerKt {
    @NotNull
    public static final WasmCompilerResult compileWasm(@NotNull ModulesStructure depsDescriptors, @NotNull PhaseConfig phaseConfig, @NotNull IrFactory irFactory, @NotNull Set<FqName> exportedDeclarations, boolean emitNameSection) {
        Iterator $this$flatMapTo$iv$iv;
        Object element$iv2;
        List list2;
        Intrinsics.checkNotNullParameter((Object)depsDescriptors, (String)"depsDescriptors");
        Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        Intrinsics.checkNotNullParameter(exportedDeclarations, (String)"exportedDeclarations");
        MainModule mainModule = depsDescriptors.getMainModule();
        CompilerConfiguration configuration = depsDescriptors.getCompilerConfiguration();
        IrModuleInfo irModuleInfo = KlibKt.loadIr$default((ModulesStructure)depsDescriptors, (IrFactory)irFactory, (boolean)false, null, (boolean)true, (int)8, null);
        IrModuleFragment moduleFragment = irModuleInfo.component1();
        List dependencyModules = irModuleInfo.component2();
        IrBuiltIns irBuiltIns = irModuleInfo.component3();
        SymbolTable symbolTable = irModuleInfo.component4();
        JsIrLinker deserializer = irModuleInfo.component5();
        MainModule mainModule2 = mainModule;
        if (mainModule2 instanceof MainModule.SourceFiles) {
            list2 = CollectionsKt.plus((Collection)dependencyModules, (Iterable)CollectionsKt.listOf((Object)moduleFragment));
        } else if (mainModule2 instanceof MainModule.Klib) {
            list2 = dependencyModules;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List allModules2 = list2;
        ModuleDescriptor moduleDescriptor = moduleFragment.getDescriptor();
        WasmBackendContext context2 = new WasmBackendContext(moduleDescriptor, irBuiltIns, symbolTable, moduleFragment, configuration);
        Iterable $this$forEach$iv = allModules2;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv2;
            boolean bl = false;
            new ExternalDependenciesGenerator(symbolTable, CollectionsKt.listOf((Object)deserializer)).generateUnboundSymbolsAsDependencies();
        }
        Iterable $this$flatMap$iv = allModules2;
        boolean $i$f$flatMap = false;
        element$iv2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            IrModuleFragment it = (IrModuleFragment)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List irFiles2 = (List)destination$iv$iv;
        moduleFragment.getFiles().clear();
        CollectionsKt.addAll((Collection)moduleFragment.getFiles(), (Iterable)irFiles2);
        new ExternalDependenciesGenerator(symbolTable, CollectionsKt.listOf((Object)deserializer)).generateUnboundSymbolsAsDependencies();
        PatchDeclarationParentsKt.patchDeclarationParents$default((IrElement)((IrElement)moduleFragment), null, (int)1, null);
        deserializer.postProcess();
        SymbolTableKt.noUnboundLeft((SymbolTable)symbolTable, (String)"Unbound symbols at the end of linker");
        Iterable $this$forEach$iv2 = moduleFragment.getFiles();
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            IrFile irFile = (IrFile)element$iv3;
            boolean bl = false;
            MarkAdditionalExportedDeclarationsKt.markExportedDeclarations(context2, irFile, exportedDeclarations);
        }
        CompilerPhaseKt.invokeToplevel((CompilerPhase)((CompilerPhase)WasmLoweringPhasesKt.getWasmPhases()), (PhaseConfig)phaseConfig, (CommonBackendContext)context2, (Object)moduleFragment);
        WasmCompiledModuleFragment compiledWasmModule = new WasmCompiledModuleFragment(context2.getIrBuiltIns());
        WasmModuleFragmentGenerator codeGenerator = new WasmModuleFragmentGenerator(context2, compiledWasmModule);
        codeGenerator.generateModule(moduleFragment);
        WasmModule linkedModule = compiledWasmModule.linkWasmCompiledFragments();
        WasmIrToText watGenerator = new WasmIrToText();
        watGenerator.appendWasmModule(linkedModule);
        String wat = watGenerator.toString();
        String js = CompilerKt.generateJs(compiledWasmModule);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStream outputStream2 = os;
        String string2 = moduleDescriptor.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"moduleDescriptor.name.asString()");
        new WasmIrToBinary(outputStream2, linkedModule, string2, emitNameSection).appendWasmModule();
        byte[] byteArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byteArray, (String)"byteArray");
        return new WasmCompilerResult(wat, js, byteArray);
    }

    public static /* synthetic */ WasmCompilerResult compileWasm$default(ModulesStructure modulesStructure, PhaseConfig phaseConfig, IrFactory irFactory, Set set, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return CompilerKt.compileWasm(modulesStructure, phaseConfig, irFactory, set, bl);
    }

    @NotNull
    public static final String generateJs(@NotNull WasmCompiledModuleFragment $this$generateJs) {
        Intrinsics.checkNotNullParameter((Object)$this$generateJs, (String)"<this>");
        String runtime = "var wasmInstance = null;\n\nconst externrefBoxes = new WeakMap();\n\nconst runtime = {\n    identity(x) {\n        return x;\n    },\n\n    println(valueAddr) {\n        console.log(\">>>  \" + importStringFromWasm(valueAddr));\n    }\n};\n\nfunction importStringFromWasm(addr) {\n    const mem16 = new Uint16Array(wasmInstance.exports.memory.buffer);\n    const mem32 = new Int32Array(wasmInstance.exports.memory.buffer);\n    const len = mem32[addr / 4];\n    const str_start_addr = (addr + 4) / 2;\n    const slice = mem16.slice(str_start_addr, str_start_addr + len);\n    return String.fromCharCode.apply(null, slice);\n}";
        String jsCode2 = "\nconst js_code = {" + CollectionsKt.joinToString$default((Iterable)$this$generateJs.getJsFuns(), (CharSequence)",\n", null, null, (int)0, null, (Function1)generateJs.jsCode.1.INSTANCE, (int)30, null) + "};";
        return runtime + jsCode2;
    }
}

