/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.promo;

import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/space/promo/SvgLoader;", "", "()V", "LOG", "Llibraries/klogging/KLogger;", "loadSvg", "Lcom/intellij/util/ui/JBImageIcon;", "path", "", "comp", "Ljavax/swing/JComponent;", "intellij.space"})
final class SvgLoader {
    private static final KLogger LOG;
    @NotNull
    public static final SvgLoader INSTANCE;

    @Nullable
    public final JBImageIcon loadSvg(@NotNull String path2, @NotNull JComponent comp) {
        JBImageIcon jBImageIcon;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(path2);
            byte[] bytes = (byte[])(inputStream != null ? inputStream.readAllBytes() : null);
            ScaleContext scaleContext = ScaleContext.create((Component)comp);
            Intrinsics.checkNotNullExpressionValue((Object)scaleContext, (String)"ScaleContext.create(comp)");
            ScaleContext ctx = scaleContext;
            BufferedImage bufferedImage = SVGLoader.loadWithoutCache((byte[])bytes, (float)((float)ctx.getScale(ScaleType.SYS_SCALE)));
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"SVGLoader.loadWithoutCac\u2026ype.SYS_SCALE).toFloat())");
            BufferedImage image = bufferedImage;
            Image hiDpi = ImageUtil.ensureHiDPI((Image)image, (ScaleContext)ctx);
            jBImageIcon = new JBImageIcon(hiDpi);
        }
        catch (Exception e) {
            KLogger this_$iv = LOG;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string2 = "Svg " + path2 + " is not loaded";
                kLogger.error(string2);
            }
            jBImageIcon = null;
        }
        return jBImageIcon;
    }

    private SvgLoader() {
    }

    static {
        SvgLoader svgLoader;
        INSTANCE = svgLoader = new SvgLoader();
        boolean $i$f$logger = false;
        LOG = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(SVGLoader.class));
    }
}

