/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.automation.script.compile;

import circlet.automation.bootstrap.AutomationDslEvaluationBootstrap;
import circlet.pipelines.config.idea.api.IdeaScriptConfig;
import circlet.pipelines.config.idea.dsl.eval.AutomationDslEvaluatorForIdea;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.space.vcs.automation.script.compile.SpaceKtsModelBuilderKt;
import com.intellij.util.io.PathKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import libraries.klogging.BaseLogger;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/space/vcs/automation/script/compile/ScriptKtsPersistentState;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCacheFile", "Ljava/nio/file/Path;", "load", "Lcirclet/pipelines/config/idea/api/IdeaScriptConfig;", "save", "", "config", "Companion", "intellij.space.vcs"})
public final class ScriptKtsPersistentState {
    @NotNull
    private final Project project;
    private static final KLogger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IdeaScriptConfig load() {
        Object object;
        Path path2 = this.getCacheFile(this.project);
        try {
            object = Files.readAttributes(path2, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (FileSystemException ignored) {
            return null;
        }
        BasicFileAttributes fileAttributes = object;
        if (fileAttributes == null || !fileAttributes.isRegularFile()) {
            return null;
        }
        try {
            IdeaScriptConfig ideaScriptConfig;
            object = Files.newBufferedReader(path2, Charsets.UTF_8);
            Throwable ignored = null;
            try {
                BufferedReader reader = (BufferedReader)object;
                boolean bl = false;
                AutomationDslEvaluatorForIdea evalService = new AutomationDslEvaluationBootstrap(LOG, SpaceKtsModelBuilderKt.getAutomationArtifactsLocationWithFallback()).loadEvaluatorForIdea();
                if (evalService == null) {
                    LOG.error("DSL evaluation service not found, cannot deserialize automation DSL model");
                    IdeaScriptConfig ideaScriptConfig2 = null;
                    return ideaScriptConfig2;
                }
                String string2 = reader.readLine();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"reader.readLine()");
                ideaScriptConfig = evalService.deserializeJsonConfig(string2);
            }
            catch (Throwable throwable) {
                ignored = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)ignored);
            }
            object = ideaScriptConfig;
        }
        catch (NoSuchFileException e) {
            object = null;
        }
        catch (IOException e) {
            BaseLogger.DefaultImpls.error$default(LOG, e, null, 2, null);
            object = null;
        }
        return object;
    }

    private final Path getCacheFile(Project project2) {
        Path path2 = ProjectUtil.getProjectCachePath$default((Project)project2, (String)"space_automation", (boolean)false, null, (int)6, null).resolve(".space.kts.dat");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"project.getProjectCacheP\u2026resolve(\".space.kts.dat\")");
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull IdeaScriptConfig config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Path path2 = this.getCacheFile(this.project);
        Closeable closeable = PathKt.safeOutputStream((Path)path2);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            String string2 = IdeaScriptConfig.DefaultImpls.printJson$default(config2, false, 1, null);
            Charset charset = Charsets.UTF_8;
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            it.write(byArray);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ScriptKtsPersistentState(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        LOG = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(ScriptKtsPersistentState.class));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/space/vcs/automation/script/compile/ScriptKtsPersistentState$Companion;", "", "()V", "LOG", "Llibraries/klogging/KLogger;", "intellij.space.vcs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

