/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.review.list;

import circlet.client.api.TD_MemberProfile;
import circlet.client.api.TeamDirectoryKt;
import circlet.code.api.CodeReviewListItem;
import circlet.code.api.CodeReviewParticipant;
import circlet.code.api.CodeReviewParticipantRole;
import circlet.code.api.CodeReviewRecord;
import circlet.platform.api.Ref;
import circlet.platform.client.RefResolveKt;
import com.intellij.collaboration.ui.codereview.OpenReviewButton;
import com.intellij.collaboration.ui.codereview.OpenReviewButtonViewModel;
import com.intellij.icons.AllIcons;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.ui.SpaceAvatarUtils;
import com.intellij.space.utils.DateUtilitiesKt;
import com.intellij.space.vcs.review.list.SpaceReviewListCellRendererKt;
import com.intellij.space.vcs.review.participants.ParticipantStatusBadgeKind;
import com.intellij.space.vcs.review.participants.ParticipantStatusBadgeParams;
import com.intellij.space.vcs.review.participants.SpaceReviewParticipantColorsKt;
import com.intellij.space.vcs.review.participants.SpaceReviewParticipantStatusKt;
import com.intellij.space.vcs.ui.icons.SpaceAvatarProvider;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J8\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020 2\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/space/vcs/review/list/SpaceReviewListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcirclet/code/api/CodeReviewListItem;", "Ljavax/swing/JPanel;", "openButtonViewModel", "Lcom/intellij/collaboration/ui/codereview/OpenReviewButtonViewModel;", "(Lcom/intellij/collaboration/ui/codereview/OpenReviewButtonViewModel;)V", "authorAvatar", "Lcom/intellij/ui/SimpleColoredComponent;", "commentIcon", "Ljavax/swing/Icon;", "getCommentIcon", "()Ljavax/swing/Icon;", "commentsLabel", "emptyAvatar", "Lcom/intellij/util/ui/EmptyIcon;", "Lorg/jetbrains/annotations/NotNull;", "firstReviewLabel", "infoLabel", "openCodeReviewButton", "secondReviewLabel", "titleLabel", "configureMemberLabel", "", "label", "profile", "Lcirclet/client/api/TD_MemberProfile;", "status", "Lcom/intellij/space/vcs/review/participants/ParticipantStatusBadgeParams;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.space.vcs"})
public final class SpaceReviewListCellRenderer
extends JPanel
implements ListCellRenderer<CodeReviewListItem> {
    private final SimpleColoredComponent titleLabel;
    private final SimpleColoredComponent infoLabel;
    private final EmptyIcon emptyAvatar;
    private final SimpleColoredComponent authorAvatar;
    private final SimpleColoredComponent commentsLabel;
    private final SimpleColoredComponent firstReviewLabel;
    private final SimpleColoredComponent secondReviewLabel;
    private final JPanel openCodeReviewButton;
    private final OpenReviewButtonViewModel openButtonViewModel;

    private final Icon getCommentIcon() {
        Icon icon2 = AllIcons.Ide.Notification.NoEvents;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Ide.Notification.NoEvents");
        return icon2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends CodeReviewListItem> list2, @NotNull CodeReviewListItem value2, int index, boolean isSelected2, boolean cellHasFocus) {
        Object object;
        CodeReviewParticipant codeReviewParticipant;
        CodeReviewParticipant it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Object it2;
        Iterable iterable;
        CharSequence it32;
        Object object2;
        TD_MemberProfile author;
        String title2;
        CodeReviewRecord review;
        List authors2;
        List reviewers2;
        Color secondaryTextColor;
        Color primaryTextColor;
        block20: {
            String createdAt2;
            String key2;
            block19: {
                List list3;
                Object element$iv$iv3;
                List list4;
                Iterable<Object> destination$iv$iv;
                List<CodeReviewParticipant> participants2;
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                this.setBackground(ListUiUtil.WithTallRow.INSTANCE.background(list2, isSelected2, list2.hasFocus()));
                primaryTextColor = ListUiUtil.WithTallRow.INSTANCE.foreground(isSelected2, list2.hasFocus());
                secondaryTextColor = ListUiUtil.WithTallRow.INSTANCE.secondaryForeground(list2, isSelected2);
                List<CodeReviewParticipant> list5 = participants2 = RefResolveKt.resolve(value2.getParticipants()).getParticipants();
                if (list5 != null) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = list5;
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        CodeReviewParticipant it4 = (CodeReviewParticipant)element$iv$iv2;
                        boolean bl = false;
                        if (!(it4.getRole() == CodeReviewParticipantRole.Reviewer)) continue;
                        destination$iv$iv.add(element$iv$iv2);
                    }
                    list4 = (List)destination$iv$iv;
                } else {
                    list4 = null;
                }
                reviewers2 = list4;
                List<CodeReviewParticipant> list6 = participants2;
                if (list6 != null) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = list6;
                    boolean $i$f$filter = false;
                    destination$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                        CodeReviewParticipant it5 = (CodeReviewParticipant)element$iv$iv3;
                        boolean bl = false;
                        if (!(it5.getRole() == CodeReviewParticipantRole.Author)) continue;
                        destination$iv$iv2.add(element$iv$iv3);
                    }
                    list3 = (List)destination$iv$iv2;
                } else {
                    list3 = null;
                }
                authors2 = list3;
                review = RefResolveKt.resolve(value2.getReview());
                title2 = review.getTitle();
                Ref<TD_MemberProfile> ref2 = review.getCreatedBy();
                author = ref2 != null ? RefResolveKt.resolve(ref2) : null;
                String string2 = review.getKey();
                if (string2 == null) {
                    string2 = "";
                }
                key2 = string2;
                createdAt2 = DateUtilitiesKt.formatPrettyDateTime(review.getCreatedAt());
                object2 = author;
                if (object2 == null) break block19;
                Object it32 = element$iv$iv3 = object2;
                boolean bl = false;
                object2 = SpaceBundle.message("review.by.author.at.time", key2, TeamDirectoryKt.englishFullName(it32), createdAt2);
                if (object2 != null) break block20;
            }
            object2 = SpaceBundle.message("review.at.time", key2, createdAt2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"author?.let { SpaceBundl\u2026at.time\", key, createdAt)");
        Object info2 = object2;
        StringBuilder $this$apply = it32 = new StringBuilder();
        boolean bl = false;
        $this$apply.append(title2).append("<br/>");
        $this$apply.append((String)info2).append("<br/>");
        List list7 = authors2;
        if (list7 != null) {
            iterable = list7;
            it2 = iterable;
            boolean bl2 = false;
            $this$apply.append("<br/>");
            $this$apply.append(SpaceBundle.message("review.details.authors.label", it2.size())).append("<br/>");
            $this$forEach$iv = authors2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (CodeReviewParticipant)element$iv;
                boolean bl3 = false;
                $this$apply.append(TeamDirectoryKt.englishFullName(RefResolveKt.resolve(it.getUser()))).append("<br/>");
            }
        }
        List list8 = reviewers2;
        if (list8 != null) {
            iterable = list8;
            it2 = iterable;
            boolean bl4 = false;
            $this$apply.append("<br/>");
            $this$apply.append(SpaceBundle.message("review.details.reviewers.label", it2.size())).append("<br/>");
            $this$forEach$iv = reviewers2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (CodeReviewParticipant)element$iv;
                boolean bl5 = false;
                $this$apply.append(TeamDirectoryKt.englishFullName(RefResolveKt.resolve(it.getUser()))).append("<br/>");
            }
        }
        CharSequence it6 = it32 = it32.toString();
        boolean bl6 = false;
        String string3 = XmlStringUtil.wrapInHtml((CharSequence)it6);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply {\n\u2026ringUtil.wrapInHtml(it) }");
        String fullToolTipText = string3;
        $this$apply = it32 = this.titleLabel;
        boolean bl7 = false;
        $this$apply.clear();
        $this$apply.append(title2);
        $this$apply.setForeground(primaryTextColor);
        $this$apply.setToolTipText(fullToolTipText);
        $this$apply = it32 = this.infoLabel;
        boolean bl8 = false;
        $this$apply.clear();
        $this$apply.append((String)info2);
        $this$apply.setForeground(secondaryTextColor);
        $this$apply.setToolTipText(fullToolTipText);
        var $fun$getParticipantStatus$3 = new Function1<CodeReviewParticipant, ParticipantStatusBadgeParams>(review, reviewers2){
            final /* synthetic */ CodeReviewRecord $review;
            final /* synthetic */ List $reviewers;

            @Nullable
            public final ParticipantStatusBadgeParams invoke(@Nullable CodeReviewParticipant participant) {
                ParticipantStatusBadgeParams participantStatusBadgeParams;
                CodeReviewParticipant codeReviewParticipant = participant;
                if (codeReviewParticipant != null) {
                    CodeReviewParticipant codeReviewParticipant2;
                    CodeReviewParticipant it = codeReviewParticipant2 = codeReviewParticipant;
                    boolean bl = false;
                    List list2 = this.$reviewers;
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    participantStatusBadgeParams = SpaceReviewParticipantStatusKt.getParticipantStatusBadgeParams(this.$review, it, list2);
                } else {
                    participantStatusBadgeParams = null;
                }
                return participantStatusBadgeParams;
            }
            {
                this.$review = codeReviewRecord;
                this.$reviewers = list2;
                super(1);
            }
        };
        List list9 = authors2;
        if (list9 != null) {
            Object v11;
            block18: {
                Iterable iterable3 = list9;
                iterable = iterable3;
                for (Object bl4 : iterable) {
                    CodeReviewParticipant it7 = (CodeReviewParticipant)bl4;
                    boolean bl9 = false;
                    if (!Intrinsics.areEqual((Object)RefResolveKt.resolve(it7.getUser()), (Object)author)) continue;
                    v11 = bl4;
                    break block18;
                }
                v11 = null;
            }
            codeReviewParticipant = v11;
        } else {
            codeReviewParticipant = null;
        }
        CodeReviewParticipant authorParticipant = codeReviewParticipant;
        this.configureMemberLabel(this.authorAvatar, author, $fun$getParticipantStatus$3.invoke(authorParticipant));
        SimpleColoredComponent $this$apply2 = object = this.commentsLabel;
        boolean bl10 = false;
        $this$apply2.clear();
        $this$apply2.setIcon(this.getCommentIcon());
        $this$apply2.append(String.valueOf(RefResolveKt.resolve(value2.getDiscussionCount()).getCounter().getTotal()));
        $this$apply2 = object = this.firstReviewLabel;
        boolean bl11 = false;
        List list10 = reviewers2;
        CodeReviewParticipant firstReviewer = list10 != null ? (CodeReviewParticipant)CollectionsKt.firstOrNull((List)list10) : null;
        Object object3 = firstReviewer;
        this.configureMemberLabel(this.firstReviewLabel, object3 != null && (object3 = ((CodeReviewParticipant)object3).getUser()) != null ? (TD_MemberProfile)RefResolveKt.resolve(object3) : null, $fun$getParticipantStatus$3.invoke(firstReviewer));
        $this$apply2 = object = this.secondReviewLabel;
        boolean bl12 = false;
        List list11 = reviewers2;
        CodeReviewParticipant secondReviewer = list11 != null ? (CodeReviewParticipant)SpaceReviewListCellRendererKt.access$secondOrNull(list11) : null;
        Object object4 = secondReviewer;
        this.configureMemberLabel(this.secondReviewLabel, object4 != null && (object4 = ((CodeReviewParticipant)object4).getUser()) != null ? (TD_MemberProfile)RefResolveKt.resolve(object4) : null, $fun$getParticipantStatus$3.invoke(secondReviewer));
        $this$apply2 = object = this.openCodeReviewButton;
        boolean bl13 = false;
        $this$apply2.setVisible(index == this.openButtonViewModel.getHoveredRowIndex());
        $this$apply2.setOpaque(this.openButtonViewModel.isButtonHovered());
        return this;
    }

    private final void configureMemberLabel(SimpleColoredComponent label2, TD_MemberProfile profile2, ParticipantStatusBadgeParams status2) {
        if (profile2 != null) {
            Icon icon2 = SpaceAvatarProvider.Companion.getInstance().getIcon(profile2, 18);
            Object object = status2;
            Color outlineColor = object != null && (object = object.getKind()) != null ? SpaceReviewParticipantColorsKt.getBorderColor((ParticipantStatusBadgeKind)((Object)object)) : null;
            label2.setIcon(SpaceAvatarUtils.INSTANCE.outlineCircleIcon(icon2, outlineColor));
            label2.setToolTipText(TeamDirectoryKt.englishFullName(profile2));
        } else {
            label2.setIcon((Icon)this.emptyAvatar);
            label2.setToolTipText("");
        }
    }

    public SpaceReviewListCellRenderer(@NotNull OpenReviewButtonViewModel openButtonViewModel) {
        SimpleColoredComponent $this$apply;
        SimpleColoredComponent simpleColoredComponent;
        Intrinsics.checkNotNullParameter((Object)openButtonViewModel, (String)"openButtonViewModel");
        super(null);
        this.openButtonViewModel = openButtonViewModel;
        SimpleColoredComponent simpleColoredComponent2 = simpleColoredComponent = new SimpleColoredComponent();
        SpaceReviewListCellRenderer spaceReviewListCellRenderer = this;
        boolean bl = false;
        $this$apply.setOpaque(false);
        Unit unit = Unit.INSTANCE;
        spaceReviewListCellRenderer.titleLabel = simpleColoredComponent;
        $this$apply = simpleColoredComponent = new SimpleColoredComponent();
        spaceReviewListCellRenderer = this;
        boolean bl2 = false;
        $this$apply.setFont((Font)JBUI.Fonts.smallFont());
        $this$apply.setOpaque(false);
        unit = Unit.INSTANCE;
        spaceReviewListCellRenderer.infoLabel = simpleColoredComponent;
        EmptyIcon emptyIcon = EmptyIcon.create((int)(JBUI.scale((int)18) + 2 * SpaceAvatarUtils.INSTANCE.getOUTLINE_WIDTH()));
        Intrinsics.checkNotNullExpressionValue((Object)emptyIcon, (String)"EmptyIcon.create(JBUI.sc\u2026IZE) + 2 * OUTLINE_WIDTH)");
        this.emptyAvatar = emptyIcon;
        $this$apply = simpleColoredComponent = new SimpleColoredComponent();
        spaceReviewListCellRenderer = this;
        boolean bl3 = false;
        $this$apply.setIcon((Icon)this.emptyAvatar);
        unit = Unit.INSTANCE;
        spaceReviewListCellRenderer.authorAvatar = simpleColoredComponent;
        $this$apply = simpleColoredComponent = new SimpleColoredComponent();
        spaceReviewListCellRenderer = this;
        boolean bl4 = false;
        $this$apply.setIcon(this.getCommentIcon());
        unit = Unit.INSTANCE;
        spaceReviewListCellRenderer.commentsLabel = simpleColoredComponent;
        $this$apply = simpleColoredComponent = new SimpleColoredComponent();
        spaceReviewListCellRenderer = this;
        boolean bl5 = false;
        $this$apply.setIcon((Icon)this.emptyAvatar);
        unit = Unit.INSTANCE;
        spaceReviewListCellRenderer.firstReviewLabel = simpleColoredComponent;
        $this$apply = simpleColoredComponent = new SimpleColoredComponent();
        spaceReviewListCellRenderer = this;
        boolean bl6 = false;
        $this$apply.setIcon((Icon)this.emptyAvatar);
        unit = Unit.INSTANCE;
        spaceReviewListCellRenderer.secondReviewLabel = simpleColoredComponent;
        this.openCodeReviewButton = OpenReviewButton.createOpenReviewButton$default((OpenReviewButton)OpenReviewButton.INSTANCE, null, (int)1, null);
        String zero2 = "0";
        String gap = JBUI.scale((int)8) + "px";
        String gapTop = JBUI.scale((int)5) + "px";
        this.setLayout((LayoutManager)new MigLayout(new LC().gridGap(zero2, zero2).insets(zero2, zero2, zero2, zero2).fillX()));
        Component component2 = (Component)this.authorAvatar;
        CC cC = new CC().gapAfter(zero2).gapBefore(gap).gapBottom(gap).gapTop(gap);
        Intrinsics.checkNotNullExpressionValue((Object)cC, (String)"CC()\n      .gapAfter(zer\u2026m(gap)\n      .gapTop(gap)");
        this.add(component2, SpaceReviewListCellRendererKt.access$center(cC).spanY(2).shrinkPrioX(100));
        this.add((Component)this.titleLabel, new CC().gapTop(gapTop).growX().pushX().minWidth("0px").spanX(2).shrinkPrioX(15).gapAfter(gap));
        Component component3 = (Component)this.commentsLabel;
        CC cC2 = new CC().spanY(2);
        Intrinsics.checkNotNullExpressionValue((Object)cC2, (String)"CC()\n      .spanY(2)");
        this.add(component3, SpaceReviewListCellRendererKt.access$center(cC2).gapAfter(gap).shrinkPrioX(100));
        Component component4 = (Component)this.firstReviewLabel;
        CC cC3 = new CC().spanY(2);
        Intrinsics.checkNotNullExpressionValue((Object)cC3, (String)"CC()\n      .spanY(2)");
        this.add(component4, SpaceReviewListCellRendererKt.access$center(cC3).gapAfter(gap).shrinkPrioX(10));
        Component component5 = (Component)this.secondReviewLabel;
        CC cC4 = new CC().spanY(2);
        Intrinsics.checkNotNullExpressionValue((Object)cC4, (String)"CC()\n      .spanY(2)");
        this.add(component5, SpaceReviewListCellRendererKt.access$center(cC4).gapAfter(gap).shrinkPrioX(9));
        Component component6 = this.openCodeReviewButton;
        CC cC5 = new CC().spanY(2);
        Intrinsics.checkNotNullExpressionValue((Object)cC5, (String)"CC()\n      .spanY(2)");
        this.add(component6, SpaceReviewListCellRendererKt.access$center(cC5).shrinkPrioX(1000).growY().minWidth("pref").wrap());
        this.add((Component)this.infoLabel, new CC().gapBottom(gapTop).skip(1).gapAfter(gap).growX().pushX().minWidth("0px"));
        Component[] componentArray = this.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"this.components");
        Component[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        for (Component element$iv : $this$forEach$iv) {
            Component it = element$iv;
            boolean bl7 = false;
            UIUtil.setNotOpaqueRecursively((Component)it);
        }
    }
}

