/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.ivy.util.Message;

public class PropertiesFile
extends Properties {
    private File file;
    private String header;

    public PropertiesFile(File file2, String header) {
        this.file = file2;
        this.header = header;
        if (file2.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file2);
                this.load(fis);
            }
            catch (Exception ex) {
                Message.warn("exception occurred while reading properties file " + file2, ex);
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void save() {
        FileOutputStream fos = null;
        try {
            if (this.file.getParentFile() != null && !this.file.getParentFile().exists()) {
                this.file.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(this.file);
            this.store(fos, this.header);
        }
        catch (Exception ex) {
            Message.warn("exception occurred while writing properties file " + this.file, ex);
        }
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

