/*
 * Decompiled with CFR 0.152.
 */
package runtime.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.LayoutBase;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import klogging.MDCUtilsKt;
import klogging.PlatformMDCKey;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import libraries.klogging.MDCKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.ScalarsKt;
import runtime.json.JsonBuilderContext;
import runtime.json.JsonDslKt;
import runtime.logging.JsonLogEventsLayoutKt;
import runtime.logging.SuppressedConnectionErrors;
import runtime.logging.SuppressedError;
import runtime.system.JStack;
import runtime.utils.HostKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0019J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0002H\u0014J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0002H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u0002H\u0002J\u0010\u0010&\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u0002H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u0002H\u0002J\u001c\u0010(\u001a\u00020\u001c2\n\u0010)\u001a\u00060*j\u0002`+2\u0006\u0010,\u001a\u00020-H\u0002JK\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u00052\n\u0010)\u001a\u00060*j\u0002`+2\u0006\u0010,\u001a\u00020-2\f\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u001c04H\u0002\u00a2\u0006\u0002\u00105J,\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000507*\u00020!2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000507H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0016\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lruntime/logging/JsonLogEventsLayout;", "Lch/qos/logback/core/LayoutBase;", "Lch/qos/logback/classic/spi/ILoggingEvent;", "()V", "app", "", "getApp", "()Ljava/lang/String;", "setApp", "(Ljava/lang/String;)V", "hostName", "getHostName", "setHostName", "mdcKeysAsFields", "", "Llibraries/klogging/MDCKey;", "getMdcKeysAsFields", "()Ljava/util/List;", "region", "getRegion", "suppressedConnectionErrors", "Lruntime/logging/SuppressedConnectionErrors;", "suppressedErrors", "Ljava/util/HashMap;", "", "Lruntime/logging/SuppressedError;", "Lkotlin/collections/HashMap;", "addSuppressedConnectionErrors", "", "addSuppressedError", "suppressedError", "customJsonFields", "jsonBuilderContext", "Lruntime/json/JsonBuilderContext;", "event", "doLayout", "isOOM", "", "isSuppressed", "maybeThreadDump", "print", "s", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "th", "Lch/qos/logback/classic/spi/IThrowableProxy;", "printEnclosedStackTrace", "caption", "enclosingTrace", "", "Lch/qos/logback/classic/spi/StackTraceElementProxy;", "used", "Ljava/util/IdentityHashMap;", "(Ljava/lang/String;Ljava/lang/StringBuilder;Lch/qos/logback/classic/spi/IThrowableProxy;[Lch/qos/logback/classic/spi/StackTraceElementProxy;Ljava/util/IdentityHashMap;)V", "preProcessMDCMap", "", "initialMDCMap", "platform-runtime"})
public class JsonLogEventsLayout
extends LayoutBase<ILoggingEvent> {
    @Nullable
    private final String region = HostKt.getApplication_region();
    @Nullable
    private String hostName;
    @Nullable
    private String app;
    @NotNull
    private final SuppressedConnectionErrors suppressedConnectionErrors = new SuppressedConnectionErrors();
    @NotNull
    private final HashMap<String, List<SuppressedError>> suppressedErrors = new HashMap();
    @NotNull
    private final List<MDCKey> mdcKeysAsFields = PlatformMDCKey.Companion.getFull();

    @Nullable
    public final String getRegion() {
        return this.region;
    }

    @Nullable
    public final String getHostName() {
        return this.hostName;
    }

    public final void setHostName(@Nullable String string2) {
        this.hostName = string2;
    }

    @Nullable
    public final String getApp() {
        return this.app;
    }

    public final void setApp(@Nullable String string2) {
        this.app = string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String doLayout(@NotNull ILoggingEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        try {
            void $this$doLayout_u24lambda_u2d0;
            boolean $i$f$jsonObjectText = false;
            ObjectMapper objectMapper = JsonDslKt.getJackson();
            Object baseObj$iv$iv = null;
            boolean $i$f$objectNode = false;
            JsonNodeFactory factory$iv$iv = new JsonNodeFactory(false);
            ObjectNode rootNode$iv$iv = factory$iv$iv.objectNode();
            Intrinsics.checkNotNullExpressionValue((Object)rootNode$iv$iv, (String)"rootNode");
            JsonBuilderContext jsonBuilderContext = new JsonBuilderContext(rootNode$iv$iv, factory$iv$iv, JsonDslKt.getJackson());
            ObjectMapper objectMapper2 = objectMapper;
            boolean bl = false;
            $this$doLayout_u24lambda_u2d0.put("@version", 1);
            $this$doLayout_u24lambda_u2d0.put("@timestamp", JsonLogEventsLayoutKt.dateFormat(event2.getTimeStamp()));
            this.customJsonFields((JsonBuilderContext)$this$doLayout_u24lambda_u2d0, event2);
            String string2 = objectMapper2.writeValueAsString((Object)rootNode$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jackson.writeValueAsStri\u2026objectNode(null, worker))");
            String logstashEvent = string2;
            return Intrinsics.stringPlus((String)logstashEvent, (Object)"\n");
        }
        catch (Throwable e) {
            StringWriter stackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)stackTrace, true));
            return "FAILED TO LAYOUT A LOG EVENT\nEvent: " + event2 + "\nError: " + e + '\n' + stackTrace;
        }
    }

    public final void addSuppressedConnectionErrors(@NotNull SuppressedConnectionErrors suppressedConnectionErrors) {
        Intrinsics.checkNotNullParameter((Object)suppressedConnectionErrors, (String)"suppressedConnectionErrors");
        this.suppressedConnectionErrors.plusAssign(suppressedConnectionErrors);
    }

    public final void addSuppressedError(@NotNull SuppressedError suppressedError) {
        block1: {
            Boolean bl;
            Intrinsics.checkNotNullParameter((Object)suppressedError, (String)"suppressedError");
            String string2 = suppressedError.getLoggerName();
            if (string2 == null) break block1;
            String it = string2;
            boolean bl2 = false;
            List<SuppressedError> list2 = this.suppressedErrors.get(it);
            Boolean bl3 = bl = list2 == null ? null : Boolean.valueOf(list2.add(suppressedError));
            if (bl == null) {
                JsonLogEventsLayout $this$addSuppressedError_u24lambda_u2d2_u24lambda_u2d1 = this;
                boolean bl4 = false;
                Map map2 = $this$addSuppressedError_u24lambda_u2d2_u24lambda_u2d1.suppressedErrors;
                Object object = new SuppressedError[]{suppressedError};
                object = CollectionsKt.mutableListOf((Object[])object);
                map2.put(it, object);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void customJsonFields(@NotNull JsonBuilderContext jsonBuilderContext, @NotNull ILoggingEvent event2) {
        JsonBuilderContext jsonBuilderContext2;
        Intrinsics.checkNotNullParameter((Object)jsonBuilderContext, (String)"jsonBuilderContext");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Level level = null;
        level = event2.getLevel();
        if (Intrinsics.areEqual((Object)level, (Object)Level.ERROR) && this.isSuppressed(event2)) {
            level = Level.WARN;
        }
        String threadDump = this.maybeThreadDump(event2);
        JsonBuilderContext $this$customJsonFields_u24lambda_u2d10 = jsonBuilderContext2 = jsonBuilderContext;
        boolean bl = false;
        String string2 = this.getHostName();
        if (string2 == null) {
            string2 = JsonLogEventsLayoutKt.access$getComputedHostName();
        }
        $this$customJsonFields_u24lambda_u2d10.put("source_host", string2);
        String string3 = this.getRegion();
        if (string3 != null) {
            String it = string3;
            boolean bl2 = false;
            $this$customJsonFields_u24lambda_u2d10.put("region", it);
        }
        JsonLogEventsLayoutKt.putLogAppVersion($this$customJsonFields_u24lambda_u2d10);
        $this$customJsonFields_u24lambda_u2d10.put("message", event2.getFormattedMessage());
        String string4 = this.getApp();
        if (string4 == null) {
            string4 = "platform";
        }
        $this$customJsonFields_u24lambda_u2d10.put("app", string4);
        IThrowableProxy iThrowableProxy = event2.getThrowableProxy();
        if (iThrowableProxy != null) {
            StringBuilder stringBuilder;
            String it;
            void this_$iv;
            IThrowableProxy proxy = iThrowableProxy;
            boolean bl3 = false;
            JsonBuilderContext jsonBuilderContext3 = $this$customJsonFields_u24lambda_u2d10;
            String $this$put$iv = "exception";
            boolean $i$f$put = false;
            ObjectNode objNode$iv = this_$iv.get__factory().objectNode();
            Intrinsics.checkNotNullExpressionValue((Object)objNode$iv, (String)"objNode");
            JsonBuilderContext $this$customJsonFields_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d8 = new JsonBuilderContext(objNode$iv, this_$iv.get__factory(), this_$iv.get__mapper());
            boolean bl4 = false;
            String string5 = proxy.getClassName();
            if (string5 != null) {
                it = string5;
                boolean bl5 = false;
                $this$customJsonFields_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d8.put("exception_class", it);
            }
            String string6 = proxy.getMessage();
            if (string6 != null) {
                it = string6;
                boolean bl6 = false;
                $this$customJsonFields_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d8.put("exception_message", it);
            }
            StringBuilder $this$customJsonFields_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d8_u24lambda_u2d6 = stringBuilder = new StringBuilder();
            boolean bl7 = false;
            this.print($this$customJsonFields_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d8_u24lambda_u2d6, proxy);
            String string7 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"StringBuilder().apply(builderAction).toString()");
            String it2 = string7;
            boolean bl8 = false;
            $this$customJsonFields_u24lambda_u2d10_u24lambda_u2d9_u24lambda_u2d8.put("stacktrace", it2);
            this_$iv.get__node().set($this$put$iv, (JsonNode)objNode$iv);
        }
        $this$customJsonFields_u24lambda_u2d10.put("logger_name", event2.getLoggerName());
        Map map2 = event2.getMDCPropertyMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"event.mdcPropertyMap");
        $this$customJsonFields_u24lambda_u2d10.put("mdc", this.preProcessMDCMap($this$customJsonFields_u24lambda_u2d10, map2));
        $this$customJsonFields_u24lambda_u2d10.put("level", level.toString());
        $this$customJsonFields_u24lambda_u2d10.put("thread_name", event2.getThreadName());
        if (threadDump != null) {
            $this$customJsonFields_u24lambda_u2d10.put("thread_dump", threadDump);
        }
    }

    private final boolean isSuppressed(ILoggingEvent event2) {
        Boolean bl;
        List<SuppressedError> list2 = this.suppressedErrors.get(event2.getLoggerName());
        if (list2 == null) {
            bl = null;
        } else {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SuppressedError it = (SuppressedError)element$iv;
                        boolean bl3 = false;
                        if (!it.match(event2)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        return ScalarsKt.orFalse(bl) || this.suppressedConnectionErrors.match(event2) || this.isOOM(event2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String maybeThreadDump(ILoggingEvent event2) {
        String string2;
        if (this.isOOM(event2)) {
            String string3 = event2.getFormattedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"event.formattedMessage");
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"unable to create native thread", (boolean)false, (int)2, null)) {
                try {
                    string3 = JStack.dumpThreads$default(JStack.INSTANCE, null, 1, null);
                }
                catch (Throwable t) {
                    string3 = null;
                }
                string2 = string3;
                return string2;
            }
        }
        string2 = null;
        return string2;
    }

    private final boolean isOOM(ILoggingEvent event2) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = JsonLogEventsLayoutKt.access$getAllCauses(event2.getThrowableProxy());
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                IThrowableProxy it = (IThrowableProxy)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getClassName(), (Object)"java.lang.OutOfMemoryError")) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> preProcessMDCMap(JsonBuilderContext $this$preProcessMDCMap, Map<String, String> initialMDCMap) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$forEach$iv = this.getMdcKeysAsFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MDCKey it = (MDCKey)element$iv;
            boolean bl = false;
            MDCUtilsKt.extractFieldFromMap($this$preProcessMDCMap, initialMDCMap, it);
        }
        $this$forEach$iv = this.getMdcKeysAsFields();
        Map<String, String> map2 = initialMDCMap;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MDCKey mDCKey = (MDCKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return MapsKt.minus(map2, (Iterable)((List)destination$iv$iv));
    }

    @NotNull
    protected List<MDCKey> getMdcKeysAsFields() {
        return this.mdcKeysAsFields;
    }

    private final void print(StringBuilder s, IThrowableProxy th) {
        IdentityHashMap<IThrowableProxy, Unit> used = new IdentityHashMap<IThrowableProxy, Unit>();
        boolean $i$f$emptyArray = false;
        this.printEnclosedStackTrace("", s, th, new StackTraceElementProxy[0], used);
    }

    /*
     * WARNING - void declaration
     */
    private final void printEnclosedStackTrace(String caption, StringBuilder s, IThrowableProxy th, StackTraceElementProxy[] enclosingTrace, IdentityHashMap<IThrowableProxy, Unit> used) {
        if (((Map)used).containsKey(th)) {
            StringBuilder stringBuilder = s;
            String string2 = Intrinsics.stringPlus((String)"\tCIRCULAR: ", (Object)th.getClassName());
            StringBuilder stringBuilder2 = stringBuilder.append(string2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
        } else {
            CharSequence charSequence;
            String string3;
            StackTraceElementProxy[] stackTraceElementProxyArray;
            Map map2 = used;
            StackTraceElementProxy[] stackTraceElementProxyArray2 = Unit.INSTANCE;
            map2.put(th, stackTraceElementProxyArray2);
            stackTraceElementProxyArray2 = th.getStackTraceElementProxyArray();
            if (stackTraceElementProxyArray2 == null) {
                boolean $i$f$emptyArray = false;
                stackTraceElementProxyArray = new StackTraceElementProxy[]{};
            } else {
                stackTraceElementProxyArray = stackTraceElementProxyArray2;
            }
            StackTraceElementProxy[] trace2 = stackTraceElementProxyArray;
            int m2 = trace2.length - 1;
            int n = enclosingTrace.length - 1;
            while (m2 >= 0 && n >= 0 && Intrinsics.areEqual((Object)trace2[m2], (Object)enclosingTrace[n])) {
                int n2 = m2;
                m2 = n2 + -1;
                n2 = n;
                n = n2 + -1;
            }
            int framesInCommon = trace2.length - 1 - m2;
            StringBuilder stringBuilder = s;
            StringBuilder stringBuilder3 = new StringBuilder().append(caption).append((Object)th.getClassName());
            String string4 = th.getMessage();
            if (string4 == null) {
                string3 = "";
            } else {
                void it;
                charSequence = string4;
                StringBuilder stringBuilder4 = stringBuilder3;
                boolean bl = false;
                String string5 = Intrinsics.stringPlus((String)" ", (Object)it);
                stringBuilder3 = stringBuilder4;
                string3 = string5;
                if (string5 == null) {
                    string3 = "";
                }
            }
            Object object = stringBuilder3.append(string3).toString();
            StringBuilder stringBuilder5 = stringBuilder.append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
            int n3 = 0;
            if (n3 <= m2) {
                int i;
                do {
                    i = n3++;
                    stringBuilder5 = s;
                    String string6 = Intrinsics.stringPlus((String)"\t", (Object)trace2[i].getSTEAsString());
                    charSequence = stringBuilder5.append(string6);
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)charSequence);
                } while (i != m2);
            }
            if (framesInCommon != 0) {
                StringBuilder stringBuilder6 = s;
                object = "\t... " + framesInCommon + " more";
                stringBuilder5 = stringBuilder6.append((String)object);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder5);
            }
            object = th.getSuppressed();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"th.suppressed");
            for (IThrowableProxy se : object) {
                Intrinsics.checkNotNullExpressionValue((Object)se, (String)"se");
                this.printEnclosedStackTrace("Suppressed: ", s, se, trace2, used);
            }
            IThrowableProxy cause = th.getCause();
            if (cause != null) {
                this.printEnclosedStackTrace("Caused by: ", s, cause, trace2, used);
            }
        }
    }
}

