/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpecialNames {
    @NotNull
    public static final SpecialNames INSTANCE = new SpecialNames();
    @JvmField
    @NotNull
    public static final Name NO_NAME_PROVIDED;
    @JvmField
    @NotNull
    public static final Name ROOT_PACKAGE;
    @JvmField
    @NotNull
    public static final Name DEFAULT_NAME_FOR_COMPANION_OBJECT;
    @JvmField
    @NotNull
    public static final Name SAFE_IDENTIFIER_FOR_NO_NAME;
    @JvmField
    @NotNull
    public static final Name ANONYMOUS;
    @JvmField
    @NotNull
    public static final Name UNARY;
    @JvmField
    @NotNull
    public static final Name THIS;
    @JvmField
    @NotNull
    public static final Name INIT;
    @JvmField
    @NotNull
    public static final Name ITERATOR;
    @JvmField
    @NotNull
    public static final Name DESTRUCT;
    @JvmField
    @NotNull
    public static final Name LOCAL;
    @JvmField
    @NotNull
    public static final Name UNDERSCORE_FOR_UNUSED_VAR;
    @JvmField
    @NotNull
    public static final Name IMPLICIT_SET_PARAMETER;

    private SpecialNames() {
    }

    @JvmStatic
    @NotNull
    public static final Name safeIdentifier(@Nullable Name name) {
        return name != null && !name.isSpecial() ? name : SAFE_IDENTIFIER_FOR_NO_NAME;
    }

    public final boolean isSafeIdentifier(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string2 = name.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.asString()");
        return ((CharSequence)string2).length() > 0 && !name.isSpecial();
    }

    static {
        Name name = Name.special("<no name provided>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<no name provided>\")");
        NO_NAME_PROVIDED = name;
        Name name2 = Name.special("<root package>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<root package>\")");
        ROOT_PACKAGE = name2;
        Name name3 = Name.identifier("Companion");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(\"Companion\")");
        DEFAULT_NAME_FOR_COMPANION_OBJECT = name3;
        Name name4 = Name.identifier("no_name_in_PSI_3d19d79d_1ba9_4cd0_b7f5_b46aa3cd5d40");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(\"no_name_in_P\u2026_4cd0_b7f5_b46aa3cd5d40\")");
        SAFE_IDENTIFIER_FOR_NO_NAME = name4;
        Name name5 = Name.special("<anonymous>");
        Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"special(ANONYMOUS_STRING)");
        ANONYMOUS = name5;
        Name name6 = Name.special("<unary>");
        Intrinsics.checkNotNullExpressionValue((Object)name6, (String)"special(\"<unary>\")");
        UNARY = name6;
        Name name7 = Name.special("<this>");
        Intrinsics.checkNotNullExpressionValue((Object)name7, (String)"special(\"<this>\")");
        THIS = name7;
        Name name8 = Name.special("<init>");
        Intrinsics.checkNotNullExpressionValue((Object)name8, (String)"special(\"<init>\")");
        INIT = name8;
        Name name9 = Name.special("<iterator>");
        Intrinsics.checkNotNullExpressionValue((Object)name9, (String)"special(\"<iterator>\")");
        ITERATOR = name9;
        Name name10 = Name.special("<destruct>");
        Intrinsics.checkNotNullExpressionValue((Object)name10, (String)"special(\"<destruct>\")");
        DESTRUCT = name10;
        Name name11 = Name.special("<local>");
        Intrinsics.checkNotNullExpressionValue((Object)name11, (String)"special(\"<local>\")");
        LOCAL = name11;
        Name name12 = Name.special("<unused var>");
        Intrinsics.checkNotNullExpressionValue((Object)name12, (String)"special(\"<unused var>\")");
        UNDERSCORE_FOR_UNUSED_VAR = name12;
        Name name13 = Name.special("<set-?>");
        Intrinsics.checkNotNullExpressionValue((Object)name13, (String)"special(\"<set-?>\")");
        IMPLICIT_SET_PARAMETER = name13;
    }
}

