/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionRequirementTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionSpecificBehaviorKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.MemberDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerSource;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeserializationContext {
    @NotNull
    private final DeserializationComponents components;
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final DeclarationDescriptor containingDeclaration;
    @NotNull
    private final TypeTable typeTable;
    @NotNull
    private final VersionRequirementTable versionRequirementTable;
    @NotNull
    private final BinaryVersion metadataVersion;
    @Nullable
    private final DeserializedContainerSource containerSource;
    @NotNull
    private final TypeDeserializer typeDeserializer;
    @NotNull
    private final MemberDeserializer memberDeserializer;

    public DeserializationContext(@NotNull DeserializationComponents components2, @NotNull NameResolver nameResolver2, @NotNull DeclarationDescriptor containingDeclaration, @NotNull TypeTable typeTable, @NotNull VersionRequirementTable versionRequirementTable, @NotNull BinaryVersion metadataVersion, @Nullable DeserializedContainerSource containerSource, @Nullable TypeDeserializer parentTypeDeserializer, @NotNull List<ProtoBuf.TypeParameter> typeParameters2) {
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)containingDeclaration, (String)"containingDeclaration");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        Intrinsics.checkNotNullParameter((Object)versionRequirementTable, (String)"versionRequirementTable");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        Intrinsics.checkNotNullParameter(typeParameters2, (String)"typeParameters");
        this.components = components2;
        this.nameResolver = nameResolver2;
        this.containingDeclaration = containingDeclaration;
        this.typeTable = typeTable;
        this.versionRequirementTable = versionRequirementTable;
        this.metadataVersion = metadataVersion;
        this.containerSource = containerSource;
        String string2 = "Deserializer for \"" + this.containingDeclaration.getName() + '\"';
        Object object = this.containerSource;
        if (object == null || (object = object.getPresentableString()) == null) {
            object = "[container not found]";
        }
        this.typeDeserializer = new TypeDeserializer(this, parentTypeDeserializer, typeParameters2, string2, (String)object);
        this.memberDeserializer = new MemberDeserializer(this);
    }

    @NotNull
    public final DeserializationComponents getComponents() {
        return this.components;
    }

    @NotNull
    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @NotNull
    public final DeclarationDescriptor getContainingDeclaration() {
        return this.containingDeclaration;
    }

    @NotNull
    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    @NotNull
    public final VersionRequirementTable getVersionRequirementTable() {
        return this.versionRequirementTable;
    }

    @Nullable
    public final DeserializedContainerSource getContainerSource() {
        return this.containerSource;
    }

    @NotNull
    public final TypeDeserializer getTypeDeserializer() {
        return this.typeDeserializer;
    }

    @NotNull
    public final MemberDeserializer getMemberDeserializer() {
        return this.memberDeserializer;
    }

    @NotNull
    public final StorageManager getStorageManager() {
        return this.components.getStorageManager();
    }

    @NotNull
    public final DeserializationContext childContext(@NotNull DeclarationDescriptor descriptor2, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable, @NotNull VersionRequirementTable versionRequirementTable, @NotNull BinaryVersion metadataVersion) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(typeParameterProtos, (String)"typeParameterProtos");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        Intrinsics.checkNotNullParameter((Object)versionRequirementTable, (String)"versionRequirementTable");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        return new DeserializationContext(this.components, nameResolver2, descriptor2, typeTable, VersionSpecificBehaviorKt.isVersionRequirementTableWrittenCorrectly(metadataVersion) ? versionRequirementTable : this.versionRequirementTable, metadataVersion, this.containerSource, this.typeDeserializer, typeParameterProtos);
    }

    public static /* synthetic */ DeserializationContext childContext$default(DeserializationContext deserializationContext, DeclarationDescriptor declarationDescriptor, List list, NameResolver nameResolver2, TypeTable typeTable, VersionRequirementTable versionRequirementTable, BinaryVersion binaryVersion, int n, Object object) {
        if ((n & 4) != 0) {
            nameResolver2 = deserializationContext.nameResolver;
        }
        if ((n & 8) != 0) {
            typeTable = deserializationContext.typeTable;
        }
        if ((n & 0x10) != 0) {
            versionRequirementTable = deserializationContext.versionRequirementTable;
        }
        if ((n & 0x20) != 0) {
            binaryVersion = deserializationContext.metadataVersion;
        }
        return deserializationContext.childContext(declarationDescriptor, list, nameResolver2, typeTable, versionRequirementTable, binaryVersion);
    }
}

