/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageOrApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.MavenComparableVersion;
import org.jetbrains.kotlin.utils.DescriptionAware;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u0003:\u0001\u0019B\u0017\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0015\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/config/ApiVersion;", "", "Lorg/jetbrains/kotlin/utils/DescriptionAware;", "Lorg/jetbrains/kotlin/config/LanguageOrApiVersion;", "version", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "versionString", "", "(Lorg/jetbrains/kotlin/config/MavenComparableVersion;Ljava/lang/String;)V", "isDeprecated", "", "()Z", "isStable", "isUnsupported", "getVersion", "()Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "getVersionString", "()Ljava/lang/String;", "compareTo", "", "other", "equals", "", "hashCode", "toString", "Companion", "util"})
public final class ApiVersion
implements Comparable<ApiVersion>,
DescriptionAware,
LanguageOrApiVersion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MavenComparableVersion version;
    @NotNull
    private final String versionString;
    @JvmField
    @NotNull
    public static final ApiVersion KOTLIN_1_0 = Companion.createByLanguageVersion(LanguageVersion.KOTLIN_1_0);
    @JvmField
    @NotNull
    public static final ApiVersion KOTLIN_1_1 = Companion.createByLanguageVersion(LanguageVersion.KOTLIN_1_1);
    @JvmField
    @NotNull
    public static final ApiVersion KOTLIN_1_2 = Companion.createByLanguageVersion(LanguageVersion.KOTLIN_1_2);
    @JvmField
    @NotNull
    public static final ApiVersion KOTLIN_1_3 = Companion.createByLanguageVersion(LanguageVersion.KOTLIN_1_3);
    @JvmField
    @NotNull
    public static final ApiVersion KOTLIN_1_4 = Companion.createByLanguageVersion(LanguageVersion.KOTLIN_1_4);
    @JvmField
    @NotNull
    public static final ApiVersion KOTLIN_1_5 = Companion.createByLanguageVersion(LanguageVersion.KOTLIN_1_5);
    @JvmField
    @NotNull
    public static final ApiVersion KOTLIN_1_6 = Companion.createByLanguageVersion(LanguageVersion.KOTLIN_1_6);
    @JvmField
    @NotNull
    public static final ApiVersion KOTLIN_1_7 = Companion.createByLanguageVersion(LanguageVersion.KOTLIN_1_7);
    @JvmField
    @NotNull
    public static final ApiVersion KOTLIN_1_8 = Companion.createByLanguageVersion(LanguageVersion.KOTLIN_1_8);
    @JvmField
    @NotNull
    public static final ApiVersion LATEST = Companion.createByLanguageVersion((LanguageVersion)ArraysKt.last((Object[])LanguageVersion.values()));
    @JvmField
    @NotNull
    public static final ApiVersion LATEST_STABLE = Companion.createByLanguageVersion(LanguageVersion.LATEST_STABLE);
    @JvmField
    @NotNull
    public static final ApiVersion FIRST_SUPPORTED = Companion.createByLanguageVersion(LanguageVersion.FIRST_API_SUPPORTED);
    @JvmField
    @NotNull
    public static final ApiVersion FIRST_NON_DEPRECATED = Companion.createByLanguageVersion(LanguageVersion.FIRST_NON_DEPRECATED);

    private ApiVersion(MavenComparableVersion version, String versionString2) {
        this.version = version;
        this.versionString = versionString2;
    }

    @NotNull
    public final MavenComparableVersion getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public String getVersionString() {
        return this.versionString;
    }

    @Override
    public boolean isStable() {
        return this.compareTo(LATEST_STABLE) <= 0;
    }

    @Override
    public boolean isDeprecated() {
        return FIRST_SUPPORTED.compareTo(this) <= 0 && this.compareTo(FIRST_NON_DEPRECATED) < 0;
    }

    @Override
    public boolean isUnsupported() {
        return this.compareTo(FIRST_SUPPORTED) < 0;
    }

    @Override
    public int compareTo(@NotNull ApiVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.version.compareTo(other.version);
    }

    public boolean equals(@Nullable Object other) {
        ApiVersion apiVersion2 = other instanceof ApiVersion ? (ApiVersion)other : null;
        return Intrinsics.areEqual((Object)(apiVersion2 != null ? apiVersion2.version : null), (Object)this.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    @NotNull
    public String toString() {
        return this.getVersionString();
    }

    @Override
    @NotNull
    public String getDescription() {
        return LanguageOrApiVersion.DefaultImpls.getDescription(this);
    }

    @JvmStatic
    @NotNull
    public static final ApiVersion createByLanguageVersion(@NotNull LanguageVersion version) {
        return Companion.createByLanguageVersion(version);
    }

    public /* synthetic */ ApiVersion(MavenComparableVersion version, String versionString2, DefaultConstructorMarker $constructor_marker) {
        this(version, versionString2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/config/ApiVersion$Companion;", "", "()V", "FIRST_NON_DEPRECATED", "Lorg/jetbrains/kotlin/config/ApiVersion;", "FIRST_SUPPORTED", "KOTLIN_1_0", "KOTLIN_1_1", "KOTLIN_1_2", "KOTLIN_1_3", "KOTLIN_1_4", "KOTLIN_1_5", "KOTLIN_1_6", "KOTLIN_1_7", "KOTLIN_1_8", "LATEST", "LATEST_STABLE", "createByLanguageVersion", "version", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "parse", "versionString", "", "util"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ApiVersion createByLanguageVersion(@NotNull LanguageVersion version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            ApiVersion apiVersion2 = this.parse(version.getVersionString());
            Intrinsics.checkNotNull((Object)apiVersion2);
            return apiVersion2;
        }

        @Nullable
        public final ApiVersion parse(@NotNull String versionString2) {
            ApiVersion apiVersion2;
            Intrinsics.checkNotNullParameter((Object)versionString2, (String)"versionString");
            try {
                apiVersion2 = new ApiVersion(new MavenComparableVersion(versionString2), versionString2, null);
            }
            catch (Exception e) {
                apiVersion2 = null;
            }
            return apiVersion2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

