/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils.kapt;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.ReflectionUtilKt;
import org.jetbrains.kotlin.utils.kapt.ClassLoaderData;
import org.jetbrains.kotlin.utils.kapt.MemoryLeak;
import org.jetbrains.kotlin.utils.kapt.MemoryLeakDetectorKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/utils/kapt/MemoryLeakDetector;", "", "()V", "classLoaderData", "", "Lorg/jetbrains/kotlin/utils/kapt/ClassLoaderData;", "add", "", "classLoader", "Ljava/lang/ClassLoader;", "inspectStatics", "", "Lorg/jetbrains/kotlin/utils/kapt/MemoryLeak;", "process", "isParanoid", "", "util"})
public final class MemoryLeakDetector {
    @NotNull
    public static final MemoryLeakDetector INSTANCE = new MemoryLeakDetector();
    @NotNull
    private static final List<ClassLoaderData> classLoaderData = new ArrayList();

    private MemoryLeakDetector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        List<ClassLoaderData> list = classLoaderData;
        synchronized (list) {
            boolean bl = false;
            boolean bl2 = classLoaderData.add(new ClassLoaderData(classLoader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<MemoryLeak> process(boolean isParanoid) {
        Set memoryLeaks = new LinkedHashSet();
        List<ClassLoaderData> list = classLoaderData;
        synchronized (list) {
            boolean bl = false;
            List newClassLoaderData = new ArrayList();
            for (ClassLoaderData data2 : classLoaderData) {
                ClassLoader classLoader;
                if ((ClassLoader)data2.getRef().get() == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"data.ref.get() ?: continue");
                data2.setAge(data2.getAge() + 1);
                if (isParanoid || data2.getAge() >= 5) {
                    INSTANCE.inspectStatics(classLoader);
                    continue;
                }
                ((Collection)newClassLoaderData).add(data2);
            }
            classLoaderData.clear();
            boolean bl2 = classLoaderData.addAll(newClassLoaderData);
        }
        return memoryLeaks;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<MemoryLeak> inspectStatics(ClassLoader classLoader) {
        Set $this$mapTo$iv;
        Vector loadedClasses = MemoryLeakDetectorKt.access$loadedClasses(classLoader);
        try {
            void destination$iv;
            Iterable iterable = loadedClasses;
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                Class clazz = (Class)item$iv;
                void var18_9 = destination$iv;
                boolean bl = false;
                var18_9.add(it);
            }
            $this$mapTo$iv = (Set)destination$iv;
        }
        catch (ConcurrentModificationException e) {
            Thread.sleep(100L);
            return this.inspectStatics(classLoader);
        }
        Set loadedClassesSet = $this$mapTo$iv;
        Set leaks = new LinkedHashSet();
        for (Class clazz : loadedClassesSet) {
            Field[] fieldArray;
            try {
                fieldArray = clazz.getDeclaredFields();
            }
            catch (Throwable e) {
                continue;
            }
            Field[] declaredFields = fieldArray;
            Intrinsics.checkNotNullExpressionValue((Object)declaredFields, (String)"declaredFields");
            for (Field field : declaredFields) {
                Object object;
                Object object2;
                if (!Modifier.isStatic(field.getModifiers())) continue;
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
                Object object3 = ReflectionUtilKt.getSafe(field, null);
                if (object3 == null) continue;
                Object it = object2 = object3;
                boolean bl = false;
                Object object4 = object = !MemoryLeakDetectorKt.access$isPrimitiveOrString(it) ? object2 : null;
                if (object == null) continue;
                Object value2 = object;
                if (MemoryLeakDetectorKt.access$isJavacComponent(value2)) {
                    object3 = leaks;
                    String string2 = clazz.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"clazz.name");
                    String string3 = field.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"field.name");
                    object3.add(new MemoryLeak(string2, string3, "Field leaks an Annotation Processing component (" + value2 + ")."));
                    continue;
                }
                if (!(value2 instanceof Class) || !loadedClassesSet.contains(value2)) continue;
                object3 = leaks;
                String string4 = clazz.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"clazz.name");
                String string5 = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"field.name");
                object3.add(new MemoryLeak(string4, string5, "Field leaks a class type from the same ClassLoader (" + ((Class)value2).getName() + ")."));
            }
        }
        return leaks;
    }
}

