/*
 * Decompiled with CFR 0.152.
 */
package org.toml.ide.json;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaDocumentationProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.toml.ide.experiments.TomlExperiments;
import org.toml.ide.json.TomlJsonSchemaCompletionContributor;
import org.toml.ide.json.TomlJsonSchemaCompletionContributor$Worker$WhenMappings;
import org.toml.lang.psi.TomlLiteral;
import org.toml.lang.psi.TomlTableHeader;
import org.toml.lang.psi.ext.TomlLiteralKind;
import org.toml.lang.psi.ext.TomlLiteralKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/toml/ide/json/TomlJsonSchemaCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "Companion", "Worker", "intellij.toml.json"})
public final class TomlJsonSchemaCompletionContributor
extends CompletionContributor {
    private static final List<JsonSchemaType> JSON_COMPOUND_TYPES;
    @NotNull
    public static final Companion Companion;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (!TomlExperiments.INSTANCE.isJsonSchemaEnabled()) {
            return;
        }
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameters.position");
        PsiElement position = psiElement;
        JsonSchemaService jsonSchemaService = JsonSchemaService.Impl.get((Project)position.getProject());
        JsonSchemaObject jsonSchemaObject = jsonSchemaService.getSchemaObject(parameters.getOriginalFile());
        if (jsonSchemaObject != null) {
            PsiElement psiElement2 = parameters.getOriginalPosition();
            if (psiElement2 == null) {
                psiElement2 = parameters.getPosition();
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parameters.originalPosition ?: parameters.position");
            PsiElement completionPosition = psiElement2;
            PsiElement psiElement3 = parameters.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"parameters.position");
            Worker worker = new Worker(jsonSchemaObject, psiElement3, completionPosition, (Consumer<LookupElement>)((Consumer)result));
            worker.work();
        }
    }

    static {
        Companion = new Companion(null);
        JSON_COMPOUND_TYPES = CollectionsKt.listOf((Object[])new JsonSchemaType[]{JsonSchemaType._array, JsonSchemaType._object, JsonSchemaType._any, null});
    }

    public static final /* synthetic */ List access$getJSON_COMPOUND_TYPES$cp() {
        return JSON_COMPOUND_TYPES;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0002\u0010\nJJ\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00030\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00112\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001aH\u0002J\u0017\u0010&\u001a\u00070'\u00a2\u0006\u0002\b(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0018\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\fH\u0002J\u0018\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0/2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0006\u00100\u001a\u00020\u0017R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/toml/ide/json/TomlJsonSchemaCompletionContributor$Worker;", "", "rootSchema", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "position", "Lcom/intellij/psi/PsiElement;", "originalPosition", "resultConsumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "(Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/util/Consumer;)V", "isInsideStringLiteral", "", "()Z", "project", "Lcom/intellij/openapi/project/Project;", "variants", "", "getVariants", "()Ljava/util/Set;", "walker", "Lcom/jetbrains/jsonSchema/extension/JsonLikePsiWalker;", "addAllPropertyVariants", "", "properties", "", "", "adapter", "Lcom/jetbrains/jsonSchema/extension/adapters/JsonPropertyAdapter;", "schemaProperties", "", "knownNames", "addPropertyVariant", "key", "jsonSchemaObject", "buildPairLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "element", "getIconForType", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "type", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaType;", "suggestValues", "schema", "isSurelyValue", "suggestValuesByType", "", "work", "intellij.toml.json"})
    private static final class Worker {
        @NotNull
        private final Set<LookupElement> variants;
        private final JsonLikePsiWalker walker;
        private final Project project;
        private final JsonSchemaObject rootSchema;
        private final PsiElement position;
        private final PsiElement originalPosition;
        private final Consumer<LookupElement> resultConsumer;

        @NotNull
        public final Set<LookupElement> getVariants() {
            return this.variants;
        }

        public final void work() {
            JsonLikePsiWalker jsonLikePsiWalker = this.walker;
            if (jsonLikePsiWalker == null || (jsonLikePsiWalker = jsonLikePsiWalker.findElementToCheck(this.position)) == null) {
                return;
            }
            JsonLikePsiWalker checkable = jsonLikePsiWalker;
            ThreeState isName = this.walker.isName((PsiElement)checkable);
            JsonPointerPosition pointerPosition = this.walker.findPosition((PsiElement)checkable, isName == ThreeState.NO);
            if (pointerPosition == null || pointerPosition.isEmpty() && isName == ThreeState.NO) {
                return;
            }
            Collection collection = new JsonSchemaResolver(this.project, this.rootSchema, pointerPosition).resolve();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"JsonSchemaResolver(proje\u2026ointerPosition).resolve()");
            Collection schemas = collection;
            HashSet knownNames = new HashSet();
            for (JsonSchemaObject schema : schemas) {
                if (isName != ThreeState.NO) {
                    Map schemaProperties;
                    Set properties = this.walker.getPropertyNamesOfParentObject(this.originalPosition, this.position);
                    JsonPropertyAdapter adapter = this.walker.getParentPropertyAdapter((PsiElement)checkable);
                    JsonSchemaObject jsonSchemaObject = schema;
                    Intrinsics.checkNotNullExpressionValue((Object)jsonSchemaObject, (String)"schema");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonSchemaObject.getProperties(), (String)"schema.properties");
                    Set set = properties;
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties");
                    this.addAllPropertyVariants(set, adapter, schemaProperties, knownNames, this.originalPosition);
                }
                if (isName == ThreeState.YES) continue;
                JsonSchemaObject jsonSchemaObject = schema;
                Intrinsics.checkNotNullExpressionValue((Object)jsonSchemaObject, (String)"schema");
                this.suggestValues(jsonSchemaObject, isName == ThreeState.NO);
            }
            for (LookupElement variant : this.variants) {
                this.resultConsumer.consume((Object)variant);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void addAllPropertyVariants(Collection<String> properties, JsonPropertyAdapter adapter, Map<String, JsonSchemaObject> schemaProperties, Set<String> knownNames, PsiElement originalPosition) {
            $this$filter$iv = schemaProperties.keySet();
            $i$f$filter = false;
            var9_9 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                name = (String)element$iv$iv;
                $i$a$-filter-TomlJsonSchemaCompletionContributor$Worker$addAllPropertyVariants$variants$1 = false;
                if (!properties.contains(name) && !knownNames.contains(name)) ** GOTO lbl-1000
                v0 = adapter;
                if (Intrinsics.areEqual((Object)name, (Object)(v0 != null ? v0.getName() : null))) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                if (!v1) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            variants = (List)destination$iv$iv;
            for (String variant : variants) {
                knownNames.add(variant);
                jsonSchemaObject = schemaProperties.get(variant);
                if (jsonSchemaObject == null) continue;
                $this$parentOfType$iv = originalPosition;
                withSelf$iv = false;
                $i$f$parentOfType = false;
                v2 = isTomlHeader = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, TomlTableHeader.class, (boolean)true) != null;
                if (isTomlHeader && !TomlJsonSchemaCompletionContributor.access$getJSON_COMPOUND_TYPES$cp().contains(jsonSchemaObject.guessType())) continue;
                this.addPropertyVariant(variant, jsonSchemaObject);
            }
        }

        private final void addPropertyVariant(String key, JsonSchemaObject jsonSchemaObject) {
            Collection collection = new JsonSchemaResolver(this.project, jsonSchemaObject).resolve();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"JsonSchemaResolver(proje\u2026onSchemaObject).resolve()");
            Collection currentVariants = collection;
            JsonSchemaObject jsonSchemaObject2 = (JsonSchemaObject)CollectionsKt.firstOrNull((Iterable)currentVariants);
            if (jsonSchemaObject2 == null) {
                jsonSchemaObject2 = jsonSchemaObject;
            }
            JsonSchemaObject jsonSchemaObject3 = jsonSchemaObject2;
            String description = JsonSchemaDocumentationProvider.getBestDocumentation((boolean)true, (JsonSchemaObject)jsonSchemaObject3);
            CharSequence charSequence = description;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                charSequence = jsonSchemaObject3.getTypeDescription(true);
                CharSequence charSequence2 = charSequence;
                description = charSequence2 == null ? "" : charSequence2;
            }
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)key).withTypeText(description).withIcon(this.getIconForType(jsonSchemaObject3.guessType()));
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"LookupElementBuilder.cre\u2026chemaObject.guessType()))");
            LookupElementBuilder lookupElement = lookupElementBuilder;
            this.variants.add((LookupElement)lookupElement);
        }

        private final boolean isInsideStringLiteral() {
            PsiElement psiElement = this.position.getParent();
            if (!(psiElement instanceof TomlLiteral)) {
                psiElement = null;
            }
            TomlLiteral tomlLiteral = (TomlLiteral)psiElement;
            return (tomlLiteral != null ? TomlLiteralKt.getKind(tomlLiteral) : null) instanceof TomlLiteralKind.String;
        }

        private final void suggestValues(JsonSchemaObject schema, boolean isSurelyValue) {
            List enumVariants = schema.getEnum();
            if (enumVariants != null) {
                for (Object o : enumVariants) {
                    String variant;
                    if (this.isInsideStringLiteral() && !(o instanceof String)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)(this.isInsideStringLiteral() ? StringUtil.unquoteString((String)o.toString()) : o.toString()), (String)"if (isInsideStringLitera\u2026g()\n                    }");
                    variant = variant;
                    LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)variant);
                    Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"LookupElementBuilder.create(variant)");
                    this.variants.add((LookupElement)lookupElementBuilder);
                }
            } else if (isSurelyValue) {
                this.variants.addAll((Collection<LookupElement>)this.suggestValuesByType(schema.guessType()));
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private final List<LookupElement> suggestValuesByType(JsonSchemaType type) {
            List list;
            JsonSchemaType jsonSchemaType = type;
            if (jsonSchemaType != null) {
                switch (TomlJsonSchemaCompletionContributor$Worker$WhenMappings.$EnumSwitchMapping$0[jsonSchemaType.ordinal()]) {
                    case 1: {
                        list = CollectionsKt.listOf((Object)this.buildPairLookupElement("{}"));
                        return list;
                    }
                    case 2: {
                        list = CollectionsKt.listOf((Object)this.buildPairLookupElement("[]"));
                        return list;
                    }
                    case 3: {
                        if (this.isInsideStringLiteral()) {
                            list = CollectionsKt.emptyList();
                            return list;
                        }
                        list = CollectionsKt.listOf((Object)this.buildPairLookupElement("\"\""));
                        return list;
                    }
                    case 4: {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = CollectionsKt.listOf((Object[])new String[]{"true", "false"});
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv.iterator();
                        while (true) {
                            void it;
                            if (!iterator.hasNext()) {
                                list = (List)destination$iv$iv;
                                return list;
                            }
                            Object item$iv$iv = iterator.next();
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)it);
                            collection.add(lookupElementBuilder);
                        }
                    }
                }
            }
            list = CollectionsKt.emptyList();
            return list;
        }

        private final LookupElementBuilder buildPairLookupElement(String element) {
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)element).withInsertHandler((InsertHandler)buildPairLookupElement.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"LookupElementBuilder.cre\u2026or, -1)\n                }");
            return lookupElementBuilder;
        }

        /*
         * Unable to fully structure code
         */
        private final Icon getIconForType(JsonSchemaType type) {
            v0 = type;
            if (v0 == null) ** GOTO lbl-1000
            switch (TomlJsonSchemaCompletionContributor$Worker$WhenMappings.$EnumSwitchMapping$1[v0.ordinal()]) {
                case 1: {
                    v1 = AllIcons.Json.Object;
                    break;
                }
                case 2: {
                    v1 = AllIcons.Json.Array;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v1 = AllIcons.Nodes.Property;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"when (type) {\n          \u2026.Nodes.Property\n        }");
            return v1;
        }

        public Worker(@NotNull JsonSchemaObject rootSchema, @NotNull PsiElement position, @NotNull PsiElement originalPosition, @NotNull Consumer<LookupElement> resultConsumer) {
            Intrinsics.checkNotNullParameter((Object)rootSchema, (String)"rootSchema");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)originalPosition, (String)"originalPosition");
            Intrinsics.checkNotNullParameter(resultConsumer, (String)"resultConsumer");
            this.rootSchema = rootSchema;
            this.position = position;
            this.originalPosition = originalPosition;
            this.resultConsumer = resultConsumer;
            this.variants = new LinkedHashSet();
            this.walker = JsonLikePsiWalker.getWalker((PsiElement)this.position, (JsonSchemaObject)this.rootSchema);
            Project project = this.originalPosition.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"originalPosition.project");
            this.project = project;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/toml/ide/json/TomlJsonSchemaCompletionContributor$Companion;", "", "()V", "JSON_COMPOUND_TYPES", "", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaType;", "intellij.toml.json"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

