/*
 * Decompiled with CFR 0.152.
 */
package org.toml.lang.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.toml.TomlBundle;
import org.toml.TomlIcons;
import org.toml.lang.TomlLanguage;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/toml/lang/psi/TomlFileType;", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "Lcom/intellij/openapi/fileTypes/ex/FileTypeIdentifiableByVirtualFile;", "()V", "getCharset", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "content", "", "getDefaultExtension", "getDescription", "getIcon", "Ljavax/swing/Icon;", "getName", "isMyFileType", "", "intellij.toml.core"})
public final class TomlFileType
extends LanguageFileType
implements FileTypeIdentifiableByVirtualFile {
    @NotNull
    public static final TomlFileType INSTANCE;

    @NotNull
    public String getName() {
        return "TOML";
    }

    @NotNull
    public String getDescription() {
        return TomlBundle.INSTANCE.message("filetype.toml.description", new Object[0]);
    }

    @NotNull
    public String getDefaultExtension() {
        return "toml";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TomlIcons.TomlFile;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"TomlIcons.TomlFile");
        return icon;
    }

    @NotNull
    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return "UTF-8";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMyFileType(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Intrinsics.areEqual((Object)file.getName(), (Object)"config")) return false;
        VirtualFile virtualFile = file.getParent();
        if (!Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getName() : null), (Object)".cargo")) return false;
        return true;
    }

    private TomlFileType() {
        super((Language)TomlLanguage.INSTANCE);
    }

    static {
        TomlFileType tomlFileType;
        INSTANCE = tomlFileType = new TomlFileType();
    }
}

