/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.LibraryModuleInfo;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.TrackableModuleInfo;
import org.jetbrains.kotlin.descriptors.ModuleCapability;
import org.jetbrains.kotlin.idea.KotlinIdeaAnalysisBundle;
import org.jetbrains.kotlin.idea.caches.project.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.LibraryDependenciesCache;
import org.jetbrains.kotlin.idea.caches.project.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.caches.project.LibraryWithoutSourceScope;
import org.jetbrains.kotlin.idea.caches.project.LibraryWrapper;
import org.jetbrains.kotlin.idea.caches.project.ModuleInfosFromIdeaModelKt;
import org.jetbrains.kotlin.idea.caches.project.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.project.ResolutionAnchorAwareLibraryModificationTracker;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.caches.project.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.project.AnalyzerServicesKt;
import org.jetbrains.kotlin.idea.project.KotlinLibraryToSourceAnalysisComponentKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u000101H\u0016J\u0013\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u000105H\u0096\u0002J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\u001507H\u0016J\b\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020\u0015H\u0016R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0012\u0010$\u001a\u00020%X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\r\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/idea/caches/project/LibraryInfo;", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/LibraryModuleInfo;", "Lorg/jetbrains/kotlin/idea/caches/project/BinaryModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/TrackableModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/libraries/Library;)V", "_sourcesModuleInfo", "Lorg/jetbrains/kotlin/idea/caches/project/SourceForBinaryModuleInfo;", "get_sourcesModuleInfo", "()Lorg/jetbrains/kotlin/idea/caches/project/SourceForBinaryModuleInfo;", "_sourcesModuleInfo$delegate", "Lkotlin/Lazy;", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "displayedName", "", "getDisplayedName", "()Ljava/lang/String;", "getLibrary", "()Lcom/intellij/openapi/roots/libraries/Library;", "libraryWrapper", "Lorg/jetbrains/kotlin/idea/caches/project/LibraryWrapper;", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getProject", "()Lcom/intellij/openapi/project/Project;", "sourcesModuleInfo", "getSourcesModuleInfo", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "createModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "dependencies", "", "equals", "", "other", "", "getLibraryRoots", "", "hashCode", "", "toString", "kotlin.core"})
public abstract class LibraryInfo
implements IdeaModuleInfo,
LibraryModuleInfo,
BinaryModuleInfo,
TrackableModuleInfo {
    private final LibraryWrapper libraryWrapper;
    @NotNull
    private final Name name;
    private final Lazy _sourcesModuleInfo$delegate;
    @NotNull
    private final Project project;
    @NotNull
    private final Library library;

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.LIBRARY;
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    @NotNull
    public String getDisplayedName() {
        return KotlinIdeaAnalysisBundle.message("library.0", String.valueOf(this.library.getName()));
    }

    @Override
    @NotNull
    public GlobalSearchScope contentScope() {
        return (GlobalSearchScope)new LibraryWithoutSourceScope(this.getProject(), this.library);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        void libraries;
        LinkedHashSet<LibraryInfo> result2 = new LinkedHashSet<LibraryInfo>();
        result2.add(this);
        Pair<List<LibraryInfo>, List<SdkInfo>> pair = LibraryDependenciesCache.Companion.getInstance(this.getProject()).getLibrariesAndSdksUsedWith(this);
        List list2 = (List)pair.component1();
        List sdks = (List)pair.component2();
        result2.addAll(sdks);
        result2.addAll((Collection)libraries);
        return CollectionsKt.toList((Iterable)result2);
    }

    @NotNull
    public abstract TargetPlatform getPlatform();

    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return AnalyzerServicesKt.findAnalyzerServices(this.getPlatform(), this.getProject());
    }

    private final SourceForBinaryModuleInfo get_sourcesModuleInfo() {
        Lazy lazy = this._sourcesModuleInfo$delegate;
        LibraryInfo libraryInfo = this;
        Object var3_3 = null;
        return (SourceForBinaryModuleInfo)lazy.getValue();
    }

    @Override
    @NotNull
    public SourceForBinaryModuleInfo getSourcesModuleInfo() {
        return this.get_sourcesModuleInfo();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getLibraryRoots() {
        void $this$mapNotNullTo$iv$iv;
        VirtualFile[] virtualFileArray = this.library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        VirtualFile[] $this$mapNotNull$iv = virtualFileArray;
        boolean $i$f$mapNotNull = false;
        VirtualFile[] virtualFileArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String string;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void p1 = element$iv$iv;
            boolean bl2 = false;
            if (PathUtil.getLocalPath((VirtualFile)p1) == null) continue;
            String it$iv$iv = string;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public ModificationTracker createModificationTracker() {
        if (!KotlinLibraryToSourceAnalysisComponentKt.getLibraryToSourceAnalysisEnabled(this.getProject())) {
            ModificationTracker modificationTracker = ModificationTracker.NEVER_CHANGED;
            Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"ModificationTracker.NEVER_CHANGED");
            return modificationTracker;
        }
        return new ResolutionAnchorAwareLibraryModificationTracker(this);
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(libraryName=" + this.library.getName() + ", libraryRoots=" + this.getLibraryRoots() + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LibraryInfo)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.libraryWrapper, (Object)((LibraryInfo)other).libraryWrapper);
    }

    public int hashCode() {
        return this.libraryWrapper.hashCode();
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final Library getLibrary() {
        return this.library;
    }

    public LibraryInfo(@NotNull Project project2, @NotNull Library library2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        this.project = project2;
        this.library = library2;
        this.libraryWrapper = ModuleInfosFromIdeaModelKt.wrap(this.library);
        Name name2 = Name.special((String)("<library " + this.library.getName() + ">"));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.special(\"<library ${library.name}>\")");
        this.name = name2;
        this._sourcesModuleInfo$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LibrarySourceInfo>(this){
            final /* synthetic */ LibraryInfo this$0;

            @NotNull
            public final LibrarySourceInfo invoke() {
                return new LibrarySourceInfo(this.this$0.getProject(), this.this$0.getLibrary(), this.this$0);
            }
            {
                this.this$0 = libraryInfo;
                super(0);
            }
        }));
    }

    @Override
    @NotNull
    public Map<ModuleCapability<?>, Object> getCapabilities() {
        return IdeaModuleInfo.DefaultImpls.getCapabilities(this);
    }

    @NotNull
    public List<ModuleInfo> getExpectedBy() {
        return IdeaModuleInfo.DefaultImpls.getExpectedBy(this);
    }

    @Nullable
    public Name getStableName() {
        return IdeaModuleInfo.DefaultImpls.getStableName(this);
    }

    @NotNull
    public ModuleInfo.DependencyOnBuiltIns dependencyOnBuiltIns() {
        return IdeaModuleInfo.DefaultImpls.dependencyOnBuiltIns(this);
    }

    @NotNull
    public Collection<ModuleInfo> modulesWhoseInternalsAreVisible() {
        return IdeaModuleInfo.DefaultImpls.modulesWhoseInternalsAreVisible(this);
    }

    @Override
    @NotNull
    public GlobalSearchScope binariesScope() {
        return BinaryModuleInfo.DefaultImpls.binariesScope(this);
    }
}

