/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.project.ProjectKt;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.FreezableKt;
import org.jetbrains.kotlin.config.JpsPluginSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.BaseKotlinCompilerSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;

@State(name="KotlinJpsPluginSettings", storages={@Storage(value="kotlinc.xml")})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0002H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinJpsPluginSettings;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/BaseKotlinCompilerSettings;", "Lorg/jetbrains/kotlin/config/JpsPluginSettings;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createSettings", "Companion", "kotlin.core"})
public final class KotlinJpsPluginSettings
extends BaseKotlinCompilerSettings<JpsPluginSettings> {
    @NotNull
    private static final String DEFAULT_VERSION;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    protected JpsPluginSettings createSettings() {
        return new JpsPluginSettings();
    }

    public KotlinJpsPluginSettings(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_VERSION = KotlinPluginLayout.Companion.getInstance().getStandaloneCompilerVersion();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinJpsPluginSettings$Companion;", "", "()V", "DEFAULT_VERSION", "", "getDEFAULT_VERSION", "()Ljava/lang/String;", "getInstance", "Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinJpsPluginSettings;", "project", "Lcom/intellij/openapi/project/Project;", "isUnbundledJpsExperimentalFeatureEnabled", "", "kotlin.core"})
    public static final class Companion {
        @NotNull
        public final String getDEFAULT_VERSION() {
            return DEFAULT_VERSION;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final KotlinJpsPluginSettings getInstance(@NotNull Project project2) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$getServiceSafe$iv = (ComponentManager)project2;
            boolean $i$f$getServiceSafe2 = false;
            Object object2 = $this$getServiceSafe$iv.getService(KotlinJpsPluginSettings.class);
            if (object2 == null) {
                String string = "Unable to locate service " + KotlinJpsPluginSettings.class.getName();
                throw new IllegalStateException(string.toString());
            }
            KotlinJpsPluginSettings jpsPluginSettings = (KotlinJpsPluginSettings)object2;
            if (!this.isUnbundledJpsExperimentalFeatureEnabled(project2)) {
                void $this$apply;
                object = FreezableKt.unfrozen(jpsPluginSettings.getSettings());
                JpsPluginSettings $i$f$getServiceSafe2 = (JpsPluginSettings)object;
                KotlinJpsPluginSettings kotlinJpsPluginSettings = jpsPluginSettings;
                boolean bl = false;
                $this$apply.setVersion("");
                Unit unit = Unit.INSTANCE;
                kotlinJpsPluginSettings.setSettings(object);
                return null;
            }
            object = ((JpsPluginSettings)jpsPluginSettings.getSettings()).getVersion();
            if (object.length() == 0) {
                object = FreezableKt.unfrozen(jpsPluginSettings.getSettings());
                JpsPluginSettings $this$apply = (JpsPluginSettings)object;
                KotlinJpsPluginSettings kotlinJpsPluginSettings = jpsPluginSettings;
                boolean bl = false;
                $this$apply.setVersion(Companion.getDEFAULT_VERSION());
                Unit unit = Unit.INSTANCE;
                kotlinJpsPluginSettings.setSettings(object);
            }
            return jpsPluginSettings;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isUnbundledJpsExperimentalFeatureEnabled(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            if (project2.isDefault()) return false;
            Path path2 = ProjectKt.getStateStore((Project)project2).getDirectoryStorePath();
            Path path3 = path2;
            if (path2 == null) return false;
            Path path4 = path3.resolve("kotlin-unbundled-jps-experimental-feature-flag");
            path3 = path4;
            if (path4 == null) return false;
            if (!PathKt.exists((Path)path3)) return false;
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

