/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageAnnotator;
import com.intellij.coverage.JavaCoverageClassesEnumerator;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.PackageAnnotator;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.core.FileIndexUtilsKt;
import org.jetbrains.kotlin.idea.coverage.KotlinCoverageExtension;
import org.jetbrains.kotlin.idea.run.KotlinRunConfiguration;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J3\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00062\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\rH\u0016\u00a2\u0006\u0002\u0010\"\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/coverage/KotlinCoverageExtension;", "Lcom/intellij/coverage/JavaCoverageEngineExtension;", "()V", "collectOutputFiles", "", "srcFile", "Lcom/intellij/psi/PsiFile;", "output", "Lcom/intellij/openapi/vfs/VirtualFile;", "testoutput", "suite", "Lcom/intellij/coverage/CoverageSuitesBundle;", "classFiles", "", "Ljava/io/File;", "getSummaryCoverageInfo", "Lcom/intellij/coverage/PackageAnnotator$ClassCoverageInfo;", "coverageAnnotator", "Lcom/intellij/coverage/JavaCoverageAnnotator;", "element", "Lcom/intellij/psi/PsiNamedElement;", "isApplicableTo", "conf", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "keepCoverageInfoForClassWithoutSource", "bundle", "classFile", "suggestQualifiedName", "sourceFile", "classes", "", "Lcom/intellij/psi/PsiClass;", "names", "", "(Lcom/intellij/psi/PsiFile;[Lcom/intellij/psi/PsiClass;Ljava/util/Set;)Z", "Companion", "kotlin.coverage"})
public final class KotlinCoverageExtension
extends JavaCoverageEngineExtension {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public boolean isApplicableTo(@Nullable RunConfigurationBase<?> conf) {
        return conf instanceof KotlinRunConfiguration;
    }

    public boolean suggestQualifiedName(@NotNull PsiFile sourceFile2, @NotNull PsiClass[] classes2, @NotNull Set<String> names) {
        List<String> qNames;
        Intrinsics.checkNotNullParameter((Object)sourceFile2, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)classes2, (String)"classes");
        Intrinsics.checkNotNullParameter(names, (String)"names");
        if (sourceFile2 instanceof KtFile && (qNames = Companion.collectGeneratedClassQualifiedNames(KotlinCoverageExtension.Companion.findOutputRoots((KtFile)sourceFile2), (KtFile)sourceFile2)) != null) {
            names.addAll((Collection<String>)qNames);
            return true;
        }
        return false;
    }

    @Nullable
    public PackageAnnotator.ClassCoverageInfo getSummaryCoverageInfo(@NotNull JavaCoverageAnnotator coverageAnnotator, @NotNull PsiNamedElement element3) {
        Intrinsics.checkNotNullParameter((Object)coverageAnnotator, (String)"coverageAnnotator");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (element3 instanceof KtClassOrObject) {
            CoverageDataManager coverageDataManager = CoverageDataManager.getInstance((Project)((KtClassOrObject)element3).getProject());
            if (coverageDataManager == null || (coverageDataManager = coverageDataManager.getCurrentSuitesBundle()) == null || (coverageDataManager = coverageDataManager.getSearchScope(((KtClassOrObject)element3).getProject())) == null) {
                return null;
            }
            CoverageDataManager searchScope2 = coverageDataManager;
            VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)element3));
            if (virtualFile2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"PsiUtilCore.getVirtualFile(element) ?: return null");
            VirtualFile vFile = virtualFile2;
            if (!searchScope2.contains(vFile)) {
                return null;
            }
            FqName fqName2 = ((KtClassOrObject)element3).getFqName();
            return coverageAnnotator.getClassCoverageInfo(fqName2 != null ? fqName2.asString() : null);
        }
        if (!(element3 instanceof KtFile)) {
            return null;
        }
        LOG.info("Retrieving coverage for " + ((KtFile)element3).getName());
        List<String> qualifiedNames = Companion.collectGeneratedClassQualifiedNames(KotlinCoverageExtension.Companion.findOutputRoots((KtFile)element3), (KtFile)element3);
        return qualifiedNames == null || qualifiedNames.isEmpty() ? null : KotlinCoverageExtension.Companion.totalCoverageForQualifiedNames(coverageAnnotator, qualifiedNames);
    }

    public boolean keepCoverageInfoForClassWithoutSource(@NotNull CoverageSuitesBundle bundle, @NotNull File classFile) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        return true;
    }

    public boolean collectOutputFiles(@NotNull PsiFile srcFile, @Nullable VirtualFile output, @Nullable VirtualFile testoutput, @NotNull CoverageSuitesBundle suite, @NotNull Set<File> classFiles) {
        Intrinsics.checkNotNullParameter((Object)srcFile, (String)"srcFile");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter(classFiles, (String)"classFiles");
        if (srcFile instanceof KtFile) {
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)srcFile.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getIn\u2026nce(srcFile.getProject())");
            ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getIn\u2026e.getProject()).fileIndex");
            ProjectFileIndex fileIndex = projectFileIndex;
            if (fileIndex.isInLibraryClasses(srcFile.getVirtualFile()) || fileIndex.isInLibrarySource(srcFile.getVirtualFile())) {
                return false;
            }
            return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(srcFile, classFiles){
                final /* synthetic */ PsiFile $srcFile;
                final /* synthetic */ Set $classFiles;

                /*
                 * WARNING - void declaration
                 */
                public final boolean invoke() {
                    void $this$mapTo$iv;
                    VirtualFile[] virtualFileArray = org.jetbrains.kotlin.idea.coverage.KotlinCoverageExtension$Companion.access$findOutputRoots(KotlinCoverageExtension.Companion, (KtFile)this.$srcFile);
                    if (virtualFileArray == null) {
                        return false;
                    }
                    VirtualFile[] outputRoots = virtualFileArray;
                    List existingClassFiles = org.jetbrains.kotlin.idea.coverage.KotlinCoverageExtension$Companion.access$getClassesGeneratedFromFile(KotlinCoverageExtension.Companion, outputRoots, (KtFile)this.$srcFile);
                    Iterable iterable = existingClassFiles;
                    Collection destination$iv = this.$classFiles;
                    boolean $i$f$mapTo = false;
                    for (T item$iv : $this$mapTo$iv) {
                        void it;
                        VirtualFile virtualFile2 = (VirtualFile)item$iv;
                        Collection collection = destination$iv;
                        boolean bl = false;
                        File file2 = new File(it.getPath());
                        collection.add(file2);
                    }
                    return true;
                }
                {
                    this.$srcFile = psiFile2;
                    this.$classFiles = set2;
                    super(0);
                }
            });
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinCoverageExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Kotli\u2026ageExtension::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nJ+\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\f2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0013J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J)\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/coverage/KotlinCoverageExtension$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "collectClassFilePrefixes", "", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectGeneratedClassQualifiedNames", "", "outputRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "outputRoots", "", "([Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/psi/KtFile;)Ljava/util/List;", "findOutputRoots", "(Lorg/jetbrains/kotlin/psi/KtFile;)[Lcom/intellij/openapi/vfs/VirtualFile;", "getClassesGeneratedFromFile", "totalCoverageForQualifiedNames", "Lcom/intellij/coverage/PackageAnnotator$ClassCoverageInfo;", "coverageAnnotator", "Lcom/intellij/coverage/JavaCoverageAnnotator;", "qualifiedNames", "kotlin.coverage"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<String> collectGeneratedClassQualifiedNames(@Nullable VirtualFile[] outputRoots, @NotNull KtFile file2) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (outputRoots != null) {
                void $this$flatMapTo$iv$iv;
                VirtualFile[] $this$flatMap$iv = outputRoots;
                boolean $i$f$flatMap = false;
                VirtualFile[] virtualFileArray = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                int n = ((void)$this$flatMapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
                    boolean bl = false;
                    List list3 = Companion.collectGeneratedClassQualifiedNames((VirtualFile)it, file2);
                    if (list3 == null) {
                        list3 = CollectionsKt.emptyList();
                    }
                    Iterable list$iv$iv = list3;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = null;
            }
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<String> collectGeneratedClassQualifiedNames(@Nullable VirtualFile outputRoot, @NotNull KtFile file2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            List<VirtualFile> existingClassFiles = this.getClassesGeneratedFromFile(outputRoot, file2);
            if (existingClassFiles.isEmpty()) {
                return null;
            }
            LOG.debug("ClassFiles: [" + CollectionsKt.joinToString$default((Iterable)existingClassFiles, null, null, null, (int)0, null, (Function1)collectGeneratedClassQualifiedNames.2.INSTANCE, (int)31, null) + "]");
            Iterable $this$map$iv = existingClassFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String relativePath;
                void it;
                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile3 = outputRoot;
                Intrinsics.checkNotNull((Object)virtualFile3);
                Intrinsics.checkNotNull((Object)VfsUtilCore.getRelativePath((VirtualFile)it, (VirtualFile)virtualFile3));
                Intrinsics.checkNotNullExpressionValue((Object)relativePath, (String)"VfsUtilCore.getRelativePath(it, outputRoot!!)!!");
                String string = StringUtil.trimEnd((String)relativePath, (String)".class");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.trimEnd(relativePath, \".class\")");
                String string2 = StringsKt.replace$default((String)string, (String)"/", (String)".", (boolean)false, (int)4, null);
                collection.add(string2);
            }
            return (List)destination$iv$iv;
        }

        private final PackageAnnotator.ClassCoverageInfo totalCoverageForQualifiedNames(JavaCoverageAnnotator coverageAnnotator, List<String> qualifiedNames) {
            PackageAnnotator.ClassCoverageInfo result2 = new PackageAnnotator.ClassCoverageInfo();
            result2.totalClassCount = 0;
            Iterable $this$forEach$iv = qualifiedNames;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                PackageAnnotator.ClassCoverageInfo classInfo = coverageAnnotator.getClassCoverageInfo(it);
                if (classInfo != null) {
                    result2.totalClassCount += classInfo.totalClassCount;
                    result2.coveredClassCount += classInfo.coveredClassCount;
                    result2.totalMethodCount += classInfo.totalMethodCount;
                    result2.coveredMethodCount += classInfo.coveredMethodCount;
                    result2.totalLineCount += classInfo.totalLineCount;
                    result2.fullyCoveredLineCount += classInfo.fullyCoveredLineCount;
                    result2.partiallyCoveredLineCount += classInfo.partiallyCoveredLineCount;
                    continue;
                }
                LOG.debug("Found no coverage for " + it);
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<VirtualFile> getClassesGeneratedFromFile(VirtualFile[] outputRoots, KtFile file2) {
            void $this$flatMapTo$iv$iv;
            VirtualFile[] $this$flatMap$iv = outputRoots;
            boolean $i$f$flatMap = false;
            VirtualFile[] virtualFileArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl = false;
                Iterable list$iv$iv = Companion.getClassesGeneratedFromFile((VirtualFile)it, file2);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<VirtualFile> getClassesGeneratedFromFile(VirtualFile outputRoot, KtFile file2) {
            void $this$filterTo$iv$iv;
            String string = file2.getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.packageFqName.asString()");
            String relativePath = StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null);
            VirtualFile virtualFile2 = outputRoot;
            if (virtualFile2 == null || (virtualFile2 = virtualFile2.findFileByRelativePath(relativePath)) == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"outputRoot?.findFileByRe\u2026ePath) ?: return listOf()");
            VirtualFile packageOutputDir = virtualFile2;
            Collection<String> prefixes = this.collectClassFilePrefixes(file2);
            LOG.debug("ClassFile prefixes: [" + CollectionsKt.joinToString$default((Iterable)prefixes, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "]");
            VirtualFile[] virtualFileArray = packageOutputDir.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"packageOutputDir.children");
            VirtualFile[] $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            VirtualFile[] virtualFileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                boolean bl;
                void element$iv$iv;
                block5: {
                    void packageFile = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl2 = false;
                    Iterable $this$any$iv = prefixes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            void v4 = packageFile;
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"packageFile");
                            String string2 = v4.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageFile.name");
                            if (!(StringsKt.startsWith$default((String)string2, (String)(it + "$"), (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)FileUtilRt.getExtension((String)packageFile.getName()), (Object)"class") || Intrinsics.areEqual((Object)packageFile.getName(), (Object)(it + ".class")))) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final VirtualFile[] findOutputRoots(KtFile file2) {
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file2));
            if (module2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"ModuleUtilCore.findModul\u2026ment(file) ?: return null");
            Module module3 = module2;
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)file2.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(file.project)");
            ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getIn\u2026e(file.project).fileIndex");
            ProjectFileIndex fileIndex = projectFileIndex;
            FileIndex fileIndex2 = (FileIndex)fileIndex;
            VirtualFile virtualFile2 = file2.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file.virtualFile");
            boolean inTests = FileIndexUtilsKt.isInTestSourceContentKotlinAware(fileIndex2, virtualFile2);
            return JavaCoverageClassesEnumerator.getRoots((CoverageDataManager)CoverageDataManager.getInstance((Project)file2.getProject()), (Module)module3, (boolean)inTests);
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<String> collectClassFilePrefixes(KtFile file2) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            PsiElement[] psiElementArray = file2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"file.children");
            PsiElement[] $this$filterIsInstance$iv = psiElementArray;
            boolean $i$f$filterIsInstance = false;
            PsiElement[] psiElementArray2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtClassOrObject)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                KtClassOrObject it = (KtClassOrObject)element$iv$iv;
                boolean bl2 = false;
                if (it.getName() == null) continue;
                String it$iv$iv = string;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List result2 = (List)destination$iv$iv;
            FqName packagePartFqName = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)file2).getFileClassFqName();
            Iterable iterable = result2;
            Object[] objectArray = new String[1];
            String string = packagePartFqName.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packagePartFqName.shortName().asString()");
            objectArray[0] = string;
            return CollectionsKt.union((Iterable)iterable, (Iterable)CollectionsKt.arrayListOf((Object[])objectArray));
        }

        private Companion() {
        }

        public static final /* synthetic */ List access$getClassesGeneratedFromFile(Companion $this, VirtualFile[] outputRoots, KtFile file2) {
            return $this.getClassesGeneratedFromFile(outputRoots, file2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

