/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleTooling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinKPMGradleModel;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinKPMGradleModelImpl;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinNativeHomeEvaluator;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinProjectModelImportingContext;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinProjectModelImportingContextKt;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinProjectModelSettings;
import org.jetbrains.kotlin.idea.gradleTooling.UtilsKt;
import org.jetbrains.kotlin.idea.gradleTooling.builders.KotlinModuleBuilder;
import org.jetbrains.kotlin.idea.gradleTooling.builders.KotlinProjectModelSettingsBuilder;
import org.jetbrains.kotlin.idea.gradleTooling.reflect.KotlinKpmExtensionReflection;
import org.jetbrains.kotlin.idea.gradleTooling.reflect.KotlinKpmExtensionReflectionKt;
import org.jetbrains.kotlin.idea.gradleTooling.reflect.KotlinModuleReflection;
import org.jetbrains.kotlin.idea.projectModel.KotlinModule;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/gradleTooling/KotlinKPMGradleModelBuilder;", "Lorg/jetbrains/plugins/gradle/tooling/AbstractModelBuilderService;", "()V", "buildAll", "Lorg/jetbrains/kotlin/idea/gradleTooling/KotlinKPMGradleModel;", "modelName", "", "project", "Lorg/gradle/api/Project;", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "canBuild", "", "getErrorMessageBuilder", "Lorg/jetbrains/plugins/gradle/tooling/ErrorMessageBuilder;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Companion", "kotlin.gradle.gradle-tooling"})
public final class KotlinKPMGradleModelBuilder
extends AbstractModelBuilderService {
    private static final String KPM_GRADLE_PLUGIN_ID = "org.jetbrains.kotlin.multiplatform.pm20";
    private static final String KPM_EXTENSION_CLASS_NAME = "org.jetbrains.kotlin.gradle.plugin.mpp.pm20.KotlinPm20ProjectExtension";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean canBuild(@Nullable String modelName) {
        return Intrinsics.areEqual((Object)modelName, (Object)KotlinKPMGradleModel.class.getName());
    }

    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project2, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ErrorMessageBuilder errorMessageBuilder = ErrorMessageBuilder.create((Project)project2, (Exception)e, (String)"Gradle import errors").withDescription("Unable to build Kotlin PM20 project configuration");
        Intrinsics.checkNotNullExpressionValue((Object)errorMessageBuilder, (String)"ErrorMessageBuilder\n    \u20260 project configuration\")");
        return errorMessageBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public KotlinKPMGradleModel buildAll(@NotNull String modelName, @NotNull Project project2, @NotNull ModelBuilderContext context2) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        try {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object object = KotlinKPMGradleModelBuilder.Companion.getKpmExtension(project2);
            if (object == null) {
                return null;
            }
            Object kpmExtension = object;
            KotlinKpmExtensionReflection kpmExtensionReflection = KotlinKpmExtensionReflectionKt.KotlinKpmExtensionReflection(kpmExtension);
            KotlinProjectModelSettings kotlinProjectModelSettings = KotlinProjectModelSettingsBuilder.INSTANCE.buildComponent(kpmExtensionReflection);
            if (kotlinProjectModelSettings == null) {
                return null;
            }
            KotlinProjectModelSettings kpmProjectSettings = kotlinProjectModelSettings;
            String string = KotlinNativeHomeEvaluator.INSTANCE.getKotlinNativeHome(project2);
            if (string == null) {
                string = "";
            }
            String kotlinNativeHome = string;
            ClassLoader classLoader2 = kpmExtension.getClass().getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"kpmExtension.javaClass.classLoader");
            KotlinProjectModelImportingContext importingContext = new KotlinProjectModelImportingContext(project2, classLoader2, null, null, 12, null);
            Iterable iterable = kpmExtensionReflection.getModules();
            List list2 = iterable;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            iterable = list2;
            boolean $i$f$mapNotNull = false;
            void var12_12 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                KotlinModule kotlinModule;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                KotlinModuleReflection originModule = (KotlinModuleReflection)element$iv$iv;
                boolean bl2 = false;
                if (KotlinModuleBuilder.INSTANCE.buildComponent(originModule, KotlinProjectModelImportingContextKt.withFragmentCache(importingContext)) == null) continue;
                KotlinModule it$iv$iv = kotlinModule;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List kpmModules = (List)destination$iv$iv;
            return new KotlinKPMGradleModelImpl(kpmModules, kpmProjectSettings, kotlinNativeHome);
        }
        catch (Throwable throwable) {
            project2.getLogger().error("Failed building KotlinKPMGradleModel", throwable);
            throw throwable;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR:\u0010\n\u001a$\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00010\u0001\u0018\u0001 \f*\u000b\u0012\u0002\b\u0003\u0018\u00010\u000b\u00a8\u0006\u00010\u000b\u00a8\u0006\u0001*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/gradleTooling/KotlinKPMGradleModelBuilder$Companion;", "", "()V", "KPM_EXTENSION_CLASS_NAME", "", "KPM_GRADLE_PLUGIN_ID", "kpmExtension", "Lorg/gradle/api/Project;", "getKpmExtension", "(Lorg/gradle/api/Project;)Ljava/lang/Object;", "kpmPlugin", "Lorg/gradle/api/Plugin;", "kotlin.jvm.PlatformType", "getKpmPlugin", "(Lorg/gradle/api/Project;)Lorg/gradle/api/Plugin;", "kotlin.gradle.gradle-tooling"})
    public static final class Companion {
        private final Plugin<Object> getKpmPlugin(Project $this$kpmPlugin) {
            Project project2 = $this$kpmPlugin.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            return project2.getPlugins().findPlugin(KotlinKPMGradleModelBuilder.KPM_GRADLE_PLUGIN_ID);
        }

        private final Object getKpmExtension(Project $this$kpmExtension) {
            Object object;
            Object object2 = Companion.getKpmPlugin($this$kpmExtension);
            if (object2 != null && (object2 = object2.getClass()) != null && (object2 = ((Class)object2).getClassLoader()) != null && (object2 = UtilsKt.loadClassOrNull((ClassLoader)object2, KotlinKPMGradleModelBuilder.KPM_EXTENSION_CLASS_NAME)) != null) {
                Object object3;
                Object it = object3 = object2;
                boolean bl = false;
                Project project2 = $this$kpmExtension.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                object = project2.getExtensions().findByType((Class)it);
            } else {
                object = null;
            }
            return object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

