/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\b*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinCovariantEqualsInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isEquals", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "kotlin.idea"})
public final class KotlinCovariantEqualsInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.namedFunctionVisitor((Function1)((Function1)new Function1<KtNamedFunction, Unit>(this, holder){
            final /* synthetic */ KotlinCovariantEqualsInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtNamedFunction function2) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                if (function2.isTopLevel() || function2.isLocal()) {
                    return;
                }
                if (Intrinsics.areEqual((Object)function2.getNameAsName(), (Object)OperatorNameConventions.EQUALS) ^ true) {
                    return;
                }
                PsiElement psiElement2 = function2.getNameIdentifier();
                if (psiElement2 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"function.nameIdentifier ?: return");
                PsiElement nameIdentifier = psiElement2;
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)function2));
                if (ktClassOrObject == null) {
                    return;
                }
                KtClassOrObject classOrObject = ktClassOrObject;
                if (classOrObject instanceof KtObjectDeclaration && ((KtObjectDeclaration)classOrObject).isCompanion()) {
                    return;
                }
                List list2 = function2.getValueParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"function.valueParameters");
                KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull((List)list2);
                if (ktParameter == null) {
                    return;
                }
                KtParameter parameter = ktParameter;
                KtTypeReference ktTypeReference = parameter.getTypeReference();
                if (ktTypeReference == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"parameter.typeReference ?: return");
                KtTypeReference typeReference2 = ktTypeReference;
                KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)((KtElement)parameter), (BodyResolveMode)BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference2);
                if (kotlinType == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"parameter.analyze(BodyRe\u2026 typeReference] ?: return");
                KotlinType type2 = kotlinType;
                if (KotlinBuiltIns.isNullableAny((KotlinType)type2)) {
                    return;
                }
                PsiElement[] psiElementArray = classOrObject.getBody();
                if (psiElementArray != null && (psiElementArray = psiElementArray.getChildren()) != null) {
                    boolean bl;
                    block13: {
                        PsiElement[] $this$any$iv = psiElementArray;
                        boolean $i$f$any = false;
                        int n = $this$any$iv.length;
                        for (int i = 0; i < n; ++i) {
                            PsiElement element$iv;
                            PsiElement it = element$iv = $this$any$iv[i];
                            boolean bl2 = false;
                            PsiElement psiElement3 = it;
                            if (!(psiElement3 instanceof KtNamedFunction)) {
                                psiElement3 = null;
                            }
                            KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement3;
                            if (!(ktNamedFunction != null && KotlinCovariantEqualsInspection.access$isEquals(this.this$0, ktNamedFunction))) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                    if (bl) {
                        return;
                    }
                }
                this.$holder.registerProblem(nameIdentifier, KotlinBundle.message("equals.should.take.any.as.its.argument", new Object[0]), new LocalQuickFix[0]);
            }
            {
                this.this$0 = kotlinCovariantEqualsInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    private final boolean isEquals(KtNamedFunction $this$isEquals) {
        if (!$this$isEquals.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)$this$isEquals.getNameAsName(), (Object)OperatorNameConventions.EQUALS) ^ true) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)$this$isEquals);
        if (!(declarationDescriptor instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)declarationDescriptor;
        if (functionDescriptor2 == null) {
            return false;
        }
        FunctionDescriptor descriptor2 = functionDescriptor2;
        List list2 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"descriptor.valueParameters");
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.singleOrNull((List)list2);
        if (valueParameterDescriptor == null || (valueParameterDescriptor = valueParameterDescriptor.getType()) == null || !TypeUtilsKt.isNullableAny((KotlinType)valueParameterDescriptor)) {
            return false;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        return kotlinType != null && TypeUtilsKt.isBoolean((KotlinType)kotlinType);
        {
        }
    }

    public static final /* synthetic */ boolean access$isEquals(KotlinCovariantEqualsInspection $this, KtNamedFunction $this$access_u24isEquals) {
        return $this.isEquals($this$access_u24isEquals);
    }
}

