/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.collections.ConvertCallChainIntoSequenceInspectionKt;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.inspections.dfa.KtDfaHelpersKt;
import org.jetbrains.kotlin.idea.intentions.RemoveExplicitTypeArgumentsIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\b*\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\b*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\b*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/RedundantAsSequenceInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "registerProblem", "", "qualified", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "callee", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isRedundant", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "isTermination", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isTransformationOrTermination", "Companion", "RemoveAsSequenceFix", "kotlin.idea"})
public final class RedundantAsSequenceInspection
extends AbstractKotlinInspection {
    private static final List<FqName> allowedSequenceFunctionFqNames;
    private static final Map<String, FqName> terminations;
    private static final Map<String, FqName> transformationsAndTerminations;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.qualifiedExpressionVisitor((Function1)((Function1)new Function1<KtQualifiedExpression, Unit>(this, holder){
            final /* synthetic */ RedundantAsSequenceInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtQualifiedExpression qualified) {
                Intrinsics.checkNotNullParameter((Object)qualified, (String)"qualified");
                KtCallExpression ktCallExpression = UtilsKt.getCallExpression(qualified);
                if (ktCallExpression == null) {
                    return;
                }
                KtCallExpression call = ktCallExpression;
                KtExpression ktExpression = call.getCalleeExpression();
                if (ktExpression == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"call.calleeExpression ?: return");
                KtExpression callee2 = ktExpression;
                if (Intrinsics.areEqual((Object)callee2.getText(), (Object)"asSequence") ^ true) {
                    return;
                }
                BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)qualified), (BodyResolveMode)BodyResolveMode.PARTIAL);
                if (!FunctionUtilsKt.isCalling(call, RedundantAsSequenceInspection.access$getAllowedSequenceFunctionFqNames$cp(), context2)) {
                    return;
                }
                KotlinType kotlinType = CallUtilKt.getType((KtExpression)qualified.getReceiverExpression(), (BindingContext)context2);
                if (kotlinType == null) {
                    return;
                }
                KotlinType receiverType2 = kotlinType;
                if (KtDfaHelpersKt.fqNameEquals(receiverType2, "kotlin.sequences.Sequence")) {
                    KtTypeArgumentList typeArgumentList2 = call.getTypeArgumentList();
                    if (typeArgumentList2 != null && !RedundantAsSequenceInspection.access$isRedundant(this.this$0, typeArgumentList2)) {
                        return;
                    }
                    RedundantAsSequenceInspection.access$registerProblem(this.this$0, this.$holder, qualified, callee2);
                } else {
                    KtCallExpression grandParentCall;
                    if (!FunctionUtilsKt.isIterable(receiverType2, (KotlinBuiltIns)DefaultBuiltIns.Companion.getInstance())) {
                        return;
                    }
                    KtQualifiedExpression parent2 = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)qualified));
                    KtQualifiedExpression ktQualifiedExpression = parent2;
                    if (ktQualifiedExpression == null || (ktQualifiedExpression = UtilsKt.getCallExpression(ktQualifiedExpression)) == null) {
                        return;
                    }
                    KtQualifiedExpression parentCall2 = ktQualifiedExpression;
                    if (!RedundantAsSequenceInspection.access$isTermination(this.this$0, (KtCallExpression)parentCall2, context2)) {
                        return;
                    }
                    KtQualifiedExpression ktQualifiedExpression2 = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)parent2));
                    KtCallExpression ktCallExpression2 = grandParentCall = ktQualifiedExpression2 != null ? UtilsKt.getCallExpression(ktQualifiedExpression2) : null;
                    if (ktCallExpression2 != null) {
                        if (RedundantAsSequenceInspection.access$isTransformationOrTermination(this.this$0, ktCallExpression2, context2)) {
                            return;
                        }
                    }
                    RedundantAsSequenceInspection.access$registerProblem(this.this$0, this.$holder, qualified, callee2);
                }
            }
            {
                this.this$0 = redundantAsSequenceInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    private final boolean isRedundant(KtTypeArgumentList $this$isRedundant) {
        return RemoveExplicitTypeArgumentsIntention.Companion.isApplicableTo($this$isRedundant, false);
    }

    private final void registerProblem(ProblemsHolder holder, KtQualifiedExpression qualified, KtExpression callee2) {
        holder.registerProblem((PsiElement)qualified, ExpressionExtKt.textRangeIn((PsiElement)callee2, (PsiElement)qualified), KotlinBundle.message("inspection.redundant.assequence.call", new Object[0]), new LocalQuickFix[]{new RemoveAsSequenceFix()});
    }

    private final boolean isTermination(KtCallExpression $this$isTermination, BindingContext context2) {
        Map<String, FqName> map2 = terminations;
        KtExpression ktExpression = $this$isTermination.getCalleeExpression();
        String string = ktExpression != null ? ktExpression.getText() : null;
        FqName fqName2 = map2.get(string);
        if (fqName2 == null) {
            return false;
        }
        FqName fqName3 = fqName2;
        return FunctionUtilsKt.isCalling($this$isTermination, fqName3, context2);
    }

    private final boolean isTransformationOrTermination(KtCallExpression $this$isTransformationOrTermination, BindingContext context2) {
        Map<String, FqName> map2 = transformationsAndTerminations;
        KtExpression ktExpression = $this$isTransformationOrTermination.getCalleeExpression();
        String string = ktExpression != null ? ktExpression.getText() : null;
        FqName fqName2 = map2.get(string);
        if (fqName2 == null) {
            return false;
        }
        FqName fqName3 = fqName2;
        return FunctionUtilsKt.isCalling($this$isTransformationOrTermination, fqName3, context2);
    }

    static {
        FqName fqName2;
        String it;
        Map map2;
        Object t;
        Companion = new Companion(null);
        allowedSequenceFunctionFqNames = CollectionsKt.listOf((Object[])new FqName[]{new FqName("kotlin.sequences.asSequence"), new FqName("kotlin.collections.asSequence")});
        Iterable $this$associateWith$iv = ConvertCallChainIntoSequenceInspectionKt.getCollectionTerminationFunctionNames();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            String string = (String)element$iv$iv;
            t = element$iv$iv;
            map2 = result$iv;
            boolean bl = false;
            fqName2 = new FqName("kotlin.sequences." + it);
            map2.put(t, fqName2);
        }
        terminations = result$iv;
        $this$associateWith$iv = ConvertCallChainIntoSequenceInspectionKt.getCollectionTransformationFunctionNames();
        $i$f$associateWith = false;
        result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        $this$associateWithTo$iv$iv = $this$associateWith$iv;
        $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (String)element$iv$iv;
            t = element$iv$iv;
            map2 = result$iv;
            boolean bl = false;
            fqName2 = new FqName("kotlin.sequences." + it);
            map2.put(t, fqName2);
        }
        transformationsAndTerminations = MapsKt.plus((Map)result$iv, terminations);
    }

    public static final /* synthetic */ List access$getAllowedSequenceFunctionFqNames$cp() {
        return allowedSequenceFunctionFqNames;
    }

    public static final /* synthetic */ boolean access$isRedundant(RedundantAsSequenceInspection $this, KtTypeArgumentList $this$access_u24isRedundant) {
        return $this.isRedundant($this$access_u24isRedundant);
    }

    public static final /* synthetic */ void access$registerProblem(RedundantAsSequenceInspection $this, ProblemsHolder holder, KtQualifiedExpression qualified, KtExpression callee2) {
        $this.registerProblem(holder, qualified, callee2);
    }

    public static final /* synthetic */ boolean access$isTermination(RedundantAsSequenceInspection $this, KtCallExpression $this$access_u24isTermination, BindingContext context2) {
        return $this.isTermination($this$access_u24isTermination, context2);
    }

    public static final /* synthetic */ boolean access$isTransformationOrTermination(RedundantAsSequenceInspection $this, KtCallExpression $this$access_u24isTransformationOrTermination, BindingContext context2) {
        return $this.isTransformationOrTermination($this$access_u24isTransformationOrTermination, context2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/RedundantAsSequenceInspection$RemoveAsSequenceFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
    private static final class RemoveAsSequenceFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message("remove.assequence.call.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiElement psiElement2;
            void $this$replaced$iv;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement3 = descriptor2.getPsiElement();
            if (!(psiElement3 instanceof KtQualifiedExpression)) {
                psiElement3 = null;
            }
            KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)psiElement3;
            if (ktQualifiedExpression == null) {
                return;
            }
            KtQualifiedExpression qualified = ktQualifiedExpression;
            CommentSaver commentSaver = new CommentSaver((PsiElement)qualified, false, 2, null);
            PsiElement psiElement4 = (PsiElement)qualified;
            PsiElement newElement$iv = (PsiElement)qualified.getReceiverExpression();
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement2 = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                PsiElement psiElement5 = result$iv;
                if (!(psiElement5 instanceof KtExpression)) {
                    psiElement5 = null;
                }
                if ((psiElement2 = (PsiElement)((KtExpression)psiElement5)) == null) {
                    PsiElement psiElement6 = result$iv;
                    if (psiElement6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    KtExpression ktExpression = ((KtParenthesizedExpression)psiElement6).getExpression();
                    if (ktExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement2 = (PsiElement)ktExpression;
                }
            }
            KtExpression replaced2 = (KtExpression)psiElement2;
            CommentSaver.restore$default(commentSaver, (PsiElement)replaced2, false, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/RedundantAsSequenceInspection$Companion;", "", "()V", "allowedSequenceFunctionFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "terminations", "", "", "transformationsAndTerminations", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

