/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jps;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.nio.file.Path;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JpsPluginSettings;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinVersionVerbose;
import org.jetbrains.kotlin.idea.compiler.configuration.BaseKotlinCompilerSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPathsProvider;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b*\u00020\u00062\b\b\u0001\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\b*\u00020\u00062\b\b\u0001\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/jps/SetupKotlinJpsPluginBeforeCompileTask;", "Lcom/intellij/openapi/compiler/CompileTask;", "()V", "execute", "", "context", "Lcom/intellij/openapi/compiler/CompileContext;", "addError", "", "msg", "", "addErrorWithReferenceToKotlincXml", "Companion", "kotlin.idea"})
public final class SetupKotlinJpsPluginBeforeCompileTask
implements CompileTask {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean execute(@NotNull CompileContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Project project2 = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"context.project");
        Object object = KotlinJpsPluginSettings.Companion.getInstance(project2);
        if (object == null || (object = (JpsPluginSettings)((BaseKotlinCompilerSettings)object).getSettings()) == null || (object = object.getVersion()) == null) {
            return true;
        }
        Object version2 = object;
        KotlinVersionVerbose parsed = KotlinVersionVerbose.Companion.parse((String)version2);
        if (parsed == null) {
            this.addErrorWithReferenceToKotlincXml(context2, KotlinBundle.message("failed.to.parse.kotlin.version.0.from.1", version2, "kotlinc.xml"));
            return false;
        }
        if (parsed.getPlainVersion().compareTo(Companion.getJpsMinimumSupportedVersion()) < 0) {
            this.addErrorWithReferenceToKotlincXml(context2, KotlinBundle.message("kotlin.jps.compiler.minimum.supported.version.not.satisfied", Companion.getJpsMinimumSupportedVersion(), version2));
            return false;
        }
        Project project3 = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"context.project");
        ProgressIndicator progressIndicator = context2.getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"context.progressIndicator");
        File jpsPluginClassPathJar2 = KotlinPathsProvider.INSTANCE.lazyDownloadMavenArtifact(project3, "kotlin-jps-plugin-classpath", (String)version2, progressIndicator, (Function0<Unit>)((Function0)new Function0<Unit>(context2){
            final /* synthetic */ CompileContext $context;

            public final void invoke() {
                ProgressIndicator progressIndicator = this.$context.getProgressIndicator();
                Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"context.progressIndicator");
                progressIndicator.setText(KotlinBundle.message("progress.text.downloading.kotlin.jps.plugin", new Object[0]));
            }
            {
                this.$context = compileContext;
                super(0);
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, context2){
            final /* synthetic */ SetupKotlinJpsPluginBeforeCompileTask this$0;
            final /* synthetic */ CompileContext $context;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SetupKotlinJpsPluginBeforeCompileTask.access$addError(this.this$0, this.$context, it);
            }
            {
                this.this$0 = setupKotlinJpsPluginBeforeCompileTask;
                this.$context = compileContext;
                super(1);
            }
        }));
        if (jpsPluginClassPathJar2 == null) {
            return false;
        }
        Project project4 = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"context.project");
        ProgressIndicator progressIndicator2 = context2.getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator2, (String)"context.progressIndicator");
        File unpackedKotlinc2 = KotlinPathsProvider.INSTANCE.lazyDownloadAndUnpackKotlincDist(project4, (String)version2, progressIndicator2, (Function0<Unit>)((Function0)new Function0<Unit>(context2){
            final /* synthetic */ CompileContext $context;

            public final void invoke() {
                ProgressIndicator progressIndicator = this.$context.getProgressIndicator();
                Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"context.progressIndicator");
                progressIndicator.setText(KotlinBundle.message("progress.text.downloading.kotlinc.dist", new Object[0]));
            }
            {
                this.$context = compileContext;
                super(0);
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, context2){
            final /* synthetic */ SetupKotlinJpsPluginBeforeCompileTask this$0;
            final /* synthetic */ CompileContext $context;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SetupKotlinJpsPluginBeforeCompileTask.access$addError(this.this$0, this.$context, it);
            }
            {
                this.this$0 = setupKotlinJpsPluginBeforeCompileTask;
                this.$context = compileContext;
                super(1);
            }
        }));
        return unpackedKotlinc2 != null;
    }

    private final void addError(CompileContext $this$addError, @Nls(capitalization=Nls.Capitalization.Sentence) String msg2) {
        $this$addError.addMessage(CompilerMessageCategory.ERROR, msg2, null, -1, -1);
    }

    private final void addErrorWithReferenceToKotlincXml(CompileContext $this$addErrorWithReferenceToKotlincXml, @Nls(capitalization=Nls.Capitalization.Sentence) String msg2) {
        PsiFile psiFile2;
        VirtualFile virtualFile2;
        VirtualFile virtualFile3;
        Project project2 = $this$addErrorWithReferenceToKotlincXml.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Path path2 = ProjectKt.getStateStore((Project)project2).getDirectoryStorePath();
        if (path2 != null && (path2 = path2.resolve("kotlinc.xml")) != null) {
            Path path3;
            Path it = path3 = path2;
            boolean bl = false;
            virtualFile3 = VirtualFileManager.getInstance().findFileByNioPath(it);
        } else {
            virtualFile3 = null;
        }
        VirtualFile virtualFile4 = virtualFile2 = virtualFile3;
        String string = virtualFile4 != null ? virtualFile4.getUrl() : null;
        VirtualFile virtualFile5 = virtualFile2;
        if (virtualFile5 != null) {
            Project project3 = $this$addErrorWithReferenceToKotlincXml.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile(virtualFile5, project3);
        } else {
            psiFile2 = null;
        }
        $this$addErrorWithReferenceToKotlincXml.addMessage(CompilerMessageCategory.ERROR, msg2, string, -1, -1, (Navigatable)psiFile2);
    }

    public static final /* synthetic */ void access$addError(SetupKotlinJpsPluginBeforeCompileTask $this, CompileContext $this$access_u24addError, String msg2) {
        $this.addError($this$access_u24addError, msg2);
    }

    @NotNull
    public static final KotlinVersion getJpsMinimumSupportedVersion() {
        return Companion.getJpsMinimumSupportedVersion();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/jps/SetupKotlinJpsPluginBeforeCompileTask$Companion;", "", "()V", "jpsMinimumSupportedVersion", "Lkotlin/KotlinVersion;", "getJpsMinimumSupportedVersion$annotations", "getJpsMinimumSupportedVersion", "()Lkotlin/KotlinVersion;", "getKotlinJpsClasspathLocation", "Ljava/io/File;", "version", "", "kotlin.idea"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getJpsMinimumSupportedVersion$annotations() {
        }

        @NotNull
        public final KotlinVersion getJpsMinimumSupportedVersion() {
            KotlinVersionVerbose kotlinVersionVerbose;
            KotlinVersionVerbose it = kotlinVersionVerbose = KotlinVersionVerbose.Companion.parse("1.5.10");
            boolean bl = false;
            KotlinVersionVerbose kotlinVersionVerbose2 = it;
            if (kotlinVersionVerbose2 == null) {
                String string = "JPS Minimum version is not valid";
                throw new IllegalStateException(string.toString());
            }
            return kotlinVersionVerbose2.getPlainVersion();
        }

        @NotNull
        public final File getKotlinJpsClasspathLocation(@NotNull String version2) {
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            return KotlinPathsProvider.INSTANCE.getExpectedMavenArtifactJarPath("kotlin-jps-plugin-classpath", version2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

