/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.junit;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.extensions.KotlinTestFrameworkProvider;
import org.jetbrains.kotlin.idea.junit.KotlinJUnitRunConfigurationProducer;
import org.jetbrains.kotlin.idea.util.SafeAnalyzeKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/junit/JunitKotlinTestFrameworkProvider;", "Lorg/jetbrains/kotlin/idea/extensions/KotlinTestFrameworkProvider;", "()V", "canRunJvmTests", "", "getCanRunJvmTests", "()Z", "isProducedByJava", "configuration", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "isProducedByKotlin", "isTestJavaClass", "testClass", "Lcom/intellij/psi/PsiClass;", "isTestJavaMethod", "testMethod", "Lcom/intellij/psi/PsiMethod;", "kotlin.junit"})
public final class JunitKotlinTestFrameworkProvider
implements KotlinTestFrameworkProvider {
    @NotNull
    public static final JunitKotlinTestFrameworkProvider INSTANCE;

    @Override
    public boolean getCanRunJvmTests() {
        return true;
    }

    @Override
    public boolean isProducedByJava(@NotNull ConfigurationFromContext configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        return configuration2.isProducedBy(JUnitConfigurationProducer.class);
    }

    @Override
    public boolean isProducedByKotlin(@NotNull ConfigurationFromContext configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        return configuration2.isProducedBy(KotlinJUnitRunConfigurationProducer.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isTestJavaClass(@NotNull PsiClass testClass) {
        Intrinsics.checkNotNullParameter((Object)testClass, (String)"testClass");
        PsiElement $this$actionUnderSafeAnalyzeBlock$iv = (PsiElement)testClass;
        boolean $i$f$actionUnderSafeAnalyzeBlock = false;
        try {
            boolean bl = false;
            return JUnitUtil.isTestClass((PsiClass)testClass, (boolean)false, (boolean)true);
        }
        catch (Exception e$iv) {
            Exception $this$returnIfNoDescriptorForDeclarationException$iv$iv = e$iv;
            boolean $i$f$returnIfNoDescriptorForDeclarationException = false;
            boolean it$iv = ResolutionUtils.isItNoDescriptorForDeclarationException((Exception)$this$returnIfNoDescriptorForDeclarationException$iv$iv);
            boolean bl = false;
            PsiFile file$iv = $this$actionUnderSafeAnalyzeBlock$iv.getContainingFile();
            if (it$iv) {
                PsiFile psiFile2 = file$iv;
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"file");
                if (!psiFile2.isPhysical()) return false;
                if (!SafeAnalyzeKt.isUnderKotlinSourceRootTypes((PsiElement)file$iv)) {
                    return false;
                }
            }
            boolean bl2 = false;
            if (!bl2) throw (Throwable)$this$returnIfNoDescriptorForDeclarationException$iv$iv;
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isTestJavaMethod(@NotNull PsiMethod testMethod) {
        Intrinsics.checkNotNullParameter((Object)testMethod, (String)"testMethod");
        PsiElement $this$actionUnderSafeAnalyzeBlock$iv = (PsiElement)testMethod;
        boolean $i$f$actionUnderSafeAnalyzeBlock = false;
        try {
            boolean bl = false;
            return JUnitUtil.isTestMethod((Location)PsiLocation.fromPsiElement((PsiElement)((PsiElement)testMethod)), (boolean)false);
        }
        catch (Exception e$iv) {
            Exception $this$returnIfNoDescriptorForDeclarationException$iv$iv = e$iv;
            boolean $i$f$returnIfNoDescriptorForDeclarationException = false;
            boolean it$iv = ResolutionUtils.isItNoDescriptorForDeclarationException((Exception)$this$returnIfNoDescriptorForDeclarationException$iv$iv);
            boolean bl = false;
            PsiFile file$iv = $this$actionUnderSafeAnalyzeBlock$iv.getContainingFile();
            if (it$iv) {
                PsiFile psiFile2 = file$iv;
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"file");
                if (!psiFile2.isPhysical()) return false;
                if (!SafeAnalyzeKt.isUnderKotlinSourceRootTypes((PsiElement)file$iv)) {
                    return false;
                }
            }
            boolean bl2 = false;
            if (!bl2) throw (Throwable)$this$returnIfNoDescriptorForDeclarationException$iv$iv;
            return false;
        }
    }

    private JunitKotlinTestFrameworkProvider() {
    }

    static {
        JunitKotlinTestFrameworkProvider junitKotlinTestFrameworkProvider;
        INSTANCE = junitKotlinTestFrameworkProvider = new JunitKotlinTestFrameworkProvider();
    }

    @Override
    @Nullable
    public KotlinTestFrameworkProvider.JavaEntity getJavaEntity(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinTestFrameworkProvider.DefaultImpls.getJavaEntity(this, element3);
    }

    @Override
    @Nullable
    public KotlinTestFrameworkProvider.JavaTestEntity getJavaTestEntity(@NotNull PsiElement element3, boolean checkMethod) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinTestFrameworkProvider.DefaultImpls.getJavaTestEntity(this, element3, checkMethod);
    }
}

