/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001a\u001bB\u000f\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J#\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J\"\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J \u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0002R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "element", "(Lorg/jetbrains/kotlin/psi/KtProperty;)V", "removeInitializer", "", "removeGetter", "removeSetter", "(Lorg/jetbrains/kotlin/psi/KtProperty;ZZZ)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "partsToRemove", "getter", "setter", "initializer", "Companion", "LateInitFactory", "kotlin.idea"})
public class RemovePartsFromPropertyFix
extends KotlinQuickFixAction<KtProperty> {
    private final boolean removeInitializer;
    private final boolean removeGetter;
    private final boolean removeSetter;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return KotlinBundle.message("remove.0.from.property", this.partsToRemove(this.removeGetter, this.removeSetter, this.removeInitializer));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("remove.parts.from.property", new Object[0]);
    }

    @Override
    protected boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KotlinType kotlinType = QuickFixUtil.getDeclarationReturnType((KtNamedDeclaration)((KtNamedDeclaration)this.getElement()));
        if (kotlinType == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"QuickFixUtil.getDeclarat\u2026(element) ?: return false");
        KotlinType type2 = kotlinType;
        return !KotlinTypeKt.isError((KotlinType)type2);
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        KtProperty replaceElement;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtProperty ktProperty = (KtProperty)this.getElement();
        Object object = ktProperty != null ? ktProperty.copy() : null;
        if (!(object instanceof KtProperty)) {
            object = null;
        }
        KtProperty ktProperty2 = (KtProperty)object;
        if (ktProperty2 == null) {
            return;
        }
        KtProperty newElement2 = ktProperty2;
        KtPropertyAccessor getter = newElement2.getGetter();
        if (this.removeGetter && getter != null) {
            newElement2.deleteChildInternal(getter.getNode());
        }
        KtPropertyAccessor setter = newElement2.getSetter();
        if (this.removeSetter && setter != null) {
            newElement2.deleteChildInternal(setter.getNode());
        }
        KtExpression initializer2 = newElement2.getInitializer();
        KotlinType typeToAdd = null;
        if (this.removeInitializer && initializer2 != null) {
            PsiElement nextSibling;
            PsiElement psiElement2 = newElement2.getNameIdentifier();
            Object object2 = nextSibling = psiElement2 != null ? psiElement2.getNextSibling() : null;
            if (nextSibling != null) {
                newElement2.deleteChildRange(nextSibling, (PsiElement)initializer2);
                KotlinType type2 = QuickFixUtil.getDeclarationReturnType((KtNamedDeclaration)((KtNamedDeclaration)this.getElement()));
                if (newElement2.getTypeReference() == null && type2 != null) {
                    typeToAdd = type2;
                }
            }
        }
        KtProperty ktProperty3 = (KtProperty)this.getElement();
        PsiElement psiElement3 = ktProperty3 != null ? ktProperty3.replace((PsiElement)newElement2) : null;
        if (!(psiElement3 instanceof KtProperty)) {
            psiElement3 = null;
        }
        if ((replaceElement = (KtProperty)psiElement3) != null && typeToAdd != null) {
            ResolutionFacade $this$frontendService$iv = ResolutionUtils.getResolutionFacade((KtElement)((KtElement)replaceElement));
            boolean $i$f$frontendService = false;
            typeToAdd = ((KotlinTypeRefiner)$this$frontendService$iv.getFrontendService(KotlinTypeRefiner.class)).refineType((KotlinTypeMarker)typeToAdd);
            SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation(editor2, (KtCallableDeclaration)replaceElement, typeToAdd);
        }
    }

    private final String partsToRemove(boolean getter, boolean setter, boolean initializer2) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (getter) {
            $this$buildString.append(KotlinBundle.message("text.getter", new Object[0]));
            if (setter && initializer2) {
                $this$buildString.append(", ");
            } else if (setter || initializer2) {
                $this$buildString.append(" " + KotlinBundle.message("configuration.text.and", new Object[0]) + " ");
            }
        }
        if (setter) {
            $this$buildString.append(KotlinBundle.message("text.setter", new Object[0]));
            if (initializer2) {
                $this$buildString.append(" " + KotlinBundle.message("configuration.text.and", new Object[0]) + " ");
            }
        }
        if (initializer2) {
            $this$buildString.append(KotlinBundle.message("text.initializer", new Object[0]));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public RemovePartsFromPropertyFix(@NotNull KtProperty element3, boolean removeInitializer, boolean removeGetter, boolean removeSetter) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super((PsiElement)element3);
        this.removeInitializer = removeInitializer;
        this.removeGetter = removeGetter;
        this.removeSetter = removeSetter;
    }

    private RemovePartsFromPropertyFix(KtProperty element3) {
        KtPropertyAccessor ktPropertyAccessor = element3.getGetter();
        KtPropertyAccessor ktPropertyAccessor2 = element3.getSetter();
        this(element3, element3.hasInitializer(), (ktPropertyAccessor != null ? ktPropertyAccessor.getBodyExpression() : null) != null, (ktPropertyAccessor2 != null ? ktPropertyAccessor2.getBodyExpression() : null) != null);
    }

    public /* synthetic */ RemovePartsFromPropertyFix(KtProperty element3, DefaultConstructorMarker $constructor_marker) {
        this(element3);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix$LateInitFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class LateInitFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final LateInitFactory INSTANCE;

        @Override
        @Nullable
        public KotlinQuickFixAction<KtProperty> createAction(@NotNull Diagnostic diagnostic) {
            boolean hasSetter;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = ((DiagnosticWithParameters1)Errors.INAPPLICABLE_LATEINIT_MODIFIER.cast((UnboundDiagnostic)diagnostic)).getPsiElement();
            if (!(psiElement2 instanceof KtProperty)) {
                psiElement2 = null;
            }
            KtProperty ktProperty = (KtProperty)psiElement2;
            if (ktProperty == null) {
                return null;
            }
            KtProperty property2 = ktProperty;
            boolean hasInitializer = property2.hasInitializer();
            KtPropertyAccessor ktPropertyAccessor = property2.getGetter();
            boolean hasGetter = (ktPropertyAccessor != null ? ktPropertyAccessor.getBodyExpression() : null) != null;
            KtPropertyAccessor ktPropertyAccessor2 = property2.getSetter();
            boolean bl = hasSetter = (ktPropertyAccessor2 != null ? ktPropertyAccessor2.getBodyExpression() : null) != null;
            if (!(hasInitializer || hasGetter || hasSetter)) {
                return null;
            }
            return new RemovePartsFromPropertyFix(property2, hasInitializer, hasGetter, hasSetter);
        }

        private LateInitFactory() {
        }

        static {
            LateInitFactory lateInitFactory;
            INSTANCE = lateInitFactory = new LateInitFactory();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemovePartsFromPropertyFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected KotlinQuickFixAction<KtProperty> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement element3 = diagnostic.getPsiElement();
            KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)element3, KtProperty.class);
            if (ktProperty == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"PsiTreeUtil.getParentOfT\u2026lass.java) ?: return null");
            KtProperty property2 = ktProperty;
            return new RemovePartsFromPropertyFix(property2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

