/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex.resolve;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.Collection;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.trackers.KotlinCodeBlockModificationListener;
import org.jetbrains.kotlin.idea.caches.trackers.KotlinPackageModificationListener;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.idea.stubindex.SubpackagesIndexService;
import org.jetbrains.kotlin.idea.stubindex.resolve.StubBasedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.AbstractDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.CombinedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.PsiBasedClassMemberDeclarationProvider;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\u0006\u0010\u0017\u001a\u00020\u0011J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0015H\u0002J\u0010\u0010)\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010*\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/stubindex/resolve/PluginDeclarationProviderFactory;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractDeclarationProviderFactory;", "project", "Lcom/intellij/openapi/project/Project;", "indexedFilesScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "nonIndexedFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "moduleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;Lorg/jetbrains/kotlin/storage/StorageManager;Ljava/util/Collection;Lorg/jetbrains/kotlin/analyzer/ModuleInfo;)V", "fileBasedDeclarationProviderFactory", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory;", "onCreationDebugInfo", "", "createPackageMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "name", "Lorg/jetbrains/kotlin/name/FqName;", "debugInfo", "debugToString", "diagnoseMissingPackageFragment", "", "fqName", "file", "diagnoseMissingPackageFragmentPartialPackageIndexCorruption", "", "message", "diagnoseMissingPackageFragmentPerModulePackageCacheMiss", "diagnoseMissingPackageFragmentUnknownReason", "getClassMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/ClassMemberDeclarationProvider;", "classLikeInfo", "Lorg/jetbrains/kotlin/resolve/lazy/data/KtClassLikeInfo;", "getStubBasedPackageMemberDeclarationProvider", "oldPackageExists", "", "packageFqName", "packageExists", "stubBasedPackageExists", "kotlin.core"})
public final class PluginDeclarationProviderFactory
extends AbstractDeclarationProviderFactory {
    private final FileBasedDeclarationProviderFactory fileBasedDeclarationProviderFactory;
    private final String onCreationDebugInfo;
    private final Project project;
    private final GlobalSearchScope indexedFilesScope;
    private final StorageManager storageManager;
    private final Collection<KtFile> nonIndexedFiles;
    private final ModuleInfo moduleInfo;

    @NotNull
    public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull KtClassLikeInfo classLikeInfo) {
        Intrinsics.checkNotNullParameter((Object)classLikeInfo, (String)"classLikeInfo");
        return (ClassMemberDeclarationProvider)new PsiBasedClassMemberDeclarationProvider(this.storageManager, classLikeInfo);
    }

    @Nullable
    protected PackageMemberDeclarationProvider createPackageMemberDeclarationProvider(@NotNull FqName name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        PackageMemberDeclarationProvider fileBasedProvider = this.fileBasedDeclarationProviderFactory.getPackageMemberDeclarationProvider(name2);
        PackageMemberDeclarationProvider stubBasedProvider = this.getStubBasedPackageMemberDeclarationProvider(name2);
        return fileBasedProvider == null && stubBasedProvider == null ? null : (fileBasedProvider == null ? stubBasedProvider : (stubBasedProvider == null ? fileBasedProvider : (PackageMemberDeclarationProvider)new CombinedPackageMemberDeclarationProvider((Collection)CollectionsKt.listOf((Object[])new PackageMemberDeclarationProvider[]{stubBasedProvider, fileBasedProvider}))));
    }

    public boolean packageExists(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.fileBasedDeclarationProviderFactory.packageExists(fqName2) || this.stubBasedPackageExists(fqName2);
    }

    private final boolean stubBasedPackageExists(FqName name2) {
        boolean bl;
        block6: {
            Object object;
            ModuleInfo moduleInfo = this.moduleInfo;
            if (!(moduleInfo instanceof IdeaModuleInfo)) {
                moduleInfo = null;
            }
            if ((object = (IdeaModuleInfo)moduleInfo) != null && (object = IdeaModuleInfosKt.projectSourceModules((IdeaModuleInfo)object)) != null) {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ModuleSourceInfo it = (ModuleSourceInfo)element$iv;
                        boolean bl2 = false;
                        if (!PerModulePackageCacheService.Companion.getInstance(this.project).packageExists(name2, it)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final PackageMemberDeclarationProvider getStubBasedPackageMemberDeclarationProvider(FqName name2) {
        if (!this.stubBasedPackageExists(name2)) {
            return null;
        }
        return new StubBasedPackageMemberDeclarationProvider(name2, this.project, this.indexedFilesScope);
    }

    private final Void diagnoseMissingPackageFragmentPartialPackageIndexCorruption(String message2) {
        throw (Throwable)new IllegalStateException("KotlinPartialPackageNamesIndex seems corrupted.\n" + message2);
    }

    private final Void diagnoseMissingPackageFragmentPerModulePackageCacheMiss(String message2) {
        PerModulePackageCacheService.Companion.getInstance(this.project).onTooComplexChange$kotlin_core();
        throw (Throwable)new IllegalStateException("PerModulePackageCache miss.\n" + message2);
    }

    private final Void diagnoseMissingPackageFragmentUnknownReason(String message2) {
        throw (Throwable)new IllegalStateException(message2);
    }

    public void diagnoseMissingPackageFragment(@NotNull FqName fqName2, @Nullable KtFile file2) {
        String string;
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        SubpackagesIndexService.SubpackagesIndex subpackagesIndex = SubpackagesIndexService.Companion.getInstance(this.project);
        ModuleInfo moduleInfo = this.moduleInfo;
        if (!(moduleInfo instanceof ModuleSourceInfo)) {
            moduleInfo = null;
        }
        ModuleSourceInfo moduleSourceInfo = (ModuleSourceInfo)moduleInfo;
        boolean packageExists = PackageIndexUtil.packageExists(fqName2, this.indexedFilesScope, this.project);
        boolean spiPackageExists = subpackagesIndex.packageExists(fqName2);
        boolean oldPackageExists = this.oldPackageExists(fqName2);
        ModuleSourceInfo moduleSourceInfo2 = moduleSourceInfo;
        if (moduleSourceInfo2 != null) {
            ModuleSourceInfo moduleSourceInfo3;
            ModuleSourceInfo it = moduleSourceInfo3 = moduleSourceInfo2;
            boolean bl2 = false;
            ComponentManager $this$getServiceSafe$iv = (ComponentManager)this.project;
            boolean $i$f$getServiceSafe = false;
            Object object = $this$getServiceSafe$iv.getService(PerModulePackageCacheService.class);
            if (object == null) {
                String string2 = "Unable to locate service " + PerModulePackageCacheService.class.getName();
                throw new IllegalStateException(string2.toString());
            }
            bl = ((PerModulePackageCacheService)object).packageExists(fqName2, it);
        } else {
            bl = null;
        }
        Boolean cachedPackageExists = bl;
        ModuleSourceInfo moduleSourceInfo4 = moduleSourceInfo;
        Long moduleModificationCount = moduleSourceInfo4 != null && (moduleSourceInfo4 = moduleSourceInfo4.createModificationTracker()) != null ? Long.valueOf(moduleSourceInfo4.getModificationCount()) : null;
        String common = StringsKt.trimIndent((String)("\n                packageExists = " + packageExists + ", cachedPackageExists = " + cachedPackageExists + ",\n                oldPackageExists = " + oldPackageExists + ",\n                SPI.packageExists = " + spiPackageExists + ", SPI = " + subpackagesIndex + ",\n                OOCB count = " + KotlinCodeBlockModificationListener.Companion.getInstance(this.project).getKotlinOutOfCodeBlockTracker().getModificationCount() + "\n                PT count = " + KotlinPackageModificationListener.Companion.getInstance(this.project).getPackageTracker().getModificationCount() + "\n                moduleModificationCount = " + moduleModificationCount + "\n            "));
        if (file2 != null) {
            VirtualFile virtualFile2 = file2.getVirtualFile();
            boolean inScope2 = this.indexedFilesScope.contains(virtualFile2);
            FqName packageFqName = file2.getPackageFqName();
            KtPackageDirective ktPackageDirective = file2.getPackageDirective();
            string = StringsKt.trimMargin$default((String)("\n                |Cannot find package fragment '" + fqName2 + "' for file " + file2.getName() + ", file package = '" + packageFqName + "':\n                |vFile: " + virtualFile2 + ",\n                |nonIndexedFiles = " + this.nonIndexedFiles + ", isNonIndexed = " + this.nonIndexedFiles.contains(file2) + ",\n                |scope = " + this.indexedFilesScope + ", isInScope = " + inScope2 + ",\n                |" + common + ",\n                |packageFqNameByTree = '" + file2.getPackageFqNameByTree() + "', packageDirectiveText = '" + (ktPackageDirective != null ? ktPackageDirective.getText() : null) + "'\n            "), null, (int)1, null);
        } else {
            string = StringsKt.trimMargin$default((String)("\n                |Cannot find package fragment '" + fqName2 + "' for unspecified file:\n                |nonIndexedFiles = " + this.nonIndexedFiles + ",\n                |scope = " + this.indexedFilesScope + ",\n                |" + common + "\n            "), null, (int)1, null);
        }
        String message2 = string;
        boolean scopeNotEmptyAndContainsFile = !GlobalSearchScope.isEmptyScope((SearchScope)((SearchScope)this.indexedFilesScope)) && (file2 == null || this.indexedFilesScope.contains(file2.getVirtualFile()));
        if (scopeNotEmptyAndContainsFile && !packageExists && !oldPackageExists) {
            Void void_ = this.diagnoseMissingPackageFragmentPartialPackageIndexCorruption(message2);
            throw new KotlinNothingValueException();
        }
        if (scopeNotEmptyAndContainsFile && packageExists && Intrinsics.areEqual((Object)cachedPackageExists, (Object)false)) {
            Void void_ = this.diagnoseMissingPackageFragmentPerModulePackageCacheMiss(message2);
            throw new KotlinNothingValueException();
        }
        Void void_ = this.diagnoseMissingPackageFragmentUnknownReason(message2);
        throw new KotlinNothingValueException();
    }

    @NotNull
    public final String debugToString() {
        return ArraysKt.joinToString$default((Object[])new String[]{"PluginDeclarationProviderFactory", "On failure:", this.debugInfo(), "On creation:", this.onCreationDebugInfo, "moduleInfo:" + this.moduleInfo + ".name", "moduleInfo dependencies: " + this.moduleInfo.dependencies()}, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final boolean oldPackageExists(FqName packageFqName) {
        return PackageIndexUtil.containsFilesWithPartialPackage(packageFqName, this.indexedFilesScope);
    }

    private final String debugInfo() {
        StringBuilder stringBuilder;
        if (this.nonIndexedFiles.isEmpty()) {
            return "-no synthetic files-\n";
        }
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = this.nonIndexedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtFile it = (KtFile)element$iv;
            boolean bl2 = false;
            $this$buildString.append(it.getName());
            $this$buildString.append(" isPhysical=" + it.isPhysical());
            $this$buildString.append(" modStamp=" + it.getModificationStamp());
            StringBuilder stringBuilder2 = $this$buildString;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public PluginDeclarationProviderFactory(@NotNull Project project2, @NotNull GlobalSearchScope indexedFilesScope, @NotNull StorageManager storageManager, @NotNull Collection<? extends KtFile> nonIndexedFiles, @NotNull ModuleInfo moduleInfo) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indexedFilesScope, (String)"indexedFilesScope");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter(nonIndexedFiles, (String)"nonIndexedFiles");
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        super(storageManager);
        this.project = project2;
        this.indexedFilesScope = indexedFilesScope;
        this.storageManager = storageManager;
        this.nonIndexedFiles = nonIndexedFiles;
        this.moduleInfo = moduleInfo;
        this.fileBasedDeclarationProviderFactory = new FileBasedDeclarationProviderFactory(this.storageManager, this.nonIndexedFiles);
        this.onCreationDebugInfo = this.debugInfo();
    }
}

