/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.statistics.fileloggers;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.statistics.fileloggers.IRecordLogger;
import org.jetbrains.kotlin.statistics.fileloggers.MetricsContainer;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/statistics/fileloggers/FileRecordLogger;", "Lorg/jetbrains/kotlin/statistics/fileloggers/IRecordLogger;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "channel", "Ljava/nio/channels/FileChannel;", "lock", "Ljava/nio/channels/FileLock;", "outputStream", "Ljava/io/OutputStream;", "append", "", "s", "", "close", "kotlin-gradle-statistics"})
public final class FileRecordLogger
implements IRecordLogger {
    @NotNull
    private final FileChannel channel;
    @NotNull
    private final OutputStream outputStream;
    @NotNull
    private final FileLock lock;

    /*
     * WARNING - void declaration
     */
    public FileRecordLogger(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND};
        AutoCloseable autoCloseable = FileChannel.open(Paths.get(file2.toURI()), openOptionArray);
        if (autoCloseable == null) {
            throw new IOException("Could not open file " + file2);
        }
        this.channel = autoCloseable;
        FileRecordLogger fileRecordLogger = this;
        try {
            FileRecordLogger fileRecordLogger2 = fileRecordLogger;
            FileLock fileLock = this.channel.tryLock();
            if (fileLock == null) {
                throw new IOException("Could not acquire an exclusive lock of file " + file2.getName());
            }
            autoCloseable = fileLock;
        }
        catch (Exception exception) {
            void e;
            FileRecordLogger fileRecordLogger3 = fileRecordLogger;
            this.channel.close();
            throw new IOException(e.getMessage(), (Throwable)e);
        }
        fileRecordLogger2.lock = autoCloseable;
        OutputStream outputStream = Channels.newOutputStream(this.channel);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(channel)");
        this.outputStream = outputStream;
    }

    @Override
    public void append(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string = s + '\n';
        Charset charset = MetricsContainer.Companion.getENCODING();
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        this.outputStream.write(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Closeable closeable = this.channel;
        Throwable throwable = null;
        try {
            FileChannel it = (FileChannel)closeable;
            boolean bl = false;
            Closeable closeable2 = this.outputStream;
            Throwable throwable2 = null;
            try {
                OutputStream it2 = (OutputStream)closeable2;
                boolean bl2 = false;
                this.lock.release();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

