/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.report;

import com.intellij.openapi.project.Project;
import com.intellij.util.io.PathKt;
import com.jetbrains.qodana.sarif.model.SarifReport;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.report.FileReportDescriptor$FailMessagesProvider$WhenMappings;
import org.jetbrains.qodana.report.ReportDescriptor;
import org.jetbrains.qodana.report.ReportReader;
import org.jetbrains.qodana.report.ReportValidator;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/qodana/report/FileReportDescriptor;", "Lorg/jetbrains/qodana/report/ReportDescriptor;", "reportPath", "Ljava/nio/file/Path;", "reportGuid", "", "reportName", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "isReportAvailable", "", "()Z", "getReportGuid", "()Ljava/lang/String;", "getReportName", "getReportPath", "()Ljava/nio/file/Path;", "reportProvider", "Lorg/jetbrains/qodana/report/ReportReader;", "getSarifReport", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "FailMessagesProvider", "intellij.qodana"})
public final class FileReportDescriptor
implements ReportDescriptor {
    private final ReportReader reportProvider;
    private final boolean isReportAvailable;
    @NotNull
    private final Path reportPath;
    @NotNull
    private final String reportGuid;
    @NotNull
    private final String reportName;

    @Override
    public boolean isReportAvailable() {
        return this.isReportAvailable;
    }

    @Override
    @Nullable
    public SarifReport getSarifReport() {
        return this.reportProvider.getReport();
    }

    @NotNull
    public final Path getReportPath() {
        return this.reportPath;
    }

    @Override
    @NotNull
    public String getReportGuid() {
        return this.reportGuid;
    }

    @Override
    @NotNull
    public String getReportName() {
        return this.reportName;
    }

    public FileReportDescriptor(@NotNull Path reportPath, @NotNull String reportGuid, @NotNull String reportName, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)reportPath, (String)"reportPath");
        Intrinsics.checkNotNullParameter((Object)reportGuid, (String)"reportGuid");
        Intrinsics.checkNotNullParameter((Object)reportName, (String)"reportName");
        this.reportPath = reportPath;
        this.reportGuid = reportGuid;
        this.reportName = reportName;
        this.reportProvider = new ReportReader(this.reportPath, project, new FailMessagesProvider());
        this.isReportAvailable = PathKt.isFile((Path)this.reportPath);
    }

    @Override
    @Nullable
    public SarifReport getReport() {
        return ReportDescriptor.DefaultImpls.getReport(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/qodana/report/FileReportDescriptor$FailMessagesProvider;", "Lorg/jetbrains/qodana/report/ReportReader$FailMessagesProvider;", "(Lorg/jetbrains/qodana/report/FileReportDescriptor;)V", "getFailedParseMessage", "", "getFailedValidationMessage", "validationError", "Lorg/jetbrains/qodana/report/ReportValidator$ValidationError;", "getFileNotExistsMessage", "intellij.qodana"})
    private final class FailMessagesProvider
    implements ReportReader.FailMessagesProvider {
        @Override
        @NotNull
        public String getFileNotExistsMessage() {
            String string = QodanaBundle.message("notification.content.report.file.does.not.exist.w.id", FileReportDescriptor.this.getReportPath(), FileReportDescriptor.this.getReportName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QodanaBundle.message(\"no\u2026, reportPath, reportName)");
            return string;
        }

        @Override
        @NotNull
        public String getFailedParseMessage() {
            String string = QodanaBundle.message("notification.content.cant.parse.report.from.file.w.id", FileReportDescriptor.this.getReportName(), FileReportDescriptor.this.getReportPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QodanaBundle.message(\"no\u2026, reportName, reportPath)");
            return string;
        }

        @Override
        @NotNull
        public String getFailedValidationMessage(@NotNull ReportValidator.ValidationError validationError) {
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)validationError), (String)"validationError");
            switch (FileReportDescriptor$FailMessagesProvider$WhenMappings.$EnumSwitchMapping$0[validationError.ordinal()]) {
                case 1: {
                    String string2 = QodanaBundle.message("notification.content.failed.validation.report.from.file.w.id.no.runs", FileReportDescriptor.this.getReportPath(), FileReportDescriptor.this.getReportName());
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"QodanaBundle.message(\"no\u2026, reportPath, reportName)");
                    break;
                }
                case 2: {
                    String string3 = QodanaBundle.message("notification.content.failed.validation.report.from.file.w.id.empty.runs", FileReportDescriptor.this.getReportPath(), FileReportDescriptor.this.getReportName());
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"QodanaBundle.message(\"no\u2026, reportPath, reportName)");
                    break;
                }
                case 3: {
                    String string4 = QodanaBundle.message("notification.content.failed.validation.report.from.file.w.id.no.results", FileReportDescriptor.this.getReportPath(), FileReportDescriptor.this.getReportName());
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"QodanaBundle.message(\"no\u2026, reportPath, reportName)");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }
    }
}

