/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.common;

import java.util.regex.Pattern;

public enum RefactoringType {
    EXTRACT_OPERATION("Extract Method", "Extract Method (.+) extracted from (.+) in class (.+)", 2),
    RENAME_CLASS("Rename Class", "Rename Class (.+) renamed to (.+)", new int[0]),
    MOVE_ATTRIBUTE("Move Attribute", "Move Attribute (.+) from class (.+) to (.+) from class (.+)", new int[0]),
    MOVE_RENAME_ATTRIBUTE("Move And Rename Attribute", "Move And Rename Attribute (.+) renamed to (.+) and moved from class (.+) to class (.+)", new int[0]),
    REPLACE_ATTRIBUTE("Replace Attribute", "Replace Attribute (.+) from class (.+) with (.+) from class (.+)", new int[0]),
    RENAME_METHOD("Rename Method", "Rename Method (.+) renamed to (.+) in class (.+)", new int[0]),
    INLINE_OPERATION("Inline Method", "Inline Method (.+) inlined to (.+) in class (.+)", 2),
    MOVE_OPERATION("Move Method", "Move Method (.+) from class (.+) to (.+) from class (.+)", new int[0]),
    MOVE_AND_RENAME_OPERATION("Move And Rename Method", "Move And Rename Method (.+) from class (.+) to (.+) from class (.+)", new int[0]),
    PULL_UP_OPERATION("Pull Up Method", "Pull Up Method (.+) from class (.+) to (.+) from class (.+)", 1, 2),
    MOVE_CLASS("Move Class", "Move Class (.+) moved to (.+)", new int[0]),
    MOVE_RENAME_CLASS("Move And Rename Class", ".+", new int[0]),
    MOVE_SOURCE_FOLDER("Move Source Folder", "Move Source Folder (.+) to (.+)", new int[0]),
    PULL_UP_ATTRIBUTE("Pull Up Attribute", "Pull Up Attribute (.+) from class (.+) to (.+) from class (.+)", 2),
    PUSH_DOWN_ATTRIBUTE("Push Down Attribute", "Push Down Attribute (.+) from class (.+) to (.+) from class (.+)", 3),
    PUSH_DOWN_OPERATION("Push Down Method", "Push Down Method (.+) from class (.+) to (.+) from class (.+)", 3, 4),
    EXTRACT_INTERFACE("Extract Interface", "Extract Interface (.+) from classes \\[(.+)\\]", 2),
    EXTRACT_SUPERCLASS("Extract Superclass", "Extract Superclass (.+) from classes \\[(.+)\\]", 2),
    EXTRACT_SUBCLASS("Extract Subclass", "Extract Subclass (.+) from class (.+)", new int[0]),
    EXTRACT_CLASS("Extract Class", "Extract Class (.+) from class (.+)", new int[0]),
    MERGE_OPERATION("Merge Method", ".+", new int[0]),
    EXTRACT_AND_MOVE_OPERATION("Extract And Move Method", "Extract And Move Method (.+) extracted from (.+) in class (.+) & moved to class (.+)", new int[0]),
    MOVE_AND_INLINE_OPERATION("Move And Inline Method", "Move And Inline Method (.+) moved from class (.+) to class (.+) & inlined to (.+)", new int[0]),
    CONVERT_ANONYMOUS_CLASS_TO_TYPE("Convert Anonymous Class to Type", ".+", new int[0]),
    INTRODUCE_POLYMORPHISM("Introduce Polymorphism", ".+", new int[0]),
    RENAME_PACKAGE("Change Package", "Change Package (.+) to (.+)", new int[0]),
    EXTRACT_VARIABLE("Extract Variable", "Extract Variable (.+) in method (.+) from class (.+)", new int[0]),
    EXTRACT_ATTRIBUTE("Extract Attribute", "Extract Attribute (.+) in class (.+)", new int[0]),
    INLINE_VARIABLE("Inline Variable", "Inline Variable (.+) in method (.+) from class (.+)", new int[0]),
    RENAME_VARIABLE("Rename Variable", "Rename Variable (.+) to (.+) in method (.+) from class (.+)", new int[0]),
    RENAME_PARAMETER("Rename Parameter", "Rename Parameter (.+) to (.+) in method (.+) from class (.+)", new int[0]),
    RENAME_ATTRIBUTE("Rename Attribute", "Rename Attribute (.+) to (.+) in class (.+)", new int[0]),
    MERGE_VARIABLE("Merge Variable", "Merge Variable \\[(.+)\\] to (.+) in method (.+) from class (.+)", new int[0]),
    MERGE_PARAMETER("Merge Parameter", "Merge Parameter \\[(.+)\\] to (.+) in method (.+) from class (.+)", new int[0]),
    MERGE_ATTRIBUTE("Merge Attribute", "Merge Attribute \\[(.+)\\] to (.+) in class (.+)", new int[0]),
    SPLIT_VARIABLE("Split Variable", "Split Variable (.+) to \\[(.+)\\] in method (.+) from class (.+)", new int[0]),
    SPLIT_PARAMETER("Split Parameter", "Split Parameter (.+) to \\[(.+)\\] in method (.+) from class (.+)", new int[0]),
    SPLIT_ATTRIBUTE("Split Attribute", "Split Attribute (.+) to \\[(.+)\\] in class (.+)", new int[0]),
    REPLACE_VARIABLE_WITH_ATTRIBUTE("Replace Variable With Attribute", "Replace Variable With Attribute (.+) to (.+) in method (.+) from class (.+)", new int[0]),
    PARAMETERIZE_VARIABLE("Parameterize Variable", "Parameterize Variable (.+) to (.+) in method (.+) from class (.+)", new int[0]),
    CHANGE_RETURN_TYPE("Change Return Type", "Change Return Type (.+) to (.+) in method (.+) from class (.+)", new int[0]),
    CHANGE_VARIABLE_TYPE("Change Variable Type", "Change Variable Type (.+) to (.+) in method (.+) from class (.+)", new int[0]),
    CHANGE_PARAMETER_TYPE("Change Parameter Type", "Change Parameter Type (.+) to (.+) in method (.+) from class (.+)", new int[0]),
    CHANGE_ATTRIBUTE_TYPE("Change Attribute Type", "Change Attribute Type (.+) to (.+) in class (.+)", new int[0]),
    ADD_METHOD_ANNOTATION("Add Method Annotation", "Add Method Annotation (.+) in method (.+) from class (.+)", new int[0]),
    REMOVE_METHOD_ANNOTATION("Remove Method Annotation", "Remove Method Annotation (.+) in method (.+) from class (.+)", new int[0]),
    MODIFY_METHOD_ANNOTATION("Modify Method Annotation", "Modify Method Annotation (.+) to (.+) in method (.+) from class (.+)", new int[0]),
    ADD_ATTRIBUTE_ANNOTATION("Add Attribute Annotation", "Add Attribute Annotation (.+) in attribute (.+) from class (.+)", new int[0]),
    REMOVE_ATTRIBUTE_ANNOTATION("Remove Attribute Annotation", "Remove Attribute Annotation (.+) in attribute (.+) from class (.+)", new int[0]),
    MODIFY_ATTRIBUTE_ANNOTATION("Modify Attribute Annotation", "Modify Attribute Annotation (.+) to (.+) in attribute (.+) from class (.+)", new int[0]),
    ADD_CLASS_ANNOTATION("Add Class Annotation", "Add Class Annotation (.+) in class (.+)", new int[0]),
    REMOVE_CLASS_ANNOTATION("Remove Class Annotation", "Remove Class Annotation (.+) in class (.+)", new int[0]),
    MODIFY_CLASS_ANNOTATION("Modify Class Annotation", "Modify Class Annotation (.+) to (.+) in class (.+)", new int[0]),
    ADD_PARAMETER_ANNOTATION("Add Parameter Annotation", "Add Parameter Annotation (.+) in parameter (.+) in method (.+) from class (.+)", new int[0]),
    REMOVE_PARAMETER_ANNOTATION("Remove Parameter Annotation", "Remove Parameter Annotation (.+) in parameter (.+) in method (.+) from class (.+)", new int[0]),
    MODIFY_PARAMETER_ANNOTATION("Modify Parameter Annotation", "Modify Parameter Annotation (.+) to (.+) in parameter (.+) in method (.+) from class (.+)", new int[0]),
    ADD_PARAMETER("Add Parameter", "Add Parameter (.+) in method (.+) from class (.+)", new int[0]),
    REMOVE_PARAMETER("Remove Parameter", "Remove Parameter (.+) in method (.+) from class (.+)", new int[0]),
    REORDER_PARAMETER("Reorder Parameter", "Reorder Parameter \\[(.+)\\] to \\[(.+)\\] in method (.+) from class (.+)", new int[0]);

    public static RefactoringType[] ALL;
    private final String displayName;
    private final Pattern regex;
    private final int[] aggregateGroups;

    private RefactoringType(String displayName, String regex, int ... aggregateGroups) {
        this.displayName = displayName;
        this.regex = Pattern.compile(regex);
        this.aggregateGroups = aggregateGroups;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    static {
        ALL = new RefactoringType[]{RENAME_CLASS, MOVE_CLASS, MOVE_SOURCE_FOLDER, RENAME_METHOD, EXTRACT_OPERATION, INLINE_OPERATION, MOVE_OPERATION, PULL_UP_OPERATION, PUSH_DOWN_OPERATION, MOVE_ATTRIBUTE, MOVE_RENAME_ATTRIBUTE, REPLACE_ATTRIBUTE, PULL_UP_ATTRIBUTE, PUSH_DOWN_ATTRIBUTE, EXTRACT_INTERFACE, EXTRACT_SUPERCLASS, EXTRACT_SUBCLASS, EXTRACT_CLASS, EXTRACT_AND_MOVE_OPERATION, MOVE_RENAME_CLASS, RENAME_PACKAGE, EXTRACT_VARIABLE, INLINE_VARIABLE, RENAME_VARIABLE, RENAME_PARAMETER, RENAME_ATTRIBUTE, REPLACE_VARIABLE_WITH_ATTRIBUTE, PARAMETERIZE_VARIABLE, MERGE_VARIABLE, MERGE_PARAMETER, MERGE_ATTRIBUTE, SPLIT_VARIABLE, SPLIT_PARAMETER, SPLIT_ATTRIBUTE, CHANGE_RETURN_TYPE, CHANGE_VARIABLE_TYPE, CHANGE_PARAMETER_TYPE, CHANGE_ATTRIBUTE_TYPE, EXTRACT_ATTRIBUTE, MOVE_AND_RENAME_OPERATION, MOVE_AND_INLINE_OPERATION, ADD_METHOD_ANNOTATION, REMOVE_METHOD_ANNOTATION, MODIFY_METHOD_ANNOTATION, ADD_ATTRIBUTE_ANNOTATION, REMOVE_ATTRIBUTE_ANNOTATION, MODIFY_ATTRIBUTE_ANNOTATION, ADD_CLASS_ANNOTATION, REMOVE_CLASS_ANNOTATION, MODIFY_CLASS_ANNOTATION, ADD_PARAMETER, REMOVE_PARAMETER, REORDER_PARAMETER, ADD_PARAMETER_ANNOTATION, REMOVE_PARAMETER_ANNOTATION, MODIFY_PARAMETER_ANNOTATION};
    }
}

