/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.common.replacement;

import org.jetbrains.research.kotlinrminer.common.util.StringDistance;

public class Replacement {
    private final String before;
    private final String after;
    private final ReplacementType type;

    public Replacement(String before, String after, ReplacementType type) {
        this.before = before;
        this.after = after;
        this.type = type;
    }

    public String getBefore() {
        return this.before;
    }

    public String getAfter() {
        return this.after;
    }

    public ReplacementType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.after == null ? 0 : this.after.hashCode());
        result = 31 * result + (this.before == null ? 0 : this.before.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Replacement) {
            Replacement other = (Replacement)obj;
            return this.before.equals(other.before) && this.after.equals(other.after) && this.type.equals((Object)other.type);
        }
        return false;
    }

    public String toString() {
        return this.before + " -> " + this.after;
    }

    public double normalizedEditDistance() {
        String s1 = this.getBefore();
        String s2 = this.getAfter();
        int distance = StringDistance.editDistance(s1, s2);
        return (double)distance / (double)Math.max(s1.length(), s2.length());
    }

    public boolean involvesVariable() {
        return this.type.equals((Object)ReplacementType.VARIABLE_NAME) || this.type.equals((Object)ReplacementType.BOOLEAN_REPLACED_WITH_VARIABLE) || this.type.equals((Object)ReplacementType.TYPE_LITERAL_REPLACED_WITH_VARIABLE) || this.type.equals((Object)ReplacementType.ARGUMENT_REPLACED_WITH_VARIABLE) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_METHOD_INVOCATION) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_EXPRESSION_OF_METHOD_INVOCATION) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_ARRAY_ACCESS) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_PREFIX_EXPRESSION) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_STRING_LITERAL) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_NULL_LITERAL) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_NUMBER_LITERAL);
    }

    public static enum ReplacementType {
        TYPE,
        STRING_LITERAL,
        NUMBER_LITERAL,
        ANONYMOUS_CLASS_DECLARATION,
        INFIX_OPERATOR,
        VARIABLE_NAME,
        VARIABLE_DECLARATION,
        MERGE_VARIABLES,
        SPLIT_VARIABLE,
        ADD_VARIABLE,
        INVERT_CONDITIONAL,
        BOOLEAN_REPLACED_WITH_VARIABLE,
        BOOLEAN_REPLACED_WITH_ARGUMENT,
        TYPE_LITERAL_REPLACED_WITH_VARIABLE,
        METHOD_INVOCATION,
        METHOD_INVOCATION_EXPRESSION,
        METHOD_INVOCATION_ARGUMENT,
        METHOD_INVOCATION_ARGUMENT_WRAPPED,
        METHOD_INVOCATION_ARGUMENT_CONCATENATED,
        METHOD_INVOCATION_NAME,
        METHOD_INVOCATION_NAME_AND_ARGUMENT,
        METHOD_INVOCATION_NAME_AND_EXPRESSION,
        ARGUMENT_REPLACED_WITH_VARIABLE,
        ARGUMENT_REPLACED_WITH_RETURN_EXPRESSION,
        ARGUMENT_REPLACED_WITH_STATEMENT,
        ARGUMENT_REPLACED_WITH_RIGHT_HAND_SIDE_OF_ASSIGNMENT_EXPRESSION,
        VARIABLE_REPLACED_WITH_METHOD_INVOCATION,
        VARIABLE_REPLACED_WITH_EXPRESSION_OF_METHOD_INVOCATION,
        VARIABLE_REPLACED_WITH_ARRAY_ACCESS,
        VARIABLE_REPLACED_WITH_PREFIX_EXPRESSION,
        VARIABLE_REPLACED_WITH_STRING_LITERAL,
        VARIABLE_REPLACED_WITH_NULL_LITERAL,
        VARIABLE_REPLACED_WITH_NUMBER_LITERAL,
        ARRAY_ACCESS_REPLACED_WITH_METHOD_INVOCATION,
        NULL_LITERAL_REPLACED_WITH_CONDITIONAL_EXPRESSION,
        CLASS_INSTANCE_CREATION,
        CLASS_INSTANCE_CREATION_ARGUMENT,
        CLASS_INSTANCE_CREATION_REPLACED_WITH_METHOD_INVOCATION,
        BUILDER_REPLACED_WITH_CLASS_INSTANCE_CREATION,
        FIELD_ASSIGNMENT_REPLACED_WITH_SETTER_METHOD_INVOCATION,
        ARRAY_CREATION_REPLACED_WITH_DATA_STRUCTURE_CREATION,
        ARRAY_INITIALIZER_REPLACED_WITH_METHOD_INVOCATION_ARGUMENTS,
        EXPRESSION_REPLACED_WITH_TERNARY_ELSE,
        EXPRESSION_REPLACED_WITH_TERNARY_THEN,
        COMPOSITE,
        CONCATENATION,
        CONDITIONAL,
        INFIX_EXPRESSION;

    }
}

