/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.UMLModelPsiReader;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLModel;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002J\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u000eH\u0002JN\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0 2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0!H\u0002JF\u0010\"\u001a\u00020\u001c2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0$2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0 H\u0002R6\u0010\u0003\u001a(\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0014\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006("}, d2={"Lorg/jetbrains/research/kotlinrminer/ide/KotlinRMiner;", "", "()V", "refactoringTypesToConsider", "", "Lorg/jetbrains/research/kotlinrminer/common/RefactoringType;", "kotlin.jvm.PlatformType", "[Lorg/jetbrains/research/kotlinrminer/common/RefactoringType;", "createModelInKotlin", "Lorg/jetbrains/research/kotlinrminer/ide/uml/UMLModel;", "project", "Lcom/intellij/openapi/project/Project;", "fileContents", "", "", "repositoryDirectories", "", "detectRefactorings", "", "Lorg/jetbrains/research/kotlinrminer/ide/Refactoring;", "changes", "Lcom/intellij/openapi/vcs/changes/Change;", "filter", "", "refactoringsAtRevision", "isKotlinFile", "path", "populateFileContents", "", "type", "Lorg/jetbrains/research/kotlinrminer/ide/KotlinRMiner$RevisionType;", "filePaths", "", "", "preprocessChanges", "filesBefore", "", "filesCurrent", "renamedFilesHint", "RevisionType", "kotlinrminer-ide"})
public final class KotlinRMiner {
    @NotNull
    public static final KotlinRMiner INSTANCE = new KotlinRMiner();
    private static final RefactoringType[] refactoringTypesToConsider = RefactoringType.ALL;

    private KotlinRMiner() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Refactoring> detectRefactorings(@NotNull Project project, @NotNull List<? extends Change> changes2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(changes2, (String)"changes");
        boolean bl = false;
        ArrayList filePathsBefore = new ArrayList();
        boolean bl2 = false;
        ArrayList filePathsCurrent = new ArrayList();
        boolean bl3 = false;
        HashMap renamedFilesHint = new HashMap();
        this.preprocessChanges(changes2, filePathsBefore, filePathsCurrent, renamedFilesHint);
        boolean bl4 = false;
        LinkedHashSet repositoryDirectoriesBefore = new LinkedHashSet();
        boolean bl5 = false;
        LinkedHashSet repositoryDirectoriesCurrent = new LinkedHashSet();
        boolean bl6 = false;
        LinkedHashMap fileContentsBefore = new LinkedHashMap();
        boolean bl7 = false;
        LinkedHashMap fileContentsCurrent = new LinkedHashMap();
        Collection collection = filePathsBefore;
        boolean bl8 = false;
        if (!collection.isEmpty()) {
            collection = filePathsCurrent;
            bl8 = false;
            if (!collection.isEmpty()) {
                void $this$filterTo$iv$iv;
                this.populateFileContents(RevisionType.BEFORE, changes2, filePathsBefore, fileContentsBefore, repositoryDirectoriesBefore);
                UMLModel parentUMLModel = this.createModelInKotlin(project, fileContentsBefore, repositoryDirectoriesBefore);
                this.populateFileContents(RevisionType.AFTER, changes2, filePathsCurrent, fileContentsCurrent, repositoryDirectoriesCurrent);
                UMLModel currentUMLModel = this.createModelInKotlin(project, fileContentsCurrent, repositoryDirectoriesCurrent);
                List<Refactoring> list = parentUMLModel.diff(currentUMLModel, renamedFilesHint).getRefactorings();
                Intrinsics.checkNotNullExpressionValue(list, (String)"parentUMLModel.diff(currentUMLModel, renamedFilesHint).refactorings");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Refactoring p0 = (Refactoring)element$iv$iv;
                    boolean bl9 = false;
                    if (!this.filter(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }
        return CollectionsKt.emptyList();
    }

    private final void preprocessChanges(List<? extends Change> changes2, List<String> filesBefore, List<String> filesCurrent, Map<String, String> renamedFilesHint) {
        for (Change change : changes2) {
            FilePath newPath;
            FilePath filePath;
            Object object;
            Change.Type type = change.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"change.type");
            Change.Type changeType = type;
            ContentRevision contentRevision = change.getBeforeRevision();
            contentRevision = contentRevision == null ? null : ((object = contentRevision.getFile()) == null ? null : object.getPath());
            boolean bl = false;
            Object object2 = contentRevision;
            if (object2 == null) {
                object2 = "";
            }
            ContentRevision oldPath = object2;
            object = change.getAfterRevision();
            object = object == null ? null : ((filePath = object.getFile()) == null ? null : filePath.getPath());
            boolean bl2 = false;
            Object object3 = object;
            if (object3 == null) {
                object3 = newPath = "";
            }
            if (changeType != Change.Type.NEW && this.isKotlinFile((String)oldPath)) {
                filesBefore.add((String)oldPath);
            }
            if (changeType != Change.Type.DELETED && this.isKotlinFile((String)newPath)) {
                filesCurrent.add((String)newPath);
            }
            if (!change.isRenamed() || !this.isKotlinFile((String)oldPath) || !this.isKotlinFile((String)newPath)) continue;
            object = renamedFilesHint;
            bl2 = false;
            object.put(oldPath, newPath);
        }
    }

    private final void populateFileContents(RevisionType type, List<? extends Change> changes2, List<String> filePaths, Map<String, String> fileContents, Set<String> repositoryDirectories) {
        for (Change change : changes2) {
            String directory;
            int n;
            int n2;
            Object object;
            ContentRevision contentRevision;
            Object object2;
            Object object3 = object2 = type == RevisionType.BEFORE ? change.getBeforeRevision() : change.getAfterRevision();
            if (object2 == null) continue;
            ContentRevision revision = contentRevision = object2;
            object2 = ChangesUtil.getFilePath((Change)change).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getFilePath(change).path");
            Object pathString = object2;
            if (filePaths.contains(pathString)) {
                object2 = fileContents;
                object = ChangesUtil.loadContentRevision((ContentRevision)revision);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"loadContentRevision(revision)");
                Charset charset = Charsets.UTF_8;
                n2 = 0;
                n = 0;
                object = new String((byte[])object, charset);
                boolean bl = false;
                object2.put(pathString, object);
            }
            if (!StringsKt.endsWith$default((String)pathString, (String)".kt", (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)((CharSequence)pathString), (CharSequence)"/", (boolean)false, (int)2, null)) continue;
            object = pathString;
            int n3 = 0;
            n2 = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)pathString), (String)"/", (int)0, (boolean)false, (int)6, null);
            n = 0;
            Intrinsics.checkNotNullExpressionValue((Object)((String)object).substring(n3, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            repositoryDirectories.add(directory);
            String subDirectory = directory;
            while (StringsKt.contains$default((CharSequence)subDirectory, (CharSequence)"/", (boolean)false, (int)2, null)) {
                String string = subDirectory;
                n2 = 0;
                n = StringsKt.lastIndexOf$default((CharSequence)subDirectory, (String)"/", (int)0, (boolean)false, (int)6, null);
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n2, n), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                repositoryDirectories.add(subDirectory);
            }
        }
    }

    private final UMLModel createModelInKotlin(Project project, Map<String, String> fileContents, Set<String> repositoryDirectories) {
        UMLModelPsiReader psiReader = new UMLModelPsiReader(repositoryDirectories);
        psiReader.parseFiles(project, fileContents);
        UMLModel uMLModel = psiReader.getUmlModel();
        Intrinsics.checkNotNullExpressionValue((Object)uMLModel, (String)"psiReader.umlModel");
        return uMLModel;
    }

    private final boolean filter(Refactoring refactoringsAtRevision) {
        RefactoringType[] refactoringTypeArray = refactoringTypesToConsider;
        Intrinsics.checkNotNullExpressionValue((Object)refactoringTypeArray, (String)"refactoringTypesToConsider");
        return ArraysKt.contains((Object[])((Object[])refactoringTypeArray), (Object)((Object)refactoringsAtRevision.getRefactoringType()));
    }

    private final boolean isKotlinFile(String path) {
        return StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/research/kotlinrminer/ide/KotlinRMiner$RevisionType;", "", "(Ljava/lang/String;I)V", "BEFORE", "AFTER", "kotlinrminer-ide"})
    public static final class RevisionType
    extends Enum<RevisionType> {
        public static final /* enum */ RevisionType BEFORE = new RevisionType();
        public static final /* enum */ RevisionType AFTER = new RevisionType();
        private static final /* synthetic */ RevisionType[] $VALUES;

        public static RevisionType[] values() {
            RevisionType[] revisionTypeArray = $VALUES;
            return Arrays.copyOf(revisionTypeArray, revisionTypeArray.length);
        }

        public static RevisionType valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(RevisionType.class, value);
        }

        static {
            $VALUES = revisionTypeArray = new RevisionType[]{RevisionType.BEFORE, RevisionType.AFTER};
        }
    }
}

