/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.common.util.StringDistance;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeFragment;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeStatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class LeafMapping
extends AbstractCodeMapping
implements Comparable<LeafMapping> {
    public LeafMapping(AbstractCodeFragment statement1, AbstractCodeFragment statement2, UMLOperation operation1, UMLOperation operation2) {
        super(statement1, statement2, operation1, operation2);
    }

    @Override
    public int compareTo(@NotNull LeafMapping o) {
        int indexDiff2;
        int depthDiff2;
        double distance2;
        int distance;
        String s2;
        String s1;
        double distance1;
        if (o == null) {
            LeafMapping.$$$reportNull$$$0(0);
        }
        if (this.getFragment1().getString().equals(this.getFragment2().getString())) {
            distance1 = 0.0;
        } else {
            s1 = this.getFragment1().getString().toLowerCase();
            s2 = this.getFragment2().getString().toLowerCase();
            distance = StringDistance.editDistance(s1, s2);
            distance1 = (double)distance / (double)Math.max(s1.length(), s2.length());
        }
        if (o.getFragment1().getString().equals(o.getFragment2().getString())) {
            distance2 = 0.0;
        } else {
            s1 = o.getFragment1().getString().toLowerCase();
            s2 = o.getFragment2().getString().toLowerCase();
            distance = StringDistance.editDistance(s1, s2);
            distance2 = (double)distance / (double)Math.max(s1.length(), s2.length());
        }
        if (distance1 != distance2) {
            if (this.isIdenticalWithExtractedVariable() && !o.isIdenticalWithExtractedVariable()) {
                return -1;
            }
            if (!this.isIdenticalWithExtractedVariable() && o.isIdenticalWithExtractedVariable()) {
                return 1;
            }
            if (this.isIdenticalWithInlinedVariable() && !o.isIdenticalWithInlinedVariable()) {
                return -1;
            }
            if (!this.isIdenticalWithInlinedVariable() && o.isIdenticalWithInlinedVariable()) {
                return 1;
            }
            return Double.compare(distance1, distance2);
        }
        int depthDiff1 = Math.abs(this.getFragment1().getDepth() - this.getFragment2().getDepth());
        if (depthDiff1 != (depthDiff2 = Math.abs(o.getFragment1().getDepth() - o.getFragment2().getDepth()))) {
            return Integer.compare(depthDiff1, depthDiff2);
        }
        int indexDiff1 = Math.abs(this.getFragment1().getIndex() - this.getFragment2().getIndex());
        if (indexDiff1 != (indexDiff2 = Math.abs(o.getFragment1().getIndex() - o.getFragment2().getIndex()))) {
            return Integer.compare(indexDiff1, indexDiff2);
        }
        double parentEditDistance1 = this.parentEditDistance();
        double parentEditDistance2 = o.parentEditDistance();
        return Double.compare(parentEditDistance1, parentEditDistance2);
    }

    private double parentEditDistance() {
        CompositeStatementObject parent2;
        CompositeStatementObject parent1;
        for (parent1 = this.getFragment1().getParent(); parent1 != null && parent1.getLocationInfo().getCodeElementType().equals((Object)CodeElementType.BLOCK); parent1 = parent1.getParent()) {
        }
        for (parent2 = this.getFragment2().getParent(); parent2 != null && parent2.getLocationInfo().getCodeElementType().equals((Object)CodeElementType.BLOCK); parent2 = parent2.getParent()) {
        }
        if (parent1 == null && parent2 == null) {
            return 0.0;
        }
        if (parent1 == null) {
            String s2 = parent2.getString();
            int distance = StringDistance.editDistance("{", s2);
            return (double)distance / (double)Math.max(1, s2.length());
        }
        if (parent2 == null) {
            String s1 = parent1.getString();
            int distance = StringDistance.editDistance(s1, "{");
            return (double)distance / (double)Math.max(s1.length(), 1);
        }
        String s1 = parent1.getString();
        String s2 = parent2.getString();
        int distance = StringDistance.editDistance(s1, s2);
        return (double)distance / (double)Math.max(s1.length(), s2.length());
    }

    public Set<String> callChainIntersection() {
        OperationInvocation invocation1 = this.getFragment1().invocationCoveringEntireFragment();
        OperationInvocation invocation2 = this.getFragment2().invocationCoveringEntireFragment();
        if (invocation1 != null && invocation2 != null) {
            return invocation1.callChainIntersection(invocation2);
        }
        return new LinkedHashSet<String>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/research/kotlinrminer/ide/decomposition/LeafMapping", "compareTo"));
    }
}

